
.\" Copyright (c), 2005 Dan McMahill
.\" Do not edit this directly.  Edit the XML source file instead
.\"

.TH ic_microstrip_calc "n" "" "Wcalc" "Wcalc Commands"
.B ic_microstrip_calc
- Integrated circuit microstrip transmission line analysis

.SH SYNOPSIS
ic_microstrip_calc w l tox h er sigmas tmet rho rough f 

.SH INPUT PARAMETERS

.TP 10
w
: width of ic_microstrip line (meters)
.TP 10
l
: lentgh of ic_microstrip line (meters)
.TP 10
tox
: oxide thickness (meters)
.TP 10
h
: substrate thickness (meters)
.TP 10
er
: substrate relative permitivity
.TP 10
sigmas
: substrate conductivity (1/ohm-m)
.TP 10
tmet
: metal thickness (meters)
.TP 10
rho
: resistivity of wire (relative to copper)
.TP 10
rough
: conductor surface roughness (meters-rms)
.TP 10
f
: synthesis frequency (Hz)

.SH OUTPUT VALUES

.TP 10
z0
: calculated characteristic impedance (Ohms)
.TP 10
keff
: calculated effective relative permitivitty
.TP 10
elen
: calculated electrical length of the line (degrees)
.TP 10
loss
: calculated loss of the line (dB)
.TP 10
L
: calculated inductance per length (Henries/meter)
.TP 10
R
: calculated resistance per length (Ohms/meter)
.TP 10
C
: calculated capacitance per length (Farads/meter)
.TP 10
G
: calculated conductance per length (Siemens/meter)
.SH DESCRIPTION

Function to analyze the electrical characteristics of a single 
integrated circuit microstrip transmission line. The physical
dimensions of the microstrip line are given as inputs and the
characteristic impedance, effective dielectric constant, loss and
open circuit end correction are calculated.


.NF



                 |<--W-->|
                  _______    
                 | metal | <- tmet,rho,rough
    ----------------------------------------------
   {**************  Oxide (tox,eox) **************
    ----------------------------------------------
   (  substrate                          /|\\     (
    )   es,sigmas                     H   |       )
   (                                     \\|/     (
    ----------------------------------------------
    XXXXXXXXXXXXXXXXXX ground XXXXXXXXXXXXXXXXXXXX



.FI

.SH EXAMPLE
.nf

* MIS microstrip calculation
ic_microstrip_calc 50e-6 1e-3 1.0e-6 4.5 200e-6 9.6 0.1 1.0e-6 3.0e-8 0.1e-6 2.4e9
*
  
.fi
.SH SEE ALSO
stdio-wcalc(1),
air_coil_calc(n), air_coil_syn(n), coax_calc(n), coax_syn(n), coupled_microstrip_calc(n), coupled_microstrip_syn(n), ic_microstrip_calc(n), ic_microstrip_syn(n), microstrip_calc(n), microstrip_syn(n), stripline_calc(n), stripline_syn(n)
.SH AUTHOR

Dan McMahill

.SH BUGS

None known
