/*
 * Decompiled with CFR 0.152.
 */
package org.usadellab.trimmomatic.fasta;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import org.usadellab.trimmomatic.fasta.FastaRecord;

public class FastaSerializer {
    public static final int BASES_PER_LINE = 60;
    private PrintStream stream;

    public void open(File file) throws IOException {
        this.stream = new PrintStream(file);
    }

    public void open(PrintStream stream) throws IOException {
        this.stream = new PrintStream(stream);
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public synchronized void writeRecord(FastaRecord record) {
        this.stream.println(">" + record.getName());
        String seq = record.getSequence();
        int len = seq.length();
        int pos = 0;
        while (pos + 60 <= len) {
            this.stream.println(seq.substring(pos, pos + 60));
            pos += 60;
        }
        String remainder = seq.substring(pos);
        if (remainder.length() > 0) {
            this.stream.println(remainder);
        }
    }
}

