
####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was fsnotifierConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################
include(${CMAKE_CURRENT_LIST_DIR}/fsnotifierTargets.cmake)

set_and_check(fsnotifier_INCLUDE_DIR "${PACKAGE_PREFIX_DIR}/include")
set_and_check(fsnotifier_LIBRARY_DIR "${PACKAGE_PREFIX_DIR}/lib")

include(CMakeFindDependencyMacro)
# dependency => required ; package => optional
find_dependency(Threads)
find_dependency(PkgConfig)
pkg_search_module(INOTIFY libinotify REQUIRED) # No clear way to use PkgConfig within CMakeFindDependencyMacro ...
# no optional packages

check_required_components(fsnotifier_sharedlib fsnotifier_staticlib fsnotifier fsnotifier-static)

include(FindPackageMessage)
find_package_message(fsnotifier "Found fsnotifier: ${fsnotifier_LIBRARY_DIR}" "[${fsnotifier_LIBRARY_DIR}][${fsnotifier_INCLUDE_DIR}]")
