package #
Date::Manip::TZ::amhava00;
# Copyright (c) 2008-2025 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Sun Mar  2 17:18:53 EST 2025
#    Data version: tzdata2025a
#    Code version: tzcode2025a

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.97';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,18,30,32],'-05:29:28',[-5,-29,-28],
          'LMT',0,[1890,1,1,5,29,27],[1889,12,31,23,59,59],
          '0001010200:00:00','0001010118:30:32','1890010105:29:27','1889123123:59:59' ],
     ],
   1890 =>
     [
        [ [1890,1,1,5,29,28],[1889,12,31,23,59,52],'-05:29:36',[-5,-29,-36],
          'HMT',0,[1925,7,19,17,29,35],[1925,7,19,11,59,59],
          '1890010105:29:28','1889123123:59:52','1925071917:29:35','1925071911:59:59' ],
     ],
   1925 =>
     [
        [ [1925,7,19,17,29,36],[1925,7,19,12,29,36],'-05:00:00',[-5,0,0],
          'CST',0,[1928,6,10,4,59,59],[1928,6,9,23,59,59],
          '1925071917:29:36','1925071912:29:36','1928061004:59:59','1928060923:59:59' ],
     ],
   1928 =>
     [
        [ [1928,6,10,5,0,0],[1928,6,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1928,10,10,3,59,59],[1928,10,9,23,59,59],
          '1928061005:00:00','1928061001:00:00','1928101003:59:59','1928100923:59:59' ],
        [ [1928,10,10,4,0,0],[1928,10,9,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1940,6,2,4,59,59],[1940,6,1,23,59,59],
          '1928101004:00:00','1928100923:00:00','1940060204:59:59','1940060123:59:59' ],
     ],
   1940 =>
     [
        [ [1940,6,2,5,0,0],[1940,6,2,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1940,9,1,3,59,59],[1940,8,31,23,59,59],
          '1940060205:00:00','1940060201:00:00','1940090103:59:59','1940083123:59:59' ],
        [ [1940,9,1,4,0,0],[1940,8,31,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1941,6,1,4,59,59],[1941,5,31,23,59,59],
          '1940090104:00:00','1940083123:00:00','1941060104:59:59','1941053123:59:59' ],
     ],
   1941 =>
     [
        [ [1941,6,1,5,0,0],[1941,6,1,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1941,9,7,3,59,59],[1941,9,6,23,59,59],
          '1941060105:00:00','1941060101:00:00','1941090703:59:59','1941090623:59:59' ],
        [ [1941,9,7,4,0,0],[1941,9,6,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1942,6,7,4,59,59],[1942,6,6,23,59,59],
          '1941090704:00:00','1941090623:00:00','1942060704:59:59','1942060623:59:59' ],
     ],
   1942 =>
     [
        [ [1942,6,7,5,0,0],[1942,6,7,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1942,9,6,3,59,59],[1942,9,5,23,59,59],
          '1942060705:00:00','1942060701:00:00','1942090603:59:59','1942090523:59:59' ],
        [ [1942,9,6,4,0,0],[1942,9,5,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1945,6,3,4,59,59],[1945,6,2,23,59,59],
          '1942090604:00:00','1942090523:00:00','1945060304:59:59','1945060223:59:59' ],
     ],
   1945 =>
     [
        [ [1945,6,3,5,0,0],[1945,6,3,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1945,9,2,3,59,59],[1945,9,1,23,59,59],
          '1945060305:00:00','1945060301:00:00','1945090203:59:59','1945090123:59:59' ],
        [ [1945,9,2,4,0,0],[1945,9,1,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1946,6,2,4,59,59],[1946,6,1,23,59,59],
          '1945090204:00:00','1945090123:00:00','1946060204:59:59','1946060123:59:59' ],
     ],
   1946 =>
     [
        [ [1946,6,2,5,0,0],[1946,6,2,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1946,9,1,3,59,59],[1946,8,31,23,59,59],
          '1946060205:00:00','1946060201:00:00','1946090103:59:59','1946083123:59:59' ],
        [ [1946,9,1,4,0,0],[1946,8,31,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1965,6,1,4,59,59],[1965,5,31,23,59,59],
          '1946090104:00:00','1946083123:00:00','1965060104:59:59','1965053123:59:59' ],
     ],
   1965 =>
     [
        [ [1965,6,1,5,0,0],[1965,6,1,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1965,9,30,3,59,59],[1965,9,29,23,59,59],
          '1965060105:00:00','1965060101:00:00','1965093003:59:59','1965092923:59:59' ],
        [ [1965,9,30,4,0,0],[1965,9,29,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1966,5,29,4,59,59],[1966,5,28,23,59,59],
          '1965093004:00:00','1965092923:00:00','1966052904:59:59','1966052823:59:59' ],
     ],
   1966 =>
     [
        [ [1966,5,29,5,0,0],[1966,5,29,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1966,10,2,3,59,59],[1966,10,1,23,59,59],
          '1966052905:00:00','1966052901:00:00','1966100203:59:59','1966100123:59:59' ],
        [ [1966,10,2,4,0,0],[1966,10,1,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1967,4,8,4,59,59],[1967,4,7,23,59,59],
          '1966100204:00:00','1966100123:00:00','1967040804:59:59','1967040723:59:59' ],
     ],
   1967 =>
     [
        [ [1967,4,8,5,0,0],[1967,4,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1967,9,10,3,59,59],[1967,9,9,23,59,59],
          '1967040805:00:00','1967040801:00:00','1967091003:59:59','1967090923:59:59' ],
        [ [1967,9,10,4,0,0],[1967,9,9,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1968,4,14,4,59,59],[1968,4,13,23,59,59],
          '1967091004:00:00','1967090923:00:00','1968041404:59:59','1968041323:59:59' ],
     ],
   1968 =>
     [
        [ [1968,4,14,5,0,0],[1968,4,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1968,9,8,3,59,59],[1968,9,7,23,59,59],
          '1968041405:00:00','1968041401:00:00','1968090803:59:59','1968090723:59:59' ],
        [ [1968,9,8,4,0,0],[1968,9,7,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1969,4,27,4,59,59],[1969,4,26,23,59,59],
          '1968090804:00:00','1968090723:00:00','1969042704:59:59','1969042623:59:59' ],
     ],
   1969 =>
     [
        [ [1969,4,27,5,0,0],[1969,4,27,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1969,10,26,3,59,59],[1969,10,25,23,59,59],
          '1969042705:00:00','1969042701:00:00','1969102603:59:59','1969102523:59:59' ],
        [ [1969,10,26,4,0,0],[1969,10,25,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1970,4,26,4,59,59],[1970,4,25,23,59,59],
          '1969102604:00:00','1969102523:00:00','1970042604:59:59','1970042523:59:59' ],
     ],
   1970 =>
     [
        [ [1970,4,26,5,0,0],[1970,4,26,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1970,10,25,3,59,59],[1970,10,24,23,59,59],
          '1970042605:00:00','1970042601:00:00','1970102503:59:59','1970102423:59:59' ],
        [ [1970,10,25,4,0,0],[1970,10,24,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1971,4,25,4,59,59],[1971,4,24,23,59,59],
          '1970102504:00:00','1970102423:00:00','1971042504:59:59','1971042423:59:59' ],
     ],
   1971 =>
     [
        [ [1971,4,25,5,0,0],[1971,4,25,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1971,10,31,3,59,59],[1971,10,30,23,59,59],
          '1971042505:00:00','1971042501:00:00','1971103103:59:59','1971103023:59:59' ],
        [ [1971,10,31,4,0,0],[1971,10,30,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1972,4,30,4,59,59],[1972,4,29,23,59,59],
          '1971103104:00:00','1971103023:00:00','1972043004:59:59','1972042923:59:59' ],
     ],
   1972 =>
     [
        [ [1972,4,30,5,0,0],[1972,4,30,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1972,10,8,3,59,59],[1972,10,7,23,59,59],
          '1972043005:00:00','1972043001:00:00','1972100803:59:59','1972100723:59:59' ],
        [ [1972,10,8,4,0,0],[1972,10,7,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1973,4,29,4,59,59],[1973,4,28,23,59,59],
          '1972100804:00:00','1972100723:00:00','1973042904:59:59','1973042823:59:59' ],
     ],
   1973 =>
     [
        [ [1973,4,29,5,0,0],[1973,4,29,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1973,10,8,3,59,59],[1973,10,7,23,59,59],
          '1973042905:00:00','1973042901:00:00','1973100803:59:59','1973100723:59:59' ],
        [ [1973,10,8,4,0,0],[1973,10,7,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1974,4,28,4,59,59],[1974,4,27,23,59,59],
          '1973100804:00:00','1973100723:00:00','1974042804:59:59','1974042723:59:59' ],
     ],
   1974 =>
     [
        [ [1974,4,28,5,0,0],[1974,4,28,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1974,10,8,3,59,59],[1974,10,7,23,59,59],
          '1974042805:00:00','1974042801:00:00','1974100803:59:59','1974100723:59:59' ],
        [ [1974,10,8,4,0,0],[1974,10,7,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1975,4,27,4,59,59],[1975,4,26,23,59,59],
          '1974100804:00:00','1974100723:00:00','1975042704:59:59','1975042623:59:59' ],
     ],
   1975 =>
     [
        [ [1975,4,27,5,0,0],[1975,4,27,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1975,10,26,3,59,59],[1975,10,25,23,59,59],
          '1975042705:00:00','1975042701:00:00','1975102603:59:59','1975102523:59:59' ],
        [ [1975,10,26,4,0,0],[1975,10,25,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1976,4,25,4,59,59],[1976,4,24,23,59,59],
          '1975102604:00:00','1975102523:00:00','1976042504:59:59','1976042423:59:59' ],
     ],
   1976 =>
     [
        [ [1976,4,25,5,0,0],[1976,4,25,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1976,10,31,3,59,59],[1976,10,30,23,59,59],
          '1976042505:00:00','1976042501:00:00','1976103103:59:59','1976103023:59:59' ],
        [ [1976,10,31,4,0,0],[1976,10,30,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1977,4,24,4,59,59],[1977,4,23,23,59,59],
          '1976103104:00:00','1976103023:00:00','1977042404:59:59','1977042323:59:59' ],
     ],
   1977 =>
     [
        [ [1977,4,24,5,0,0],[1977,4,24,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1977,10,30,3,59,59],[1977,10,29,23,59,59],
          '1977042405:00:00','1977042401:00:00','1977103003:59:59','1977102923:59:59' ],
        [ [1977,10,30,4,0,0],[1977,10,29,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1978,5,7,4,59,59],[1978,5,6,23,59,59],
          '1977103004:00:00','1977102923:00:00','1978050704:59:59','1978050623:59:59' ],
     ],
   1978 =>
     [
        [ [1978,5,7,5,0,0],[1978,5,7,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1978,10,8,3,59,59],[1978,10,7,23,59,59],
          '1978050705:00:00','1978050701:00:00','1978100803:59:59','1978100723:59:59' ],
        [ [1978,10,8,4,0,0],[1978,10,7,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1979,3,18,4,59,59],[1979,3,17,23,59,59],
          '1978100804:00:00','1978100723:00:00','1979031804:59:59','1979031723:59:59' ],
     ],
   1979 =>
     [
        [ [1979,3,18,5,0,0],[1979,3,18,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1979,10,14,3,59,59],[1979,10,13,23,59,59],
          '1979031805:00:00','1979031801:00:00','1979101403:59:59','1979101323:59:59' ],
        [ [1979,10,14,4,0,0],[1979,10,13,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1980,3,16,4,59,59],[1980,3,15,23,59,59],
          '1979101404:00:00','1979101323:00:00','1980031604:59:59','1980031523:59:59' ],
     ],
   1980 =>
     [
        [ [1980,3,16,5,0,0],[1980,3,16,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1980,10,12,3,59,59],[1980,10,11,23,59,59],
          '1980031605:00:00','1980031601:00:00','1980101203:59:59','1980101123:59:59' ],
        [ [1980,10,12,4,0,0],[1980,10,11,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1981,5,10,4,59,59],[1981,5,9,23,59,59],
          '1980101204:00:00','1980101123:00:00','1981051004:59:59','1981050923:59:59' ],
     ],
   1981 =>
     [
        [ [1981,5,10,5,0,0],[1981,5,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1981,10,11,3,59,59],[1981,10,10,23,59,59],
          '1981051005:00:00','1981051001:00:00','1981101103:59:59','1981101023:59:59' ],
        [ [1981,10,11,4,0,0],[1981,10,10,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1982,5,9,4,59,59],[1982,5,8,23,59,59],
          '1981101104:00:00','1981101023:00:00','1982050904:59:59','1982050823:59:59' ],
     ],
   1982 =>
     [
        [ [1982,5,9,5,0,0],[1982,5,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1982,10,10,3,59,59],[1982,10,9,23,59,59],
          '1982050905:00:00','1982050901:00:00','1982101003:59:59','1982100923:59:59' ],
        [ [1982,10,10,4,0,0],[1982,10,9,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1983,5,8,4,59,59],[1983,5,7,23,59,59],
          '1982101004:00:00','1982100923:00:00','1983050804:59:59','1983050723:59:59' ],
     ],
   1983 =>
     [
        [ [1983,5,8,5,0,0],[1983,5,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1983,10,9,3,59,59],[1983,10,8,23,59,59],
          '1983050805:00:00','1983050801:00:00','1983100903:59:59','1983100823:59:59' ],
        [ [1983,10,9,4,0,0],[1983,10,8,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1984,5,6,4,59,59],[1984,5,5,23,59,59],
          '1983100904:00:00','1983100823:00:00','1984050604:59:59','1984050523:59:59' ],
     ],
   1984 =>
     [
        [ [1984,5,6,5,0,0],[1984,5,6,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1984,10,14,3,59,59],[1984,10,13,23,59,59],
          '1984050605:00:00','1984050601:00:00','1984101403:59:59','1984101323:59:59' ],
        [ [1984,10,14,4,0,0],[1984,10,13,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1985,5,5,4,59,59],[1985,5,4,23,59,59],
          '1984101404:00:00','1984101323:00:00','1985050504:59:59','1985050423:59:59' ],
     ],
   1985 =>
     [
        [ [1985,5,5,5,0,0],[1985,5,5,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1985,10,13,3,59,59],[1985,10,12,23,59,59],
          '1985050505:00:00','1985050501:00:00','1985101303:59:59','1985101223:59:59' ],
        [ [1985,10,13,4,0,0],[1985,10,12,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1986,3,16,4,59,59],[1986,3,15,23,59,59],
          '1985101304:00:00','1985101223:00:00','1986031604:59:59','1986031523:59:59' ],
     ],
   1986 =>
     [
        [ [1986,3,16,5,0,0],[1986,3,16,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1986,10,12,3,59,59],[1986,10,11,23,59,59],
          '1986031605:00:00','1986031601:00:00','1986101203:59:59','1986101123:59:59' ],
        [ [1986,10,12,4,0,0],[1986,10,11,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1987,3,15,4,59,59],[1987,3,14,23,59,59],
          '1986101204:00:00','1986101123:00:00','1987031504:59:59','1987031423:59:59' ],
     ],
   1987 =>
     [
        [ [1987,3,15,5,0,0],[1987,3,15,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1987,10,11,3,59,59],[1987,10,10,23,59,59],
          '1987031505:00:00','1987031501:00:00','1987101103:59:59','1987101023:59:59' ],
        [ [1987,10,11,4,0,0],[1987,10,10,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1988,3,20,4,59,59],[1988,3,19,23,59,59],
          '1987101104:00:00','1987101023:00:00','1988032004:59:59','1988031923:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,20,5,0,0],[1988,3,20,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1988,10,9,3,59,59],[1988,10,8,23,59,59],
          '1988032005:00:00','1988032001:00:00','1988100903:59:59','1988100823:59:59' ],
        [ [1988,10,9,4,0,0],[1988,10,8,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1989,3,19,4,59,59],[1989,3,18,23,59,59],
          '1988100904:00:00','1988100823:00:00','1989031904:59:59','1989031823:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,19,5,0,0],[1989,3,19,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1989,10,8,3,59,59],[1989,10,7,23,59,59],
          '1989031905:00:00','1989031901:00:00','1989100803:59:59','1989100723:59:59' ],
        [ [1989,10,8,4,0,0],[1989,10,7,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1990,4,1,4,59,59],[1990,3,31,23,59,59],
          '1989100804:00:00','1989100723:00:00','1990040104:59:59','1990033123:59:59' ],
     ],
   1990 =>
     [
        [ [1990,4,1,5,0,0],[1990,4,1,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1990,10,14,3,59,59],[1990,10,13,23,59,59],
          '1990040105:00:00','1990040101:00:00','1990101403:59:59','1990101323:59:59' ],
        [ [1990,10,14,4,0,0],[1990,10,13,23,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1991,4,7,4,59,59],[1991,4,6,23,59,59],
          '1990101404:00:00','1990101323:00:00','1991040704:59:59','1991040623:59:59' ],
     ],
   1991 =>
     [
        [ [1991,4,7,5,0,0],[1991,4,7,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1991,10,13,4,59,59],[1991,10,13,0,59,59],
          '1991040705:00:00','1991040701:00:00','1991101304:59:59','1991101300:59:59' ],
        [ [1991,10,13,5,0,0],[1991,10,13,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1992,4,5,4,59,59],[1992,4,4,23,59,59],
          '1991101305:00:00','1991101300:00:00','1992040504:59:59','1992040423:59:59' ],
     ],
   1992 =>
     [
        [ [1992,4,5,5,0,0],[1992,4,5,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1992,10,11,4,59,59],[1992,10,11,0,59,59],
          '1992040505:00:00','1992040501:00:00','1992101104:59:59','1992101100:59:59' ],
        [ [1992,10,11,5,0,0],[1992,10,11,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1993,4,4,4,59,59],[1993,4,3,23,59,59],
          '1992101105:00:00','1992101100:00:00','1993040404:59:59','1993040323:59:59' ],
     ],
   1993 =>
     [
        [ [1993,4,4,5,0,0],[1993,4,4,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1993,10,10,4,59,59],[1993,10,10,0,59,59],
          '1993040405:00:00','1993040401:00:00','1993101004:59:59','1993101000:59:59' ],
        [ [1993,10,10,5,0,0],[1993,10,10,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1994,4,3,4,59,59],[1994,4,2,23,59,59],
          '1993101005:00:00','1993101000:00:00','1994040304:59:59','1994040223:59:59' ],
     ],
   1994 =>
     [
        [ [1994,4,3,5,0,0],[1994,4,3,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1994,10,9,4,59,59],[1994,10,9,0,59,59],
          '1994040305:00:00','1994040301:00:00','1994100904:59:59','1994100900:59:59' ],
        [ [1994,10,9,5,0,0],[1994,10,9,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1995,4,2,4,59,59],[1995,4,1,23,59,59],
          '1994100905:00:00','1994100900:00:00','1995040204:59:59','1995040123:59:59' ],
     ],
   1995 =>
     [
        [ [1995,4,2,5,0,0],[1995,4,2,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1995,10,8,4,59,59],[1995,10,8,0,59,59],
          '1995040205:00:00','1995040201:00:00','1995100804:59:59','1995100800:59:59' ],
        [ [1995,10,8,5,0,0],[1995,10,8,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1996,4,7,4,59,59],[1996,4,6,23,59,59],
          '1995100805:00:00','1995100800:00:00','1996040704:59:59','1996040623:59:59' ],
     ],
   1996 =>
     [
        [ [1996,4,7,5,0,0],[1996,4,7,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1996,10,6,4,59,59],[1996,10,6,0,59,59],
          '1996040705:00:00','1996040701:00:00','1996100604:59:59','1996100600:59:59' ],
        [ [1996,10,6,5,0,0],[1996,10,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1997,4,6,4,59,59],[1997,4,5,23,59,59],
          '1996100605:00:00','1996100600:00:00','1997040604:59:59','1997040523:59:59' ],
     ],
   1997 =>
     [
        [ [1997,4,6,5,0,0],[1997,4,6,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1997,10,12,4,59,59],[1997,10,12,0,59,59],
          '1997040605:00:00','1997040601:00:00','1997101204:59:59','1997101200:59:59' ],
        [ [1997,10,12,5,0,0],[1997,10,12,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1998,3,29,4,59,59],[1998,3,28,23,59,59],
          '1997101205:00:00','1997101200:00:00','1998032904:59:59','1998032823:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,29,5,0,0],[1998,3,29,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1998,10,25,4,59,59],[1998,10,25,0,59,59],
          '1998032905:00:00','1998032901:00:00','1998102504:59:59','1998102500:59:59' ],
        [ [1998,10,25,5,0,0],[1998,10,25,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[1999,3,28,4,59,59],[1999,3,27,23,59,59],
          '1998102505:00:00','1998102500:00:00','1999032804:59:59','1999032723:59:59' ],
     ],
   1999 =>
     [
        [ [1999,3,28,5,0,0],[1999,3,28,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[1999,10,31,4,59,59],[1999,10,31,0,59,59],
          '1999032805:00:00','1999032801:00:00','1999103104:59:59','1999103100:59:59' ],
        [ [1999,10,31,5,0,0],[1999,10,31,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2000,4,2,4,59,59],[2000,4,1,23,59,59],
          '1999103105:00:00','1999103100:00:00','2000040204:59:59','2000040123:59:59' ],
     ],
   2000 =>
     [
        [ [2000,4,2,5,0,0],[2000,4,2,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2000,10,29,4,59,59],[2000,10,29,0,59,59],
          '2000040205:00:00','2000040201:00:00','2000102904:59:59','2000102900:59:59' ],
        [ [2000,10,29,5,0,0],[2000,10,29,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2001,4,1,4,59,59],[2001,3,31,23,59,59],
          '2000102905:00:00','2000102900:00:00','2001040104:59:59','2001033123:59:59' ],
     ],
   2001 =>
     [
        [ [2001,4,1,5,0,0],[2001,4,1,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2001,10,28,4,59,59],[2001,10,28,0,59,59],
          '2001040105:00:00','2001040101:00:00','2001102804:59:59','2001102800:59:59' ],
        [ [2001,10,28,5,0,0],[2001,10,28,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2002,4,7,4,59,59],[2002,4,6,23,59,59],
          '2001102805:00:00','2001102800:00:00','2002040704:59:59','2002040623:59:59' ],
     ],
   2002 =>
     [
        [ [2002,4,7,5,0,0],[2002,4,7,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2002,10,27,4,59,59],[2002,10,27,0,59,59],
          '2002040705:00:00','2002040701:00:00','2002102704:59:59','2002102700:59:59' ],
        [ [2002,10,27,5,0,0],[2002,10,27,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2003,4,6,4,59,59],[2003,4,5,23,59,59],
          '2002102705:00:00','2002102700:00:00','2003040604:59:59','2003040523:59:59' ],
     ],
   2003 =>
     [
        [ [2003,4,6,5,0,0],[2003,4,6,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2003,10,26,4,59,59],[2003,10,26,0,59,59],
          '2003040605:00:00','2003040601:00:00','2003102604:59:59','2003102600:59:59' ],
        [ [2003,10,26,5,0,0],[2003,10,26,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2004,3,28,4,59,59],[2004,3,27,23,59,59],
          '2003102605:00:00','2003102600:00:00','2004032804:59:59','2004032723:59:59' ],
     ],
   2004 =>
     [
        [ [2004,3,28,5,0,0],[2004,3,28,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2006,10,29,4,59,59],[2006,10,29,0,59,59],
          '2004032805:00:00','2004032801:00:00','2006102904:59:59','2006102900:59:59' ],
     ],
   2006 =>
     [
        [ [2006,10,29,5,0,0],[2006,10,29,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2007,3,11,4,59,59],[2007,3,10,23,59,59],
          '2006102905:00:00','2006102900:00:00','2007031104:59:59','2007031023:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,11,5,0,0],[2007,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2007,10,28,4,59,59],[2007,10,28,0,59,59],
          '2007031105:00:00','2007031101:00:00','2007102804:59:59','2007102800:59:59' ],
        [ [2007,10,28,5,0,0],[2007,10,28,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2008,3,16,4,59,59],[2008,3,15,23,59,59],
          '2007102805:00:00','2007102800:00:00','2008031604:59:59','2008031523:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,16,5,0,0],[2008,3,16,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2008,10,26,4,59,59],[2008,10,26,0,59,59],
          '2008031605:00:00','2008031601:00:00','2008102604:59:59','2008102600:59:59' ],
        [ [2008,10,26,5,0,0],[2008,10,26,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2009,3,8,4,59,59],[2009,3,7,23,59,59],
          '2008102605:00:00','2008102600:00:00','2009030804:59:59','2009030723:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,8,5,0,0],[2009,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2009,10,25,4,59,59],[2009,10,25,0,59,59],
          '2009030805:00:00','2009030801:00:00','2009102504:59:59','2009102500:59:59' ],
        [ [2009,10,25,5,0,0],[2009,10,25,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2010,3,14,4,59,59],[2010,3,13,23,59,59],
          '2009102505:00:00','2009102500:00:00','2010031404:59:59','2010031323:59:59' ],
     ],
   2010 =>
     [
        [ [2010,3,14,5,0,0],[2010,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2010,10,31,4,59,59],[2010,10,31,0,59,59],
          '2010031405:00:00','2010031401:00:00','2010103104:59:59','2010103100:59:59' ],
        [ [2010,10,31,5,0,0],[2010,10,31,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2011,3,20,4,59,59],[2011,3,19,23,59,59],
          '2010103105:00:00','2010103100:00:00','2011032004:59:59','2011031923:59:59' ],
     ],
   2011 =>
     [
        [ [2011,3,20,5,0,0],[2011,3,20,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2011,11,13,4,59,59],[2011,11,13,0,59,59],
          '2011032005:00:00','2011032001:00:00','2011111304:59:59','2011111300:59:59' ],
        [ [2011,11,13,5,0,0],[2011,11,13,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2012,4,1,4,59,59],[2012,3,31,23,59,59],
          '2011111305:00:00','2011111300:00:00','2012040104:59:59','2012033123:59:59' ],
     ],
   2012 =>
     [
        [ [2012,4,1,5,0,0],[2012,4,1,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2012,11,4,4,59,59],[2012,11,4,0,59,59],
          '2012040105:00:00','2012040101:00:00','2012110404:59:59','2012110400:59:59' ],
        [ [2012,11,4,5,0,0],[2012,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2013,3,10,4,59,59],[2013,3,9,23,59,59],
          '2012110405:00:00','2012110400:00:00','2013031004:59:59','2013030923:59:59' ],
     ],
   2013 =>
     [
        [ [2013,3,10,5,0,0],[2013,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2013,11,3,4,59,59],[2013,11,3,0,59,59],
          '2013031005:00:00','2013031001:00:00','2013110304:59:59','2013110300:59:59' ],
        [ [2013,11,3,5,0,0],[2013,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2014,3,9,4,59,59],[2014,3,8,23,59,59],
          '2013110305:00:00','2013110300:00:00','2014030904:59:59','2014030823:59:59' ],
     ],
   2014 =>
     [
        [ [2014,3,9,5,0,0],[2014,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2014,11,2,4,59,59],[2014,11,2,0,59,59],
          '2014030905:00:00','2014030901:00:00','2014110204:59:59','2014110200:59:59' ],
        [ [2014,11,2,5,0,0],[2014,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2015,3,8,4,59,59],[2015,3,7,23,59,59],
          '2014110205:00:00','2014110200:00:00','2015030804:59:59','2015030723:59:59' ],
     ],
   2015 =>
     [
        [ [2015,3,8,5,0,0],[2015,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2015,11,1,4,59,59],[2015,11,1,0,59,59],
          '2015030805:00:00','2015030801:00:00','2015110104:59:59','2015110100:59:59' ],
        [ [2015,11,1,5,0,0],[2015,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2016,3,13,4,59,59],[2016,3,12,23,59,59],
          '2015110105:00:00','2015110100:00:00','2016031304:59:59','2016031223:59:59' ],
     ],
   2016 =>
     [
        [ [2016,3,13,5,0,0],[2016,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2016,11,6,4,59,59],[2016,11,6,0,59,59],
          '2016031305:00:00','2016031301:00:00','2016110604:59:59','2016110600:59:59' ],
        [ [2016,11,6,5,0,0],[2016,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2017,3,12,4,59,59],[2017,3,11,23,59,59],
          '2016110605:00:00','2016110600:00:00','2017031204:59:59','2017031123:59:59' ],
     ],
   2017 =>
     [
        [ [2017,3,12,5,0,0],[2017,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2017,11,5,4,59,59],[2017,11,5,0,59,59],
          '2017031205:00:00','2017031201:00:00','2017110504:59:59','2017110500:59:59' ],
        [ [2017,11,5,5,0,0],[2017,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2018,3,11,4,59,59],[2018,3,10,23,59,59],
          '2017110505:00:00','2017110500:00:00','2018031104:59:59','2018031023:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,11,5,0,0],[2018,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2018,11,4,4,59,59],[2018,11,4,0,59,59],
          '2018031105:00:00','2018031101:00:00','2018110404:59:59','2018110400:59:59' ],
        [ [2018,11,4,5,0,0],[2018,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2019,3,10,4,59,59],[2019,3,9,23,59,59],
          '2018110405:00:00','2018110400:00:00','2019031004:59:59','2019030923:59:59' ],
     ],
   2019 =>
     [
        [ [2019,3,10,5,0,0],[2019,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2019,11,3,4,59,59],[2019,11,3,0,59,59],
          '2019031005:00:00','2019031001:00:00','2019110304:59:59','2019110300:59:59' ],
        [ [2019,11,3,5,0,0],[2019,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2020,3,8,4,59,59],[2020,3,7,23,59,59],
          '2019110305:00:00','2019110300:00:00','2020030804:59:59','2020030723:59:59' ],
     ],
   2020 =>
     [
        [ [2020,3,8,5,0,0],[2020,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2020,11,1,4,59,59],[2020,11,1,0,59,59],
          '2020030805:00:00','2020030801:00:00','2020110104:59:59','2020110100:59:59' ],
        [ [2020,11,1,5,0,0],[2020,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2021,3,14,4,59,59],[2021,3,13,23,59,59],
          '2020110105:00:00','2020110100:00:00','2021031404:59:59','2021031323:59:59' ],
     ],
   2021 =>
     [
        [ [2021,3,14,5,0,0],[2021,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2021,11,7,4,59,59],[2021,11,7,0,59,59],
          '2021031405:00:00','2021031401:00:00','2021110704:59:59','2021110700:59:59' ],
        [ [2021,11,7,5,0,0],[2021,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2022,3,13,4,59,59],[2022,3,12,23,59,59],
          '2021110705:00:00','2021110700:00:00','2022031304:59:59','2022031223:59:59' ],
     ],
   2022 =>
     [
        [ [2022,3,13,5,0,0],[2022,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2022,11,6,4,59,59],[2022,11,6,0,59,59],
          '2022031305:00:00','2022031301:00:00','2022110604:59:59','2022110600:59:59' ],
        [ [2022,11,6,5,0,0],[2022,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2023,3,12,4,59,59],[2023,3,11,23,59,59],
          '2022110605:00:00','2022110600:00:00','2023031204:59:59','2023031123:59:59' ],
     ],
   2023 =>
     [
        [ [2023,3,12,5,0,0],[2023,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2023,11,5,4,59,59],[2023,11,5,0,59,59],
          '2023031205:00:00','2023031201:00:00','2023110504:59:59','2023110500:59:59' ],
        [ [2023,11,5,5,0,0],[2023,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2024,3,10,4,59,59],[2024,3,9,23,59,59],
          '2023110505:00:00','2023110500:00:00','2024031004:59:59','2024030923:59:59' ],
     ],
   2024 =>
     [
        [ [2024,3,10,5,0,0],[2024,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2024,11,3,4,59,59],[2024,11,3,0,59,59],
          '2024031005:00:00','2024031001:00:00','2024110304:59:59','2024110300:59:59' ],
        [ [2024,11,3,5,0,0],[2024,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2025,3,9,4,59,59],[2025,3,8,23,59,59],
          '2024110305:00:00','2024110300:00:00','2025030904:59:59','2025030823:59:59' ],
     ],
   2025 =>
     [
        [ [2025,3,9,5,0,0],[2025,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2025,11,2,4,59,59],[2025,11,2,0,59,59],
          '2025030905:00:00','2025030901:00:00','2025110204:59:59','2025110200:59:59' ],
        [ [2025,11,2,5,0,0],[2025,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2026,3,8,4,59,59],[2026,3,7,23,59,59],
          '2025110205:00:00','2025110200:00:00','2026030804:59:59','2026030723:59:59' ],
     ],
   2026 =>
     [
        [ [2026,3,8,5,0,0],[2026,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2026,11,1,4,59,59],[2026,11,1,0,59,59],
          '2026030805:00:00','2026030801:00:00','2026110104:59:59','2026110100:59:59' ],
        [ [2026,11,1,5,0,0],[2026,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2027,3,14,4,59,59],[2027,3,13,23,59,59],
          '2026110105:00:00','2026110100:00:00','2027031404:59:59','2027031323:59:59' ],
     ],
   2027 =>
     [
        [ [2027,3,14,5,0,0],[2027,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2027,11,7,4,59,59],[2027,11,7,0,59,59],
          '2027031405:00:00','2027031401:00:00','2027110704:59:59','2027110700:59:59' ],
        [ [2027,11,7,5,0,0],[2027,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2028,3,12,4,59,59],[2028,3,11,23,59,59],
          '2027110705:00:00','2027110700:00:00','2028031204:59:59','2028031123:59:59' ],
     ],
   2028 =>
     [
        [ [2028,3,12,5,0,0],[2028,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2028,11,5,4,59,59],[2028,11,5,0,59,59],
          '2028031205:00:00','2028031201:00:00','2028110504:59:59','2028110500:59:59' ],
        [ [2028,11,5,5,0,0],[2028,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2029,3,11,4,59,59],[2029,3,10,23,59,59],
          '2028110505:00:00','2028110500:00:00','2029031104:59:59','2029031023:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,11,5,0,0],[2029,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2029,11,4,4,59,59],[2029,11,4,0,59,59],
          '2029031105:00:00','2029031101:00:00','2029110404:59:59','2029110400:59:59' ],
        [ [2029,11,4,5,0,0],[2029,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2030,3,10,4,59,59],[2030,3,9,23,59,59],
          '2029110405:00:00','2029110400:00:00','2030031004:59:59','2030030923:59:59' ],
     ],
   2030 =>
     [
        [ [2030,3,10,5,0,0],[2030,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2030,11,3,4,59,59],[2030,11,3,0,59,59],
          '2030031005:00:00','2030031001:00:00','2030110304:59:59','2030110300:59:59' ],
        [ [2030,11,3,5,0,0],[2030,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2031,3,9,4,59,59],[2031,3,8,23,59,59],
          '2030110305:00:00','2030110300:00:00','2031030904:59:59','2031030823:59:59' ],
     ],
   2031 =>
     [
        [ [2031,3,9,5,0,0],[2031,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2031,11,2,4,59,59],[2031,11,2,0,59,59],
          '2031030905:00:00','2031030901:00:00','2031110204:59:59','2031110200:59:59' ],
        [ [2031,11,2,5,0,0],[2031,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2032,3,14,4,59,59],[2032,3,13,23,59,59],
          '2031110205:00:00','2031110200:00:00','2032031404:59:59','2032031323:59:59' ],
     ],
   2032 =>
     [
        [ [2032,3,14,5,0,0],[2032,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2032,11,7,4,59,59],[2032,11,7,0,59,59],
          '2032031405:00:00','2032031401:00:00','2032110704:59:59','2032110700:59:59' ],
        [ [2032,11,7,5,0,0],[2032,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2033,3,13,4,59,59],[2033,3,12,23,59,59],
          '2032110705:00:00','2032110700:00:00','2033031304:59:59','2033031223:59:59' ],
     ],
   2033 =>
     [
        [ [2033,3,13,5,0,0],[2033,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2033,11,6,4,59,59],[2033,11,6,0,59,59],
          '2033031305:00:00','2033031301:00:00','2033110604:59:59','2033110600:59:59' ],
        [ [2033,11,6,5,0,0],[2033,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2034,3,12,4,59,59],[2034,3,11,23,59,59],
          '2033110605:00:00','2033110600:00:00','2034031204:59:59','2034031123:59:59' ],
     ],
   2034 =>
     [
        [ [2034,3,12,5,0,0],[2034,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2034,11,5,4,59,59],[2034,11,5,0,59,59],
          '2034031205:00:00','2034031201:00:00','2034110504:59:59','2034110500:59:59' ],
        [ [2034,11,5,5,0,0],[2034,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2035,3,11,4,59,59],[2035,3,10,23,59,59],
          '2034110505:00:00','2034110500:00:00','2035031104:59:59','2035031023:59:59' ],
     ],
   2035 =>
     [
        [ [2035,3,11,5,0,0],[2035,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2035,11,4,4,59,59],[2035,11,4,0,59,59],
          '2035031105:00:00','2035031101:00:00','2035110404:59:59','2035110400:59:59' ],
        [ [2035,11,4,5,0,0],[2035,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2036,3,9,4,59,59],[2036,3,8,23,59,59],
          '2035110405:00:00','2035110400:00:00','2036030904:59:59','2036030823:59:59' ],
     ],
   2036 =>
     [
        [ [2036,3,9,5,0,0],[2036,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2036,11,2,4,59,59],[2036,11,2,0,59,59],
          '2036030905:00:00','2036030901:00:00','2036110204:59:59','2036110200:59:59' ],
        [ [2036,11,2,5,0,0],[2036,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2037,3,8,4,59,59],[2037,3,7,23,59,59],
          '2036110205:00:00','2036110200:00:00','2037030804:59:59','2037030723:59:59' ],
     ],
   2037 =>
     [
        [ [2037,3,8,5,0,0],[2037,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2037,11,1,4,59,59],[2037,11,1,0,59,59],
          '2037030805:00:00','2037030801:00:00','2037110104:59:59','2037110100:59:59' ],
        [ [2037,11,1,5,0,0],[2037,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2038,3,14,4,59,59],[2038,3,13,23,59,59],
          '2037110105:00:00','2037110100:00:00','2038031404:59:59','2038031323:59:59' ],
     ],
   2038 =>
     [
        [ [2038,3,14,5,0,0],[2038,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2038,11,7,4,59,59],[2038,11,7,0,59,59],
          '2038031405:00:00','2038031401:00:00','2038110704:59:59','2038110700:59:59' ],
        [ [2038,11,7,5,0,0],[2038,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2039,3,13,4,59,59],[2039,3,12,23,59,59],
          '2038110705:00:00','2038110700:00:00','2039031304:59:59','2039031223:59:59' ],
     ],
   2039 =>
     [
        [ [2039,3,13,5,0,0],[2039,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2039,11,6,4,59,59],[2039,11,6,0,59,59],
          '2039031305:00:00','2039031301:00:00','2039110604:59:59','2039110600:59:59' ],
        [ [2039,11,6,5,0,0],[2039,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2040,3,11,4,59,59],[2040,3,10,23,59,59],
          '2039110605:00:00','2039110600:00:00','2040031104:59:59','2040031023:59:59' ],
     ],
   2040 =>
     [
        [ [2040,3,11,5,0,0],[2040,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2040,11,4,4,59,59],[2040,11,4,0,59,59],
          '2040031105:00:00','2040031101:00:00','2040110404:59:59','2040110400:59:59' ],
        [ [2040,11,4,5,0,0],[2040,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2041,3,10,4,59,59],[2041,3,9,23,59,59],
          '2040110405:00:00','2040110400:00:00','2041031004:59:59','2041030923:59:59' ],
     ],
   2041 =>
     [
        [ [2041,3,10,5,0,0],[2041,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2041,11,3,4,59,59],[2041,11,3,0,59,59],
          '2041031005:00:00','2041031001:00:00','2041110304:59:59','2041110300:59:59' ],
        [ [2041,11,3,5,0,0],[2041,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2042,3,9,4,59,59],[2042,3,8,23,59,59],
          '2041110305:00:00','2041110300:00:00','2042030904:59:59','2042030823:59:59' ],
     ],
   2042 =>
     [
        [ [2042,3,9,5,0,0],[2042,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2042,11,2,4,59,59],[2042,11,2,0,59,59],
          '2042030905:00:00','2042030901:00:00','2042110204:59:59','2042110200:59:59' ],
        [ [2042,11,2,5,0,0],[2042,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2043,3,8,4,59,59],[2043,3,7,23,59,59],
          '2042110205:00:00','2042110200:00:00','2043030804:59:59','2043030723:59:59' ],
     ],
   2043 =>
     [
        [ [2043,3,8,5,0,0],[2043,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2043,11,1,4,59,59],[2043,11,1,0,59,59],
          '2043030805:00:00','2043030801:00:00','2043110104:59:59','2043110100:59:59' ],
        [ [2043,11,1,5,0,0],[2043,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2044,3,13,4,59,59],[2044,3,12,23,59,59],
          '2043110105:00:00','2043110100:00:00','2044031304:59:59','2044031223:59:59' ],
     ],
   2044 =>
     [
        [ [2044,3,13,5,0,0],[2044,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2044,11,6,4,59,59],[2044,11,6,0,59,59],
          '2044031305:00:00','2044031301:00:00','2044110604:59:59','2044110600:59:59' ],
        [ [2044,11,6,5,0,0],[2044,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2045,3,12,4,59,59],[2045,3,11,23,59,59],
          '2044110605:00:00','2044110600:00:00','2045031204:59:59','2045031123:59:59' ],
     ],
   2045 =>
     [
        [ [2045,3,12,5,0,0],[2045,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2045,11,5,4,59,59],[2045,11,5,0,59,59],
          '2045031205:00:00','2045031201:00:00','2045110504:59:59','2045110500:59:59' ],
        [ [2045,11,5,5,0,0],[2045,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2046,3,11,4,59,59],[2046,3,10,23,59,59],
          '2045110505:00:00','2045110500:00:00','2046031104:59:59','2046031023:59:59' ],
     ],
   2046 =>
     [
        [ [2046,3,11,5,0,0],[2046,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2046,11,4,4,59,59],[2046,11,4,0,59,59],
          '2046031105:00:00','2046031101:00:00','2046110404:59:59','2046110400:59:59' ],
        [ [2046,11,4,5,0,0],[2046,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2047,3,10,4,59,59],[2047,3,9,23,59,59],
          '2046110405:00:00','2046110400:00:00','2047031004:59:59','2047030923:59:59' ],
     ],
   2047 =>
     [
        [ [2047,3,10,5,0,0],[2047,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2047,11,3,4,59,59],[2047,11,3,0,59,59],
          '2047031005:00:00','2047031001:00:00','2047110304:59:59','2047110300:59:59' ],
        [ [2047,11,3,5,0,0],[2047,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2048,3,8,4,59,59],[2048,3,7,23,59,59],
          '2047110305:00:00','2047110300:00:00','2048030804:59:59','2048030723:59:59' ],
     ],
   2048 =>
     [
        [ [2048,3,8,5,0,0],[2048,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2048,11,1,4,59,59],[2048,11,1,0,59,59],
          '2048030805:00:00','2048030801:00:00','2048110104:59:59','2048110100:59:59' ],
        [ [2048,11,1,5,0,0],[2048,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2049,3,14,4,59,59],[2049,3,13,23,59,59],
          '2048110105:00:00','2048110100:00:00','2049031404:59:59','2049031323:59:59' ],
     ],
   2049 =>
     [
        [ [2049,3,14,5,0,0],[2049,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2049,11,7,4,59,59],[2049,11,7,0,59,59],
          '2049031405:00:00','2049031401:00:00','2049110704:59:59','2049110700:59:59' ],
        [ [2049,11,7,5,0,0],[2049,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2050,3,13,4,59,59],[2050,3,12,23,59,59],
          '2049110705:00:00','2049110700:00:00','2050031304:59:59','2050031223:59:59' ],
     ],
   2050 =>
     [
        [ [2050,3,13,5,0,0],[2050,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2050,11,6,4,59,59],[2050,11,6,0,59,59],
          '2050031305:00:00','2050031301:00:00','2050110604:59:59','2050110600:59:59' ],
        [ [2050,11,6,5,0,0],[2050,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2051,3,12,4,59,59],[2051,3,11,23,59,59],
          '2050110605:00:00','2050110600:00:00','2051031204:59:59','2051031123:59:59' ],
     ],
   2051 =>
     [
        [ [2051,3,12,5,0,0],[2051,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2051,11,5,4,59,59],[2051,11,5,0,59,59],
          '2051031205:00:00','2051031201:00:00','2051110504:59:59','2051110500:59:59' ],
        [ [2051,11,5,5,0,0],[2051,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2052,3,10,4,59,59],[2052,3,9,23,59,59],
          '2051110505:00:00','2051110500:00:00','2052031004:59:59','2052030923:59:59' ],
     ],
   2052 =>
     [
        [ [2052,3,10,5,0,0],[2052,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2052,11,3,4,59,59],[2052,11,3,0,59,59],
          '2052031005:00:00','2052031001:00:00','2052110304:59:59','2052110300:59:59' ],
        [ [2052,11,3,5,0,0],[2052,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2053,3,9,4,59,59],[2053,3,8,23,59,59],
          '2052110305:00:00','2052110300:00:00','2053030904:59:59','2053030823:59:59' ],
     ],
   2053 =>
     [
        [ [2053,3,9,5,0,0],[2053,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2053,11,2,4,59,59],[2053,11,2,0,59,59],
          '2053030905:00:00','2053030901:00:00','2053110204:59:59','2053110200:59:59' ],
        [ [2053,11,2,5,0,0],[2053,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2054,3,8,4,59,59],[2054,3,7,23,59,59],
          '2053110205:00:00','2053110200:00:00','2054030804:59:59','2054030723:59:59' ],
     ],
   2054 =>
     [
        [ [2054,3,8,5,0,0],[2054,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2054,11,1,4,59,59],[2054,11,1,0,59,59],
          '2054030805:00:00','2054030801:00:00','2054110104:59:59','2054110100:59:59' ],
        [ [2054,11,1,5,0,0],[2054,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2055,3,14,4,59,59],[2055,3,13,23,59,59],
          '2054110105:00:00','2054110100:00:00','2055031404:59:59','2055031323:59:59' ],
     ],
   2055 =>
     [
        [ [2055,3,14,5,0,0],[2055,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2055,11,7,4,59,59],[2055,11,7,0,59,59],
          '2055031405:00:00','2055031401:00:00','2055110704:59:59','2055110700:59:59' ],
        [ [2055,11,7,5,0,0],[2055,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2056,3,12,4,59,59],[2056,3,11,23,59,59],
          '2055110705:00:00','2055110700:00:00','2056031204:59:59','2056031123:59:59' ],
     ],
   2056 =>
     [
        [ [2056,3,12,5,0,0],[2056,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2056,11,5,4,59,59],[2056,11,5,0,59,59],
          '2056031205:00:00','2056031201:00:00','2056110504:59:59','2056110500:59:59' ],
        [ [2056,11,5,5,0,0],[2056,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2057,3,11,4,59,59],[2057,3,10,23,59,59],
          '2056110505:00:00','2056110500:00:00','2057031104:59:59','2057031023:59:59' ],
     ],
   2057 =>
     [
        [ [2057,3,11,5,0,0],[2057,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2057,11,4,4,59,59],[2057,11,4,0,59,59],
          '2057031105:00:00','2057031101:00:00','2057110404:59:59','2057110400:59:59' ],
        [ [2057,11,4,5,0,0],[2057,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2058,3,10,4,59,59],[2058,3,9,23,59,59],
          '2057110405:00:00','2057110400:00:00','2058031004:59:59','2058030923:59:59' ],
     ],
   2058 =>
     [
        [ [2058,3,10,5,0,0],[2058,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2058,11,3,4,59,59],[2058,11,3,0,59,59],
          '2058031005:00:00','2058031001:00:00','2058110304:59:59','2058110300:59:59' ],
        [ [2058,11,3,5,0,0],[2058,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2059,3,9,4,59,59],[2059,3,8,23,59,59],
          '2058110305:00:00','2058110300:00:00','2059030904:59:59','2059030823:59:59' ],
     ],
   2059 =>
     [
        [ [2059,3,9,5,0,0],[2059,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2059,11,2,4,59,59],[2059,11,2,0,59,59],
          '2059030905:00:00','2059030901:00:00','2059110204:59:59','2059110200:59:59' ],
        [ [2059,11,2,5,0,0],[2059,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2060,3,14,4,59,59],[2060,3,13,23,59,59],
          '2059110205:00:00','2059110200:00:00','2060031404:59:59','2060031323:59:59' ],
     ],
   2060 =>
     [
        [ [2060,3,14,5,0,0],[2060,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2060,11,7,4,59,59],[2060,11,7,0,59,59],
          '2060031405:00:00','2060031401:00:00','2060110704:59:59','2060110700:59:59' ],
        [ [2060,11,7,5,0,0],[2060,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2061,3,13,4,59,59],[2061,3,12,23,59,59],
          '2060110705:00:00','2060110700:00:00','2061031304:59:59','2061031223:59:59' ],
     ],
   2061 =>
     [
        [ [2061,3,13,5,0,0],[2061,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2061,11,6,4,59,59],[2061,11,6,0,59,59],
          '2061031305:00:00','2061031301:00:00','2061110604:59:59','2061110600:59:59' ],
        [ [2061,11,6,5,0,0],[2061,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2062,3,12,4,59,59],[2062,3,11,23,59,59],
          '2061110605:00:00','2061110600:00:00','2062031204:59:59','2062031123:59:59' ],
     ],
   2062 =>
     [
        [ [2062,3,12,5,0,0],[2062,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2062,11,5,4,59,59],[2062,11,5,0,59,59],
          '2062031205:00:00','2062031201:00:00','2062110504:59:59','2062110500:59:59' ],
        [ [2062,11,5,5,0,0],[2062,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2063,3,11,4,59,59],[2063,3,10,23,59,59],
          '2062110505:00:00','2062110500:00:00','2063031104:59:59','2063031023:59:59' ],
     ],
   2063 =>
     [
        [ [2063,3,11,5,0,0],[2063,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2063,11,4,4,59,59],[2063,11,4,0,59,59],
          '2063031105:00:00','2063031101:00:00','2063110404:59:59','2063110400:59:59' ],
        [ [2063,11,4,5,0,0],[2063,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2064,3,9,4,59,59],[2064,3,8,23,59,59],
          '2063110405:00:00','2063110400:00:00','2064030904:59:59','2064030823:59:59' ],
     ],
   2064 =>
     [
        [ [2064,3,9,5,0,0],[2064,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2064,11,2,4,59,59],[2064,11,2,0,59,59],
          '2064030905:00:00','2064030901:00:00','2064110204:59:59','2064110200:59:59' ],
        [ [2064,11,2,5,0,0],[2064,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2065,3,8,4,59,59],[2065,3,7,23,59,59],
          '2064110205:00:00','2064110200:00:00','2065030804:59:59','2065030723:59:59' ],
     ],
   2065 =>
     [
        [ [2065,3,8,5,0,0],[2065,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2065,11,1,4,59,59],[2065,11,1,0,59,59],
          '2065030805:00:00','2065030801:00:00','2065110104:59:59','2065110100:59:59' ],
        [ [2065,11,1,5,0,0],[2065,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2066,3,14,4,59,59],[2066,3,13,23,59,59],
          '2065110105:00:00','2065110100:00:00','2066031404:59:59','2066031323:59:59' ],
     ],
   2066 =>
     [
        [ [2066,3,14,5,0,0],[2066,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2066,11,7,4,59,59],[2066,11,7,0,59,59],
          '2066031405:00:00','2066031401:00:00','2066110704:59:59','2066110700:59:59' ],
        [ [2066,11,7,5,0,0],[2066,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2067,3,13,4,59,59],[2067,3,12,23,59,59],
          '2066110705:00:00','2066110700:00:00','2067031304:59:59','2067031223:59:59' ],
     ],
   2067 =>
     [
        [ [2067,3,13,5,0,0],[2067,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2067,11,6,4,59,59],[2067,11,6,0,59,59],
          '2067031305:00:00','2067031301:00:00','2067110604:59:59','2067110600:59:59' ],
        [ [2067,11,6,5,0,0],[2067,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2068,3,11,4,59,59],[2068,3,10,23,59,59],
          '2067110605:00:00','2067110600:00:00','2068031104:59:59','2068031023:59:59' ],
     ],
   2068 =>
     [
        [ [2068,3,11,5,0,0],[2068,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2068,11,4,4,59,59],[2068,11,4,0,59,59],
          '2068031105:00:00','2068031101:00:00','2068110404:59:59','2068110400:59:59' ],
        [ [2068,11,4,5,0,0],[2068,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2069,3,10,4,59,59],[2069,3,9,23,59,59],
          '2068110405:00:00','2068110400:00:00','2069031004:59:59','2069030923:59:59' ],
     ],
   2069 =>
     [
        [ [2069,3,10,5,0,0],[2069,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2069,11,3,4,59,59],[2069,11,3,0,59,59],
          '2069031005:00:00','2069031001:00:00','2069110304:59:59','2069110300:59:59' ],
        [ [2069,11,3,5,0,0],[2069,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2070,3,9,4,59,59],[2070,3,8,23,59,59],
          '2069110305:00:00','2069110300:00:00','2070030904:59:59','2070030823:59:59' ],
     ],
   2070 =>
     [
        [ [2070,3,9,5,0,0],[2070,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2070,11,2,4,59,59],[2070,11,2,0,59,59],
          '2070030905:00:00','2070030901:00:00','2070110204:59:59','2070110200:59:59' ],
        [ [2070,11,2,5,0,0],[2070,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2071,3,8,4,59,59],[2071,3,7,23,59,59],
          '2070110205:00:00','2070110200:00:00','2071030804:59:59','2071030723:59:59' ],
     ],
   2071 =>
     [
        [ [2071,3,8,5,0,0],[2071,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2071,11,1,4,59,59],[2071,11,1,0,59,59],
          '2071030805:00:00','2071030801:00:00','2071110104:59:59','2071110100:59:59' ],
        [ [2071,11,1,5,0,0],[2071,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2072,3,13,4,59,59],[2072,3,12,23,59,59],
          '2071110105:00:00','2071110100:00:00','2072031304:59:59','2072031223:59:59' ],
     ],
   2072 =>
     [
        [ [2072,3,13,5,0,0],[2072,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2072,11,6,4,59,59],[2072,11,6,0,59,59],
          '2072031305:00:00','2072031301:00:00','2072110604:59:59','2072110600:59:59' ],
        [ [2072,11,6,5,0,0],[2072,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2073,3,12,4,59,59],[2073,3,11,23,59,59],
          '2072110605:00:00','2072110600:00:00','2073031204:59:59','2073031123:59:59' ],
     ],
   2073 =>
     [
        [ [2073,3,12,5,0,0],[2073,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2073,11,5,4,59,59],[2073,11,5,0,59,59],
          '2073031205:00:00','2073031201:00:00','2073110504:59:59','2073110500:59:59' ],
        [ [2073,11,5,5,0,0],[2073,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2074,3,11,4,59,59],[2074,3,10,23,59,59],
          '2073110505:00:00','2073110500:00:00','2074031104:59:59','2074031023:59:59' ],
     ],
   2074 =>
     [
        [ [2074,3,11,5,0,0],[2074,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2074,11,4,4,59,59],[2074,11,4,0,59,59],
          '2074031105:00:00','2074031101:00:00','2074110404:59:59','2074110400:59:59' ],
        [ [2074,11,4,5,0,0],[2074,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2075,3,10,4,59,59],[2075,3,9,23,59,59],
          '2074110405:00:00','2074110400:00:00','2075031004:59:59','2075030923:59:59' ],
     ],
   2075 =>
     [
        [ [2075,3,10,5,0,0],[2075,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2075,11,3,4,59,59],[2075,11,3,0,59,59],
          '2075031005:00:00','2075031001:00:00','2075110304:59:59','2075110300:59:59' ],
        [ [2075,11,3,5,0,0],[2075,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2076,3,8,4,59,59],[2076,3,7,23,59,59],
          '2075110305:00:00','2075110300:00:00','2076030804:59:59','2076030723:59:59' ],
     ],
   2076 =>
     [
        [ [2076,3,8,5,0,0],[2076,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2076,11,1,4,59,59],[2076,11,1,0,59,59],
          '2076030805:00:00','2076030801:00:00','2076110104:59:59','2076110100:59:59' ],
        [ [2076,11,1,5,0,0],[2076,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2077,3,14,4,59,59],[2077,3,13,23,59,59],
          '2076110105:00:00','2076110100:00:00','2077031404:59:59','2077031323:59:59' ],
     ],
   2077 =>
     [
        [ [2077,3,14,5,0,0],[2077,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2077,11,7,4,59,59],[2077,11,7,0,59,59],
          '2077031405:00:00','2077031401:00:00','2077110704:59:59','2077110700:59:59' ],
        [ [2077,11,7,5,0,0],[2077,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2078,3,13,4,59,59],[2078,3,12,23,59,59],
          '2077110705:00:00','2077110700:00:00','2078031304:59:59','2078031223:59:59' ],
     ],
   2078 =>
     [
        [ [2078,3,13,5,0,0],[2078,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2078,11,6,4,59,59],[2078,11,6,0,59,59],
          '2078031305:00:00','2078031301:00:00','2078110604:59:59','2078110600:59:59' ],
        [ [2078,11,6,5,0,0],[2078,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2079,3,12,4,59,59],[2079,3,11,23,59,59],
          '2078110605:00:00','2078110600:00:00','2079031204:59:59','2079031123:59:59' ],
     ],
   2079 =>
     [
        [ [2079,3,12,5,0,0],[2079,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2079,11,5,4,59,59],[2079,11,5,0,59,59],
          '2079031205:00:00','2079031201:00:00','2079110504:59:59','2079110500:59:59' ],
        [ [2079,11,5,5,0,0],[2079,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2080,3,10,4,59,59],[2080,3,9,23,59,59],
          '2079110505:00:00','2079110500:00:00','2080031004:59:59','2080030923:59:59' ],
     ],
   2080 =>
     [
        [ [2080,3,10,5,0,0],[2080,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2080,11,3,4,59,59],[2080,11,3,0,59,59],
          '2080031005:00:00','2080031001:00:00','2080110304:59:59','2080110300:59:59' ],
        [ [2080,11,3,5,0,0],[2080,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2081,3,9,4,59,59],[2081,3,8,23,59,59],
          '2080110305:00:00','2080110300:00:00','2081030904:59:59','2081030823:59:59' ],
     ],
   2081 =>
     [
        [ [2081,3,9,5,0,0],[2081,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2081,11,2,4,59,59],[2081,11,2,0,59,59],
          '2081030905:00:00','2081030901:00:00','2081110204:59:59','2081110200:59:59' ],
        [ [2081,11,2,5,0,0],[2081,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2082,3,8,4,59,59],[2082,3,7,23,59,59],
          '2081110205:00:00','2081110200:00:00','2082030804:59:59','2082030723:59:59' ],
     ],
   2082 =>
     [
        [ [2082,3,8,5,0,0],[2082,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2082,11,1,4,59,59],[2082,11,1,0,59,59],
          '2082030805:00:00','2082030801:00:00','2082110104:59:59','2082110100:59:59' ],
        [ [2082,11,1,5,0,0],[2082,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2083,3,14,4,59,59],[2083,3,13,23,59,59],
          '2082110105:00:00','2082110100:00:00','2083031404:59:59','2083031323:59:59' ],
     ],
   2083 =>
     [
        [ [2083,3,14,5,0,0],[2083,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2083,11,7,4,59,59],[2083,11,7,0,59,59],
          '2083031405:00:00','2083031401:00:00','2083110704:59:59','2083110700:59:59' ],
        [ [2083,11,7,5,0,0],[2083,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2084,3,12,4,59,59],[2084,3,11,23,59,59],
          '2083110705:00:00','2083110700:00:00','2084031204:59:59','2084031123:59:59' ],
     ],
   2084 =>
     [
        [ [2084,3,12,5,0,0],[2084,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2084,11,5,4,59,59],[2084,11,5,0,59,59],
          '2084031205:00:00','2084031201:00:00','2084110504:59:59','2084110500:59:59' ],
        [ [2084,11,5,5,0,0],[2084,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2085,3,11,4,59,59],[2085,3,10,23,59,59],
          '2084110505:00:00','2084110500:00:00','2085031104:59:59','2085031023:59:59' ],
     ],
   2085 =>
     [
        [ [2085,3,11,5,0,0],[2085,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2085,11,4,4,59,59],[2085,11,4,0,59,59],
          '2085031105:00:00','2085031101:00:00','2085110404:59:59','2085110400:59:59' ],
        [ [2085,11,4,5,0,0],[2085,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2086,3,10,4,59,59],[2086,3,9,23,59,59],
          '2085110405:00:00','2085110400:00:00','2086031004:59:59','2086030923:59:59' ],
     ],
   2086 =>
     [
        [ [2086,3,10,5,0,0],[2086,3,10,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2086,11,3,4,59,59],[2086,11,3,0,59,59],
          '2086031005:00:00','2086031001:00:00','2086110304:59:59','2086110300:59:59' ],
        [ [2086,11,3,5,0,0],[2086,11,3,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2087,3,9,4,59,59],[2087,3,8,23,59,59],
          '2086110305:00:00','2086110300:00:00','2087030904:59:59','2087030823:59:59' ],
     ],
   2087 =>
     [
        [ [2087,3,9,5,0,0],[2087,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2087,11,2,4,59,59],[2087,11,2,0,59,59],
          '2087030905:00:00','2087030901:00:00','2087110204:59:59','2087110200:59:59' ],
        [ [2087,11,2,5,0,0],[2087,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2088,3,14,4,59,59],[2088,3,13,23,59,59],
          '2087110205:00:00','2087110200:00:00','2088031404:59:59','2088031323:59:59' ],
     ],
   2088 =>
     [
        [ [2088,3,14,5,0,0],[2088,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2088,11,7,4,59,59],[2088,11,7,0,59,59],
          '2088031405:00:00','2088031401:00:00','2088110704:59:59','2088110700:59:59' ],
        [ [2088,11,7,5,0,0],[2088,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2089,3,13,4,59,59],[2089,3,12,23,59,59],
          '2088110705:00:00','2088110700:00:00','2089031304:59:59','2089031223:59:59' ],
     ],
   2089 =>
     [
        [ [2089,3,13,5,0,0],[2089,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2089,11,6,4,59,59],[2089,11,6,0,59,59],
          '2089031305:00:00','2089031301:00:00','2089110604:59:59','2089110600:59:59' ],
        [ [2089,11,6,5,0,0],[2089,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2090,3,12,4,59,59],[2090,3,11,23,59,59],
          '2089110605:00:00','2089110600:00:00','2090031204:59:59','2090031123:59:59' ],
     ],
   2090 =>
     [
        [ [2090,3,12,5,0,0],[2090,3,12,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2090,11,5,4,59,59],[2090,11,5,0,59,59],
          '2090031205:00:00','2090031201:00:00','2090110504:59:59','2090110500:59:59' ],
        [ [2090,11,5,5,0,0],[2090,11,5,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2091,3,11,4,59,59],[2091,3,10,23,59,59],
          '2090110505:00:00','2090110500:00:00','2091031104:59:59','2091031023:59:59' ],
     ],
   2091 =>
     [
        [ [2091,3,11,5,0,0],[2091,3,11,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2091,11,4,4,59,59],[2091,11,4,0,59,59],
          '2091031105:00:00','2091031101:00:00','2091110404:59:59','2091110400:59:59' ],
        [ [2091,11,4,5,0,0],[2091,11,4,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2092,3,9,4,59,59],[2092,3,8,23,59,59],
          '2091110405:00:00','2091110400:00:00','2092030904:59:59','2092030823:59:59' ],
     ],
   2092 =>
     [
        [ [2092,3,9,5,0,0],[2092,3,9,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2092,11,2,4,59,59],[2092,11,2,0,59,59],
          '2092030905:00:00','2092030901:00:00','2092110204:59:59','2092110200:59:59' ],
        [ [2092,11,2,5,0,0],[2092,11,2,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2093,3,8,4,59,59],[2093,3,7,23,59,59],
          '2092110205:00:00','2092110200:00:00','2093030804:59:59','2093030723:59:59' ],
     ],
   2093 =>
     [
        [ [2093,3,8,5,0,0],[2093,3,8,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2093,11,1,4,59,59],[2093,11,1,0,59,59],
          '2093030805:00:00','2093030801:00:00','2093110104:59:59','2093110100:59:59' ],
        [ [2093,11,1,5,0,0],[2093,11,1,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2094,3,14,4,59,59],[2094,3,13,23,59,59],
          '2093110105:00:00','2093110100:00:00','2094031404:59:59','2094031323:59:59' ],
     ],
   2094 =>
     [
        [ [2094,3,14,5,0,0],[2094,3,14,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2094,11,7,4,59,59],[2094,11,7,0,59,59],
          '2094031405:00:00','2094031401:00:00','2094110704:59:59','2094110700:59:59' ],
        [ [2094,11,7,5,0,0],[2094,11,7,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2095,3,13,4,59,59],[2095,3,12,23,59,59],
          '2094110705:00:00','2094110700:00:00','2095031304:59:59','2095031223:59:59' ],
     ],
   2095 =>
     [
        [ [2095,3,13,5,0,0],[2095,3,13,1,0,0],'-04:00:00',[-4,0,0],
          'CDT',1,[2095,11,6,4,59,59],[2095,11,6,0,59,59],
          '2095031305:00:00','2095031301:00:00','2095110604:59:59','2095110600:59:59' ],
        [ [2095,11,6,5,0,0],[2095,11,6,0,0,0],'-05:00:00',[-5,0,0],
          'CST',0,[2096,3,11,4,59,59],[2096,3,10,23,59,59],
          '2095110605:00:00','2095110600:00:00','2096031104:59:59','2096031023:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-04:00:00',
                'stdoff' => '-05:00:00',
               },
   'rules'  => {
                '03' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '8',
                         'type'    => 's',
                         'time'    => '00:00:00',
                         'isdst'   => '1',
                         'abb'     => 'CDT',
                        },
                '11' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 's',
                         'time'    => '00:00:00',
                         'isdst'   => '0',
                         'abb'     => 'CST',
                        },
               },
);

1;
