require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MACHINE_VMPARAM_H_)) {
    eval 'sub _MACHINE_VMPARAM_H_ () {1;}' unless defined(&_MACHINE_VMPARAM_H_);
    require 'm68k/vmparam.ph';
    unless(defined(&USRSTACK)) {
	eval 'sub USRSTACK () {0x1e000000;}' unless defined(&USRSTACK);
    }
    unless(defined(&MAXTSIZ)) {
	eval 'sub MAXTSIZ () {(32*1024*1024);}' unless defined(&MAXTSIZ);
    }
    unless(defined(&DFLDSIZ)) {
	eval 'sub DFLDSIZ () {(64*1024*1024);}' unless defined(&DFLDSIZ);
    }
    unless(defined(&MAXDSIZ)) {
	eval 'sub MAXDSIZ () {(224*1024*1024);}' unless defined(&MAXDSIZ);
    }
    unless(defined(&DFLSSIZ)) {
	eval 'sub DFLSSIZ () {(2*1024*1024);}' unless defined(&DFLSSIZ);
    }
    unless(defined(&MAXSSIZ)) {
	eval 'sub MAXSSIZ () {(32*1024*1024);}' unless defined(&MAXSSIZ);
    }
    unless(defined(&USRIOSIZE)) {
	eval 'sub USRIOSIZE () {(1*  &NPTEPG);}' unless defined(&USRIOSIZE);
    }
    eval 'sub VM_MIN_ADDRESS () {(( &vaddr_t)0);}' unless defined(&VM_MIN_ADDRESS);
    eval 'sub VM_MAX_ADDRESS () {(( &vaddr_t)( &USRSTACK));}' unless defined(&VM_MAX_ADDRESS);
    eval 'sub VM_MAXUSER_ADDRESS () {(( &vaddr_t)( &VM_MAX_ADDRESS));}' unless defined(&VM_MAXUSER_ADDRESS);
    eval 'sub VM_MIN_KERNEL_ADDRESS () {(( &vaddr_t)0);}' unless defined(&VM_MIN_KERNEL_ADDRESS);
    eval 'sub VM_MAX_KERNEL_ADDRESS () {(( &vaddr_t)-( &NPTEPG *  &PAGE_SIZE));}' unless defined(&VM_MAX_KERNEL_ADDRESS);
    eval 'sub VM_PHYS_SIZE () {( &USRIOSIZE* &PAGE_SIZE);}' unless defined(&VM_PHYS_SIZE);
    eval 'sub VM_PHYSSEG_MAX () {(16);}' unless defined(&VM_PHYSSEG_MAX);
    eval 'sub VM_PHYSSEG_STRAT () { &VM_PSTRAT_RANDOM;}' unless defined(&VM_PHYSSEG_STRAT);
    eval 'sub VM_NFREELIST () {2;}' unless defined(&VM_NFREELIST);
    eval 'sub VM_FREELIST_DEFAULT () {0;}' unless defined(&VM_FREELIST_DEFAULT);
    eval 'sub VM_FREELIST_ZORROII () {1;}' unless defined(&VM_FREELIST_ZORROII);
    eval 'sub __HAVE_PMAP_PHYSSEG () {1;}' unless defined(&__HAVE_PMAP_PHYSSEG);
    eval 'sub VM_KERNEL_PT_PAGES () {(( &vm_size_t)10);}' unless defined(&VM_KERNEL_PT_PAGES);
}
1;
