require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_ATOMIC_H_)) {
    eval 'sub _SYS_ATOMIC_H_ () {1;}' unless defined(&_SYS_ATOMIC_H_);
    require 'sys/types.ph';
    if(!defined(&_KERNEL)  && !defined(&_STANDALONE)) {
	require 'stdint.ph';
    }
    if(defined(&_KERNEL)  && defined(&_KERNEL_OPT)) {
	require './sys/opt_kasan.ph';
	require './sys/opt_kcsan.ph';
	require './sys/opt_kmsan.ph';
    }
    if(defined(&KASAN)) {
	eval 'sub ATOMIC_PROTO_ADD {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &kasan_atomic_add_$name( &volatile $targ1 *, $targ2); $tret  &kasan_atomic_add_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_ADD);
	eval 'sub ATOMIC_PROTO_AND {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &kasan_atomic_and_$name( &volatile $targ1 *, $targ2); $tret  &kasan_atomic_and_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_AND);
	eval 'sub ATOMIC_PROTO_OR {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &kasan_atomic_or_$name( &volatile $targ1 *, $targ2); $tret  &kasan_atomic_or_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_OR);
	eval 'sub ATOMIC_PROTO_CAS {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q($tret  &kasan_atomic_cas_$name( &volatile $targ1 *, $targ2, $targ2); $tret  &kasan_atomic_cas_$name &_ni( &volatile $targ1 *, $targ2, $targ2));
	}' unless defined(&ATOMIC_PROTO_CAS);
	eval 'sub ATOMIC_PROTO_SWAP {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q($tret  &kasan_atomic_swap_$name( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_SWAP);
	eval 'sub ATOMIC_PROTO_DEC {
	    my($name, $tret, $targ1) = @_;
    	    eval q( &void  &kasan_atomic_dec_$name( &volatile $targ1 *); $tret  &kasan_atomic_dec_$name &_nv( &volatile $targ1 *));
	}' unless defined(&ATOMIC_PROTO_DEC);
	eval 'sub ATOMIC_PROTO_INC {
	    my($name, $tret, $targ1) = @_;
    	    eval q( &void  &kasan_atomic_inc_$name( &volatile $targ1 *); $tret  &kasan_atomic_inc_$name &_nv( &volatile $targ1 *));
	}' unless defined(&ATOMIC_PROTO_INC);
    }
 elsif(defined(&KCSAN)) {
	eval 'sub ATOMIC_PROTO_ADD {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &kcsan_atomic_add_$name( &volatile $targ1 *, $targ2); $tret  &kcsan_atomic_add_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_ADD);
	eval 'sub ATOMIC_PROTO_AND {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &kcsan_atomic_and_$name( &volatile $targ1 *, $targ2); $tret  &kcsan_atomic_and_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_AND);
	eval 'sub ATOMIC_PROTO_OR {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &kcsan_atomic_or_$name( &volatile $targ1 *, $targ2); $tret  &kcsan_atomic_or_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_OR);
	eval 'sub ATOMIC_PROTO_CAS {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q($tret  &kcsan_atomic_cas_$name( &volatile $targ1 *, $targ2, $targ2); $tret  &kcsan_atomic_cas_$name &_ni( &volatile $targ1 *, $targ2, $targ2));
	}' unless defined(&ATOMIC_PROTO_CAS);
	eval 'sub ATOMIC_PROTO_SWAP {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q($tret  &kcsan_atomic_swap_$name( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_SWAP);
	eval 'sub ATOMIC_PROTO_DEC {
	    my($name, $tret, $targ1) = @_;
    	    eval q( &void  &kcsan_atomic_dec_$name( &volatile $targ1 *); $tret  &kcsan_atomic_dec_$name &_nv( &volatile $targ1 *));
	}' unless defined(&ATOMIC_PROTO_DEC);
	eval 'sub ATOMIC_PROTO_INC {
	    my($name, $tret, $targ1) = @_;
    	    eval q( &void  &kcsan_atomic_inc_$name( &volatile $targ1 *); $tret  &kcsan_atomic_inc_$name &_nv( &volatile $targ1 *));
	}' unless defined(&ATOMIC_PROTO_INC);
    }
 elsif(defined(&KMSAN)) {
	eval 'sub ATOMIC_PROTO_ADD {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &kmsan_atomic_add_$name( &volatile $targ1 *, $targ2); $tret  &kmsan_atomic_add_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_ADD);
	eval 'sub ATOMIC_PROTO_AND {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &kmsan_atomic_and_$name( &volatile $targ1 *, $targ2); $tret  &kmsan_atomic_and_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_AND);
	eval 'sub ATOMIC_PROTO_OR {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &kmsan_atomic_or_$name( &volatile $targ1 *, $targ2); $tret  &kmsan_atomic_or_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_OR);
	eval 'sub ATOMIC_PROTO_CAS {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q($tret  &kmsan_atomic_cas_$name( &volatile $targ1 *, $targ2, $targ2); $tret  &kmsan_atomic_cas_$name &_ni( &volatile $targ1 *, $targ2, $targ2));
	}' unless defined(&ATOMIC_PROTO_CAS);
	eval 'sub ATOMIC_PROTO_SWAP {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q($tret  &kmsan_atomic_swap_$name( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_SWAP);
	eval 'sub ATOMIC_PROTO_DEC {
	    my($name, $tret, $targ1) = @_;
    	    eval q( &void  &kmsan_atomic_dec_$name( &volatile $targ1 *); $tret  &kmsan_atomic_dec_$name &_nv( &volatile $targ1 *));
	}' unless defined(&ATOMIC_PROTO_DEC);
	eval 'sub ATOMIC_PROTO_INC {
	    my($name, $tret, $targ1) = @_;
    	    eval q( &void  &kmsan_atomic_inc_$name( &volatile $targ1 *); $tret  &kmsan_atomic_inc_$name &_nv( &volatile $targ1 *));
	}' unless defined(&ATOMIC_PROTO_INC);
    } else {
	eval 'sub ATOMIC_PROTO_ADD {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &atomic_add_$name( &volatile $targ1 *, $targ2); $tret  &atomic_add_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_ADD);
	eval 'sub ATOMIC_PROTO_AND {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &atomic_and_$name( &volatile $targ1 *, $targ2); $tret  &atomic_and_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_AND);
	eval 'sub ATOMIC_PROTO_OR {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q( &void  &atomic_or_$name( &volatile $targ1 *, $targ2); $tret  &atomic_or_$name &_nv( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_OR);
	eval 'sub ATOMIC_PROTO_CAS {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q($tret  &atomic_cas_$name( &volatile $targ1 *, $targ2, $targ2); $tret  &atomic_cas_$name &_ni( &volatile $targ1 *, $targ2, $targ2));
	}' unless defined(&ATOMIC_PROTO_CAS);
	eval 'sub ATOMIC_PROTO_SWAP {
	    my($name, $tret, $targ1, $targ2) = @_;
    	    eval q($tret  &atomic_swap_$name( &volatile $targ1 *, $targ2));
	}' unless defined(&ATOMIC_PROTO_SWAP);
	eval 'sub ATOMIC_PROTO_DEC {
	    my($name, $tret, $targ1) = @_;
    	    eval q( &void  &atomic_dec_$name( &volatile $targ1 *); $tret  &atomic_dec_$name &_nv( &volatile $targ1 *));
	}' unless defined(&ATOMIC_PROTO_DEC);
	eval 'sub ATOMIC_PROTO_INC {
	    my($name, $tret, $targ1) = @_;
    	    eval q( &void  &atomic_inc_$name( &volatile $targ1 *); $tret  &atomic_inc_$name &_nv( &volatile $targ1 *));
	}' unless defined(&ATOMIC_PROTO_INC);
    }
    if(defined(&__HAVE_MEMBAR_DATADEP_CONSUMER)) {
    } else {
	eval 'sub membar_datadep_consumer () {
	    eval q((( &void)0));
	}' unless defined(&membar_datadep_consumer);
    }
    if(defined(&KASAN)) {
	eval 'sub atomic_add_32 () { &kasan_atomic_add_32;}' unless defined(&atomic_add_32);
	eval 'sub atomic_add_int () { &kasan_atomic_add_int;}' unless defined(&atomic_add_int);
	eval 'sub atomic_add_long () {\'kasan_atomic_add_long\';}' unless defined(&atomic_add_long);
	eval 'sub atomic_add_ptr () { &kasan_atomic_add_ptr;}' unless defined(&atomic_add_ptr);
	eval 'sub atomic_add_64 () { &kasan_atomic_add_64;}' unless defined(&atomic_add_64);
	eval 'sub atomic_add_32_nv () { &kasan_atomic_add_32_nv;}' unless defined(&atomic_add_32_nv);
	eval 'sub atomic_add_int_nv () { &kasan_atomic_add_int_nv;}' unless defined(&atomic_add_int_nv);
	eval 'sub atomic_add_long_nv () {\'kasan_atomic_add_long_nv\';}' unless defined(&atomic_add_long_nv);
	eval 'sub atomic_add_ptr_nv () { &kasan_atomic_add_ptr_nv;}' unless defined(&atomic_add_ptr_nv);
	eval 'sub atomic_add_64_nv () { &kasan_atomic_add_64_nv;}' unless defined(&atomic_add_64_nv);
	eval 'sub atomic_and_32 () { &kasan_atomic_and_32;}' unless defined(&atomic_and_32);
	eval 'sub atomic_and_uint () { &kasan_atomic_and_uint;}' unless defined(&atomic_and_uint);
	eval 'sub atomic_and_ulong () {\'kasan_atomic_and_ulong\';}' unless defined(&atomic_and_ulong);
	eval 'sub atomic_and_64 () { &kasan_atomic_and_64;}' unless defined(&atomic_and_64);
	eval 'sub atomic_and_32_nv () { &kasan_atomic_and_32_nv;}' unless defined(&atomic_and_32_nv);
	eval 'sub atomic_and_uint_nv () { &kasan_atomic_and_uint_nv;}' unless defined(&atomic_and_uint_nv);
	eval 'sub atomic_and_ulong_nv () {\'kasan_atomic_and_ulong_nv\';}' unless defined(&atomic_and_ulong_nv);
	eval 'sub atomic_and_64_nv () { &kasan_atomic_and_64_nv;}' unless defined(&atomic_and_64_nv);
	eval 'sub atomic_or_32 () { &kasan_atomic_or_32;}' unless defined(&atomic_or_32);
	eval 'sub atomic_or_uint () { &kasan_atomic_or_uint;}' unless defined(&atomic_or_uint);
	eval 'sub atomic_or_ulong () {\'kasan_atomic_or_ulong\';}' unless defined(&atomic_or_ulong);
	eval 'sub atomic_or_64 () { &kasan_atomic_or_64;}' unless defined(&atomic_or_64);
	eval 'sub atomic_or_32_nv () { &kasan_atomic_or_32_nv;}' unless defined(&atomic_or_32_nv);
	eval 'sub atomic_or_uint_nv () { &kasan_atomic_or_uint_nv;}' unless defined(&atomic_or_uint_nv);
	eval 'sub atomic_or_ulong_nv () {\'kasan_atomic_or_ulong_nv\';}' unless defined(&atomic_or_ulong_nv);
	eval 'sub atomic_or_64_nv () { &kasan_atomic_or_64_nv;}' unless defined(&atomic_or_64_nv);
	eval 'sub atomic_cas_32 () { &kasan_atomic_cas_32;}' unless defined(&atomic_cas_32);
	eval 'sub atomic_cas_uint () { &kasan_atomic_cas_uint;}' unless defined(&atomic_cas_uint);
	eval 'sub atomic_cas_ulong () {\'kasan_atomic_cas_ulong\';}' unless defined(&atomic_cas_ulong);
	eval 'sub atomic_cas_ptr () { &kasan_atomic_cas_ptr;}' unless defined(&atomic_cas_ptr);
	eval 'sub atomic_cas_64 () { &kasan_atomic_cas_64;}' unless defined(&atomic_cas_64);
	eval 'sub atomic_cas_32_ni () { &kasan_atomic_cas_32_ni;}' unless defined(&atomic_cas_32_ni);
	eval 'sub atomic_cas_uint_ni () { &kasan_atomic_cas_uint_ni;}' unless defined(&atomic_cas_uint_ni);
	eval 'sub atomic_cas_ulong_ni () {\'kasan_atomic_cas_ulong_ni\';}' unless defined(&atomic_cas_ulong_ni);
	eval 'sub atomic_cas_ptr_ni () { &kasan_atomic_cas_ptr_ni;}' unless defined(&atomic_cas_ptr_ni);
	eval 'sub atomic_cas_64_ni () { &kasan_atomic_cas_64_ni;}' unless defined(&atomic_cas_64_ni);
	eval 'sub atomic_swap_32 () { &kasan_atomic_swap_32;}' unless defined(&atomic_swap_32);
	eval 'sub atomic_swap_uint () { &kasan_atomic_swap_uint;}' unless defined(&atomic_swap_uint);
	eval 'sub atomic_swap_ulong () {\'kasan_atomic_swap_ulong\';}' unless defined(&atomic_swap_ulong);
	eval 'sub atomic_swap_ptr () { &kasan_atomic_swap_ptr;}' unless defined(&atomic_swap_ptr);
	eval 'sub atomic_swap_64 () { &kasan_atomic_swap_64;}' unless defined(&atomic_swap_64);
	eval 'sub atomic_dec_32 () { &kasan_atomic_dec_32;}' unless defined(&atomic_dec_32);
	eval 'sub atomic_dec_uint () { &kasan_atomic_dec_uint;}' unless defined(&atomic_dec_uint);
	eval 'sub atomic_dec_ulong () {\'kasan_atomic_dec_ulong\';}' unless defined(&atomic_dec_ulong);
	eval 'sub atomic_dec_ptr () { &kasan_atomic_dec_ptr;}' unless defined(&atomic_dec_ptr);
	eval 'sub atomic_dec_64 () { &kasan_atomic_dec_64;}' unless defined(&atomic_dec_64);
	eval 'sub atomic_dec_32_nv () { &kasan_atomic_dec_32_nv;}' unless defined(&atomic_dec_32_nv);
	eval 'sub atomic_dec_uint_nv () { &kasan_atomic_dec_uint_nv;}' unless defined(&atomic_dec_uint_nv);
	eval 'sub atomic_dec_ulong_nv () {\'kasan_atomic_dec_ulong_nv\';}' unless defined(&atomic_dec_ulong_nv);
	eval 'sub atomic_dec_ptr_nv () { &kasan_atomic_dec_ptr_nv;}' unless defined(&atomic_dec_ptr_nv);
	eval 'sub atomic_dec_64_nv () { &kasan_atomic_dec_64_nv;}' unless defined(&atomic_dec_64_nv);
	eval 'sub atomic_inc_32 () { &kasan_atomic_inc_32;}' unless defined(&atomic_inc_32);
	eval 'sub atomic_inc_uint () { &kasan_atomic_inc_uint;}' unless defined(&atomic_inc_uint);
	eval 'sub atomic_inc_ulong () {\'kasan_atomic_inc_ulong\';}' unless defined(&atomic_inc_ulong);
	eval 'sub atomic_inc_ptr () { &kasan_atomic_inc_ptr;}' unless defined(&atomic_inc_ptr);
	eval 'sub atomic_inc_64 () { &kasan_atomic_inc_64;}' unless defined(&atomic_inc_64);
	eval 'sub atomic_inc_32_nv () { &kasan_atomic_inc_32_nv;}' unless defined(&atomic_inc_32_nv);
	eval 'sub atomic_inc_uint_nv () { &kasan_atomic_inc_uint_nv;}' unless defined(&atomic_inc_uint_nv);
	eval 'sub atomic_inc_ulong_nv () {\'kasan_atomic_inc_ulong_nv\';}' unless defined(&atomic_inc_ulong_nv);
	eval 'sub atomic_inc_ptr_nv () { &kasan_atomic_inc_ptr_nv;}' unless defined(&atomic_inc_ptr_nv);
	eval 'sub atomic_inc_64_nv () { &kasan_atomic_inc_64_nv;}' unless defined(&atomic_inc_64_nv);
    }
 elsif(defined(&KCSAN)) {
	eval 'sub atomic_add_32 () { &kcsan_atomic_add_32;}' unless defined(&atomic_add_32);
	eval 'sub atomic_add_int () { &kcsan_atomic_add_int;}' unless defined(&atomic_add_int);
	eval 'sub atomic_add_long () {\'kcsan_atomic_add_long\';}' unless defined(&atomic_add_long);
	eval 'sub atomic_add_ptr () { &kcsan_atomic_add_ptr;}' unless defined(&atomic_add_ptr);
	eval 'sub atomic_add_64 () { &kcsan_atomic_add_64;}' unless defined(&atomic_add_64);
	eval 'sub atomic_add_32_nv () { &kcsan_atomic_add_32_nv;}' unless defined(&atomic_add_32_nv);
	eval 'sub atomic_add_int_nv () { &kcsan_atomic_add_int_nv;}' unless defined(&atomic_add_int_nv);
	eval 'sub atomic_add_long_nv () {\'kcsan_atomic_add_long_nv\';}' unless defined(&atomic_add_long_nv);
	eval 'sub atomic_add_ptr_nv () { &kcsan_atomic_add_ptr_nv;}' unless defined(&atomic_add_ptr_nv);
	eval 'sub atomic_add_64_nv () { &kcsan_atomic_add_64_nv;}' unless defined(&atomic_add_64_nv);
	eval 'sub atomic_and_32 () { &kcsan_atomic_and_32;}' unless defined(&atomic_and_32);
	eval 'sub atomic_and_uint () { &kcsan_atomic_and_uint;}' unless defined(&atomic_and_uint);
	eval 'sub atomic_and_ulong () {\'kcsan_atomic_and_ulong\';}' unless defined(&atomic_and_ulong);
	eval 'sub atomic_and_64 () { &kcsan_atomic_and_64;}' unless defined(&atomic_and_64);
	eval 'sub atomic_and_32_nv () { &kcsan_atomic_and_32_nv;}' unless defined(&atomic_and_32_nv);
	eval 'sub atomic_and_uint_nv () { &kcsan_atomic_and_uint_nv;}' unless defined(&atomic_and_uint_nv);
	eval 'sub atomic_and_ulong_nv () {\'kcsan_atomic_and_ulong_nv\';}' unless defined(&atomic_and_ulong_nv);
	eval 'sub atomic_and_64_nv () { &kcsan_atomic_and_64_nv;}' unless defined(&atomic_and_64_nv);
	eval 'sub atomic_or_32 () { &kcsan_atomic_or_32;}' unless defined(&atomic_or_32);
	eval 'sub atomic_or_uint () { &kcsan_atomic_or_uint;}' unless defined(&atomic_or_uint);
	eval 'sub atomic_or_ulong () {\'kcsan_atomic_or_ulong\';}' unless defined(&atomic_or_ulong);
	eval 'sub atomic_or_64 () { &kcsan_atomic_or_64;}' unless defined(&atomic_or_64);
	eval 'sub atomic_or_32_nv () { &kcsan_atomic_or_32_nv;}' unless defined(&atomic_or_32_nv);
	eval 'sub atomic_or_uint_nv () { &kcsan_atomic_or_uint_nv;}' unless defined(&atomic_or_uint_nv);
	eval 'sub atomic_or_ulong_nv () {\'kcsan_atomic_or_ulong_nv\';}' unless defined(&atomic_or_ulong_nv);
	eval 'sub atomic_or_64_nv () { &kcsan_atomic_or_64_nv;}' unless defined(&atomic_or_64_nv);
	eval 'sub atomic_cas_32 () { &kcsan_atomic_cas_32;}' unless defined(&atomic_cas_32);
	eval 'sub atomic_cas_uint () { &kcsan_atomic_cas_uint;}' unless defined(&atomic_cas_uint);
	eval 'sub atomic_cas_ulong () {\'kcsan_atomic_cas_ulong\';}' unless defined(&atomic_cas_ulong);
	eval 'sub atomic_cas_ptr () { &kcsan_atomic_cas_ptr;}' unless defined(&atomic_cas_ptr);
	eval 'sub atomic_cas_64 () { &kcsan_atomic_cas_64;}' unless defined(&atomic_cas_64);
	eval 'sub atomic_cas_32_ni () { &kcsan_atomic_cas_32_ni;}' unless defined(&atomic_cas_32_ni);
	eval 'sub atomic_cas_uint_ni () { &kcsan_atomic_cas_uint_ni;}' unless defined(&atomic_cas_uint_ni);
	eval 'sub atomic_cas_ulong_ni () {\'kcsan_atomic_cas_ulong_ni\';}' unless defined(&atomic_cas_ulong_ni);
	eval 'sub atomic_cas_ptr_ni () { &kcsan_atomic_cas_ptr_ni;}' unless defined(&atomic_cas_ptr_ni);
	eval 'sub atomic_cas_64_ni () { &kcsan_atomic_cas_64_ni;}' unless defined(&atomic_cas_64_ni);
	eval 'sub atomic_swap_32 () { &kcsan_atomic_swap_32;}' unless defined(&atomic_swap_32);
	eval 'sub atomic_swap_uint () { &kcsan_atomic_swap_uint;}' unless defined(&atomic_swap_uint);
	eval 'sub atomic_swap_ulong () {\'kcsan_atomic_swap_ulong\';}' unless defined(&atomic_swap_ulong);
	eval 'sub atomic_swap_ptr () { &kcsan_atomic_swap_ptr;}' unless defined(&atomic_swap_ptr);
	eval 'sub atomic_swap_64 () { &kcsan_atomic_swap_64;}' unless defined(&atomic_swap_64);
	eval 'sub atomic_dec_32 () { &kcsan_atomic_dec_32;}' unless defined(&atomic_dec_32);
	eval 'sub atomic_dec_uint () { &kcsan_atomic_dec_uint;}' unless defined(&atomic_dec_uint);
	eval 'sub atomic_dec_ulong () {\'kcsan_atomic_dec_ulong\';}' unless defined(&atomic_dec_ulong);
	eval 'sub atomic_dec_ptr () { &kcsan_atomic_dec_ptr;}' unless defined(&atomic_dec_ptr);
	eval 'sub atomic_dec_64 () { &kcsan_atomic_dec_64;}' unless defined(&atomic_dec_64);
	eval 'sub atomic_dec_32_nv () { &kcsan_atomic_dec_32_nv;}' unless defined(&atomic_dec_32_nv);
	eval 'sub atomic_dec_uint_nv () { &kcsan_atomic_dec_uint_nv;}' unless defined(&atomic_dec_uint_nv);
	eval 'sub atomic_dec_ulong_nv () {\'kcsan_atomic_dec_ulong_nv\';}' unless defined(&atomic_dec_ulong_nv);
	eval 'sub atomic_dec_ptr_nv () { &kcsan_atomic_dec_ptr_nv;}' unless defined(&atomic_dec_ptr_nv);
	eval 'sub atomic_dec_64_nv () { &kcsan_atomic_dec_64_nv;}' unless defined(&atomic_dec_64_nv);
	eval 'sub atomic_inc_32 () { &kcsan_atomic_inc_32;}' unless defined(&atomic_inc_32);
	eval 'sub atomic_inc_uint () { &kcsan_atomic_inc_uint;}' unless defined(&atomic_inc_uint);
	eval 'sub atomic_inc_ulong () {\'kcsan_atomic_inc_ulong\';}' unless defined(&atomic_inc_ulong);
	eval 'sub atomic_inc_ptr () { &kcsan_atomic_inc_ptr;}' unless defined(&atomic_inc_ptr);
	eval 'sub atomic_inc_64 () { &kcsan_atomic_inc_64;}' unless defined(&atomic_inc_64);
	eval 'sub atomic_inc_32_nv () { &kcsan_atomic_inc_32_nv;}' unless defined(&atomic_inc_32_nv);
	eval 'sub atomic_inc_uint_nv () { &kcsan_atomic_inc_uint_nv;}' unless defined(&atomic_inc_uint_nv);
	eval 'sub atomic_inc_ulong_nv () {\'kcsan_atomic_inc_ulong_nv\';}' unless defined(&atomic_inc_ulong_nv);
	eval 'sub atomic_inc_ptr_nv () { &kcsan_atomic_inc_ptr_nv;}' unless defined(&atomic_inc_ptr_nv);
	eval 'sub atomic_inc_64_nv () { &kcsan_atomic_inc_64_nv;}' unless defined(&atomic_inc_64_nv);
    }
 elsif(defined(&KMSAN)) {
	eval 'sub atomic_add_32 () { &kmsan_atomic_add_32;}' unless defined(&atomic_add_32);
	eval 'sub atomic_add_int () { &kmsan_atomic_add_int;}' unless defined(&atomic_add_int);
	eval 'sub atomic_add_long () {\'kmsan_atomic_add_long\';}' unless defined(&atomic_add_long);
	eval 'sub atomic_add_ptr () { &kmsan_atomic_add_ptr;}' unless defined(&atomic_add_ptr);
	eval 'sub atomic_add_64 () { &kmsan_atomic_add_64;}' unless defined(&atomic_add_64);
	eval 'sub atomic_add_32_nv () { &kmsan_atomic_add_32_nv;}' unless defined(&atomic_add_32_nv);
	eval 'sub atomic_add_int_nv () { &kmsan_atomic_add_int_nv;}' unless defined(&atomic_add_int_nv);
	eval 'sub atomic_add_long_nv () {\'kmsan_atomic_add_long_nv\';}' unless defined(&atomic_add_long_nv);
	eval 'sub atomic_add_ptr_nv () { &kmsan_atomic_add_ptr_nv;}' unless defined(&atomic_add_ptr_nv);
	eval 'sub atomic_add_64_nv () { &kmsan_atomic_add_64_nv;}' unless defined(&atomic_add_64_nv);
	eval 'sub atomic_and_32 () { &kmsan_atomic_and_32;}' unless defined(&atomic_and_32);
	eval 'sub atomic_and_uint () { &kmsan_atomic_and_uint;}' unless defined(&atomic_and_uint);
	eval 'sub atomic_and_ulong () {\'kmsan_atomic_and_ulong\';}' unless defined(&atomic_and_ulong);
	eval 'sub atomic_and_64 () { &kmsan_atomic_and_64;}' unless defined(&atomic_and_64);
	eval 'sub atomic_and_32_nv () { &kmsan_atomic_and_32_nv;}' unless defined(&atomic_and_32_nv);
	eval 'sub atomic_and_uint_nv () { &kmsan_atomic_and_uint_nv;}' unless defined(&atomic_and_uint_nv);
	eval 'sub atomic_and_ulong_nv () {\'kmsan_atomic_and_ulong_nv\';}' unless defined(&atomic_and_ulong_nv);
	eval 'sub atomic_and_64_nv () { &kmsan_atomic_and_64_nv;}' unless defined(&atomic_and_64_nv);
	eval 'sub atomic_or_32 () { &kmsan_atomic_or_32;}' unless defined(&atomic_or_32);
	eval 'sub atomic_or_uint () { &kmsan_atomic_or_uint;}' unless defined(&atomic_or_uint);
	eval 'sub atomic_or_ulong () {\'kmsan_atomic_or_ulong\';}' unless defined(&atomic_or_ulong);
	eval 'sub atomic_or_64 () { &kmsan_atomic_or_64;}' unless defined(&atomic_or_64);
	eval 'sub atomic_or_32_nv () { &kmsan_atomic_or_32_nv;}' unless defined(&atomic_or_32_nv);
	eval 'sub atomic_or_uint_nv () { &kmsan_atomic_or_uint_nv;}' unless defined(&atomic_or_uint_nv);
	eval 'sub atomic_or_ulong_nv () {\'kmsan_atomic_or_ulong_nv\';}' unless defined(&atomic_or_ulong_nv);
	eval 'sub atomic_or_64_nv () { &kmsan_atomic_or_64_nv;}' unless defined(&atomic_or_64_nv);
	eval 'sub atomic_cas_32 () { &kmsan_atomic_cas_32;}' unless defined(&atomic_cas_32);
	eval 'sub atomic_cas_uint () { &kmsan_atomic_cas_uint;}' unless defined(&atomic_cas_uint);
	eval 'sub atomic_cas_ulong () {\'kmsan_atomic_cas_ulong\';}' unless defined(&atomic_cas_ulong);
	eval 'sub atomic_cas_ptr () { &kmsan_atomic_cas_ptr;}' unless defined(&atomic_cas_ptr);
	eval 'sub atomic_cas_64 () { &kmsan_atomic_cas_64;}' unless defined(&atomic_cas_64);
	eval 'sub atomic_cas_32_ni () { &kmsan_atomic_cas_32_ni;}' unless defined(&atomic_cas_32_ni);
	eval 'sub atomic_cas_uint_ni () { &kmsan_atomic_cas_uint_ni;}' unless defined(&atomic_cas_uint_ni);
	eval 'sub atomic_cas_ulong_ni () {\'kmsan_atomic_cas_ulong_ni\';}' unless defined(&atomic_cas_ulong_ni);
	eval 'sub atomic_cas_ptr_ni () { &kmsan_atomic_cas_ptr_ni;}' unless defined(&atomic_cas_ptr_ni);
	eval 'sub atomic_cas_64_ni () { &kmsan_atomic_cas_64_ni;}' unless defined(&atomic_cas_64_ni);
	eval 'sub atomic_swap_32 () { &kmsan_atomic_swap_32;}' unless defined(&atomic_swap_32);
	eval 'sub atomic_swap_uint () { &kmsan_atomic_swap_uint;}' unless defined(&atomic_swap_uint);
	eval 'sub atomic_swap_ulong () {\'kmsan_atomic_swap_ulong\';}' unless defined(&atomic_swap_ulong);
	eval 'sub atomic_swap_ptr () { &kmsan_atomic_swap_ptr;}' unless defined(&atomic_swap_ptr);
	eval 'sub atomic_swap_64 () { &kmsan_atomic_swap_64;}' unless defined(&atomic_swap_64);
	eval 'sub atomic_dec_32 () { &kmsan_atomic_dec_32;}' unless defined(&atomic_dec_32);
	eval 'sub atomic_dec_uint () { &kmsan_atomic_dec_uint;}' unless defined(&atomic_dec_uint);
	eval 'sub atomic_dec_ulong () {\'kmsan_atomic_dec_ulong\';}' unless defined(&atomic_dec_ulong);
	eval 'sub atomic_dec_ptr () { &kmsan_atomic_dec_ptr;}' unless defined(&atomic_dec_ptr);
	eval 'sub atomic_dec_64 () { &kmsan_atomic_dec_64;}' unless defined(&atomic_dec_64);
	eval 'sub atomic_dec_32_nv () { &kmsan_atomic_dec_32_nv;}' unless defined(&atomic_dec_32_nv);
	eval 'sub atomic_dec_uint_nv () { &kmsan_atomic_dec_uint_nv;}' unless defined(&atomic_dec_uint_nv);
	eval 'sub atomic_dec_ulong_nv () {\'kmsan_atomic_dec_ulong_nv\';}' unless defined(&atomic_dec_ulong_nv);
	eval 'sub atomic_dec_ptr_nv () { &kmsan_atomic_dec_ptr_nv;}' unless defined(&atomic_dec_ptr_nv);
	eval 'sub atomic_dec_64_nv () { &kmsan_atomic_dec_64_nv;}' unless defined(&atomic_dec_64_nv);
	eval 'sub atomic_inc_32 () { &kmsan_atomic_inc_32;}' unless defined(&atomic_inc_32);
	eval 'sub atomic_inc_uint () { &kmsan_atomic_inc_uint;}' unless defined(&atomic_inc_uint);
	eval 'sub atomic_inc_ulong () {\'kmsan_atomic_inc_ulong\';}' unless defined(&atomic_inc_ulong);
	eval 'sub atomic_inc_ptr () { &kmsan_atomic_inc_ptr;}' unless defined(&atomic_inc_ptr);
	eval 'sub atomic_inc_64 () { &kmsan_atomic_inc_64;}' unless defined(&atomic_inc_64);
	eval 'sub atomic_inc_32_nv () { &kmsan_atomic_inc_32_nv;}' unless defined(&atomic_inc_32_nv);
	eval 'sub atomic_inc_uint_nv () { &kmsan_atomic_inc_uint_nv;}' unless defined(&atomic_inc_uint_nv);
	eval 'sub atomic_inc_ulong_nv () {\'kmsan_atomic_inc_ulong_nv\';}' unless defined(&atomic_inc_ulong_nv);
	eval 'sub atomic_inc_ptr_nv () { &kmsan_atomic_inc_ptr_nv;}' unless defined(&atomic_inc_ptr_nv);
	eval 'sub atomic_inc_64_nv () { &kmsan_atomic_inc_64_nv;}' unless defined(&atomic_inc_64_nv);
    }
    if(defined(&_KERNEL)) {
	if(1) {
	    require 'sys/cdefs.ph';
	    require 'lib/libkern/libkern.ph';
	    if(defined(&_LP64)) {
		eval 'sub __HAVE_ATOMIC64_LOADSTORE () {1;}' unless defined(&__HAVE_ATOMIC64_LOADSTORE);
		eval 'sub __ATOMIC_SIZE_MAX () {8;}' unless defined(&__ATOMIC_SIZE_MAX);
	    } else {
		eval 'sub __ATOMIC_SIZE_MAX () {4;}' unless defined(&__ATOMIC_SIZE_MAX);
	    }
	    eval 'sub __ATOMIC_PTR_CHECK {
	        my($p) = @_;
    		eval q( &do {  &CTASSERT($sizeof{($p)} <=  &__ATOMIC_SIZE_MAX);  &KASSERT((( &uintptr_t)($p) & ($sizeof{($p)} - 1)) == 0); }  &while (0));
	    }' unless defined(&__ATOMIC_PTR_CHECK);
	    if(defined(&KCSAN)) {
		eval 'sub __BEGIN_ATOMIC_LOAD {
		    my($p, $v) = @_;
    		    eval q(\'union union\' {  &__typeof__(*($p))  &__al_val; \'char\'  $__al_buf[1]; } $v;  &kcsan_atomic_load($p,  ($v->{__al_buf}), $sizeof{ ($v->{__al_val})}));
		}' unless defined(&__BEGIN_ATOMIC_LOAD);
		eval 'sub __END_ATOMIC_LOAD {
		    my($v) = @_;
    		    eval q(($v). &__al_val);
		}' unless defined(&__END_ATOMIC_LOAD);
		eval 'sub __DO_ATOMIC_STORE {
		    my($p, $v) = @_;
    		    eval q( &kcsan_atomic_store($p,  &__UNVOLATILE($v), $sizeof{$v}));
		}' unless defined(&__DO_ATOMIC_STORE);
	    } else {
		eval 'sub __BEGIN_ATOMIC_LOAD {
		    my($p, $v) = @_;
    		    eval q( &__typeof__(*($p)) $v = *($p));
		}' unless defined(&__BEGIN_ATOMIC_LOAD);
		eval 'sub __END_ATOMIC_LOAD {
		    my($v) = @_;
    		    eval q($v);
		}' unless defined(&__END_ATOMIC_LOAD);
		if(defined(&__HAVE_HASHLOCKED_ATOMICS)) {
		    eval 'sub __DO_ATOMIC_STORE {
		        my($p, $v) = @_;
    			eval q( &__do_atomic_store($p,  &__UNVOLATILE($v), $sizeof{$v}));
		    }' unless defined(&__DO_ATOMIC_STORE);
		} else {
		    eval 'sub __DO_ATOMIC_STORE {
		        my($p, $v) = @_;
    			eval q(*$p = $v);
		    }' unless defined(&__DO_ATOMIC_STORE);
		}
	    }
	    eval 'sub atomic_load_relaxed {
	        my($p) = @_;
    		eval q(({  &const  &volatile  &__typeof__(*($p)) * &__al_ptr = ($p);  &__ATOMIC_PTR_CHECK( &__al_ptr);  &__BEGIN_ATOMIC_LOAD( &__al_ptr,  &__al_val);  &__END_ATOMIC_LOAD( &__al_val); }));
	    }' unless defined(&atomic_load_relaxed);
	    eval 'sub atomic_load_consume {
	        my($p) = @_;
    		eval q(({  &const  &volatile  &__typeof__(*($p)) * &__al_ptr = ($p);  &__ATOMIC_PTR_CHECK( &__al_ptr);  &__BEGIN_ATOMIC_LOAD( &__al_ptr,  &__al_val);  &membar_datadep_consumer();  &__END_ATOMIC_LOAD( &__al_val); }));
	    }' unless defined(&atomic_load_consume);
	    eval 'sub atomic_load_acquire {
	        my($p) = @_;
    		eval q(({  &const  &volatile  &__typeof__(*($p)) * &__al_ptr = ($p);  &__ATOMIC_PTR_CHECK( &__al_ptr);  &__BEGIN_ATOMIC_LOAD( &__al_ptr,  &__al_val);  &membar_acquire();  &__END_ATOMIC_LOAD( &__al_val); }));
	    }' unless defined(&atomic_load_acquire);
	    eval 'sub atomic_store_relaxed {
	        my($p,$v) = @_;
    		eval q(({  &volatile  &__typeof__(*($p)) * &__as_ptr = ($p);  &__typeof__(*($p))  &__as_val = ($v);  &__ATOMIC_PTR_CHECK( &__as_ptr);  &__DO_ATOMIC_STORE( &__as_ptr,  &__as_val); }));
	    }' unless defined(&atomic_store_relaxed);
	    eval 'sub atomic_store_release {
	        my($p,$v) = @_;
    		eval q(({  &volatile  &__typeof__(*($p)) * &__as_ptr = ($p);  &__typeof__(*($p))  &__as_val = ($v);  &__ATOMIC_PTR_CHECK( &__as_ptr);  &membar_release();  &__DO_ATOMIC_STORE( &__as_ptr,  &__as_val); }));
	    }' unless defined(&atomic_store_release);
	    if(defined(&__HAVE_HASHLOCKED_ATOMICS)) {
# some #ifdef were dropped here -- fill in the blanks
		eval 'sub __do_atomic_store {
		    my($p,$q,$size) = @_;
    		    eval q({  &switch ($size) {  &case 1: {  &uint8_t  &v; my $s = 8* (( &uintptr_t)$p & 3);  &uint32_t  &o,  &n,  &m = ~(0xff <<  $s);  &memcpy( &v, $q, 1);  &do {  &o =  &atomic_load_relaxed(( &const  &volatile  &uint32_t *)$p);  &n = ( &o &  &m) | (( &uint32_t) &v <<  $s); }  &while ( &atomic_cas_32(( &volatile  &uint32_t *)$p,  &o,  &n) !=  &o);  &break; }  &case 2: {  &uint16_t  &v; my $s = 8* ((( &uintptr_t)$p & 2) >> 1);  &uint32_t  &o,  &n,  &m = ~(0xffff <<  $s);  &memcpy( &v, $q, 2);  &do {  &o =  &atomic_load_relaxed(( &const  &volatile  &uint32_t *)$p);  &n = ( &o &  &m) | (( &uint32_t) &v <<  $s); }  &while ( &atomic_cas_32(( &volatile  &uint32_t *)$p,  &o,  &n) !=  &o);  &break; }  &case 4: {  &uint32_t  &v;  &memcpy( &v, $q, 4); ( &void) &atomic_swap_32($p,  &v);  &break; } } });
		}' unless defined(&__do_atomic_store);
	    }
	} else {
	    require 'stdatomic.ph';
	    eval 'sub atomic_load_relaxed {
	        my($p) = @_;
    		eval q( &atomic_load_explicit(($p),  &memory_order_relaxed));
	    }' unless defined(&atomic_load_relaxed);
	    if(0) {
		eval 'sub atomic_load_consume {
		    my($p) = @_;
    		    eval q( &atomic_load_explicit(($p),  &memory_order_consume));
		}' unless defined(&atomic_load_consume);
	    } else {
		eval 'sub atomic_load_consume {
		    my($p) = @_;
    		    eval q(({  &const  &__typeof__(*($p))  &__al_val =  &atomic_load_relaxed($p);  &membar_datadep_consumer();  &__al_val; }));
		}' unless defined(&atomic_load_consume);
	    }
	    eval 'sub atomic_load_acquire {
	        my($p) = @_;
    		eval q( &atomic_load_explicit(($p),  &memory_order_acquire));
	    }' unless defined(&atomic_load_acquire);
	    eval 'sub atomic_store_relaxed {
	        my($p, $v) = @_;
    		eval q( &atomic_store_explicit(($p), ($v),  &memory_order_relaxed));
	    }' unless defined(&atomic_store_relaxed);
	    eval 'sub atomic_store_release {
	        my($p, $v) = @_;
    		eval q( &atomic_store_explicit(($p), ($v),  &memory_order_release));
	    }' unless defined(&atomic_store_release);
	}
    }
}
1;
