require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_MIDIIO_H_)) {
    eval 'sub _SYS_MIDIIO_H_ () {1;}' unless defined(&_SYS_MIDIIO_H_);
    require 'machine/endian_machdep.ph';
    require 'sys/ioccom.ph';
    eval 'sub MIDI_PRETIME () { &_IOWR(ord(\'m\'), 0, \'int\');}' unless defined(&MIDI_PRETIME);
    eval 'sub MIDI_MPUMODE () { &_IOWR(ord(\'m\'), 1, \'int\');}' unless defined(&MIDI_MPUMODE);
    eval 'sub MIDI_MPUCMD () { &_IOWR(ord(\'m\'), 2,  &mpu_command_rec);}' unless defined(&MIDI_MPUCMD);
    eval 'sub MIDI_ACK () {0xfe;}' unless defined(&MIDI_ACK);
    eval 'sub SEQUENCER_RESET () { &_IO (ord(\'Q\'), 0);}' unless defined(&SEQUENCER_RESET);
    eval 'sub SEQUENCER_SYNC () { &_IO (ord(\'Q\'), 1);}' unless defined(&SEQUENCER_SYNC);
    eval 'sub SEQUENCER_INFO () { &_IOWR(ord(\'Q\'), 2, \'struct synth_info\');}' unless defined(&SEQUENCER_INFO);
    eval 'sub SEQUENCER_CTRLRATE () { &_IOWR(ord(\'Q\'), 3, \'int\');}' unless defined(&SEQUENCER_CTRLRATE);
    eval 'sub SEQUENCER_GETOUTCOUNT () { &_IOR (ord(\'Q\'), 4, \'int\');}' unless defined(&SEQUENCER_GETOUTCOUNT);
    eval 'sub SEQUENCER_GETINCOUNT () { &_IOR (ord(\'Q\'), 5, \'int\');}' unless defined(&SEQUENCER_GETINCOUNT);
    eval 'sub SEQUENCER_RESETSAMPLES () { &_IOW (ord(\'Q\'), 9, \'int\');}' unless defined(&SEQUENCER_RESETSAMPLES);
    eval 'sub SEQUENCER_NRSYNTHS () { &_IOR (ord(\'Q\'),10, \'int\');}' unless defined(&SEQUENCER_NRSYNTHS);
    eval 'sub SEQUENCER_NRMIDIS () { &_IOR (ord(\'Q\'),11, \'int\');}' unless defined(&SEQUENCER_NRMIDIS);
    eval 'sub SEQUENCER_THRESHOLD () { &_IOW (ord(\'Q\'),13, \'int\');}' unless defined(&SEQUENCER_THRESHOLD);
    eval 'sub SEQUENCER_MEMAVL () { &_IOWR(ord(\'Q\'),14, \'int\');}' unless defined(&SEQUENCER_MEMAVL);
    eval 'sub SEQUENCER_PANIC () { &_IO (ord(\'Q\'),17);}' unless defined(&SEQUENCER_PANIC);
    eval 'sub SEQUENCER_OUTOFBAND () { &_IOW (ord(\'Q\'),18, \'struct seq_event_rec\');}' unless defined(&SEQUENCER_OUTOFBAND);
    eval 'sub SEQUENCER_GETTIME () { &_IOR (ord(\'Q\'),19, \'int\');}' unless defined(&SEQUENCER_GETTIME);
    if(0) {
    }
    eval 'sub CMDSIZE () {8;}' unless defined(&CMDSIZE);
    eval 'sub SYNTH_TYPE_FM () {0;}' unless defined(&SYNTH_TYPE_FM);
    eval 'sub SYNTH_TYPE_SAMPLE () {1;}' unless defined(&SYNTH_TYPE_SAMPLE);
    eval 'sub SYNTH_TYPE_MIDI () {2;}' unless defined(&SYNTH_TYPE_MIDI);
    eval 'sub SYNTH_SUB_FM_TYPE_ADLIB () {0x;}' unless defined(&SYNTH_SUB_FM_TYPE_ADLIB);
    eval 'sub SYNTH_SUB_FM_TYPE_OPL3 () {0x1;}' unless defined(&SYNTH_SUB_FM_TYPE_OPL3);
    eval 'sub SYNTH_SUB_MIDI_TYPE_MPU401 () {0x401;}' unless defined(&SYNTH_SUB_MIDI_TYPE_MPU401);
    eval 'sub SYNTH_SUB_SAMPLE_TYPE_BASIC () {0x10;}' unless defined(&SYNTH_SUB_SAMPLE_TYPE_BASIC);
    eval 'sub SYNTH_SUB_SAMPLE_TYPE_GUS () { &SAMPLE_TYPE_BASIC;}' unless defined(&SYNTH_SUB_SAMPLE_TYPE_GUS);
    eval 'sub SYNTH_CAP_OPL3 () {0x2;}' unless defined(&SYNTH_CAP_OPL3);
    eval 'sub SYNTH_CAP_INPUT () {0x4;}' unless defined(&SYNTH_CAP_INPUT);
    eval 'sub SEQUENCER_TMR_TIMEBASE () { &_IOWR(ord(\'T\'), 1, \'int\');}' unless defined(&SEQUENCER_TMR_TIMEBASE);
    eval 'sub SEQUENCER_TMR_START () { &_IO (ord(\'T\'), 2);}' unless defined(&SEQUENCER_TMR_START);
    eval 'sub SEQUENCER_TMR_STOP () { &_IO (ord(\'T\'), 3);}' unless defined(&SEQUENCER_TMR_STOP);
    eval 'sub SEQUENCER_TMR_CONTINUE () { &_IO (ord(\'T\'), 4);}' unless defined(&SEQUENCER_TMR_CONTINUE);
    eval 'sub SEQUENCER_TMR_TEMPO () { &_IOWR(ord(\'T\'), 5, \'int\');}' unless defined(&SEQUENCER_TMR_TEMPO);
    eval 'sub SEQUENCER_TMR_SOURCE () { &_IOWR(ord(\'T\'), 6, \'int\');}' unless defined(&SEQUENCER_TMR_SOURCE);
    eval 'sub SEQUENCER_TMR_INTERNAL () {0x1;}' unless defined(&SEQUENCER_TMR_INTERNAL);
    if(0) {
	eval 'sub SEQUENCER_TMR_EXTERNAL () {0x2;}' unless defined(&SEQUENCER_TMR_EXTERNAL);
	eval 'sub SEQUENCER_TMR_MODE_MIDI () {0x10;}' unless defined(&SEQUENCER_TMR_MODE_MIDI);
	eval 'sub SEQUENCER_TMR_MODE_FSK () {0x20;}' unless defined(&SEQUENCER_TMR_MODE_FSK);
	eval 'sub SEQUENCER_TMR_MODE_CLS () {0x40;}' unless defined(&SEQUENCER_TMR_MODE_CLS);
	eval 'sub SEQUENCER_TMR_MODE_SMPTE () {0x80;}' unless defined(&SEQUENCER_TMR_MODE_SMPTE);
    }
    eval 'sub SEQUENCER_TMR_METRONOME () { &_IOW (ord(\'T\'), 7, \'int\');}' unless defined(&SEQUENCER_TMR_METRONOME);
    eval 'sub SEQUENCER_TMR_SELECT () { &_IOW (ord(\'T\'), 8, \'int\');}' unless defined(&SEQUENCER_TMR_SELECT);
    eval 'sub MIDI_CTRL_BANK_SELECT_MSB () {0;}' unless defined(&MIDI_CTRL_BANK_SELECT_MSB);
    eval 'sub MIDI_CTRL_MODULATION_MSB () {1;}' unless defined(&MIDI_CTRL_MODULATION_MSB);
    eval 'sub MIDI_CTRL_BREATH_MSB () {2;}' unless defined(&MIDI_CTRL_BREATH_MSB);
    eval 'sub MIDI_CTRL_FOOT_MSB () {4;}' unless defined(&MIDI_CTRL_FOOT_MSB);
    eval 'sub MIDI_CTRL_PORTAMENTO_TIME_MSB () {5;}' unless defined(&MIDI_CTRL_PORTAMENTO_TIME_MSB);
    eval 'sub MIDI_CTRL_DATA_ENTRY_MSB () {6;}' unless defined(&MIDI_CTRL_DATA_ENTRY_MSB);
    eval 'sub MIDI_CTRL_CHANNEL_VOLUME_MSB () {7;}' unless defined(&MIDI_CTRL_CHANNEL_VOLUME_MSB);
    eval 'sub MIDI_CTRL_BALANCE_MSB () {8;}' unless defined(&MIDI_CTRL_BALANCE_MSB);
    eval 'sub MIDI_CTRL_PAN_MSB () {10;}' unless defined(&MIDI_CTRL_PAN_MSB);
    eval 'sub MIDI_CTRL_EXPRESSION_MSB () {11;}' unless defined(&MIDI_CTRL_EXPRESSION_MSB);
    eval 'sub MIDI_CTRL_EFFECT_1_MSB () {12;}' unless defined(&MIDI_CTRL_EFFECT_1_MSB);
    eval 'sub MIDI_CTRL_EFFECT_2_MSB () {13;}' unless defined(&MIDI_CTRL_EFFECT_2_MSB);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_1_MSB () {16;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_1_MSB);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_2_MSB () {17;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_2_MSB);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_3_MSB () {18;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_3_MSB);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_4_MSB () {19;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_4_MSB);
    eval 'sub MIDI_CTRL_BANK_SELECT_LSB () {32;}' unless defined(&MIDI_CTRL_BANK_SELECT_LSB);
    eval 'sub MIDI_CTRL_MODULATION_LSB () {33;}' unless defined(&MIDI_CTRL_MODULATION_LSB);
    eval 'sub MIDI_CTRL_BREATH_LSB () {34;}' unless defined(&MIDI_CTRL_BREATH_LSB);
    eval 'sub MIDI_CTRL_FOOT_LSB () {36;}' unless defined(&MIDI_CTRL_FOOT_LSB);
    eval 'sub MIDI_CTRL_PORTAMENTO_TIME_LSB () {37;}' unless defined(&MIDI_CTRL_PORTAMENTO_TIME_LSB);
    eval 'sub MIDI_CTRL_DATA_ENTRY_LSB () {38;}' unless defined(&MIDI_CTRL_DATA_ENTRY_LSB);
    eval 'sub MIDI_CTRL_CHANNEL_VOLUME_LSB () {39;}' unless defined(&MIDI_CTRL_CHANNEL_VOLUME_LSB);
    eval 'sub MIDI_CTRL_BALANCE_LSB () {40;}' unless defined(&MIDI_CTRL_BALANCE_LSB);
    eval 'sub MIDI_CTRL_PAN_LSB () {42;}' unless defined(&MIDI_CTRL_PAN_LSB);
    eval 'sub MIDI_CTRL_EXPRESSION_LSB () {43;}' unless defined(&MIDI_CTRL_EXPRESSION_LSB);
    eval 'sub MIDI_CTRL_EFFECT_1_LSB () {44;}' unless defined(&MIDI_CTRL_EFFECT_1_LSB);
    eval 'sub MIDI_CTRL_EFFECT_2_LSB () {45;}' unless defined(&MIDI_CTRL_EFFECT_2_LSB);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_1_LSB () {48;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_1_LSB);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_2_LSB () {49;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_2_LSB);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_3_LSB () {50;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_3_LSB);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_4_LSB () {51;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_4_LSB);
    eval 'sub MIDI_CTRL_HOLD_1 () {64;}' unless defined(&MIDI_CTRL_HOLD_1);
    eval 'sub MIDI_CTRL_PORTAMENTO () {65;}' unless defined(&MIDI_CTRL_PORTAMENTO);
    eval 'sub MIDI_CTRL_SOSTENUTO () {66;}' unless defined(&MIDI_CTRL_SOSTENUTO);
    eval 'sub MIDI_CTRL_SOFT_PEDAL () {67;}' unless defined(&MIDI_CTRL_SOFT_PEDAL);
    eval 'sub MIDI_CTRL_LEGATO () {68;}' unless defined(&MIDI_CTRL_LEGATO);
    eval 'sub MIDI_CTRL_HOLD_2 () {69;}' unless defined(&MIDI_CTRL_HOLD_2);
    eval 'sub MIDI_CTRL_SOUND_VARIATION () {70;}' unless defined(&MIDI_CTRL_SOUND_VARIATION);
    eval 'sub MIDI_CTRL_HARMONIC_INTENSITY () {71;}' unless defined(&MIDI_CTRL_HARMONIC_INTENSITY);
    eval 'sub MIDI_CTRL_RELEASE_TIME () {72;}' unless defined(&MIDI_CTRL_RELEASE_TIME);
    eval 'sub MIDI_CTRL_ATTACK_TIME () {73;}' unless defined(&MIDI_CTRL_ATTACK_TIME);
    eval 'sub MIDI_CTRL_BRIGHTNESS () {74;}' unless defined(&MIDI_CTRL_BRIGHTNESS);
    eval 'sub MIDI_CTRL_DECAY_TIME () {75;}' unless defined(&MIDI_CTRL_DECAY_TIME);
    eval 'sub MIDI_CTRL_VIBRATO_RATE () {76;}' unless defined(&MIDI_CTRL_VIBRATO_RATE);
    eval 'sub MIDI_CTRL_VIBRATO_DEPTH () {77;}' unless defined(&MIDI_CTRL_VIBRATO_DEPTH);
    eval 'sub MIDI_CTRL_VIBRATO_DELAY () {78;}' unless defined(&MIDI_CTRL_VIBRATO_DELAY);
    eval 'sub MIDI_CTRL_VIBRATO_DECAY () { &MIDI_CTRL_VIBRATO_DELAY;}' unless defined(&MIDI_CTRL_VIBRATO_DECAY);
    eval 'sub MIDI_CTRL_SOUND_10 () {79;}' unless defined(&MIDI_CTRL_SOUND_10);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_5 () {80;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_5);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_6 () {81;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_6);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_7 () {82;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_7);
    eval 'sub MIDI_CTRL_GENERAL_PURPOSE_8 () {83;}' unless defined(&MIDI_CTRL_GENERAL_PURPOSE_8);
    eval 'sub MIDI_CTRL_PORTAMENTO_CONTROL () {84;}' unless defined(&MIDI_CTRL_PORTAMENTO_CONTROL);
    eval 'sub MIDI_CTRL_EFFECT_DEPTH_1 () {91;}' unless defined(&MIDI_CTRL_EFFECT_DEPTH_1);
    eval 'sub MIDI_CTRL_EFFECT_DEPTH_2 () {92;}' unless defined(&MIDI_CTRL_EFFECT_DEPTH_2);
    eval 'sub MIDI_CTRL_EFFECT_DEPTH_3 () {93;}' unless defined(&MIDI_CTRL_EFFECT_DEPTH_3);
    eval 'sub MIDI_CTRL_EFFECT_DEPTH_4 () {94;}' unless defined(&MIDI_CTRL_EFFECT_DEPTH_4);
    eval 'sub MIDI_CTRL_EFFECT_DEPTH_5 () {95;}' unless defined(&MIDI_CTRL_EFFECT_DEPTH_5);
    eval 'sub MIDI_CTRL_RPN_INCREMENT () {96;}' unless defined(&MIDI_CTRL_RPN_INCREMENT);
    eval 'sub MIDI_CTRL_RPN_DECREMENT () {97;}' unless defined(&MIDI_CTRL_RPN_DECREMENT);
    eval 'sub MIDI_CTRL_NRPN_LSB () {98;}' unless defined(&MIDI_CTRL_NRPN_LSB);
    eval 'sub MIDI_CTRL_NRPN_MSB () {99;}' unless defined(&MIDI_CTRL_NRPN_MSB);
    eval 'sub MIDI_CTRL_RPN_LSB () {100;}' unless defined(&MIDI_CTRL_RPN_LSB);
    eval 'sub MIDI_CTRL_RPN_MSB () {101;}' unless defined(&MIDI_CTRL_RPN_MSB);
    eval 'sub MIDI_CTRL_SOUND_OFF () {120;}' unless defined(&MIDI_CTRL_SOUND_OFF);
    eval 'sub MIDI_CTRL_RESET () {121;}' unless defined(&MIDI_CTRL_RESET);
    eval 'sub MIDI_CTRL_LOCAL () {122;}' unless defined(&MIDI_CTRL_LOCAL);
    eval 'sub MIDI_CTRL_NOTES_OFF () {123;}' unless defined(&MIDI_CTRL_NOTES_OFF);
    eval 'sub MIDI_CTRL_ALLOFF () { &MIDI_CTRL_NOTES_OFF;}' unless defined(&MIDI_CTRL_ALLOFF);
    eval 'sub MIDI_CTRL_OMNI_OFF () {124;}' unless defined(&MIDI_CTRL_OMNI_OFF);
    eval 'sub MIDI_CTRL_OMNI_ON () {125;}' unless defined(&MIDI_CTRL_OMNI_ON);
    eval 'sub MIDI_CTRL_POLY_OFF () {126;}' unless defined(&MIDI_CTRL_POLY_OFF);
    eval 'sub MIDI_CTRL_POLY_ON () {127;}' unless defined(&MIDI_CTRL_POLY_ON);
    eval 'sub MIDI_BEND_NEUTRAL () {(1<<13);}' unless defined(&MIDI_BEND_NEUTRAL);
    eval 'sub MIDI_RPN_PITCH_BEND_SENSITIVITY () {0;}' unless defined(&MIDI_RPN_PITCH_BEND_SENSITIVITY);
    eval 'sub MIDI_RPN_CHANNEL_FINE_TUNING () {1;}' unless defined(&MIDI_RPN_CHANNEL_FINE_TUNING);
    eval 'sub MIDI_RPN_CHANNEL_COARSE_TUNING () {2;}' unless defined(&MIDI_RPN_CHANNEL_COARSE_TUNING);
    eval 'sub MIDI_RPN_TUNING_PROGRAM_CHANGE () {3;}' unless defined(&MIDI_RPN_TUNING_PROGRAM_CHANGE);
    eval 'sub MIDI_RPN_TUNING_BANK_SELECT () {4;}' unless defined(&MIDI_RPN_TUNING_BANK_SELECT);
    eval 'sub MIDI_RPN_MODULATION_DEPTH_RANGE () {5;}' unless defined(&MIDI_RPN_MODULATION_DEPTH_RANGE);
    eval 'sub MIDI_NOTEOFF () {0x80;}' unless defined(&MIDI_NOTEOFF);
    eval 'sub MIDI_NOTEON () {0x90;}' unless defined(&MIDI_NOTEON);
    eval 'sub MIDI_KEY_PRESSURE () {0xa0;}' unless defined(&MIDI_KEY_PRESSURE);
    eval 'sub MIDI_CTL_CHANGE () {0xb0;}' unless defined(&MIDI_CTL_CHANGE);
    eval 'sub MIDI_PGM_CHANGE () {0xc0;}' unless defined(&MIDI_PGM_CHANGE);
    eval 'sub MIDI_CHN_PRESSURE () {0xd0;}' unless defined(&MIDI_CHN_PRESSURE);
    eval 'sub MIDI_PITCH_BEND () {0xe0;}' unless defined(&MIDI_PITCH_BEND);
    eval 'sub MIDI_SYSTEM_PREFIX () {0xf0;}' unless defined(&MIDI_SYSTEM_PREFIX);
    eval 'sub MIDI_IS_STATUS {
        my($d) = @_;
	    eval q((($d) >= 0x80));
    }' unless defined(&MIDI_IS_STATUS);
    eval 'sub MIDI_IS_COMMON {
        my($d) = @_;
	    eval q((($d) >= 0xf0));
    }' unless defined(&MIDI_IS_COMMON);
    eval 'sub MIDI_SYSEX_START () {0xf0;}' unless defined(&MIDI_SYSEX_START);
    eval 'sub MIDI_SYSEX_END () {0xf7;}' unless defined(&MIDI_SYSEX_END);
    eval 'sub MIDI_GET_STATUS {
        my($d) = @_;
	    eval q((($d) & 0xf0));
    }' unless defined(&MIDI_GET_STATUS);
    eval 'sub MIDI_GET_CHAN {
        my($d) = @_;
	    eval q((($d) & 0xf));
    }' unless defined(&MIDI_GET_CHAN);
    eval 'sub MIDI_HALF_VEL () {64;}' unless defined(&MIDI_HALF_VEL);
    eval 'sub SEQ_LOCAL () {0x80;}' unless defined(&SEQ_LOCAL);
    eval 'sub SEQ_TIMING () {0x81;}' unless defined(&SEQ_TIMING);
    eval 'sub SEQ_CHN_COMMON () {0x92;}' unless defined(&SEQ_CHN_COMMON);
    eval 'sub SEQ_CHN_VOICE () {0x93;}' unless defined(&SEQ_CHN_VOICE);
    eval 'sub SEQ_SYSEX () {0x94;}' unless defined(&SEQ_SYSEX);
    eval 'sub SEQ_FULLSIZE () {0xfd;}' unless defined(&SEQ_FULLSIZE);
    eval 'sub SEQ_MK_CHN_VOICE {
        my($e, $unit, $cmd, $chan, $key, $vel) = @_;
	    eval q(( ($e)-> $arr[0] =  &SEQ_CHN_VOICE, ($e)-> $arr[1] = ($unit), ($e)-> $arr[2] = ($cmd), ($e)-> $arr[3] = ($chan), ($e)-> $arr[4] = ($key), ($e)-> $arr[5] = ($vel), ($e)-> $arr[6] = 0, ($e)-> $arr[7] = 0));
    }' unless defined(&SEQ_MK_CHN_VOICE);
    eval 'sub SEQ_MK_CHN_COMMON {
        my($e, $unit, $cmd, $chan, $p1, $p2, $w14) = @_;
	    eval q(( ($e)-> $arr[0] =  &SEQ_CHN_COMMON, ($e)-> $arr[1] = ($unit), ($e)-> $arr[2] = ($cmd), ($e)-> $arr[3] = ($chan), ($e)-> $arr[4] = ($p1), ($e)-> $arr[5] = ($p2), *($e)-> $arr[6] = ($w14)));
    }' unless defined(&SEQ_MK_CHN_COMMON);
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
	eval 'sub SEQ_PATCHKEY {
	    my($id) = @_;
    	    eval q((0xfd00|$id));
	}' unless defined(&SEQ_PATCHKEY);
    } else {
	eval 'sub SEQ_PATCHKEY {
	    my($id) = @_;
    	    eval q((($id<<8)|0xfd));
	}' unless defined(&SEQ_PATCHKEY);
    }
    eval 'sub SEQ_SYSEX_PATCH () { &SEQ_PATCHKEY(0x5);}' unless defined(&SEQ_SYSEX_PATCH);
    eval 'sub SEQ_MAUI_PATCH () { &SEQ_PATCHKEY(0x6);}' unless defined(&SEQ_MAUI_PATCH);
    eval 'sub SEQ_SYSEX_HDRSIZE () {((0)-> &data);}' unless defined(&SEQ_SYSEX_HDRSIZE);
    eval 'sub SBI_FM_PATCH () { &SEQ_PATCHKEY(0x1);}' unless defined(&SBI_FM_PATCH);
    eval 'sub SBI_OPL3_PATCH () { &SEQ_PATCHKEY(0x3);}' unless defined(&SBI_OPL3_PATCH);
    eval 'sub TMR_RESET () {0;}' unless defined(&TMR_RESET);
    eval 'sub TMR_WAIT_REL () {1;}' unless defined(&TMR_WAIT_REL);
    eval 'sub TMR_WAIT_ABS () {2;}' unless defined(&TMR_WAIT_ABS);
    eval 'sub TMR_STOP () {3;}' unless defined(&TMR_STOP);
    eval 'sub TMR_START () {4;}' unless defined(&TMR_START);
    eval 'sub TMR_CONTINUE () {5;}' unless defined(&TMR_CONTINUE);
    eval 'sub TMR_TEMPO () {6;}' unless defined(&TMR_TEMPO);
    eval 'sub TMR_ECHO () {8;}' unless defined(&TMR_ECHO);
    eval 'sub TMR_CLOCK () {9;}' unless defined(&TMR_CLOCK);
    eval 'sub TMR_SPP () {10;}' unless defined(&TMR_SPP);
    eval 'sub TMR_TIMESIG () {11;}' unless defined(&TMR_TIMESIG);
    eval 'sub SEQOLD_CMDSIZE () {4;}' unless defined(&SEQOLD_CMDSIZE);
    eval 'sub SEQOLD_NOTEOFF () {0;}' unless defined(&SEQOLD_NOTEOFF);
    eval 'sub SEQOLD_NOTEON () {1;}' unless defined(&SEQOLD_NOTEON);
    eval 'sub SEQOLD_WAIT () { &TMR_WAIT_ABS;}' unless defined(&SEQOLD_WAIT);
    eval 'sub SEQOLD_PGMCHANGE () {3;}' unless defined(&SEQOLD_PGMCHANGE);
    eval 'sub SEQOLD_SYNCTIMER () { &TMR_START;}' unless defined(&SEQOLD_SYNCTIMER);
    eval 'sub SEQOLD_MIDIPUTC () {5;}' unless defined(&SEQOLD_MIDIPUTC);
    eval 'sub SEQOLD_ECHO () { &TMR_ECHO;}' unless defined(&SEQOLD_ECHO);
    eval 'sub SEQOLD_AFTERTOUCH () {9;}' unless defined(&SEQOLD_AFTERTOUCH);
    eval 'sub SEQOLD_CONTROLLER () {10;}' unless defined(&SEQOLD_CONTROLLER);
    eval 'sub SEQOLD_PRIVATE () {0xfe;}' unless defined(&SEQOLD_PRIVATE);
    eval 'sub SEQOLD_EXTENDED () {0xff;}' unless defined(&SEQOLD_EXTENDED);
    eval 'sub MIDIPITCH_FROM_KEY {
        my($k) = @_;
	    eval q((($k)<<14));
    }' unless defined(&MIDIPITCH_FROM_KEY);
    eval 'sub MIDIPITCH_TO_KEY {
        my($mp) = @_;
	    eval q(((($mp)+(1<<13))>>14));
    }' unless defined(&MIDIPITCH_TO_KEY);
    eval 'sub MIDIPITCH_MAX () {( &MIDIPITCH_FROM_KEY(128)-2);}' unless defined(&MIDIPITCH_MAX);
    eval 'sub MIDIPITCH_OCTAVE () {196608;}' unless defined(&MIDIPITCH_OCTAVE);
    eval 'sub MIDIPITCH_SEMITONE () {16384;}' unless defined(&MIDIPITCH_SEMITONE);
    eval 'sub MIDIPITCH_CENT () {164;}' unless defined(&MIDIPITCH_CENT);
    eval 'sub MIDIHZ18_TO_HZ {
        my($h18) = @_;
	    eval q((($h18)>>18));
    }' unless defined(&MIDIHZ18_TO_HZ);
    unless(defined(&_KERNEL)) {
	require 'math.ph';
	eval 'sub MIDIPITCH_TO_FRKEY {
	    my($mp) = @_;
    	    eval q(( &scalbn(($mp),-14)));
	}' unless defined(&MIDIPITCH_TO_FRKEY);
	eval 'sub MIDIPITCH_FROM_FRKEY {
	    my($frk) = @_;
    	    eval q((( &midipitch_t) &round( &scalbn(($frk),14))));
	}' unless defined(&MIDIPITCH_FROM_FRKEY);
	eval 'sub MIDIHZ18_TO_FRHZ {
	    my($h18) = @_;
    	    eval q(( &scalbn(($h18),-18)));
	}' unless defined(&MIDIHZ18_TO_FRHZ);
	eval 'sub MIDIHZ18_FROM_FRHZ {
	    my($frh) = @_;
    	    eval q((( &midihz18_t) &round( &scalbn(($frh),18))));
	}' unless defined(&MIDIHZ18_FROM_FRHZ);
	eval 'sub MIDIPITCH_TO_FRHZ {
	    my($mp) = @_;
    	    eval q((440* &pow(2,( &MIDIPITCH_TO_FRKEY(($mp))-69)/12)));
	}' unless defined(&MIDIPITCH_TO_FRHZ);
	eval 'sub MIDIPITCH_FROM_FRHZ {
	    my($fhz) = @_;
    	    eval q( &MIDIPITCH_FROM_FRKEY(69+12* &log(($fhz)/440)/ &log(2)));
	}' unless defined(&MIDIPITCH_FROM_FRHZ);
	eval 'sub MIDIPITCH_TO_HZ18 {
	    my($mp) = @_;
    	    eval q( &MIDIHZ18_FROM_FRHZ( &MIDIPITCH_TO_FRHZ(($mp))));
	}' unless defined(&MIDIPITCH_TO_HZ18);
	eval 'sub MIDIPITCH_FROM_HZ18 {
	    my($h18) = @_;
    	    eval q( &MIDIPITCH_FROM_FRHZ( &MIDIHZ18_TO_FRHZ(($h18))));
	}' unless defined(&MIDIPITCH_FROM_HZ18);
    } else {
	eval 'sub MIDIPITCH_TO_HZ18 {
	    my($mp) = @_;
    	    eval q(( &midisyn_mp2hz18(($mp))));
	}' unless defined(&MIDIPITCH_TO_HZ18);
    }
    eval 'sub _EVT_HDR () { &uint8_t  &tag;}' unless defined(&_EVT_HDR);
    eval 'sub _LOCAL_HDR () { &_EVT_HDR;  &uint8_t  &op;}' unless defined(&_LOCAL_HDR);
    eval 'sub _TIMING_HDR () { &_LOCAL_HDR;  &uint16_t  &_zeroh;}' unless defined(&_TIMING_HDR);
    if((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_BIG_ENDIAN) ? &_BIG_ENDIAN : undef)) {
    }
 elsif((defined(&_BYTE_ORDER) ? &_BYTE_ORDER : undef) == (defined(&_LITTLE_ENDIAN) ? &_LITTLE_ENDIAN : undef)) {
    } else {
	die("unexpected _BYTE_ORDER");
    }
    eval 'sub _COMMON_HDR () { &_EVT_HDR;  &uint8_t  &device;  &uint8_t  &op;  &uint8_t  &channel;}' unless defined(&_COMMON_HDR);
    eval 'sub _VOICE_HDR () { &_COMMON_HDR;  &uint8_t  &key;}' unless defined(&_VOICE_HDR);
    undef(&_VOICE_HDR) if defined(&_VOICE_HDR);
    undef(&_COMMON_HDR) if defined(&_COMMON_HDR);
    undef(&_TIMING_HDR) if defined(&_TIMING_HDR);
    undef(&_LOCAL_HDR) if defined(&_LOCAL_HDR);
    undef(&_EVT_HDR) if defined(&_EVT_HDR);
    eval 'sub _SEQ_TAG_NOTEOFF () { &SEQ_CHN_VOICE;}' unless defined(&_SEQ_TAG_NOTEOFF);
    eval 'sub _SEQ_TAG_NOTEON () { &SEQ_CHN_VOICE;}' unless defined(&_SEQ_TAG_NOTEON);
    eval 'sub _SEQ_TAG_KEY_PRESSURE () { &SEQ_CHN_VOICE;}' unless defined(&_SEQ_TAG_KEY_PRESSURE);
    eval 'sub _SEQ_TAG_CTL_CHANGE () { &SEQ_CHN_COMMON;}' unless defined(&_SEQ_TAG_CTL_CHANGE);
    eval 'sub _SEQ_TAG_PGM_CHANGE () { &SEQ_CHN_COMMON;}' unless defined(&_SEQ_TAG_PGM_CHANGE);
    eval 'sub _SEQ_TAG_CHN_PRESSURE () { &SEQ_CHN_COMMON;}' unless defined(&_SEQ_TAG_CHN_PRESSURE);
    eval 'sub _SEQ_TAG_PITCH_BEND () { &SEQ_CHN_COMMON;}' unless defined(&_SEQ_TAG_PITCH_BEND);
    if((defined(&__STDC_VERSION__) ? &__STDC_VERSION__ : undef) >= 199901) {
	eval 'sub SEQ_MK_EVENT () {( &_member, &_tag,...) ( &seq_event_t){ . &_member = { . &tag = ( &_tag),  &__VA_ARGS__ } };}' unless defined(&SEQ_MK_EVENT);
	eval 'sub SEQ_MK_TIMING () {( &_op,...)  &SEQ_MK_EVENT( &t_ &_op,  &SEQ_TIMING, . &op =  &TMR_ &_op,  &__VA_ARGS__);}' unless defined(&SEQ_MK_TIMING);
	eval 'sub SEQ_MK_CHN () {( &_op,...)  &SEQ_MK_EVENT( &c_ &_op,  &_SEQ_TAG_ &_op, . &op =  &MIDI_ &_op,  &__VA_ARGS__);}' unless defined(&SEQ_MK_CHN);
	eval 'sub SEQ_MK_SYSEX () {( &_dev,...)  &SEQ_MK_EVENT( &sysex, 0x94, . &device=( &_dev), . &buffer={0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  &__VA_ARGS__});}' unless defined(&SEQ_MK_SYSEX);
    } else {
	eval 'sub SEQ_MK_EVENT () {( &_member, &_tag, &_args...) ( &seq_event_t){ . &_member = { . &tag = ( &_tag),  &_args } };}' unless defined(&SEQ_MK_EVENT);
	eval 'sub SEQ_MK_TIMING () {( &_op, &_args...)  &SEQ_MK_EVENT( &t_ &_op,  &SEQ_TIMING, . &op =  &TMR_ &_op,  &_args);}' unless defined(&SEQ_MK_TIMING);
	eval 'sub SEQ_MK_CHN () {( &_op, &_args...)  &SEQ_MK_EVENT( &c_ &_op,  &_SEQ_TAG_ &_op, . &op =  &MIDI_ &_op,  &_args);}' unless defined(&SEQ_MK_CHN);
	eval 'sub SEQ_MK_SYSEX () {( &_dev, &_args...)  &SEQ_MK_EVENT( &sysex, 0x94, . &device=( &_dev), . &buffer={0xff, 0xff, 0xff, 0xff, 0xff, 0xff,  &_args});}' unless defined(&SEQ_MK_SYSEX);
    }
    if(0) {
	require 'fcntl.ph';
	require 'stdio.ph';
    }
}
1;
