require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_SOCKETVAR_H_)) {
    eval 'sub _SYS_SOCKETVAR_H_ () {1;}' unless defined(&_SYS_SOCKETVAR_H_);
    require 'sys/select.ph';
    require 'sys/selinfo.ph';
    require 'sys/queue.ph';
    require 'sys/mutex.ph';
    require 'sys/condvar.ph';
    if(!defined(&_KERNEL)) {
    } else {
	require 'sys/atomic.ph';
	require 'sys/uidinfo.ph';
    }
    eval 'sub sb_startzero () { &sb_cc;}' unless defined(&sb_startzero);
    unless(defined(&SB_MAX)) {
	eval 'sub SB_MAX () {(256*1024);}' unless defined(&SB_MAX);
    }
    eval 'sub SB_LOCK () {0x1;}' unless defined(&SB_LOCK);
    eval 'sub SB_NOTIFY () {0x4;}' unless defined(&SB_NOTIFY);
    eval 'sub SB_ASYNC () {0x10;}' unless defined(&SB_ASYNC);
    eval 'sub SB_UPCALL () {0x20;}' unless defined(&SB_UPCALL);
    eval 'sub SB_NOINTR () {0x40;}' unless defined(&SB_NOINTR);
    eval 'sub SB_KNOTE () {0x100;}' unless defined(&SB_KNOTE);
    eval 'sub SB_AUTOSIZE () {0x800;}' unless defined(&SB_AUTOSIZE);
    eval 'sub SS_NOFDREF () {0x1;}' unless defined(&SS_NOFDREF);
    eval 'sub SS_ISCONNECTED () {0x2;}' unless defined(&SS_ISCONNECTED);
    eval 'sub SS_ISCONNECTING () {0x4;}' unless defined(&SS_ISCONNECTING);
    eval 'sub SS_ISDISCONNECTING () {0x8;}' unless defined(&SS_ISDISCONNECTING);
    eval 'sub SS_CANTSENDMORE () {0x10;}' unless defined(&SS_CANTSENDMORE);
    eval 'sub SS_CANTRCVMORE () {0x20;}' unless defined(&SS_CANTRCVMORE);
    eval 'sub SS_RCVATMARK () {0x40;}' unless defined(&SS_RCVATMARK);
    eval 'sub SS_ISABORTING () {0x80;}' unless defined(&SS_ISABORTING);
    eval 'sub SS_RESTARTSYS () {0x100;}' unless defined(&SS_RESTARTSYS);
    eval 'sub SS_POLLRDBAND () {0x200;}' unless defined(&SS_POLLRDBAND);
    eval 'sub SS_MORETOCOME () {0x400;}' unless defined(&SS_MORETOCOME);
    eval 'sub SS_ISDISCONNECTED () {0x800;}' unless defined(&SS_ISDISCONNECTED);
    eval 'sub SS_ISAPIPE () {0x1000;}' unless defined(&SS_ISAPIPE);
    eval 'sub SS_NBIO () {0x2000;}' unless defined(&SS_NBIO);
    if(defined(&_KERNEL)) {
	eval 'sub SB_EMPTY_FIXUP {
	    my($sb) = @_;
    	    eval q( &do {  &KASSERT( &solocked(($sb)-> &sb_so));  &if (($sb)-> &sb_mb ==  &NULL) { ($sb)-> &sb_mbtail =  &NULL; ($sb)-> &sb_lastrecord =  &NULL; } }  &while ( 0));
	}' unless defined(&SB_EMPTY_FIXUP);
	eval 'sub SOOPT_TIMESTAMP {
	    my($o) = @_;
    	    eval q((($o) & ( &SO_TIMESTAMP | 0x400)));
	}' unless defined(&SOOPT_TIMESTAMP);
	require 'sys/protosw.ph';
	require 'sys/mbuf.ph';
	eval 'sub sbspace_oob {
	    my($sb) = @_;
    	    eval q({ my $hiwat =  ($sb->{sb_hiwat});  &if ( $hiwat <  &ULONG_MAX - 1024)  $hiwat += 1024;  &KASSERT( &solocked( ($sb->{sb_so})));  &if ( $hiwat <=  ($sb->{sb_cc}) ||  ($sb->{sb_mbmax}) <=  ($sb->{sb_mbcnt})) 0;  &lmin( $hiwat -  ($sb->{sb_cc}),  ($sb->{sb_mbmax}) -  ($sb->{sb_mbcnt})); });
	}' unless defined(&sbspace_oob);
	eval 'sub sorwakeup {
	    my($so) = @_;
    	    eval q({  &KASSERT( &solocked($so));  &if ( &sb_notify( ($so->{so_rcv})))  &sowakeup($so,  ($so->{so_rcv}),  &POLL_IN); });
	}' unless defined(&sorwakeup);
	eval 'sub sowwakeup {
	    my($so) = @_;
    	    eval q({  &KASSERT( &solocked($so));  &if ( &sb_notify( ($so->{so_snd})))  &sowakeup($so,  ($so->{so_snd}),  &POLL_OUT); });
	}' unless defined(&sowwakeup);
	eval 'sub solock {
	    my($so) = @_;
    	    eval q({  &kmutex_t * &lock;  &lock =  &atomic_load_consume( ($so->{so_lock}));  &mutex_enter( &lock);  &if ( &__predict_false( &lock !=  &atomic_load_relaxed( ($so->{so_lock}))))  &solockretry($so,  &lock); });
	}' unless defined(&solock);
	eval 'sub sounlock {
	    my($so) = @_;
    	    eval q({  &mutex_exit( ($so->{so_lock})); });
	}' unless defined(&sounlock);
	if(defined(&SOCKBUF_DEBUG)) {
	    eval 'sub SBLASTRECORDCHK {
	        my($sb, $where) = @_;
    		eval q( &sblastrecordchk(($sb), ($where)));
	    }' unless defined(&SBLASTRECORDCHK);
	    eval 'sub SBLASTMBUFCHK {
	        my($sb, $where) = @_;
    		eval q( &sblastmbufchk(($sb), ($where)));
	    }' unless defined(&SBLASTMBUFCHK);
	    eval 'sub SBCHECK {
	        my($sb) = @_;
    		eval q( &sbcheck($sb));
	    }' unless defined(&SBCHECK);
	} else {
	    eval 'sub SBLASTRECORDCHK {
	        my($sb, $where) = @_;
    		eval q();
	    }' unless defined(&SBLASTRECORDCHK);
	    eval 'sub SBLASTMBUFCHK {
	        my($sb, $where) = @_;
    		eval q();
	    }' unless defined(&SBLASTMBUFCHK);
	    eval 'sub SBCHECK {
	        my($sb) = @_;
    		eval q();
	    }' unless defined(&SBCHECK);
	}
	eval 'sub SB_PRIO_NONE () {0;}' unless defined(&SB_PRIO_NONE);
	eval 'sub SB_PRIO_ONESHOT_OVERFLOW () {1;}' unless defined(&SB_PRIO_ONESHOT_OVERFLOW);
	eval 'sub SB_PRIO_OVERDRAFT () {2;}' unless defined(&SB_PRIO_OVERDRAFT);
	eval 'sub SB_PRIO_BESTEFFORT () {3;}' unless defined(&SB_PRIO_BESTEFFORT);
	if(defined(&ACCEPT_FILTER_MOD)) {
	    if(defined(&SYSCTL_DECL)) {
	    }
	}
	if(defined(&DDB)) {
	}
    }
}
1;
