<?php

/**
 * BaseEmployeeSkill
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @property int            $emp_number                Type: integer(4), primary key, default "0"
 * @property int            $skillId                   Type: integer, primary key
 * @property float          $years_of_exp              Type: decimal(2)
 * @property string         $comments                  Type: string(100)
 * @property Employee       $Employee                  
 * @property Skill          $Skill                     
 *  
 * @method int              getEmpNumber()             Type: integer(4), primary key, default "0"
 * @method int              getSkillid()               Type: integer, primary key
 * @method float            getYearsOfExp()            Type: decimal(2)
 * @method string           getComments()              Type: string(100)
 * @method Employee         getEmployee()              
 * @method Skill            getSkill()                 
 *  
 * @method EmployeeSkill    setEmpNumber(int $val)     Type: integer(4), primary key, default "0"
 * @method EmployeeSkill    setSkillid(int $val)       Type: integer, primary key
 * @method EmployeeSkill    setYearsOfExp(float $val)  Type: decimal(2)
 * @method EmployeeSkill    setComments(string $val)   Type: string(100)
 * @method EmployeeSkill    setEmployee(Employee $val) 
 * @method EmployeeSkill    setSkill(Skill $val)       
 *  
 * @package    orangehrm
 * @subpackage model
 * @author     Your name here
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class BaseEmployeeSkill extends sfDoctrineRecord
{
    public function setTableDefinition()
    {
        $this->setTableName('hs_hr_emp_skill');
        $this->hasColumn('emp_number', 'integer', 4, array(
             'type' => 'integer',
             'primary' => true,
             'length' => 4,
             ));
        $this->hasColumn('skill_id as skillId', 'integer', null, array(
             'type' => 'integer',
             'primary' => true,
             ));
        $this->hasColumn('years_of_exp', 'decimal', 2, array(
             'type' => 'decimal',
             'length' => 2,
             ));
        $this->hasColumn('comments', 'string', 100, array(
             'type' => 'string',
             'default' => '',
             'notnull' => true,
             'length' => 100,
             ));
    }

    public function setUp()
    {
        parent::setUp();
        $this->hasOne('Employee', array(
             'local' => 'emp_number',
             'foreign' => 'emp_number'));

        $this->hasOne('Skill', array(
             'local' => 'skillId',
             'foreign' => 'id'));
    }
}