<?php

/**
 * PluginComment
 * 
 * This class has been auto-generated by the Doctrine ORM Framework
 * 
 * @package    ##PACKAGE##
 * @subpackage ##SUBPACKAGE##
 * @author     ##NAME## <##EMAIL##>
 * @version    SVN: $Id: Builder.php 7490 2010-03-29 19:53:27Z jwage $
 */
abstract class PluginComment extends BaseComment {
    protected $buzzConfigService;
    protected $buzzTimeZoneUtility;
    /**
     * check loged In User Like this post
     * @param int $id
     * @return string
     */
    public function isLike($id) {
        $likes = $this->getLike();
        $userId = $id;
        if ($userId) {
            foreach ($likes as $like) {
                if ($like->getEmployeeNumber() == $userId) {
                    return 'Unlike';
                }
            }
        } else {
            foreach ($likes as $like) {
                if ($like->getEmployeeNumber() == null) {
                    return 'Unlike';
                }
            }
        }
        return 'Like';
    }

    public function getEmployeeFirstLastName() {
        if ($this->getEmployeeNumber() != '') {
            return $this->getEmployeeComment()->getFirstAndLastNames();
        } else {
            return 'Admin';
        }
    }

    /**
     * Returns the lits of emloyees who liked the comment.
     * @return Employee Collection
     */
    public function getLikedEmployees($loggedInUserId = null) {
        $count=  $this->getBuzzConfigService()->getBuzzLikeCount();
        $arrayOfEmployees = array();
       foreach ($this->getLike() as $value) {
            $empId = $value->getEmployeeNumber();
            $empName = $value->getEmployeeFirstLastName();
            if ($empName == " ") {
                $empName = 'Admin';
            }if ($empId == $loggedInUserId) {
                $empName = "you like this";
                $arrayOfEmployees[] = $empName;
                $count--;
            }
            
        }
        foreach ($this->getLike() as $value) {
            $empId = $value->getEmployeeNumber();
            $empName = $value->getEmployeeFirstLastName();
            if ($empName == " ") {
                $empName = 'Admin';
            }if ($empId == $loggedInUserId) {
                
            }else{
            $arrayOfEmployees[] = $empName;
            $count--;
            }
            if($count<=0){
                break;
            }
        }
        
        return $arrayOfEmployees;
    }
    public function getLikedEmployeeList(){
        $arrayOfEmployees = array();
        foreach ($this->getLike() as $value) {
            
            $arrayOfEmployees[] = $value->getEmployeeLike()->getFirst();
        
        }
        return $arrayOfEmployees;
    }
    
      /**
     * 
     * @return buzzConfigService
     */
    private function getBuzzConfigService() {
       if (!$this->buzzConfigService) {
            $this->buzzConfigService= new BuzzConfigService();
        }
        return $this->buzzConfigService;
    }
    
    public function getDate(){
        return set_datepicker_date_format($this->getCommentTime());
    }
    
    public function getTime(){
        $timeFormat=  $this->getBuzzConfigService()->getTimeFormat();
        return date($timeFormat, strtotime($this->getCommentTime()));
    }
    
     public function isUnLike($id) {
        $likes = $this->getUnlike();
        $userId = $id;
        if ($id) {
            foreach ($likes as $like) {
                if ($like->getEmployeeNumber() == $userId) {
                    return 'yes';
                }
            }
        } else {
            foreach ($likes as $like) {
                if ($like->getEmployeeNumber() == null) {
                    return 'yes';
                }
            }
        }
        return 'no';
    }
    
    
     /**
     * Returns the list of emloyees who liked the comment [WEB SERVICES].
     * @return Employee Collection
     */
    public function getCommentLikedEmployeeList() {       
        $arrayOfEmployees = array();
        foreach ($this->getLike() as $value) {
            $employee = array();            
            $empId = $value->getEmployeeNumber();
            $empName = $value->getEmployeeFirstLastName();
            if(!$value->getEmployeeLike()->getFirst()) {
                $jobTitle = "Administrator";
            } else {
                $jobTitle = $value->getEmployeeLike()->getFirst()->getJobTitleName();
            }

            if ($empId == null) {
                $empName = "Admin";
                $jobTitle = "Administrator";                  
            }
            $employee['employee_name'] = $empName;
            $employee['employee_number'] = $empId;
            $employee['employee_job_title'] = $jobTitle;  
            $arrayOfEmployees[] = $employee;
        }
        return $arrayOfEmployees;
    }
    
     /**
     * Returns the list of emloyees who disliked the comment [WEB SERVICES].
     * @return Employee Collection
     */
    public function getCommentDislikedEmployeeList() {       
        $arrayOfEmployees = array();
        foreach ($this->getUnlike() as $value) {
            $employee = array();           
            $empId = $value->getEmployeeNumber();
            if(!$value->getEmployeeUnLike()->getFirst() || $empId == null) {
                $empName = "Admin";
                $jobTitle = "Administrator";
            } else {
                $empName = $value->getEmployeeUnLike()->getFirst()->getFirstAndLastNames();
                $jobTitle = $value->getEmployeeUnLike()->getFirst()->getJobTitleName();
            }
            $employee['employee_name'] = $empName;
            $employee['employee_number'] = $empId;
            $employee['employee_job_title'] = $jobTitle;        
            $arrayOfEmployees[] = $employee;
        }
        return $arrayOfEmployees;
    }
    
    
     public function isCommentUnLike($id) {
        $likes = $this->getUnlike();
        $userId = $id;
        if ($id) {
            foreach ($likes as $like) {
                if ($like->getEmployeeNumber() == $userId) {
                    return true;
                }
            }
        } else {
            foreach ($likes as $like) {
                if ($like->getEmployeeNumber() == null) {
                    return true;
                }
            }
        }
        return false;
    }
    
     public function isCommentLike($id) {
        $likes = $this->getLike();
        $userId = $id;
        if ($userId) {
            foreach ($likes as $like) {
                if ($like->getEmployeeNumber() == $userId) {
                    return true;
                }
            }
        } else {
            foreach ($likes as $like) {
                if ($like->getEmployeeNumber() == null) {
                    return true;
                }
            }
        }
        return false;
    }

    public function __call($method, $arguments) {
        if ($method == 'getCommentTime') {
            $offset = sfContext::getInstance()->getUser()->getUserTimeZoneOffsetForBuzz();
            $getCommentTime = parent::__call($method, $arguments);
            if(!isset($offset) || is_null($offset)){
                return $getCommentTime;
            }
            $date = gmdate('Y-m-d H:i:s',strtotime($getCommentTime));
            $given = new DateTime($date,new DateTimeZone('+0:00'));
            $given->setTimezone(new DateTimeZone($this->getBuzzTimezoneUtility()->getTimeZoneFromClientOffset($offset)));
            return $given->format("Y-m-d H:i:s");
        }
        return parent::__call($method, $arguments);
    }

    public function getBuzzTimezoneUtility() {
        if(!$this->buzzTimeZoneUtility instanceof BuzzTimezoneUtility) {
            $this->buzzTimeZoneUtility = new BuzzTimezoneUtility();
        }
        return $this->buzzTimeZoneUtility;
    }

}
