################################################################
package Container;
# $Id: Container.pm,v 1.4 2000/11/29 19:20:43 tom Exp $
################################################################

use strict;
use vars qw(@ISA @EXPORT);
use ObjectTemplate;
use Exporter;
use FileHandle;

use JConv;
use Container::Item;

@ISA = qw(ObjectTemplate);
@EXPORT = qw(attributes);

attributes qw(filename content hash);

################################################################

sub initialize($)
{
    my $self = shift;
    
    $self->content([]);
    $self->hash({});
    $self->SUPER::initialize;
}
sub CreateItem($)
{
    my $self = shift;
    return new Container::Item;
}
sub Read($)
{
    my $self = shift;

    *jconv = mkjconv('auto', 'euc');
    
    my $fh = new FileHandle;
    $fh->open($self->filename) || warn $self->filename;
    while (<$fh>){
	next if (/^\#/ || /^$/);
	my $line = $_;
	&jconv(\$line);
	my $item = $self->CreateItem;
	$item->SetByLine($line);
	$self->Add($item);
    }
    $fh->close;
}
sub Add($$)
{
    my ($self, $item) = @_;

    push(@{$self->content}, $item);
    my $key = $item->key;

#    print $key, $item->Value($key), "\n";
    $self->hash->{$item->Value($key)} = $item;
}
   
sub Clear($)
{
    my $self = shift;
    $self->content([]);
    $self->hash({});
}
sub AllContent
{
    my $self = shift;

    return @{$self->content};
}
sub AsPlain($)
{
    my $self = shift;

    my $line;
    for (@{$self->content}){
	$line .= $_->AsPlain;
    }
    return $line;
}
		
1;
