package Di;

=head1 NAME

 DI - Document Information

=cut

# $Id: Di.pm,v 1.8 2000/10/20 16:06:12 tom Exp $
################################################################
    
use strict;

use ObjectTemplate;
use DateTime::Date;
use DateTime::Format;


=head1 STATIC VARIABLES

 $DefaultDiFilename     ǥեȤDIե̾
 $DefaultInterval       ֳ֡Expire ޤǤλ֡
 $TimeFormat            եեޥå

=cut

use vars qw(@ISA
	    $DefaultInterval $TimeFormat $DefaultDiFilename);

@ISA = qw(ObjectTemplate);
$DefaultDiFilename = "hina.di";
$DefaultInterval = 21600;
$TimeFormat = "%a, %d %b %Y %H:%M:%S %Z";


=head1 MEMBER VARIABLES

 filename   hina.di ե̾
 no_expire  Expire, L-M-D, L-M-I Ϥʤ
 ...

=cut

attributes qw(filename
	      extend
	      no_expire
	      url date title author_name
	      lm
	      last_modified last_modified_detected last_modified_interval
	      authorized authorized_url method expire
	      );
################################################################
sub initialize
{
    my $self = shift;

    $self->date(time2str($TimeFormat, time(), "GMT"))
	unless ($self->date);
    $self->last_modified_interval($DefaultInterval)
	unless $self->last_modified_interval;
    $self->filename($DefaultDiFilename) unless $self->filename;
    $self->extend([]);
    $self->SUPER::initialize;
}

sub Read($)
{
    my $self = shift;

    unless (open(F, $self->filename)){
	return 0;
    } else {
	while (<F>){
	    next if 1../^$/;         # ƬԤޤǥå
	    chomp;
#	    print "$_<br>";
	    my ($tag, $content) = split(/: /);
	    $tag = lc($tag);
	    $tag =~ s/-/_/g;
#	    print "\$self->$tag(\$content)";
#	    print "$tag, $content<br>";
	    eval "\$self->$tag(\$content)";
#	    die $@ if $@;
#	    if ($@){
#		$self->Add_X($tag, $content);
#	    }
	}
	close F;
#	print "lmd: ", $self->last_modified_detected, "<br>";
	return 1;
    }
}

sub Add_X($$$)
{
    my ($self, $tag, $content) = @_;

#    print "$tag, $content\n";
    push(@{$self->extend}, [$tag, $content]);
}
sub AsDi($)
{
    my $self = shift;
    
    my $text = sprintf("HINA/2.0
User-Agent: %s

", $self->authorized);
    for (qw(URL Date Title Author-Name Expire Last-Modified
	    Last-Modified-Detected Last-Modified-Interval
	    Authorized Authorized-url Method)){
	my $tag = $_;
	# no_expire
	if ($self->no_expire &&
	    ($tag =~ /Detected/ || $tag =~ /Interval/ || $tag =~ /Expire/)){
	    next;
	}
	my $key = lc($tag);
	$key =~ s/-/_/g;
	
	$text .= sprintf("%s: %s\n", $tag, eval "\$self->$key");
    }
    for (@{$self->extend}){
	my ($tag, $content) = @$_;
	$text .= sprintf("X-%s: %s\n", $tag, $content);
    }
#    $text .= $self->ExtendItems;
    return $text . "\n";
}
sub Write($)
{
    my $self = shift;

    my $filename = $self->filename;

    if (open(F, ">$filename")){
	print F $self->AsDi;
	close F;
	utime $self->lm, $self->lm, $filename;
    }
}

sub SetLastModified
{
    my ($self, $lm, $lm_detected) = @_;

    $self->lm($lm);
    $self->last_modified(time2str($TimeFormat, $lm, "GMT"));
    $self->last_modified_detected(time2str($TimeFormat, $lm_detected, "GMT"));
    $self->expire(time2str($TimeFormat,
			   $lm_detected + $self->last_modified_interval,
			   "GMT"));
}

sub IsUpdated($$)
{
    my ($self, $lm) = @_;

    my $lm_str = time2str($TimeFormat, $lm, "GMT");
#    print STDERR "update? : ", $self->last_modified, ", $lm_str\n";
    return $self->last_modified ne $lm_str;
}

1;

