.TH FBCAT 1 25-Jun-90
.CM 3
.SH NAME
fbcat \- convert image format
.SH SYNOPSIS
.nf
fbcat [ -a<aspect> -t'title' -c'credits' ] [ -<type> ] [ image ] > image
.fi
.SH DESCRIPTION
.PP
A general format converter.  It can read any of the known formats
and write one of the specified output formats (see fbm(1) for format
details).  Note that some conversions require more than simple format
changes, such as color to grayscale or grayscale to 1bit.  For these
conversion you must use a pipeline of ther commands.
.SH OPTIONS
.TP
.BR -a<aspect>
.I aspect ratio,
a floating point number which is the ratio of the height of a pixel to
its width.  Some formats specify this, and for GIF images the reader
attempts to guess from the size of the image.  This option overrides
the input or guessed aspect ratio.  So if you know that your GIF image
has a 1-1 aspect ratio, you should specify -a1 to override the guess.
.TP
.BR -t'title'
.I title,
specify a character string (up to 80 characters) to describe the image.
The default is no title.
.TP
.BR -c'credits'
.I credits or subtitle,
specify a second character string (up to 80 characters) to describe the
image.  The default is no credit string.
.TP
.BR -B
.I face
format, as used by Bennet Yee's
.I face
program at CMU. 
.TP
.BR -F
.I FBM,
format (by default, the default).  You are guaranteed not
to lose information by specifying FBM as the default.
.TP
.BR -G
.I GIF,
Compuserve GIF format.
.TP
.BR -I
.I IFF
format, interleaved bitmaps (ILBM), used by Amigas.
.TP
.BR -P
.I PBM,
Jef Poskanzer's bitmap format.
.TP
.BR -S
.I sun,
Sun rasterfiles (not run length encoded).
.SH EXAMPLE
.PP
To convert a GIF file to an IFF file
.sp
    % fbcat -I < foo.gif > foo.iff
.sp
To convert a Sun raster file to an FBM file, adding a title:
.sp
    % fbcat -t'Title String' < bar.8bit > bar.fbm
.SH SEE ALSO
fbm(1) for general discussion, pbm(1) for PBM routines.
.SH BUGS
None known.
.SH HISTORY
Copyright (C) 1989,1990 by Michael Mauldin.  Permission is granted
to use this file in whole or in part for any purpose, educational,
recreational or commercial, provided that this copyright notice
is retained unchanged.  This software is available to all free of
charge by anonymous FTP and in the UUNET archives.
.TP
25-Jun-90  Michael Mauldin at Carnegie Mellon University
Release 1.0 mlm@cs.cmu.edu
.TP
07-Mar-89  Michael L. Mauldin at Carnegie Mellon University
Beta release (version 0.9) mlm@cs.cmu.edu
