# autovoice lists.. same as autoop lists, but doing a +v instead of +o
# orabidoo (roger.espel.llima@ens.fr)  7 Nov '95, after an idea from
# slackie (slackjaw@sky.net)

# also adds /bless = /mode +v, after another idea from slackie.

$add_ons.="+avoice.pl" if $add_ons !~ /voice/;

$autovoice=1;
@autovoice=();
$avfile=$ENV{"HOME"}."/.avoice-pl.sve";

sub av_hostpat {
  if ($_[0] =~ /^(\d+)\.(\d+)\.(\d+)\.(\d+)$/) {
    return "${1}.${2}.${3}.*";
  } elsif ($_[0] =~ /^([^. \t]+)\.([^. \t]+)\.(.*)$/) {
    return "*.${2}.${3}";
  } else {
    return $_[0];
  }
}

sub autovoiced {
  local($nuh)=@_;
  local($p);
  foreach $p (@autovoice) {
    return 1 if $nuh =~ /^${p}$/;
  }
  return '';
}

sub addtovoice {
  if (&autovoiced($who."!".$user."\@".$host)) {
    &tell("*\cba\cb* $who is already on your auto-voice list");
  } else {
    $host=&av_hostpat($host);
    $user =~ s/^\~//;
    local($pat)=("*!*".$user."\@".$host);
    &tell("*\cba\cb* Adding $who as $pat to your auto-voice list");
    $pat =~ s/([^\\])\./$1\\./g;
    $pat =~ s/\*/\.\*/g;
    $pat =~ s/([^\.\*\\\w])/\\$1/g;
    push(@autovoice, $pat);
    &sl("NOTICE $who :You have been added to ${nick}'s autovoice list, you should be *very* grateful");
  }
}

sub cmd_addvoice {
  &getarg;
  &tell("*\cba\cb* Must specify a nick or pattern"), return unless $newarg;
  if ($newarg =~ /\!.*\@/) {
    &tell("*\cba\cb* Adding $newarg to your auto-voice list");
    $newarg =~ s/([^\\])\./$1\\./g;
    $newarg =~ s/\*/\.\*/g;
    $newarg =~ s/([^\.\*\\\w])/\\$1/g;
    push(@autovoice, $newarg);
  } else {
    &userhost($newarg, "&addtovoice;");
  }
}
&addcmd("addvoice");

sub hook_avjoined {
  local($c)=($_[0]);
  $c =~ tr/A-Z/a-z/;
  &sl("MODE $c +v $who")
    if ($autovoice && $haveops{$c} && &autovoiced($who."!".$user."\@".$host));
}
&addhook("join", "avjoined");

sub cmd_autovoice {
  &getarg;
  if ($newarg =~ /^on$/) {
    $autovoice=1;
  } elsif ($newarg =~ /^off$/) {
    $autovoice='';
  }
  &tell("*\cba\cb* Auto-voice is ".($autovoice?"on":"off"));
}
&addcmd("autovoice");

sub cmd_listvoice {
  local($n, $p, $q)=(0);
  &tell("*\cba\cb* That's the people in your auto-voice list:");
  foreach $p (@autovoice) {
    $n++;
    $q=$p;
    $q =~ s/\\//g;
    $q =~ s/\.\*/*/g;
    &tell("*\cba\cb* $q");
  }
  &tell("*\cba\cb* which makes.. uhm... $n people, I think");
}
&addcmd("listvoice");

sub remvoice {
  local($nuh)=($who."!".$user."\@".$host);
  @autovoice=grep(($nuh !~ /^${_}$/), @autovoice);
}

sub cmd_remvoice {
  &getarg;
  if (!$newarg) {
    &tell("*\cba\cb* Must specify a nick or address");
  } elsif ($newarg =~ /\@/) {
    $newarg='*!'.$newarg if ($newarg !~ /\!/);
    &tell("*\cba\cb* Time to remove $newarg from the auto-voice list");
    @autovoice=grep(($newarg !~ /^${_}$/), @autovoice);
  } else {
    &tell("*\cba\cb* Time to remove $newarg from the auto-voice list");
    &userhost($newarg, "&remvoice;");
  }
}
&addcmd("remvoice");

sub cmd_clearvoice {
  @autovoice=();
  &tell("*\cba\cb* Auto-voice list cleared!");
}
&addcmd("clearvoice");

# saving the settings

sub cmd_svevoice {
  local($p);
  if (!open(SVE, "> ".$avfile)) {
    &tell("*\cbE\cb* can't write to save file");
    return;
  }
  print SVE ($autovoice ? "1" : "0"), "\n";
  print SVE join(" ", @autovoice), "\n";
  close SVE;
  &tell("*\cba\cb* save completed!");
}
&addcmd("svevoice");

sub cmd_bless {
  local($c, $n, $l)=($talkchannel, 0, '');
  &getarg, $c=$newarg if ($args =~ /^[\#\&]/);
  local(@ppl)=split(/ +/, $args);
  foreach (@ppl) {
    if ($n<4) {
      $l .= " ".$_;
      $n++;
    } else {
      &sl("MODE $c +vvvv $l");
      $l=$_;
      $n=1;
    }
  }
  $l && &sl("MODE $c +vvvv $l");
}
&addcmd("bless");


# some online help

&addhelp("voice", "This is \cbavoice.pl\cb for sirc, by \cborabidoo\cb
 
/autovoice [on|off]        toggles auto-voice
/addvoice <nick>|<pattrn>  adds user to your auto-voice list
/remvoice <nick>|<address> removes user from your auto-voice list
/clearvoice                clears your auto-voice list
/listvoice                 lists your auto-voice list
/svevoice                  saves your auto-voice list and toggle
/bless [<#chan>] <nick> gives a +v to someone");

# reading the saved settings

if (open(AV, "< ".$avfile)) {
  local($n, $l);
  chop($autovoice=<AV>);
  chop($l=<AV>);
  @autovoice=split(' ', $l);
  close(AV);
}

&print("*\cba\cb* \cborabidoo\cb's *\cvavoice.pl\cv* loaded, type /help voice  for help");

