#!/bin/bash
#
# This file is a part of the CM-LGC font package
# version 0.5 (May 07, 2005)
#
# Copyright (c) 2003--2005 Alexej Kryukov <basileia@yandex.ru>.
# 
# This package is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# As a special exception, permission is granted to include these font
# programs in a Postscript or PDF file that consists of a document that
# contains text to be displayed or printed using these fonts, regardless
# of the conditions or license applying to the document itself.
#
# This package is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function maketfm () {
	PL_NAME=$1
	echo "Processing $PL_NAME..."
	pltotf $PL_NAME ${PL_NAME%.pl}.tfm
}

function makevf () {
	VPL_NAME=$1
	echo "Processing $VPL_NAME..."
	vptovf $VPL_NAME ${VPL_NAME%.vpl}.vf ${VPL_NAME%.vpl}.tfm
}

PACKAGE_NAME="cm-lgc"
CUR_DIR=$PWD
TEX_DIR=$CUR_DIR/tex
AFM_DIR=$CUR_DIR/texmf/fonts/afm/public/$PACKAGE_NAME
FD_DIR=$CUR_DIR/texmf/tex/latex/cm-lgc
TFM_DIR=$CUR_DIR/texmf/fonts/tfm/public/$PACKAGE_NAME
VF_DIR=$CUR_DIR/texmf/fonts/vf/public/$PACKAGE_NAME

cd $AFM_DIR

cp $TEX_DIR/getmtx.tex $AFM_DIR
cp $TEX_DIR/cyralias-uni.tex $AFM_DIR
latex $TEX_DIR/cm-lgc-t.tex

for i in *.pl; do
	maketfm $i
done

for i in *.vpl; do
	makevf $i
done

rm -f *.mtx *.tex
rm -f *.pl *.vpl

mv -f *.log $TEX_DIR
mv -f *.tfm $TFM_DIR
mv -f *.vf $VF_DIR

mv -f *.fd $FD_DIR

exit 0
