#-*- perl -*-
#
#  Copyright (C) 2008 Ken'ichi Fukamachi
#   All rights reserved. This program is free software; you can
#   redistribute it and/or modify it under the same terms as Perl itself.
#
# $FML: @template.pm,v 1.12 2008/08/24 08:28:36 fukachan Exp $
#

package FML::Char::Ascii::Data;
use strict;
use vars qw(@ISA @EXPORT @EXPORT_OK $AUTOLOAD $banner_table);
use Carp;

=head1 NAME

FML::Char::Ascii::Data - ascii presentation of letters

=head1 SYNOPSIS

NONE.

=head1 DESCRIPTION

Use /usr/bin/banner. For example, run "banner Perl" shows 

    % banner Perl
    ######
    #     #  ######  #####   #
    #     #  #       #    #  #
    ######   #####   #    #  #
    #        #       #####   #
    #        #       #   #   #
    #        ######  #    #  ######

This position data of letters are pre-defined as below.

=head1 METHODS

NONE.

=cut


#
# DATA BEGIN
#

$banner_table = {
	' ' => [
		"       ",
		"       ",
		"       ",
		"       ",
		"       ",
		"       ",
		"       ",
		"       ",
	],
	'!' => [
		"       ",
		"  ###  ",
		"  ###  ",
		"  ###  ",
		"   #   ",
		"       ",
		"  ###  ",
		"  ###  ",
	],
	'"' => [
		"       ",
		"### ###",
		"### ###",
		" #   # ",
		"       ",
		"       ",
		"       ",
		"       ",
	],
	'#' => [
		"       ",
		"  # #  ",
		"  # #  ",
		"#######",
		"  # #  ",
		"#######",
		"  # #  ",
		"  # #  ",
	],
	'$' => [
		"       ",
		" ##### ",
		"#  #  #",
		"#  #   ",
		" ##### ",
		"   #  #",
		"#  #  #",
		" ##### ",
	],
	'%' => [
		"       ",
		"###   #",
		"# #  # ",
		"### #  ",
		"   #   ",
		"  # ###",
		" #  # #",
		"#   ###",
	],
	'&' => [
		"       ",
		"  ##   ",
		" #  #  ",
		"  ##   ",
		" ###   ",
		"#   # #",
		"#    # ",
		" ###  #",
	],
	'\'' => [
		"       ",
		"  ###  ",
		"  ###  ",
		"   #   ",
		"  #    ",
		"       ",
		"       ",
		"       ",
	],
	'(' => [
		"       ",
		"   ##  ",
		"  #    ",
		" #     ",
		" #     ",
		" #     ",
		"  #    ",
		"   ##  ",
	],
	')' => [
		"       ",
		"  ##   ",
		"    #  ",
		"     # ",
		"     # ",
		"     # ",
		"    #  ",
		"  ##   ",
	],
	'*' => [
		"       ",
		"       ",
		" #   # ",
		"  # #  ",
		"#######",
		"  # #  ",
		" #   # ",
		"       ",
	],
	'+' => [
		"       ",
		"       ",
		"   #   ",
		"   #   ",
		" ##### ",
		"   #   ",
		"   #   ",
		"       ",
	],
	',' => [
		"       ",
		"       ",
		"       ",
		"       ",
		"  ###  ",
		"  ###  ",
		"   #   ",
		"  #    ",
	],
	'-' => [
		"       ",
		"       ",
		"       ",
		"       ",
		" ##### ",
		"       ",
		"       ",
		"       ",
	],
	'.' => [
		"       ",
		"       ",
		"       ",
		"       ",
		"       ",
		"  ###  ",
		"  ###  ",
		"  ###  ",
	],
	'/' => [
		"       ",
		"      #",
		"     # ",
		"    #  ",
		"   #   ",
		"  #    ",
		" #     ",
		"#      ",
	],
	'0' => [
		"       ",
		"  ###  ",
		" #   # ",
		"#     #",
		"#     #",
		"#     #",
		" #   # ",
		"  ###  ",
	],
	'1' => [
		"       ",
		"   #   ",
		"  ##   ",
		" # #   ",
		"   #   ",
		"   #   ",
		"   #   ",
		" ##### ",
	],
	'2' => [
		"       ",
		" ##### ",
		"#     #",
		"      #",
		" ##### ",
		"#      ",
		"#      ",
		"#######",
	],
	'3' => [
		"       ",
		" ##### ",
		"#     #",
		"      #",
		" ##### ",
		"      #",
		"#     #",
		" ##### ",
	],
	'4' => [
		"       ",
		"#      ",
		"#    # ",
		"#    # ",
		"#    # ",
		"#######",
		"     # ",
		"     # ",
	],
	'5' => [
		"       ",
		"#######",
		"#      ",
		"#      ",
		"###### ",
		"      #",
		"#     #",
		" ##### ",
	],
	'6' => [
		"       ",
		" ##### ",
		"#     #",
		"#      ",
		"###### ",
		"#     #",
		"#     #",
		" ##### ",
	],
	'7' => [
		"       ",
		"#######",
		"#    # ",
		"    #  ",
		"   #   ",
		"  #    ",
		"  #    ",
		"  #    ",
	],
	'8' => [
		"       ",
		" ##### ",
		"#     #",
		"#     #",
		" ##### ",
		"#     #",
		"#     #",
		" ##### ",
	],
	'9' => [
		"       ",
		" ##### ",
		"#     #",
		"#     #",
		" ######",
		"      #",
		"#     #",
		" ##### ",
	],
	':' => [
		"       ",
		"   #   ",
		"  ###  ",
		"   #   ",
		"       ",
		"   #   ",
		"  ###  ",
		"   #   ",
	],
	';' => [
		"       ",
		"  ###  ",
		"  ###  ",
		"       ",
		"  ###  ",
		"  ###  ",
		"   #   ",
		"  #    ",
	],
	'<' => [
		"       ",
		"    #  ",
		"   #   ",
		"  #    ",
		" #     ",
		"  #    ",
		"   #   ",
		"    #  ",
	],
	'=' => [
		"       ",
		"       ",
		"       ",
		" ##### ",
		"       ",
		" ##### ",
		"       ",
		"       ",
	],
	'>' => [
		"       ",
		"  #    ",
		"   #   ",
		"    #  ",
		"     # ",
		"    #  ",
		"   #   ",
		"  #    ",
	],
	'?' => [
		"       ",
		" ##### ",
		"#     #",
		"      #",
		"   ### ",
		"   #   ",
		"       ",
		"   #   ",
	],
	'@' => [
		"       ",
		" ##### ",
		"#     #",
		"# ### #",
		"# ### #",
		"# #### ",
		"#      ",
		" ##### ",
	],
	'A' => [
		"       ",
		"   #   ",
		"  # #  ",
		" #   # ",
		"#     #",
		"#######",
		"#     #",
		"#     #",
	],
	'B' => [
		"       ",
		"###### ",
		"#     #",
		"#     #",
		"###### ",
		"#     #",
		"#     #",
		"###### ",
	],
	'C' => [
		"       ",
		" ##### ",
		"#     #",
		"#      ",
		"#      ",
		"#      ",
		"#     #",
		" ##### ",
	],
	'D' => [
		"       ",
		"###### ",
		"#     #",
		"#     #",
		"#     #",
		"#     #",
		"#     #",
		"###### ",
	],
	'E' => [
		"       ",
		"#######",
		"#      ",
		"#      ",
		"#####  ",
		"#      ",
		"#      ",
		"#######",
	],
	'F' => [
		"       ",
		"#######",
		"#      ",
		"#      ",
		"#####  ",
		"#      ",
		"#      ",
		"#      ",
	],
	'G' => [
		"       ",
		" ##### ",
		"#     #",
		"#      ",
		"#  ####",
		"#     #",
		"#     #",
		" ##### ",
	],
	'H' => [
		"       ",
		"#     #",
		"#     #",
		"#     #",
		"#######",
		"#     #",
		"#     #",
		"#     #",
	],
	'I' => [
		"       ",
		"  ###  ",
		"   #   ",
		"   #   ",
		"   #   ",
		"   #   ",
		"   #   ",
		"  ###  ",
	],
	'J' => [
		"       ",
		"      #",
		"      #",
		"      #",
		"      #",
		"#     #",
		"#     #",
		" ##### ",
	],
	'K' => [
		"       ",
		"#    # ",
		"#   #  ",
		"#  #   ",
		"###    ",
		"#  #   ",
		"#   #  ",
		"#    # ",
	],
	'L' => [
		"       ",
		"#      ",
		"#      ",
		"#      ",
		"#      ",
		"#      ",
		"#      ",
		"#######",
	],
	'M' => [
		"       ",
		"#     #",
		"##   ##",
		"# # # #",
		"#  #  #",
		"#     #",
		"#     #",
		"#     #",
	],
	'N' => [
		"       ",
		"#     #",
		"##    #",
		"# #   #",
		"#  #  #",
		"#   # #",
		"#    ##",
		"#     #",
	],
	'O' => [
		"       ",
		"#######",
		"#     #",
		"#     #",
		"#     #",
		"#     #",
		"#     #",
		"#######",
	],
	'P' => [
		"       ",
		"###### ",
		"#     #",
		"#     #",
		"###### ",
		"#      ",
		"#      ",
		"#      ",
	],
	'Q' => [
		"       ",
		" ##### ",
		"#     #",
		"#     #",
		"#     #",
		"#   # #",
		"#    # ",
		" #### #",
	],
	'R' => [
		"       ",
		"###### ",
		"#     #",
		"#     #",
		"###### ",
		"#   #  ",
		"#    # ",
		"#     #",
	],
	'S' => [
		"       ",
		" ##### ",
		"#     #",
		"#      ",
		" ##### ",
		"      #",
		"#     #",
		" ##### ",
	],
	'T' => [
		"       ",
		"#######",
		"   #   ",
		"   #   ",
		"   #   ",
		"   #   ",
		"   #   ",
		"   #   ",
	],
	'U' => [
		"       ",
		"#     #",
		"#     #",
		"#     #",
		"#     #",
		"#     #",
		"#     #",
		" ##### ",
	],
	'V' => [
		"       ",
		"#     #",
		"#     #",
		"#     #",
		"#     #",
		" #   # ",
		"  # #  ",
		"   #   ",
	],
	'W' => [
		"       ",
		"#     #",
		"#  #  #",
		"#  #  #",
		"#  #  #",
		"#  #  #",
		"#  #  #",
		" ## ## ",
	],
	'X' => [
		"       ",
		"#     #",
		" #   # ",
		"  # #  ",
		"   #   ",
		"  # #  ",
		" #   # ",
		"#     #",
	],
	'Y' => [
		"       ",
		"#     #",
		" #   # ",
		"  # #  ",
		"   #   ",
		"   #   ",
		"   #   ",
		"   #   ",
	],
	'Z' => [
		"       ",
		"#######",
		"     # ",
		"    #  ",
		"   #   ",
		"  #    ",
		" #     ",
		"#######",
	],
	'[' => [
		"       ",
		" ##### ",
		" #     ",
		" #     ",
		" #     ",
		" #     ",
		" #     ",
		" ##### ",
	],
	'\\' => [
		"       ",
		"#      ",
		" #     ",
		"  #    ",
		"   #   ",
		"    #  ",
		"     # ",
		"      #",
	],
	']' => [
		"       ",
		" ##### ",
		"     # ",
		"     # ",
		"     # ",
		"     # ",
		"     # ",
		" ##### ",
	],
	'^' => [
		"       ",
		"   #   ",
		"  # #  ",
		" #   # ",
		"       ",
		"       ",
		"       ",
		"       ",
	],
	'_' => [
		"       ",
		"       ",
		"       ",
		"       ",
		"       ",
		"       ",
		"       ",
		"#######",
	],
	'`' => [
		"       ",
		"  ###  ",
		"  ###  ",
		"   #   ",
		"    #  ",
		"       ",
		"       ",
		"       ",
	],
	'a' => [
		"       ",
		"       ",
		"   ##  ",
		"  #  # ",
		" #    #",
		" ######",
		" #    #",
		" #    #",
	],
	'b' => [
		"       ",
		"       ",
		" ##### ",
		" #    #",
		" ##### ",
		" #    #",
		" #    #",
		" ##### ",
	],
	'c' => [
		"       ",
		"       ",
		"  #### ",
		" #    #",
		" #     ",
		" #     ",
		" #    #",
		"  #### ",
	],
	'd' => [
		"       ",
		"       ",
		" ##### ",
		" #    #",
		" #    #",
		" #    #",
		" #    #",
		" ##### ",
	],
	'e' => [
		"       ",
		"       ",
		" ######",
		" #     ",
		" ##### ",
		" #     ",
		" #     ",
		" ######",
	],
	'f' => [
		"       ",
		"       ",
		" ######",
		" #     ",
		" ##### ",
		" #     ",
		" #     ",
		" #     ",
	],
	'g' => [
		"       ",
		"       ",
		"  #### ",
		" #    #",
		" #     ",
		" #  ###",
		" #    #",
		"  #### ",
	],
	'h' => [
		"       ",
		"       ",
		" #    #",
		" #    #",
		" ######",
		" #    #",
		" #    #",
		" #    #",
	],
	'i' => [
		"       ",
		"       ",
		"    #  ",
		"    #  ",
		"    #  ",
		"    #  ",
		"    #  ",
		"    #  ",
	],
	'j' => [
		"       ",
		"       ",
		"      #",
		"      #",
		"      #",
		"      #",
		" #    #",
		"  #### ",
	],
	'k' => [
		"       ",
		"       ",
		" #    #",
		" #   # ",
		" ####  ",
		" #  #  ",
		" #   # ",
		" #    #",
	],
	'l' => [
		"       ",
		"       ",
		" #     ",
		" #     ",
		" #     ",
		" #     ",
		" #     ",
		" ######",
	],
	'm' => [
		"       ",
		"       ",
		" #    #",
		" ##  ##",
		" # ## #",
		" #    #",
		" #    #",
		" #    #",
	],
	'n' => [
		"       ",
		"       ",
		" #    #",
		" ##   #",
		" # #  #",
		" #  # #",
		" #   ##",
		" #    #",
	],
	'o' => [
		"       ",
		"       ",
		"  #### ",
		" #    #",
		" #    #",
		" #    #",
		" #    #",
		"  #### ",
	],
	'p' => [
		"       ",
		"       ",
		" ##### ",
		" #    #",
		" #    #",
		" ##### ",
		" #     ",
		" #     ",
	],
	'q' => [
		"       ",
		"       ",
		"  #### ",
		" #    #",
		" #    #",
		" #  # #",
		" #   # ",
		"  ### #",
	],
	'r' => [
		"       ",
		"       ",
		" ##### ",
		" #    #",
		" #    #",
		" ##### ",
		" #   # ",
		" #    #",
	],
	's' => [
		"       ",
		"       ",
		"  #### ",
		" #     ",
		"  #### ",
		"      #",
		" #    #",
		"  #### ",
	],
	't' => [
		"       ",
		"       ",
		"  #####",
		"    #  ",
		"    #  ",
		"    #  ",
		"    #  ",
		"    #  ",
	],
	'u' => [
		"       ",
		"       ",
		" #    #",
		" #    #",
		" #    #",
		" #    #",
		" #    #",
		"  #### ",
	],
	'v' => [
		"       ",
		"       ",
		" #    #",
		" #    #",
		" #    #",
		" #    #",
		"  #  # ",
		"   ##  ",
	],
	'w' => [
		"       ",
		"       ",
		" #    #",
		" #    #",
		" #    #",
		" # ## #",
		" ##  ##",
		" #    #",
	],
	'x' => [
		"       ",
		"       ",
		" #    #",
		"  #  # ",
		"   ##  ",
		"   ##  ",
		"  #  # ",
		" #    #",
	],
	'y' => [
		"       ",
		"       ",
		"  #   #",
		"   # # ",
		"    #  ",
		"    #  ",
		"    #  ",
		"    #  ",
	],
	'z' => [
		"       ",
		"       ",
		" ######",
		"     # ",
		"    #  ",
		"   #   ",
		"  #    ",
		" ######",
	],
	'|' => [
		"       ",
		"   #   ",
		"   #   ",
		"   #   ",
		"       ",
		"   #   ",
		"   #   ",
		"   #   ",
	],
	'}' => [
		"       ",
		"  ###  ",
		"     # ",
		"     # ",
		"     ##",
		"     # ",
		"     # ",
		"  ###  ",
	],
	'~' => [
		"       ",
		" ##    ",
		"#  #  #",
		"    ## ",
		"       ",
		"       ",
		"       ",
		"       ",
	],
};


#
# DATA END
#


=head1 CODING STYLE

See C<http://www.fml.org/software/FNF/> on fml coding style guide.

=head1 AUTHOR

Ken'ichi Fukamachi

=head1 COPYRIGHT

Copyright (C) 2008 Ken'ichi Fukamachi

All rights reserved. This program is free software; you can
redistribute it and/or modify it under the same terms as Perl itself.

=head1 HISTORY

This data is derived from NetBSD's /usr/bin/banner source code (BSD
License).

FML::Char::Ascii::Data appeared in fml8 mailing list driver package.
See C<http://www.fml.org/> for more details.

=cut


1;
