# NOTE: Derived from web_diary_dir/lib/DateTime/Zone.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package DateTime::Zone;

#line 178 "web_diary_dir/lib/DateTime/Zone.pm (autosplit into web_diary_dir/lib/auto/DateTime/Zone/calc_off.al)"
sub calc_off
{
	my ($time) = @_;

	my (@l) = localtime($time);
	my (@g) = gmtime($time);

	my $off;

	$off =     $l[0] - $g[0]
		+ ($l[1] - $g[1]) * 60
		+ ($l[2] - $g[2]) * 3600;

	# subscript 7 is yday.

	if ($l[7] == $g[7]) {
		# done
	} elsif ($l[7] == $g[7] + 1) {
		$off += 86400;
	} elsif ($l[7] == $g[7] - 1) {
		$off -= 86400;
	} elsif ($l[7] < $g[7]) {
		# crossed over a year boundry!
		# localtime is beginning of year, gmt is end
		# therefore local is ahead
		$off += 86400;
	} else {
		$off -= 86400;
	}

	return $off;
}

# end of DateTime::Zone::calc_off
1;
