package TDS::Admin::Skelton;
# $Id#
################################################################

use strict;
use vars qw(@ISA @EXPORT);

use Exporter;

use TDS::Skelton;

@ISA = qw(TDS::Skelton);
@EXPORT = qw(attributes);

attributes qw();

################################################################

sub initialize($)
{
    my $self = shift;

    $self->SUPER::initialize;
}
sub SetMacros($)
{
    my $self = shift;

    $self->SUPER::SetMacros;
    
    require TDS::Admin::WriteServer;
    require TDS::Admin::FTP;

    $self->SetMacro("INPUT_PASSWORD", sub {
	my $rtn = qq(Password: <input type="password" name="password"><br>);
	if (TDS::Admin::WriteServer->GetWriteMethod() eq 'ftp'){
	    $rtn .= qq(FTP Password: <input type="password" name="ftp_password">);
	}
	return $rtn;
    });
    $self->SetMacro("FTP_ADDITIONAL_INFORMATION", sub {
	my $self = shift;
	if (TDS::Admin::WriteServer::GetWriteMethod() eq 'ftp'){
	    return sprintf("ftp server: %s<br>
ftp user name: %s<br>
server web dir: %s<br>
server customize dir: %s<br>
server diary dir: %s",
			   $TDS::Admin::FTP::Server,
			   $TDS::Admin::FTP::UserName,
			   $TDS::Admin::FTP::ServerWebDir,
			   $TDS::Admin::FTP::ServerCustomizeDir,
			   $TDS::Admin::FTP::ServerDiaryDir);
	} else {
	    return undef;
	}
    });
}
1;

