require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_DEV_IC_HD44780VAR_H_)) {
    eval 'sub _DEV_IC_HD44780VAR_H_ () {1;}' unless defined(&_DEV_IC_HD44780VAR_H_);
    require 'sys/ioccom.ph';
    eval 'sub HLCD_DISPCTL () { &_IOW(ord(\'h\'), 1, \'struct hd44780_dispctl\');}' unless defined(&HLCD_DISPCTL);
    eval 'sub HLCD_RESET () { &_IO(ord(\'h\'), 2);}' unless defined(&HLCD_RESET);
    eval 'sub HLCD_CLEAR () { &_IO(ord(\'h\'), 3);}' unless defined(&HLCD_CLEAR);
    eval 'sub HLCD_CURSOR_LEFT () { &_IO(ord(\'h\'), 4);}' unless defined(&HLCD_CURSOR_LEFT);
    eval 'sub HLCD_CURSOR_RIGHT () { &_IO(ord(\'h\'), 5);}' unless defined(&HLCD_CURSOR_RIGHT);
    eval 'sub HLCD_GET_CURSOR_POS () { &_IOR(ord(\'h\'), 6, \'struct hd44780_io\');}' unless defined(&HLCD_GET_CURSOR_POS);
    eval 'sub HLCD_SET_CURSOR_POS () { &_IOW(ord(\'h\'), 7, \'struct hd44780_io\');}' unless defined(&HLCD_SET_CURSOR_POS);
    eval 'sub HLCD_GETC () { &_IOR(ord(\'h\'), 8, \'struct hd44780_io\');}' unless defined(&HLCD_GETC);
    eval 'sub HLCD_PUTC () { &_IOW(ord(\'h\'), 9, \'struct hd44780_io\');}' unless defined(&HLCD_PUTC);
    eval 'sub HLCD_SHIFT_LEFT () { &_IO(ord(\'h\'), 10);}' unless defined(&HLCD_SHIFT_LEFT);
    eval 'sub HLCD_SHIFT_RIGHT () { &_IO(ord(\'h\'), 11);}' unless defined(&HLCD_SHIFT_RIGHT);
    eval 'sub HLCD_HOME () { &_IO(ord(\'h\'), 12);}' unless defined(&HLCD_HOME);
    eval 'sub HLCD_WRITE () { &_IOWR(ord(\'h\'), 13, \'struct hd44780_io\');}' unless defined(&HLCD_WRITE);
    eval 'sub HLCD_READ () { &_IOWR(ord(\'h\'), 14, \'struct hd44780_io\');}' unless defined(&HLCD_READ);
    eval 'sub HLCD_REDRAW () { &_IOW(ord(\'h\'), 15, \'struct hd44780_io\');}' unless defined(&HLCD_REDRAW);
    eval 'sub HLCD_WRITE_INST () { &_IOW(ord(\'h\'), 16, \'struct hd44780_io\');}' unless defined(&HLCD_WRITE_INST);
    eval 'sub HLCD_WRITE_DATA () { &_IOW(ord(\'h\'), 17, \'struct hd44780_io\');}' unless defined(&HLCD_WRITE_DATA);
    eval 'sub HLCD_GET_INFO () { &_IOR(ord(\'h\'), 18, \'struct hd44780_info\');}' unless defined(&HLCD_GET_INFO);
    eval 'sub HLCD_GET_CHIPNO () { &_IOR(ord(\'h\'), 19,  &uint8_t);}' unless defined(&HLCD_GET_CHIPNO);
    eval 'sub HLCD_SET_CHIPNO () { &_IOW(ord(\'h\'), 20,  &uint8_t);}' unless defined(&HLCD_SET_CHIPNO);
    if(defined(&_KERNEL)) {
	eval 'sub HD_8BIT () {0x1;}' unless defined(&HD_8BIT);
	eval 'sub HD_MULTILINE () {0x2;}' unless defined(&HD_MULTILINE);
	eval 'sub HD_BIGFONT () {0x4;}' unless defined(&HD_BIGFONT);
	eval 'sub HD_KEYPAD () {0x8;}' unless defined(&HD_KEYPAD);
	eval 'sub HD_UP () {0x10;}' unless defined(&HD_UP);
	eval 'sub HD_TIMEDOUT () {0x20;}' unless defined(&HD_TIMEDOUT);
	eval 'sub HD_MULTICHIP () {0x40;}' unless defined(&HD_MULTICHIP);
	eval 'sub hd44780_ir_write {
	    my($sc, $en, $dat) = @_;
    	    eval q( &do {  &hd44780_busy_wait($sc, ($en)); ($sc)-> &sc_writereg(($sc), ($en), 0, ($dat)); }  &while(0));
	}' unless defined(&hd44780_ir_write);
	eval 'sub hd44780_ir_read {
	    my($sc, $en) = @_;
    	    eval q(($sc)-> &sc_readreg(($sc), ($en), 0));
	}' unless defined(&hd44780_ir_read);
	eval 'sub hd44780_dr_write {
	    my($sc, $en, $dat) = @_;
    	    eval q(($sc)-> &sc_writereg(($sc), ($en), 1, ($dat)));
	}' unless defined(&hd44780_dr_write);
	eval 'sub hd44780_dr_read {
	    my($sc, $en) = @_;
    	    eval q(($sc)-> &sc_readreg(($sc), ($en), 1));
	}' unless defined(&hd44780_dr_read);
	eval 'sub HD_DDRAM_READ () {0x;}' unless defined(&HD_DDRAM_READ);
	eval 'sub HD_DDRAM_WRITE () {0x1;}' unless defined(&HD_DDRAM_WRITE);
	if(defined(&HD44780_STD_WIDE) || defined(&HD44780_STD_SHORT)) {
	}
    }
}
1;
