require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_EXEC_ELF_H_)) {
    eval 'sub _SYS_EXEC_ELF_H_ () {1;}' unless defined(&_SYS_EXEC_ELF_H_);
    if(defined(&_KERNEL) || defined(&_STANDALONE)) {
	require 'sys/types.ph';
    } else {
	require 'inttypes.ph';
	require 'stddef.ph';
    }
    if((defined(&HAVE_NBTOOL_CONFIG_H) ? &HAVE_NBTOOL_CONFIG_H : undef)) {
	require 'nbinclude/machine/elf_machdep.ph';
    } else {
	require 'machine/elf_machdep.ph';
    }
    eval 'sub ELF32_FSZ_ADDR () {4;}' unless defined(&ELF32_FSZ_ADDR);
    eval 'sub ELF32_FSZ_OFF () {4;}' unless defined(&ELF32_FSZ_OFF);
    eval 'sub ELF32_FSZ_SWORD () {4;}' unless defined(&ELF32_FSZ_SWORD);
    eval 'sub ELF32_FSZ_WORD () {4;}' unless defined(&ELF32_FSZ_WORD);
    eval 'sub ELF32_FSZ_HALF () {2;}' unless defined(&ELF32_FSZ_HALF);
    eval 'sub ELF32_FSZ_LWORD () {8;}' unless defined(&ELF32_FSZ_LWORD);
    eval 'sub ELF64_FSZ_ADDR () {8;}' unless defined(&ELF64_FSZ_ADDR);
    eval 'sub ELF64_FSZ_OFF () {8;}' unless defined(&ELF64_FSZ_OFF);
    eval 'sub ELF64_FSZ_SWORD () {4;}' unless defined(&ELF64_FSZ_SWORD);
    eval 'sub ELF64_FSZ_WORD () {4;}' unless defined(&ELF64_FSZ_WORD);
    eval 'sub ELF64_FSZ_SXWORD () {8;}' unless defined(&ELF64_FSZ_SXWORD);
    eval 'sub ELF64_FSZ_XWORD () {8;}' unless defined(&ELF64_FSZ_XWORD);
    eval 'sub ELF64_FSZ_LWORD () {8;}' unless defined(&ELF64_FSZ_LWORD);
    eval 'sub ELF64_FSZ_HALF () {2;}' unless defined(&ELF64_FSZ_HALF);
    eval 'sub ELF_NIDENT () {16;}' unless defined(&ELF_NIDENT);
    eval 'sub EI_MAG0 () {0;}' unless defined(&EI_MAG0);
    eval 'sub EI_MAG1 () {1;}' unless defined(&EI_MAG1);
    eval 'sub EI_MAG2 () {2;}' unless defined(&EI_MAG2);
    eval 'sub EI_MAG3 () {3;}' unless defined(&EI_MAG3);
    eval 'sub EI_CLASS () {4;}' unless defined(&EI_CLASS);
    eval 'sub EI_DATA () {5;}' unless defined(&EI_DATA);
    eval 'sub EI_VERSION () {6;}' unless defined(&EI_VERSION);
    eval 'sub EI_OSABI () {7;}' unless defined(&EI_OSABI);
    eval 'sub EI_ABIVERSION () {8;}' unless defined(&EI_ABIVERSION);
    eval 'sub EI_PAD () {9;}' unless defined(&EI_PAD);
    eval 'sub EI_NIDENT () {16;}' unless defined(&EI_NIDENT);
    eval 'sub ELFMAG0 () {0x7f;}' unless defined(&ELFMAG0);
    eval 'sub ELFMAG1 () {ord(\'E\');}' unless defined(&ELFMAG1);
    eval 'sub ELFMAG2 () {ord(\'L\');}' unless defined(&ELFMAG2);
    eval 'sub ELFMAG3 () {ord(\'F\');}' unless defined(&ELFMAG3);
    eval 'sub ELFMAG () {"\\177ELF";}' unless defined(&ELFMAG);
    eval 'sub SELFMAG () {4;}' unless defined(&SELFMAG);
    eval 'sub ELFCLASSNONE () {0;}' unless defined(&ELFCLASSNONE);
    eval 'sub ELFCLASS32 () {1;}' unless defined(&ELFCLASS32);
    eval 'sub ELFCLASS64 () {2;}' unless defined(&ELFCLASS64);
    eval 'sub ELFCLASSNUM () {3;}' unless defined(&ELFCLASSNUM);
    eval 'sub ELFDATANONE () {0;}' unless defined(&ELFDATANONE);
    eval 'sub ELFDATA2LSB () {1;}' unless defined(&ELFDATA2LSB);
    eval 'sub ELFDATA2MSB () {2;}' unless defined(&ELFDATA2MSB);
    eval 'sub EV_NONE () {0;}' unless defined(&EV_NONE);
    eval 'sub EV_CURRENT () {1;}' unless defined(&EV_CURRENT);
    eval 'sub EV_NUM () {2;}' unless defined(&EV_NUM);
    eval 'sub ELFOSABI_SYSV () {0;}' unless defined(&ELFOSABI_SYSV);
    eval 'sub ELFOSABI_HPUX () {1;}' unless defined(&ELFOSABI_HPUX);
    eval 'sub ELFOSABI_NETBSD () {2;}' unless defined(&ELFOSABI_NETBSD);
    eval 'sub ELFOSABI_LINUX () {3;}' unless defined(&ELFOSABI_LINUX);
    eval 'sub ELFOSABI_HURD () {4;}' unless defined(&ELFOSABI_HURD);
    eval 'sub ELFOSABI_86OPEN () {5;}' unless defined(&ELFOSABI_86OPEN);
    eval 'sub ELFOSABI_SOLARIS () {6;}' unless defined(&ELFOSABI_SOLARIS);
    eval 'sub ELFOSABI_MONTEREY () {7;}' unless defined(&ELFOSABI_MONTEREY);
    eval 'sub ELFOSABI_IRIX () {8;}' unless defined(&ELFOSABI_IRIX);
    eval 'sub ELFOSABI_FREEBSD () {9;}' unless defined(&ELFOSABI_FREEBSD);
    eval 'sub ELFOSABI_TRU64 () {10;}' unless defined(&ELFOSABI_TRU64);
    eval 'sub ELFOSABI_MODESTO () {11;}' unless defined(&ELFOSABI_MODESTO);
    eval 'sub ELFOSABI_OPENBSD () {12;}' unless defined(&ELFOSABI_OPENBSD);
    eval 'sub ELFOSABI_OPENVMS () {13;}' unless defined(&ELFOSABI_OPENVMS);
    eval 'sub ELFOSABI_NSK () {14;}' unless defined(&ELFOSABI_NSK);
    eval 'sub ELFOSABI_AROS () {15;}' unless defined(&ELFOSABI_AROS);
    eval 'sub ELFOSABI_ARM () {97;}' unless defined(&ELFOSABI_ARM);
    eval 'sub ELFOSABI_STANDALONE () {255;}' unless defined(&ELFOSABI_STANDALONE);
    eval 'sub ELFOSABI_NONE () { &ELFOSABI_SYSV;}' unless defined(&ELFOSABI_NONE);
    eval 'sub ELFOSABI_AIX () { &ELFOSABI_MONTEREY;}' unless defined(&ELFOSABI_AIX);
    eval 'sub ET_NONE () {0;}' unless defined(&ET_NONE);
    eval 'sub ET_REL () {1;}' unless defined(&ET_REL);
    eval 'sub ET_EXEC () {2;}' unless defined(&ET_EXEC);
    eval 'sub ET_DYN () {3;}' unless defined(&ET_DYN);
    eval 'sub ET_CORE () {4;}' unless defined(&ET_CORE);
    eval 'sub ET_NUM () {5;}' unless defined(&ET_NUM);
    eval 'sub ET_LOOS () {0xfe00;}' unless defined(&ET_LOOS);
    eval 'sub ET_HIOS () {0xfeff;}' unless defined(&ET_HIOS);
    eval 'sub ET_LOPROC () {0xff00;}' unless defined(&ET_LOPROC);
    eval 'sub ET_HIPROC () {0xffff;}' unless defined(&ET_HIPROC);
    eval 'sub EM_NONE () {0;}' unless defined(&EM_NONE);
    eval 'sub EM_M32 () {1;}' unless defined(&EM_M32);
    eval 'sub EM_SPARC () {2;}' unless defined(&EM_SPARC);
    eval 'sub EM_386 () {3;}' unless defined(&EM_386);
    eval 'sub EM_68K () {4;}' unless defined(&EM_68K);
    eval 'sub EM_88K () {5;}' unless defined(&EM_88K);
    eval 'sub EM_486 () {6;}' unless defined(&EM_486);
    eval 'sub EM_IAMCU () {6;}' unless defined(&EM_IAMCU);
    eval 'sub EM_860 () {7;}' unless defined(&EM_860);
    eval 'sub EM_MIPS () {8;}' unless defined(&EM_MIPS);
    eval 'sub EM_S370 () {9;}' unless defined(&EM_S370);
    eval 'sub EM_MIPS_RS3_LE () {10;}' unless defined(&EM_MIPS_RS3_LE);
    eval 'sub EM_RS6000 () {11;}' unless defined(&EM_RS6000);
    eval 'sub EM_PARISC () {15;}' unless defined(&EM_PARISC);
    eval 'sub EM_NCUBE () {16;}' unless defined(&EM_NCUBE);
    eval 'sub EM_VPP500 () {17;}' unless defined(&EM_VPP500);
    eval 'sub EM_SPARC32PLUS () {18;}' unless defined(&EM_SPARC32PLUS);
    eval 'sub EM_960 () {19;}' unless defined(&EM_960);
    eval 'sub EM_PPC () {20;}' unless defined(&EM_PPC);
    eval 'sub EM_PPC64 () {21;}' unless defined(&EM_PPC64);
    eval 'sub EM_S390 () {22;}' unless defined(&EM_S390);
    eval 'sub EM_V800 () {36;}' unless defined(&EM_V800);
    eval 'sub EM_FR20 () {37;}' unless defined(&EM_FR20);
    eval 'sub EM_RH32 () {38;}' unless defined(&EM_RH32);
    eval 'sub EM_RCE () {39;}' unless defined(&EM_RCE);
    eval 'sub EM_ARM () {40;}' unless defined(&EM_ARM);
    eval 'sub EM_ALPHA () {41;}' unless defined(&EM_ALPHA);
    eval 'sub EM_SH () {42;}' unless defined(&EM_SH);
    eval 'sub EM_SPARCV9 () {43;}' unless defined(&EM_SPARCV9);
    eval 'sub EM_TRICORE () {44;}' unless defined(&EM_TRICORE);
    eval 'sub EM_ARC () {45;}' unless defined(&EM_ARC);
    eval 'sub EM_H8_300 () {46;}' unless defined(&EM_H8_300);
    eval 'sub EM_H8_300H () {47;}' unless defined(&EM_H8_300H);
    eval 'sub EM_H8S () {48;}' unless defined(&EM_H8S);
    eval 'sub EM_H8_500 () {49;}' unless defined(&EM_H8_500);
    eval 'sub EM_IA_64 () {50;}' unless defined(&EM_IA_64);
    eval 'sub EM_MIPS_X () {51;}' unless defined(&EM_MIPS_X);
    eval 'sub EM_COLDFIRE () {52;}' unless defined(&EM_COLDFIRE);
    eval 'sub EM_68HC12 () {53;}' unless defined(&EM_68HC12);
    eval 'sub EM_MMA () {54;}' unless defined(&EM_MMA);
    eval 'sub EM_PCP () {55;}' unless defined(&EM_PCP);
    eval 'sub EM_NCPU () {56;}' unless defined(&EM_NCPU);
    eval 'sub EM_NDR1 () {57;}' unless defined(&EM_NDR1);
    eval 'sub EM_STARCORE () {58;}' unless defined(&EM_STARCORE);
    eval 'sub EM_ME16 () {59;}' unless defined(&EM_ME16);
    eval 'sub EM_ST100 () {60;}' unless defined(&EM_ST100);
    eval 'sub EM_TINYJ () {61;}' unless defined(&EM_TINYJ);
    eval 'sub EM_X86_64 () {62;}' unless defined(&EM_X86_64);
    eval 'sub EM_PDSP () {63;}' unless defined(&EM_PDSP);
    eval 'sub EM_PDP10 () {64;}' unless defined(&EM_PDP10);
    eval 'sub EM_PDP11 () {65;}' unless defined(&EM_PDP11);
    eval 'sub EM_FX66 () {66;}' unless defined(&EM_FX66);
    eval 'sub EM_ST9PLUS () {67;}' unless defined(&EM_ST9PLUS);
    eval 'sub EM_ST7 () {68;}' unless defined(&EM_ST7);
    eval 'sub EM_68HC16 () {69;}' unless defined(&EM_68HC16);
    eval 'sub EM_68HC11 () {70;}' unless defined(&EM_68HC11);
    eval 'sub EM_68HC08 () {71;}' unless defined(&EM_68HC08);
    eval 'sub EM_68HC05 () {72;}' unless defined(&EM_68HC05);
    eval 'sub EM_SVX () {73;}' unless defined(&EM_SVX);
    eval 'sub EM_ST19 () {74;}' unless defined(&EM_ST19);
    eval 'sub EM_VAX () {75;}' unless defined(&EM_VAX);
    eval 'sub EM_CRIS () {76;}' unless defined(&EM_CRIS);
    eval 'sub EM_JAVELIN () {77;}' unless defined(&EM_JAVELIN);
    eval 'sub EM_FIREPATH () {78;}' unless defined(&EM_FIREPATH);
    eval 'sub EM_ZSP () {79;}' unless defined(&EM_ZSP);
    eval 'sub EM_MMIX () {80;}' unless defined(&EM_MMIX);
    eval 'sub EM_HUANY () {81;}' unless defined(&EM_HUANY);
    eval 'sub EM_PRISM () {82;}' unless defined(&EM_PRISM);
    eval 'sub EM_AVR () {83;}' unless defined(&EM_AVR);
    eval 'sub EM_FR30 () {84;}' unless defined(&EM_FR30);
    eval 'sub EM_D10V () {85;}' unless defined(&EM_D10V);
    eval 'sub EM_D30V () {86;}' unless defined(&EM_D30V);
    eval 'sub EM_V850 () {87;}' unless defined(&EM_V850);
    eval 'sub EM_M32R () {88;}' unless defined(&EM_M32R);
    eval 'sub EM_MN10300 () {89;}' unless defined(&EM_MN10300);
    eval 'sub EM_MN10200 () {90;}' unless defined(&EM_MN10200);
    eval 'sub EM_PJ () {91;}' unless defined(&EM_PJ);
    eval 'sub EM_OR1K () {92;}' unless defined(&EM_OR1K);
    eval 'sub EM_OPENRISC () { &EM_OR1K;}' unless defined(&EM_OPENRISC);
    eval 'sub EM_ARC_A5 () {93;}' unless defined(&EM_ARC_A5);
    eval 'sub EM_XTENSA () {94;}' unless defined(&EM_XTENSA);
    eval 'sub EM_VIDEOCORE () {95;}' unless defined(&EM_VIDEOCORE);
    eval 'sub EM_TMM_GPP () {96;}' unless defined(&EM_TMM_GPP);
    eval 'sub EM_NS32K () {97;}' unless defined(&EM_NS32K);
    eval 'sub EM_TPC () {98;}' unless defined(&EM_TPC);
    eval 'sub EM_SNP1K () {99;}' unless defined(&EM_SNP1K);
    eval 'sub EM_ST200 () {100;}' unless defined(&EM_ST200);
    eval 'sub EM_IP2K () {101;}' unless defined(&EM_IP2K);
    eval 'sub EM_MAX () {102;}' unless defined(&EM_MAX);
    eval 'sub EM_CR () {103;}' unless defined(&EM_CR);
    eval 'sub EM_F2MC16 () {104;}' unless defined(&EM_F2MC16);
    eval 'sub EM_MSP430 () {105;}' unless defined(&EM_MSP430);
    eval 'sub EM_BLACKFIN () {106;}' unless defined(&EM_BLACKFIN);
    eval 'sub EM_SE_C33 () {107;}' unless defined(&EM_SE_C33);
    eval 'sub EM_SEP () {108;}' unless defined(&EM_SEP);
    eval 'sub EM_ARCA () {109;}' unless defined(&EM_ARCA);
    eval 'sub EM_UNICORE () {110;}' unless defined(&EM_UNICORE);
    eval 'sub EM_ALTERA_NIOS2 () {113;}' unless defined(&EM_ALTERA_NIOS2);
    eval 'sub EM_AARCH64 () {183;}' unless defined(&EM_AARCH64);
    eval 'sub EM_AVR32 () {185;}' unless defined(&EM_AVR32);
    eval 'sub EM_TILE64 () {187;}' unless defined(&EM_TILE64);
    eval 'sub EM_TILEPRO () {188;}' unless defined(&EM_TILEPRO);
    eval 'sub EM_MICROBLAZE () {189;}' unless defined(&EM_MICROBLAZE);
    eval 'sub EM_TILEGX () {192;}' unless defined(&EM_TILEGX);
    eval 'sub EM_Z80 () {220;}' unless defined(&EM_Z80);
    eval 'sub EM_RISCV () {243;}' unless defined(&EM_RISCV);
    eval 'sub EM_ALPHA_EXP () {36902;}' unless defined(&EM_ALPHA_EXP);
    eval 'sub EM_NUM () {36903;}' unless defined(&EM_NUM);
    eval 'sub PT_NULL () {0;}' unless defined(&PT_NULL);
    eval 'sub PT_LOAD () {1;}' unless defined(&PT_LOAD);
    eval 'sub PT_DYNAMIC () {2;}' unless defined(&PT_DYNAMIC);
    eval 'sub PT_INTERP () {3;}' unless defined(&PT_INTERP);
    eval 'sub PT_NOTE () {4;}' unless defined(&PT_NOTE);
    eval 'sub PT_SHLIB () {5;}' unless defined(&PT_SHLIB);
    eval 'sub PT_PHDR () {6;}' unless defined(&PT_PHDR);
    eval 'sub PT_TLS () {7;}' unless defined(&PT_TLS);
    eval 'sub PT_NUM () {8;}' unless defined(&PT_NUM);
    eval 'sub PT_LOOS () {0x60000000;}' unless defined(&PT_LOOS);
    eval 'sub PT_GNU_EH_FRAME () {0x6474e550;}' unless defined(&PT_GNU_EH_FRAME);
    eval 'sub PT_GNU_STACK () {0x6474e551;}' unless defined(&PT_GNU_STACK);
    eval 'sub PT_GNU_RELRO () {0x6474e552;}' unless defined(&PT_GNU_RELRO);
    eval 'sub PT_HIOS () {0x6fffffff;}' unless defined(&PT_HIOS);
    eval 'sub PT_LOPROC () {0x70000000;}' unless defined(&PT_LOPROC);
    eval 'sub PT_HIPROC () {0x7fffffff;}' unless defined(&PT_HIPROC);
    eval 'sub PT_MIPS_REGINFO () {0x70000000;}' unless defined(&PT_MIPS_REGINFO);
    eval 'sub PT_MIPS_ABIFLAGS () {0x70000003;}' unless defined(&PT_MIPS_ABIFLAGS);
    eval 'sub PF_R () {0x4;}' unless defined(&PF_R);
    eval 'sub PF_W () {0x2;}' unless defined(&PF_W);
    eval 'sub PF_X () {0x1;}' unless defined(&PF_X);
    eval 'sub PF_MASKOS () {0xff00000;}' unless defined(&PF_MASKOS);
    eval 'sub PF_MASKPROC () {0xf0000000;}' unless defined(&PF_MASKPROC);
    eval 'sub PN_XNUM () {0xffff;}' unless defined(&PN_XNUM);
    eval 'sub SHT_NULL () {0;}' unless defined(&SHT_NULL);
    eval 'sub SHT_PROGBITS () {1;}' unless defined(&SHT_PROGBITS);
    eval 'sub SHT_SYMTAB () {2;}' unless defined(&SHT_SYMTAB);
    eval 'sub SHT_STRTAB () {3;}' unless defined(&SHT_STRTAB);
    eval 'sub SHT_RELA () {4;}' unless defined(&SHT_RELA);
    eval 'sub SHT_HASH () {5;}' unless defined(&SHT_HASH);
    eval 'sub SHT_DYNAMIC () {6;}' unless defined(&SHT_DYNAMIC);
    eval 'sub SHT_NOTE () {7;}' unless defined(&SHT_NOTE);
    eval 'sub SHT_NOBITS () {8;}' unless defined(&SHT_NOBITS);
    eval 'sub SHT_REL () {9;}' unless defined(&SHT_REL);
    eval 'sub SHT_SHLIB () {10;}' unless defined(&SHT_SHLIB);
    eval 'sub SHT_DYNSYM () {11;}' unless defined(&SHT_DYNSYM);
    eval 'sub SHT_INIT_ARRAY () {14;}' unless defined(&SHT_INIT_ARRAY);
    eval 'sub SHT_FINI_ARRAY () {15;}' unless defined(&SHT_FINI_ARRAY);
    eval 'sub SHT_PREINIT_ARRAY () {16;}' unless defined(&SHT_PREINIT_ARRAY);
    eval 'sub SHT_GROUP () {17;}' unless defined(&SHT_GROUP);
    eval 'sub SHT_SYMTAB_SHNDX () {18;}' unless defined(&SHT_SYMTAB_SHNDX);
    eval 'sub SHT_NUM () {19;}' unless defined(&SHT_NUM);
    eval 'sub SHT_LOOS () {0x60000000;}' unless defined(&SHT_LOOS);
    eval 'sub SHT_GNU_INCREMENTAL_INPUTS () {0x6fff4700;}' unless defined(&SHT_GNU_INCREMENTAL_INPUTS);
    eval 'sub SHT_LOSUNW () {0x6ffffff4;}' unless defined(&SHT_LOSUNW);
    eval 'sub SHT_SUNW_dof () {0x6ffffff4;}' unless defined(&SHT_SUNW_dof);
    eval 'sub SHT_GNU_ATTRIBUTES () {0x6ffffff5;}' unless defined(&SHT_GNU_ATTRIBUTES);
    eval 'sub SHT_SUNW_cap () {0x6ffffff5;}' unless defined(&SHT_SUNW_cap);
    eval 'sub SHT_SUNW_SIGNATURE () {0x6ffffff6;}' unless defined(&SHT_SUNW_SIGNATURE);
    eval 'sub SHT_GNU_HASH () {0x6ffffff6;}' unless defined(&SHT_GNU_HASH);
    eval 'sub SHT_GNU_LIBLIST () {0x6ffffff7;}' unless defined(&SHT_GNU_LIBLIST);
    eval 'sub SHT_SUNW_move () {0x6ffffffa;}' unless defined(&SHT_SUNW_move);
    eval 'sub SHT_SUNW_COMDAT () {0x6ffffffb;}' unless defined(&SHT_SUNW_COMDAT);
    eval 'sub SHT_SUNW_syminfo () {0x6ffffffc;}' unless defined(&SHT_SUNW_syminfo);
    eval 'sub SHT_SUNW_verdef () {0x6ffffffd;}' unless defined(&SHT_SUNW_verdef);
    eval 'sub SHT_GNU_verdef () { &SHT_SUNW_verdef;}' unless defined(&SHT_GNU_verdef);
    eval 'sub SHT_SUNW_verneed () {0x6ffffffe;}' unless defined(&SHT_SUNW_verneed);
    eval 'sub SHT_GNU_verneed () { &SHT_SUNW_verneed;}' unless defined(&SHT_GNU_verneed);
    eval 'sub SHT_SUNW_versym () {0x6fffffff;}' unless defined(&SHT_SUNW_versym);
    eval 'sub SHT_GNU_versym () { &SHT_SUNW_versym;}' unless defined(&SHT_GNU_versym);
    eval 'sub SHT_HISUNW () {0x6fffffff;}' unless defined(&SHT_HISUNW);
    eval 'sub SHT_HIOS () {0x6fffffff;}' unless defined(&SHT_HIOS);
    eval 'sub SHT_LOPROC () {0x70000000;}' unless defined(&SHT_LOPROC);
    eval 'sub SHT_AMD64_UNWIND () {0x70000001;}' unless defined(&SHT_AMD64_UNWIND);
    eval 'sub SHT_ARM_EXIDX () {0x70000001;}' unless defined(&SHT_ARM_EXIDX);
    eval 'sub SHT_ARM_PREEMPTMAP () {0x70000002;}' unless defined(&SHT_ARM_PREEMPTMAP);
    eval 'sub SHT_ARM_ATTRIBUTES () {0x70000003;}' unless defined(&SHT_ARM_ATTRIBUTES);
    eval 'sub SHT_ARM_DEBUGOVERLAY () {0x70000004;}' unless defined(&SHT_ARM_DEBUGOVERLAY);
    eval 'sub SHT_ARM_OVERLAYSECTION () {0x70000005;}' unless defined(&SHT_ARM_OVERLAYSECTION);
    eval 'sub SHT_MIPS_REGINFO () {0x70000006;}' unless defined(&SHT_MIPS_REGINFO);
    eval 'sub SHT_MIPS_OPTIONS () {0x7000000d;}' unless defined(&SHT_MIPS_OPTIONS);
    eval 'sub SHT_MIPS_DWARF () {0x7000001e;}' unless defined(&SHT_MIPS_DWARF);
    eval 'sub SHT_HIPROC () {0x7fffffff;}' unless defined(&SHT_HIPROC);
    eval 'sub SHT_LOUSER () {0x80000000;}' unless defined(&SHT_LOUSER);
    eval 'sub SHT_HIUSER () {0xffffffff;}' unless defined(&SHT_HIUSER);
    eval 'sub SHF_WRITE () {0x1;}' unless defined(&SHF_WRITE);
    eval 'sub SHF_ALLOC () {0x2;}' unless defined(&SHF_ALLOC);
    eval 'sub SHF_EXECINSTR () {0x4;}' unless defined(&SHF_EXECINSTR);
    eval 'sub SHF_MERGE () {0x10;}' unless defined(&SHF_MERGE);
    eval 'sub SHF_STRINGS () {0x20;}' unless defined(&SHF_STRINGS);
    eval 'sub SHF_INFO_LINK () {0x40;}' unless defined(&SHF_INFO_LINK);
    eval 'sub SHF_LINK_ORDER () {0x80;}' unless defined(&SHF_LINK_ORDER);
    eval 'sub SHF_OS_NONCONFORMING () {0x100;}' unless defined(&SHF_OS_NONCONFORMING);
    eval 'sub SHF_GROUP () {0x200;}' unless defined(&SHF_GROUP);
    eval 'sub SHF_TLS () {0x400;}' unless defined(&SHF_TLS);
    eval 'sub SHF_MASKOS () {0xff00000;}' unless defined(&SHF_MASKOS);
    eval 'sub SHF_MASKPROC () {0xf0000000;}' unless defined(&SHF_MASKPROC);
    eval 'sub SHF_ORDERED () {0x40000000;}' unless defined(&SHF_ORDERED);
    eval 'sub SHF_EXCLUDE () {0x80000000;}' unless defined(&SHF_EXCLUDE);
    eval 'sub ELF_SYM_UNDEFINED () {0;}' unless defined(&ELF_SYM_UNDEFINED);
    eval 'sub STN_UNDEF () {0;}' unless defined(&STN_UNDEF);
    eval 'sub STB_LOCAL () {0;}' unless defined(&STB_LOCAL);
    eval 'sub STB_GLOBAL () {1;}' unless defined(&STB_GLOBAL);
    eval 'sub STB_WEAK () {2;}' unless defined(&STB_WEAK);
    eval 'sub STB_NUM () {3;}' unless defined(&STB_NUM);
    eval 'sub STB_LOOS () {10;}' unless defined(&STB_LOOS);
    eval 'sub STB_HIOS () {12;}' unless defined(&STB_HIOS);
    eval 'sub STB_LOPROC () {13;}' unless defined(&STB_LOPROC);
    eval 'sub STB_HIPROC () {15;}' unless defined(&STB_HIPROC);
    eval 'sub STT_NOTYPE () {0;}' unless defined(&STT_NOTYPE);
    eval 'sub STT_OBJECT () {1;}' unless defined(&STT_OBJECT);
    eval 'sub STT_FUNC () {2;}' unless defined(&STT_FUNC);
    eval 'sub STT_SECTION () {3;}' unless defined(&STT_SECTION);
    eval 'sub STT_FILE () {4;}' unless defined(&STT_FILE);
    eval 'sub STT_COMMON () {5;}' unless defined(&STT_COMMON);
    eval 'sub STT_TLS () {6;}' unless defined(&STT_TLS);
    eval 'sub STT_NUM () {7;}' unless defined(&STT_NUM);
    eval 'sub STT_LOOS () {10;}' unless defined(&STT_LOOS);
    eval 'sub STT_GNU_IFUNC () {10;}' unless defined(&STT_GNU_IFUNC);
    eval 'sub STT_HIOS () {12;}' unless defined(&STT_HIOS);
    eval 'sub STT_LOPROC () {13;}' unless defined(&STT_LOPROC);
    eval 'sub STT_HIPROC () {15;}' unless defined(&STT_HIPROC);
    eval 'sub STV_DEFAULT () {0;}' unless defined(&STV_DEFAULT);
    eval 'sub STV_INTERNAL () {1;}' unless defined(&STV_INTERNAL);
    eval 'sub STV_HIDDEN () {2;}' unless defined(&STV_HIDDEN);
    eval 'sub STV_PROTECTED () {3;}' unless defined(&STV_PROTECTED);
    eval 'sub STV_EXPORTED () {4;}' unless defined(&STV_EXPORTED);
    eval 'sub STV_SINGLETON () {5;}' unless defined(&STV_SINGLETON);
    eval 'sub STV_ELIMINATE () {6;}' unless defined(&STV_ELIMINATE);
    eval 'sub ELF_ST_BIND {
        my($info) = @_;
	    eval q((( &uint32_t)($info) >> 4));
    }' unless defined(&ELF_ST_BIND);
    eval 'sub ELF_ST_TYPE {
        my($info) = @_;
	    eval q((( &uint32_t)($info) & 0xf));
    }' unless defined(&ELF_ST_TYPE);
    eval 'sub ELF_ST_INFO {
        my($bind,$type) = @_;
	    eval q((( &Elf_Byte)((($bind) << 4) | (($type) & 0xf))));
    }' unless defined(&ELF_ST_INFO);
    eval 'sub ELF_ST_VISIBILITY {
        my($other) = @_;
	    eval q((( &uint32_t)($other) & 3));
    }' unless defined(&ELF_ST_VISIBILITY);
    eval 'sub SHN_UNDEF () {0;}' unless defined(&SHN_UNDEF);
    eval 'sub SHN_LORESERVE () {0xff00;}' unless defined(&SHN_LORESERVE);
    eval 'sub SHN_ABS () {0xfff1;}' unless defined(&SHN_ABS);
    eval 'sub SHN_COMMON () {0xfff2;}' unless defined(&SHN_COMMON);
    eval 'sub SHN_XINDEX () {0xffff;}' unless defined(&SHN_XINDEX);
    eval 'sub SHN_HIRESERVE () {0xffff;}' unless defined(&SHN_HIRESERVE);
    eval 'sub SHN_LOPROC () {0xff00;}' unless defined(&SHN_LOPROC);
    eval 'sub SHN_HIPROC () {0xff1f;}' unless defined(&SHN_HIPROC);
    eval 'sub SHN_LOOS () {0xff20;}' unless defined(&SHN_LOOS);
    eval 'sub SHN_HIOS () {0xff3f;}' unless defined(&SHN_HIOS);
    eval 'sub SHN_MIPS_ACOMMON () {0xff00;}' unless defined(&SHN_MIPS_ACOMMON);
    eval 'sub SHN_MIPS_TEXT () {0xff01;}' unless defined(&SHN_MIPS_TEXT);
    eval 'sub SHN_MIPS_DATA () {0xff02;}' unless defined(&SHN_MIPS_DATA);
    eval 'sub SHN_MIPS_SCOMMON () {0xff03;}' unless defined(&SHN_MIPS_SCOMMON);
    eval 'sub ELF32_R_SYM {
        my($info) = @_;
	    eval q((($info) >> 8));
    }' unless defined(&ELF32_R_SYM);
    eval 'sub ELF32_R_TYPE {
        my($info) = @_;
	    eval q((($info) & 0xff));
    }' unless defined(&ELF32_R_TYPE);
    eval 'sub ELF32_R_INFO {
        my($sym, $type) = @_;
	    eval q((( << 8) + ($type)));
    }' unless defined(&ELF32_R_INFO);
    eval 'sub ELF64_R_SYM {
        my($info) = @_;
	    eval q((($info) >> 32));
    }' unless defined(&ELF64_R_SYM);
    eval 'sub ELF64_R_TYPE {
        my($info) = @_;
	    eval q((($info) & 0xffffffff));
    }' unless defined(&ELF64_R_TYPE);
    eval 'sub ELF64_R_INFO {
        my($sym,$type) = @_;
	    eval q(((($sym) << 32) + ($type)));
    }' unless defined(&ELF64_R_INFO);
    eval 'sub ELF32_M_SYM {
        my($info) = @_;
	    eval q((($info) >> 8));
    }' unless defined(&ELF32_M_SYM);
    eval 'sub ELF32_M_SIZE {
        my($info) = @_;
	    eval q((($info) & 0xff));
    }' unless defined(&ELF32_M_SIZE);
    eval 'sub ELF32_M_INFO {
        my($sym, $size) = @_;
	    eval q((( << 8) + ($size)));
    }' unless defined(&ELF32_M_INFO);
    eval 'sub ELF64_M_SYM {
        my($info) = @_;
	    eval q((($info) >> 8));
    }' unless defined(&ELF64_M_SYM);
    eval 'sub ELF64_M_SIZE {
        my($info) = @_;
	    eval q((($info) & 0xff));
    }' unless defined(&ELF64_M_SIZE);
    eval 'sub ELF64_M_INFO {
        my($sym, $size) = @_;
	    eval q((( << 8) + ($size)));
    }' unless defined(&ELF64_M_INFO);
    eval 'sub DT_NULL () {0;}' unless defined(&DT_NULL);
    eval 'sub DT_NEEDED () {1;}' unless defined(&DT_NEEDED);
    eval 'sub DT_PLTRELSZ () {2;}' unless defined(&DT_PLTRELSZ);
    eval 'sub DT_PLTGOT () {3;}' unless defined(&DT_PLTGOT);
    eval 'sub DT_HASH () {4;}' unless defined(&DT_HASH);
    eval 'sub DT_STRTAB () {5;}' unless defined(&DT_STRTAB);
    eval 'sub DT_SYMTAB () {6;}' unless defined(&DT_SYMTAB);
    eval 'sub DT_RELA () {7;}' unless defined(&DT_RELA);
    eval 'sub DT_RELASZ () {8;}' unless defined(&DT_RELASZ);
    eval 'sub DT_RELAENT () {9;}' unless defined(&DT_RELAENT);
    eval 'sub DT_STRSZ () {10;}' unless defined(&DT_STRSZ);
    eval 'sub DT_SYMENT () {11;}' unless defined(&DT_SYMENT);
    eval 'sub DT_INIT () {12;}' unless defined(&DT_INIT);
    eval 'sub DT_FINI () {13;}' unless defined(&DT_FINI);
    eval 'sub DT_SONAME () {14;}' unless defined(&DT_SONAME);
    eval 'sub DT_RPATH () {15;}' unless defined(&DT_RPATH);
    eval 'sub DT_SYMBOLIC () {16;}' unless defined(&DT_SYMBOLIC);
    eval 'sub DT_REL () {17;}' unless defined(&DT_REL);
    eval 'sub DT_RELSZ () {18;}' unless defined(&DT_RELSZ);
    eval 'sub DT_RELENT () {19;}' unless defined(&DT_RELENT);
    eval 'sub DT_PLTREL () {20;}' unless defined(&DT_PLTREL);
    eval 'sub DT_DEBUG () {21;}' unless defined(&DT_DEBUG);
    eval 'sub DT_TEXTREL () {22;}' unless defined(&DT_TEXTREL);
    eval 'sub DT_JMPREL () {23;}' unless defined(&DT_JMPREL);
    eval 'sub DT_BIND_NOW () {24;}' unless defined(&DT_BIND_NOW);
    eval 'sub DT_INIT_ARRAY () {25;}' unless defined(&DT_INIT_ARRAY);
    eval 'sub DT_FINI_ARRAY () {26;}' unless defined(&DT_FINI_ARRAY);
    eval 'sub DT_INIT_ARRAYSZ () {27;}' unless defined(&DT_INIT_ARRAYSZ);
    eval 'sub DT_FINI_ARRAYSZ () {28;}' unless defined(&DT_FINI_ARRAYSZ);
    eval 'sub DT_RUNPATH () {29;}' unless defined(&DT_RUNPATH);
    eval 'sub DT_FLAGS () {30;}' unless defined(&DT_FLAGS);
    eval 'sub DT_ENCODING () {31;}' unless defined(&DT_ENCODING);
    eval 'sub DT_PREINIT_ARRAY () {32;}' unless defined(&DT_PREINIT_ARRAY);
    eval 'sub DT_PREINIT_ARRAYSZ () {33;}' unless defined(&DT_PREINIT_ARRAYSZ);
    eval 'sub DT_NUM () {34;}' unless defined(&DT_NUM);
    eval 'sub DT_LOOS () {0x60000000;}' unless defined(&DT_LOOS);
    eval 'sub DT_VERSYM () {0x6ffffff0;}' unless defined(&DT_VERSYM);
    eval 'sub DT_FLAGS_1 () {0x6ffffffb;}' unless defined(&DT_FLAGS_1);
    eval 'sub DT_VERDEF () {0x6ffffffc;}' unless defined(&DT_VERDEF);
    eval 'sub DT_VERDEFNUM () {0x6ffffffd;}' unless defined(&DT_VERDEFNUM);
    eval 'sub DT_VERNEED () {0x6ffffffe;}' unless defined(&DT_VERNEED);
    eval 'sub DT_VERNEEDNUM () {0x6fffffff;}' unless defined(&DT_VERNEEDNUM);
    eval 'sub DT_HIOS () {0x6fffffff;}' unless defined(&DT_HIOS);
    eval 'sub DT_LOPROC () {0x70000000;}' unless defined(&DT_LOPROC);
    eval 'sub DT_HIPROC () {0x7fffffff;}' unless defined(&DT_HIPROC);
    eval 'sub DF_ORIGIN () {0x1;}' unless defined(&DF_ORIGIN);
    eval 'sub DF_SYMBOLIC () {0x2;}' unless defined(&DF_SYMBOLIC);
    eval 'sub DF_TEXTREL () {0x4;}' unless defined(&DF_TEXTREL);
    eval 'sub DF_BIND_NOW () {0x8;}' unless defined(&DF_BIND_NOW);
    eval 'sub DF_STATIC_TLS () {0x10;}' unless defined(&DF_STATIC_TLS);
    eval 'sub DF_1_NOW () {0x1;}' unless defined(&DF_1_NOW);
    eval 'sub DF_1_GLOBAL () {0x2;}' unless defined(&DF_1_GLOBAL);
    eval 'sub DF_1_GROUP () {0x4;}' unless defined(&DF_1_GROUP);
    eval 'sub DF_1_NODELETE () {0x8;}' unless defined(&DF_1_NODELETE);
    eval 'sub DF_1_LOADFLTR () {0x10;}' unless defined(&DF_1_LOADFLTR);
    eval 'sub DF_1_INITFIRST () {0x20;}' unless defined(&DF_1_INITFIRST);
    eval 'sub DF_1_NOOPEN () {0x40;}' unless defined(&DF_1_NOOPEN);
    eval 'sub DF_1_ORIGIN () {0x80;}' unless defined(&DF_1_ORIGIN);
    eval 'sub DF_1_DIRECT () {0x100;}' unless defined(&DF_1_DIRECT);
    eval 'sub DF_1_INTERPOSE () {0x400;}' unless defined(&DF_1_INTERPOSE);
    eval 'sub DF_1_NODEFLIB () {0x800;}' unless defined(&DF_1_NODEFLIB);
    eval 'sub DF_1_NODUMP () {0x1000;}' unless defined(&DF_1_NODUMP);
    eval 'sub DF_1_CONFALT () {0x2000;}' unless defined(&DF_1_CONFALT);
    eval 'sub DF_1_ENDFILTEE () {0x4000;}' unless defined(&DF_1_ENDFILTEE);
    eval 'sub DF_1_DISPRELDNE () {0x8000;}' unless defined(&DF_1_DISPRELDNE);
    eval 'sub DF_1_DISPRELPND () {0x10000;}' unless defined(&DF_1_DISPRELPND);
    eval 'sub DF_1_NODIRECT () {0x20000;}' unless defined(&DF_1_NODIRECT);
    eval 'sub DF_1_IGNMULDEF () {0x40000;}' unless defined(&DF_1_IGNMULDEF);
    eval 'sub DF_1_NOKSYMS () {0x80000;}' unless defined(&DF_1_NOKSYMS);
    eval 'sub DF_1_NOHDR () {0x100000;}' unless defined(&DF_1_NOHDR);
    eval 'sub DF_1_EDITED () {0x200000;}' unless defined(&DF_1_EDITED);
    eval 'sub DF_1_NORELOC () {0x400000;}' unless defined(&DF_1_NORELOC);
    eval 'sub DF_1_SYMINTPOSE () {0x800000;}' unless defined(&DF_1_SYMINTPOSE);
    eval 'sub DF_1_GLOBAUDIT () {0x1000000;}' unless defined(&DF_1_GLOBAUDIT);
    eval 'sub DF_1_SINGLETON () {0x2000000;}' unless defined(&DF_1_SINGLETON);
    eval 'sub DF_1_STUB () {0x4000000;}' unless defined(&DF_1_STUB);
    eval 'sub DF_1_PIE () {0x8000000;}' unless defined(&DF_1_PIE);
    eval 'sub AT_NULL () {0;}' unless defined(&AT_NULL);
    eval 'sub AT_IGNORE () {1;}' unless defined(&AT_IGNORE);
    eval 'sub AT_EXECFD () {2;}' unless defined(&AT_EXECFD);
    eval 'sub AT_PHDR () {3;}' unless defined(&AT_PHDR);
    eval 'sub AT_PHENT () {4;}' unless defined(&AT_PHENT);
    eval 'sub AT_PHNUM () {5;}' unless defined(&AT_PHNUM);
    eval 'sub AT_PAGESZ () {6;}' unless defined(&AT_PAGESZ);
    eval 'sub AT_BASE () {7;}' unless defined(&AT_BASE);
    eval 'sub AT_FLAGS () {8;}' unless defined(&AT_FLAGS);
    eval 'sub AT_ENTRY () {9;}' unless defined(&AT_ENTRY);
    eval 'sub AT_DCACHEBSIZE () {10;}' unless defined(&AT_DCACHEBSIZE);
    eval 'sub AT_ICACHEBSIZE () {11;}' unless defined(&AT_ICACHEBSIZE);
    eval 'sub AT_UCACHEBSIZE () {12;}' unless defined(&AT_UCACHEBSIZE);
    eval 'sub AT_STACKBASE () {13;}' unless defined(&AT_STACKBASE);
    eval 'sub AT_MIPS_NOTELF () {10;}' unless defined(&AT_MIPS_NOTELF);
    eval 'sub AT_EUID () {2000;}' unless defined(&AT_EUID);
    eval 'sub AT_RUID () {2001;}' unless defined(&AT_RUID);
    eval 'sub AT_EGID () {2002;}' unless defined(&AT_EGID);
    eval 'sub AT_RGID () {2003;}' unless defined(&AT_RGID);
    eval 'sub AT_SUN_LDELF () {2004;}' unless defined(&AT_SUN_LDELF);
    eval 'sub AT_SUN_LDSHDR () {2005;}' unless defined(&AT_SUN_LDSHDR);
    eval 'sub AT_SUN_LDNAME () {2006;}' unless defined(&AT_SUN_LDNAME);
    eval 'sub AT_SUN_LPGSIZE () {2007;}' unless defined(&AT_SUN_LPGSIZE);
    eval 'sub AT_SUN_PLATFORM () {2008;}' unless defined(&AT_SUN_PLATFORM);
    eval 'sub AT_SUN_HWCAP () {2009;}' unless defined(&AT_SUN_HWCAP);
    eval 'sub AT_SUN_IFLUSH () {2010;}' unless defined(&AT_SUN_IFLUSH);
    eval 'sub AT_SUN_CPU () {2011;}' unless defined(&AT_SUN_CPU);
    eval 'sub AT_SUN_EMUL_ENTRY () {2012;}' unless defined(&AT_SUN_EMUL_ENTRY);
    eval 'sub AT_SUN_EMUL_EXECFD () {2013;}' unless defined(&AT_SUN_EMUL_EXECFD);
    eval 'sub AT_SUN_EXECNAME () {2014;}' unless defined(&AT_SUN_EXECNAME);
    eval 'sub ELF_NOTE_GNU_NAMESZ () {4;}' unless defined(&ELF_NOTE_GNU_NAMESZ);
    eval 'sub ELF_NOTE_GNU_NAME () {"GNU\\0";}' unless defined(&ELF_NOTE_GNU_NAME);
    eval 'sub ELF_NOTE_TYPE_ABI_TAG () {1;}' unless defined(&ELF_NOTE_TYPE_ABI_TAG);
    eval 'sub ELF_NOTE_ABI_NAME () { &ELF_NOTE_GNU_NAME;}' unless defined(&ELF_NOTE_ABI_NAME);
    eval 'sub ELF_NOTE_ABI_NAMESZ () { &ELF_NOTE_GNU_NAMESZ;}' unless defined(&ELF_NOTE_ABI_NAMESZ);
    eval 'sub ELF_NOTE_ABI_DESCSZ () {16;}' unless defined(&ELF_NOTE_ABI_DESCSZ);
    eval 'sub ELF_NOTE_ABI_OS_LINUX () {0;}' unless defined(&ELF_NOTE_ABI_OS_LINUX);
    eval 'sub ELF_NOTE_ABI_OS_HURD () {1;}' unless defined(&ELF_NOTE_ABI_OS_HURD);
    eval 'sub ELF_NOTE_ABI_OS_SOLARIS () {2;}' unless defined(&ELF_NOTE_ABI_OS_SOLARIS);
    eval 'sub ELF_NOTE_ABI_OS_KFREEBSD () {3;}' unless defined(&ELF_NOTE_ABI_OS_KFREEBSD);
    eval 'sub ELF_NOTE_ABI_OS_KNETBSD () {4;}' unless defined(&ELF_NOTE_ABI_OS_KNETBSD);
    eval 'sub ELF_NOTE_OGCC_NAMESZ () {8;}' unless defined(&ELF_NOTE_OGCC_NAMESZ);
    eval 'sub ELF_NOTE_OGCC_NAME () {"01.01\\0\\0\\0\\0";}' unless defined(&ELF_NOTE_OGCC_NAME);
    eval 'sub ELF_NOTE_OGCC_DESCSZ () {0;}' unless defined(&ELF_NOTE_OGCC_DESCSZ);
    eval 'sub ELF_NOTE_TYPE_GNU_HWCAP () {2;}' unless defined(&ELF_NOTE_TYPE_GNU_HWCAP);
    eval 'sub ELF_NOTE_TYPE_GNU_BUILD_ID () {3;}' unless defined(&ELF_NOTE_TYPE_GNU_BUILD_ID);
    eval 'sub ELF_NOTE_TYPE_SUSE_TAG () {1;}' unless defined(&ELF_NOTE_TYPE_SUSE_TAG);
    eval 'sub ELF_NOTE_SUSE_NAMESZ () {5;}' unless defined(&ELF_NOTE_SUSE_NAMESZ);
    eval 'sub ELF_NOTE_SUSE_DESCSZ () {2;}' unless defined(&ELF_NOTE_SUSE_DESCSZ);
    eval 'sub ELF_NOTE_SUSE_NAME () {"SuSE\\0";}' unless defined(&ELF_NOTE_SUSE_NAME);
    eval 'sub ELF_NOTE_TYPE_SUSE_VERSION_TAG () {0x45537553;}' unless defined(&ELF_NOTE_TYPE_SUSE_VERSION_TAG);
    eval 'sub ELF_NOTE_SUSE_VERSION_NAMESZ () {8;}' unless defined(&ELF_NOTE_SUSE_VERSION_NAMESZ);
    eval 'sub ELF_NOTE_SUSE_VERSION_DESCSZ () {8;}' unless defined(&ELF_NOTE_SUSE_VERSION_DESCSZ);
    eval 'sub ELF_NOTE_SUSE_VERSION_NAME () {"SuSE\\0\\0\\0\\0";}' unless defined(&ELF_NOTE_SUSE_VERSION_NAME);
    eval 'sub ELF_NOTE_TYPE_GO_BUILDID_TAG () {4;}' unless defined(&ELF_NOTE_TYPE_GO_BUILDID_TAG);
    eval 'sub ELF_NOTE_GO_BUILDID_NAMESZ () {4;}' unless defined(&ELF_NOTE_GO_BUILDID_NAMESZ);
    eval 'sub ELF_NOTE_GO_BUILDID_DESCSZ () {40;}' unless defined(&ELF_NOTE_GO_BUILDID_DESCSZ);
    eval 'sub ELF_NOTE_GO_BUILDID_NAME () {"Go\\0\\0";}' unless defined(&ELF_NOTE_GO_BUILDID_NAME);
    eval 'sub ELF_NOTE_TYPE_NETBSD_TAG () {1;}' unless defined(&ELF_NOTE_TYPE_NETBSD_TAG);
    eval 'sub ELF_NOTE_NETBSD_NAMESZ () {7;}' unless defined(&ELF_NOTE_NETBSD_NAMESZ);
    eval 'sub ELF_NOTE_NETBSD_DESCSZ () {4;}' unless defined(&ELF_NOTE_NETBSD_DESCSZ);
    eval 'sub ELF_NOTE_NETBSD_NAME () {"NetBSD\\0\\0";}' unless defined(&ELF_NOTE_NETBSD_NAME);
    eval 'sub ELF_NOTE_TYPE_NETBSD_EMUL_TAG () {2;}' unless defined(&ELF_NOTE_TYPE_NETBSD_EMUL_TAG);
    eval 'sub ELF_NOTE_NETBSD_EMUL_NAMESZ () {7;}' unless defined(&ELF_NOTE_NETBSD_EMUL_NAMESZ);
    eval 'sub ELF_NOTE_NETBSD_EMUL_DESCSZ () {7;}' unless defined(&ELF_NOTE_NETBSD_EMUL_DESCSZ);
    eval 'sub ELF_NOTE_NETBSD_EMUL_NAME () {"NetBSD\\0\\0";}' unless defined(&ELF_NOTE_NETBSD_EMUL_NAME);
    eval 'sub ELF_NOTE_TYPE_PAX_TAG () {3;}' unless defined(&ELF_NOTE_TYPE_PAX_TAG);
    eval 'sub ELF_NOTE_PAX_MPROTECT () {0x1;}' unless defined(&ELF_NOTE_PAX_MPROTECT);
    eval 'sub ELF_NOTE_PAX_NOMPROTECT () {0x2;}' unless defined(&ELF_NOTE_PAX_NOMPROTECT);
    eval 'sub ELF_NOTE_PAX_GUARD () {0x4;}' unless defined(&ELF_NOTE_PAX_GUARD);
    eval 'sub ELF_NOTE_PAX_NOGUARD () {0x8;}' unless defined(&ELF_NOTE_PAX_NOGUARD);
    eval 'sub ELF_NOTE_PAX_ASLR () {0x10;}' unless defined(&ELF_NOTE_PAX_ASLR);
    eval 'sub ELF_NOTE_PAX_NOASLR () {0x20;}' unless defined(&ELF_NOTE_PAX_NOASLR);
    eval 'sub ELF_NOTE_PAX_NAMESZ () {4;}' unless defined(&ELF_NOTE_PAX_NAMESZ);
    eval 'sub ELF_NOTE_PAX_NAME () {"PaX\\0";}' unless defined(&ELF_NOTE_PAX_NAME);
    eval 'sub ELF_NOTE_PAX_DESCSZ () {4;}' unless defined(&ELF_NOTE_PAX_DESCSZ);
    eval 'sub ELF_NOTE_NETBSD_CORE_NAME () {"NetBSD-CORE";}' unless defined(&ELF_NOTE_NETBSD_CORE_NAME);
    eval 'sub ELF_NOTE_NETBSD_CORE_PROCINFO () {1;}' unless defined(&ELF_NOTE_NETBSD_CORE_PROCINFO);
    eval 'sub ELF_NOTE_NETBSD_CORE_AUXV () {2;}' unless defined(&ELF_NOTE_NETBSD_CORE_AUXV);
    eval 'sub NETBSD_ELFCORE_PROCINFO_VERSION () {1;}' unless defined(&NETBSD_ELFCORE_PROCINFO_VERSION);
    eval 'sub ELF_NOTE_TYPE_MARCH_TAG () {5;}' unless defined(&ELF_NOTE_TYPE_MARCH_TAG);
    eval 'sub ELF_NOTE_MARCH_NAMESZ () { &ELF_NOTE_NETBSD_NAMESZ;}' unless defined(&ELF_NOTE_MARCH_NAMESZ);
    eval 'sub ELF_NOTE_MARCH_NAME () { &ELF_NOTE_NETBSD_NAME;}' unless defined(&ELF_NOTE_MARCH_NAME);
    eval 'sub ELF_NOTE_TYPE_MCMODEL_TAG () {6;}' unless defined(&ELF_NOTE_TYPE_MCMODEL_TAG);
    eval 'sub ELF_NOTE_MCMODEL_NAMESZ () { &ELF_NOTE_NETBSD_NAMESZ;}' unless defined(&ELF_NOTE_MCMODEL_NAMESZ);
    eval 'sub ELF_NOTE_MCMODEL_NAME () { &ELF_NOTE_NETBSD_NAME;}' unless defined(&ELF_NOTE_MCMODEL_NAME);
    if(!defined(&ELFSIZE)) {
	if(defined(&_RUMPKERNEL) || !defined(&_KERNEL)) {
	    eval 'sub ELFSIZE () { &ARCH_ELFSIZE;}' unless defined(&ELFSIZE);
	} else {
	    eval 'sub ELFSIZE () { &KERN_ELFSIZE;}' unless defined(&ELFSIZE);
	}
    }
    if(defined(&ELFSIZE)) {
	eval 'sub CONCAT {
	    my($x,$y) = @_;
    	    eval q( &__CONCAT($x,$y));
	}' unless defined(&CONCAT);
	eval 'sub ELFNAME {
	    my($x) = @_;
    	    eval q( &CONCAT( &elf, &CONCAT( &ELFSIZE, &CONCAT( &_,$x))));
	}' unless defined(&ELFNAME);
	eval 'sub ELFNAME2 {
	    my($x,$y) = @_;
    	    eval q( &CONCAT($x, &CONCAT( &_elf, &CONCAT( &ELFSIZE, &CONCAT( &_,$y)))));
	}' unless defined(&ELFNAME2);
	eval 'sub ELFNAMEEND {
	    my($x) = @_;
    	    eval q( &CONCAT($x, &CONCAT( &_elf, &ELFSIZE)));
	}' unless defined(&ELFNAMEEND);
	eval 'sub ELFDEFNNAME {
	    my($x) = @_;
    	    eval q( &CONCAT( &ELF, &CONCAT( &ELFSIZE, &CONCAT( &_,$x))));
	}' unless defined(&ELFDEFNNAME);
	eval 'sub ElfW {
	    my($x) = @_;
    	    eval q( &CONCAT( &Elf, &CONCAT( &ELFSIZE, &CONCAT( &_,$x))));
	}' unless defined(&ElfW);
    }
    if(defined(&ELFSIZE)  && ((defined(&ELFSIZE) ? &ELFSIZE : undef) == 32)) {
	eval 'sub Elf_Ehdr () { &Elf32_Ehdr;}' unless defined(&Elf_Ehdr);
	eval 'sub Elf_Phdr () { &Elf32_Phdr;}' unless defined(&Elf_Phdr);
	eval 'sub Elf_Shdr () { &Elf32_Shdr;}' unless defined(&Elf_Shdr);
	eval 'sub Elf_Sym () { &Elf32_Sym;}' unless defined(&Elf_Sym);
	eval 'sub Elf_Rel () { &Elf32_Rel;}' unless defined(&Elf_Rel);
	eval 'sub Elf_Rela () { &Elf32_Rela;}' unless defined(&Elf_Rela);
	eval 'sub Elf_Dyn () { &Elf32_Dyn;}' unless defined(&Elf_Dyn);
	eval 'sub Elf_Word () { &Elf32_Word;}' unless defined(&Elf_Word);
	eval 'sub Elf_Sword () { &Elf32_Sword;}' unless defined(&Elf_Sword);
	eval 'sub Elf_Half () { &Elf32_Half;}' unless defined(&Elf_Half);
	eval 'sub Elf_Addr () { &Elf32_Addr;}' unless defined(&Elf_Addr);
	eval 'sub Elf_Off () { &Elf32_Off;}' unless defined(&Elf_Off);
	eval 'sub Elf_SOff () { &Elf32_SOff;}' unless defined(&Elf_SOff);
	eval 'sub Elf_Nhdr () { &Elf32_Nhdr;}' unless defined(&Elf_Nhdr);
	eval 'sub Elf_Verdef () { &Elf32_Verdef;}' unless defined(&Elf_Verdef);
	eval 'sub Elf_Verdaux () { &Elf32_Verdaux;}' unless defined(&Elf_Verdaux);
	eval 'sub Elf_Verneed () { &Elf32_Verneed;}' unless defined(&Elf_Verneed);
	eval 'sub Elf_Vernaux () { &Elf32_Vernaux;}' unless defined(&Elf_Vernaux);
	eval 'sub Elf_Versym () { &Elf32_Versym;}' unless defined(&Elf_Versym);
	eval 'sub ELF_R_SYM () { &ELF32_R_SYM;}' unless defined(&ELF_R_SYM);
	eval 'sub ELF_R_TYPE () { &ELF32_R_TYPE;}' unless defined(&ELF_R_TYPE);
	eval 'sub ELFCLASS () { &ELFCLASS32;}' unless defined(&ELFCLASS);
	eval 'sub AuxInfo () { &Aux32Info;}' unless defined(&AuxInfo);
    }
 elsif(defined(&ELFSIZE)  && ((defined(&ELFSIZE) ? &ELFSIZE : undef) == 64)) {
	eval 'sub Elf_Ehdr () { &Elf64_Ehdr;}' unless defined(&Elf_Ehdr);
	eval 'sub Elf_Phdr () { &Elf64_Phdr;}' unless defined(&Elf_Phdr);
	eval 'sub Elf_Shdr () { &Elf64_Shdr;}' unless defined(&Elf_Shdr);
	eval 'sub Elf_Sym () { &Elf64_Sym;}' unless defined(&Elf_Sym);
	eval 'sub Elf_Rel () { &Elf64_Rel;}' unless defined(&Elf_Rel);
	eval 'sub Elf_Rela () { &Elf64_Rela;}' unless defined(&Elf_Rela);
	eval 'sub Elf_Dyn () { &Elf64_Dyn;}' unless defined(&Elf_Dyn);
	eval 'sub Elf_Word () { &Elf64_Word;}' unless defined(&Elf_Word);
	eval 'sub Elf_Sword () { &Elf64_Sword;}' unless defined(&Elf_Sword);
	eval 'sub Elf_Half () { &Elf64_Half;}' unless defined(&Elf_Half);
	eval 'sub Elf_Addr () { &Elf64_Addr;}' unless defined(&Elf_Addr);
	eval 'sub Elf_Off () { &Elf64_Off;}' unless defined(&Elf_Off);
	eval 'sub Elf_SOff () { &Elf64_SOff;}' unless defined(&Elf_SOff);
	eval 'sub Elf_Nhdr () { &Elf64_Nhdr;}' unless defined(&Elf_Nhdr);
	eval 'sub Elf_Verdef () { &Elf64_Verdef;}' unless defined(&Elf_Verdef);
	eval 'sub Elf_Verdaux () { &Elf64_Verdaux;}' unless defined(&Elf_Verdaux);
	eval 'sub Elf_Verneed () { &Elf64_Verneed;}' unless defined(&Elf_Verneed);
	eval 'sub Elf_Vernaux () { &Elf64_Vernaux;}' unless defined(&Elf_Vernaux);
	eval 'sub Elf_Versym () { &Elf64_Versym;}' unless defined(&Elf_Versym);
	eval 'sub ELF_R_SYM () { &ELF64_R_SYM;}' unless defined(&ELF_R_SYM);
	eval 'sub ELF_R_TYPE () { &ELF64_R_TYPE;}' unless defined(&ELF_R_TYPE);
	eval 'sub ELFCLASS () { &ELFCLASS64;}' unless defined(&ELFCLASS);
	eval 'sub AuxInfo () { &Aux64Info;}' unless defined(&AuxInfo);
    }
    unless(defined(&Elf_Symindx)) {
	eval 'sub Elf_Symindx () { &uint32_t;}' unless defined(&Elf_Symindx);
    }
    eval 'sub ELF32_ST_BIND {
        my($info) = @_;
	    eval q( &ELF_ST_BIND($info));
    }' unless defined(&ELF32_ST_BIND);
    eval 'sub ELF32_ST_TYPE {
        my($info) = @_;
	    eval q( &ELF_ST_TYPE($info));
    }' unless defined(&ELF32_ST_TYPE);
    eval 'sub ELF32_ST_INFO {
        my($bind,$type) = @_;
	    eval q( &ELF_ST_INFO($bind,$type));
    }' unless defined(&ELF32_ST_INFO);
    eval 'sub ELF32_ST_VISIBILITY {
        my($other) = @_;
	    eval q( &ELF_ST_VISIBILITY($other));
    }' unless defined(&ELF32_ST_VISIBILITY);
    eval 'sub ELF64_ST_BIND {
        my($info) = @_;
	    eval q( &ELF_ST_BIND($info));
    }' unless defined(&ELF64_ST_BIND);
    eval 'sub ELF64_ST_TYPE {
        my($info) = @_;
	    eval q( &ELF_ST_TYPE($info));
    }' unless defined(&ELF64_ST_TYPE);
    eval 'sub ELF64_ST_INFO {
        my($bind,$type) = @_;
	    eval q( &ELF_ST_INFO($bind,$type));
    }' unless defined(&ELF64_ST_INFO);
    eval 'sub ELF64_ST_VISIBILITY {
        my($other) = @_;
	    eval q( &ELF_ST_VISIBILITY($other));
    }' unless defined(&ELF64_ST_VISIBILITY);
    eval 'sub SYMINFO_FLG_DIRECT () {0x1;}' unless defined(&SYMINFO_FLG_DIRECT);
    eval 'sub SYMINFO_FLG_PASSTHRU () {0x2;}' unless defined(&SYMINFO_FLG_PASSTHRU);
    eval 'sub SYMINFO_FLG_COPY () {0x4;}' unless defined(&SYMINFO_FLG_COPY);
    eval 'sub SYMINFO_FLG_LAZYLOAD () {0x8;}' unless defined(&SYMINFO_FLG_LAZYLOAD);
    eval 'sub SYMINFO_FLG_DIRECTBIND () {0x10;}' unless defined(&SYMINFO_FLG_DIRECTBIND);
    eval 'sub SYMINFO_FLG_NOEXTDIRECT () {0x20;}' unless defined(&SYMINFO_FLG_NOEXTDIRECT);
    eval 'sub SYMINFO_FLG_FILTER () {0x2;}' unless defined(&SYMINFO_FLG_FILTER);
    eval 'sub SYMINFO_FLG_AUXILIARY () {0x40;}' unless defined(&SYMINFO_FLG_AUXILIARY);
    eval 'sub SYMINFO_BT_SELF () {0xffff;}' unless defined(&SYMINFO_BT_SELF);
    eval 'sub SYMINFO_BT_PARENT () {0xfffe;}' unless defined(&SYMINFO_BT_PARENT);
    eval 'sub SYMINFO_BT_NONE () {0xfffd;}' unless defined(&SYMINFO_BT_NONE);
    eval 'sub SYMINFO_BT_EXTERN () {0xfffc;}' unless defined(&SYMINFO_BT_EXTERN);
    eval 'sub SYMINFO_BT_LOWRESERVE () {0xff00;}' unless defined(&SYMINFO_BT_LOWRESERVE);
    eval 'sub SYMINFO_NONE () {0;}' unless defined(&SYMINFO_NONE);
    eval 'sub SYMINFO_CURRENT () {1;}' unless defined(&SYMINFO_CURRENT);
    eval 'sub SYMINFO_NUM () {2;}' unless defined(&SYMINFO_NUM);
    eval 'sub VER_DEF_NONE () {0;}' unless defined(&VER_DEF_NONE);
    eval 'sub VER_DEF_CURRENT () {1;}' unless defined(&VER_DEF_CURRENT);
    eval 'sub VER_DEF_IDX {
        my($x) = @_;
	    eval q( &VER_NDX($x));
    }' unless defined(&VER_DEF_IDX);
    eval 'sub VER_FLG_BASE () {0x1;}' unless defined(&VER_FLG_BASE);
    eval 'sub VER_FLG_WEAK () {0x2;}' unless defined(&VER_FLG_WEAK);
    eval 'sub VER_NDX_LOCAL () {0;}' unless defined(&VER_NDX_LOCAL);
    eval 'sub VER_NDX_GLOBAL () {1;}' unless defined(&VER_NDX_GLOBAL);
    eval 'sub VER_NDX_GIVEN () {2;}' unless defined(&VER_NDX_GIVEN);
    eval 'sub VER_NEED_NONE () {0;}' unless defined(&VER_NEED_NONE);
    eval 'sub VER_NEED_CURRENT () {1;}' unless defined(&VER_NEED_CURRENT);
    eval 'sub VER_NEED_HIDDEN () { &VER_NDX_HIDDEN;}' unless defined(&VER_NEED_HIDDEN);
    eval 'sub VER_NEED_IDX {
        my($x) = @_;
	    eval q( &VER_NDX($x));
    }' unless defined(&VER_NEED_IDX);
    eval 'sub VER_NDX_HIDDEN () {0x8000;}' unless defined(&VER_NDX_HIDDEN);
    eval 'sub VER_NDX {
        my($x) = @_;
	    eval q((($x) & ~ &VER_NDX_HIDDEN));
    }' unless defined(&VER_NDX);
    eval 'sub VERSYM_HIDDEN () {0x8000;}' unless defined(&VERSYM_HIDDEN);
    eval 'sub VERSYM_VERSION () {0x7fff;}' unless defined(&VERSYM_VERSION);
    eval 'sub ELF_VER_CHR () {ord(\'@\');}' unless defined(&ELF_VER_CHR);
    if(defined(&_KERNEL)) {
	eval 'sub ELF_MAXPHNUM () {128;}' unless defined(&ELF_MAXPHNUM);
	eval 'sub ELF_MAXSHNUM () {32768;}' unless defined(&ELF_MAXSHNUM);
	eval 'sub ELF_MAXNOTESIZE () {1024;}' unless defined(&ELF_MAXNOTESIZE);
	eval 'sub ELF_AUX_ENTRIES () {15;}' unless defined(&ELF_AUX_ENTRIES);
	eval 'sub ELF32_NO_ADDR () {(~( &Elf32_Addr)0);}' unless defined(&ELF32_NO_ADDR);
	eval 'sub ELF32_LINK_ADDR () {(( &Elf32_Addr)-2);}' unless defined(&ELF32_LINK_ADDR);
	eval 'sub ELF64_NO_ADDR () {(~( &Elf64_Addr)0);}' unless defined(&ELF64_NO_ADDR);
	eval 'sub ELF64_LINK_ADDR () {(( &Elf64_Addr)-2);}' unless defined(&ELF64_LINK_ADDR);
	if(defined(&ELFSIZE)  && ((defined(&ELFSIZE) ? &ELFSIZE : undef) == 64)) {
	    eval 'sub ELF_NO_ADDR () { &ELF64_NO_ADDR;}' unless defined(&ELF_NO_ADDR);
	    eval 'sub ELF_LINK_ADDR () { &ELF64_LINK_ADDR;}' unless defined(&ELF_LINK_ADDR);
	}
 elsif(defined(&ELFSIZE)  && ((defined(&ELFSIZE) ? &ELFSIZE : undef) == 32)) {
	    eval 'sub ELF_NO_ADDR () { &ELF32_NO_ADDR;}' unless defined(&ELF_NO_ADDR);
	    eval 'sub ELF_LINK_ADDR () { &ELF32_LINK_ADDR;}' unless defined(&ELF_LINK_ADDR);
	}
	unless(defined(&ELF32_EHDR_FLAGS_OK)) {
	    eval 'sub ELF32_EHDR_FLAGS_OK {
	        my($eh) = @_;
    		eval q(1);
	    }' unless defined(&ELF32_EHDR_FLAGS_OK);
	}
	unless(defined(&ELF64_EHDR_FLAGS_OK)) {
	    eval 'sub ELF64_EHDR_FLAGS_OK {
	        my($eh) = @_;
    		eval q(1);
	    }' unless defined(&ELF64_EHDR_FLAGS_OK);
	}
	if(defined(&ELFSIZE)  && ((defined(&ELFSIZE) ? &ELFSIZE : undef) == 64)) {
	    eval 'sub ELF_EHDR_FLAGS_OK {
	        my($eh) = @_;
    		eval q( &ELF64_EHDR_FLAGS_OK($eh));
	    }' unless defined(&ELF_EHDR_FLAGS_OK);
	} else {
	    eval 'sub ELF_EHDR_FLAGS_OK {
	        my($eh) = @_;
    		eval q( &ELF32_EHDR_FLAGS_OK($eh));
	    }' unless defined(&ELF_EHDR_FLAGS_OK);
	}
	if(defined(&ELFSIZE)) {
	}
	if(defined(&_KERNEL_OPT)) {
	    require './opt_execfmt.ph';
	}
	if(defined(&EXEC_ELF32)) {
	}
	if(defined(&EXEC_ELF64)) {
	}
    }
}
1;
