require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_SYS_CONF_H_)) {
    eval 'sub _SYS_CONF_H_ () {1;}' unless defined(&_SYS_CONF_H_);
    require 'sys/queue.ph';
    require 'sys/device_if.ph';
    eval 'sub D_OTHER () {0x;}' unless defined(&D_OTHER);
    eval 'sub D_TAPE () {0x1;}' unless defined(&D_TAPE);
    eval 'sub D_DISK () {0x2;}' unless defined(&D_DISK);
    eval 'sub D_TTY () {0x3;}' unless defined(&D_TTY);
    eval 'sub D_TYPEMASK () {0xff;}' unless defined(&D_TYPEMASK);
    eval 'sub D_MPSAFE () {0x100;}' unless defined(&D_MPSAFE);
    eval 'sub D_NEGOFFSAFE () {0x200;}' unless defined(&D_NEGOFFSAFE);
    eval 'sub D_MCLOSE () {0x400;}' unless defined(&D_MCLOSE);
    if(defined(&_KERNEL)) {
	require 'sys/mutex.ph';
	eval 'sub dev_type_open {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t, \'int\', \'int\', \'struct lwp\' *));
	}' unless defined(&dev_type_open);
	eval 'sub dev_type_close {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t, \'int\', \'int\', \'struct lwp\' *));
	}' unless defined(&dev_type_close);
	eval 'sub dev_type_read {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t, \'struct uio\' *, \'int\'));
	}' unless defined(&dev_type_read);
	eval 'sub dev_type_write {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t, \'struct uio\' *, \'int\'));
	}' unless defined(&dev_type_write);
	eval 'sub dev_type_ioctl {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t, \'u_long\',  &void *, \'int\', \'struct lwp\' *));
	}' unless defined(&dev_type_ioctl);
	eval 'sub dev_type_stop {
	    my($n) = @_;
    	    eval q( &void $n (\'struct tty\' *, \'int\'));
	}' unless defined(&dev_type_stop);
	eval 'sub dev_type_tty {
	    my($n) = @_;
    	    eval q(\'struct tty\' * $n ( &dev_t));
	}' unless defined(&dev_type_tty);
	eval 'sub dev_type_poll {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t, \'int\', \'struct lwp\' *));
	}' unless defined(&dev_type_poll);
	eval 'sub dev_type_mmap {
	    my($n) = @_;
    	    eval q( &paddr_t $n ( &dev_t,  &off_t, \'int\'));
	}' unless defined(&dev_type_mmap);
	eval 'sub dev_type_strategy {
	    my($n) = @_;
    	    eval q( &void $n );
	}' unless defined(&dev_type_strategy);
	eval 'sub dev_type_dump {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t,  &daddr_t,  &void *, \'size_t\'));
	}' unless defined(&dev_type_dump);
	eval 'sub dev_type_size {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t));
	}' unless defined(&dev_type_size);
	eval 'sub dev_type_kqfilter {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t, \'struct knote\' *));
	}' unless defined(&dev_type_kqfilter);
	eval 'sub dev_type_discard {
	    my($n) = @_;
    	    eval q(\'int\' $n ( &dev_t,  &off_t,  &off_t));
	}' unless defined(&dev_type_discard);
	eval 'sub noopen () {(( &dev_type_open((*))) &enodev);}' unless defined(&noopen);
	eval 'sub noclose () {(( &dev_type_close((*))) &enodev);}' unless defined(&noclose);
	eval 'sub noread () {(( &dev_type_read((*))) &enodev);}' unless defined(&noread);
	eval 'sub nowrite () {(( &dev_type_write((*))) &enodev);}' unless defined(&nowrite);
	eval 'sub noioctl () {(( &dev_type_ioctl((*))) &enodev);}' unless defined(&noioctl);
	eval 'sub nostop () {(( &dev_type_stop((*))) &enodev);}' unless defined(&nostop);
	eval 'sub notty () { &NULL;}' unless defined(&notty);
	eval 'sub nopoll () { &seltrue;}' unless defined(&nopoll);
	eval 'sub nodump () {(( &dev_type_dump((*))) &enodev);}' unless defined(&nodump);
	eval 'sub nosize () { &NULL;}' unless defined(&nosize);
	eval 'sub nokqfilter () { &seltrue_kqfilter;}' unless defined(&nokqfilter);
	eval 'sub nodiscard () {(( &dev_type_discard((*))) &enodev);}' unless defined(&nodiscard);
	eval 'sub nullopen () {(( &dev_type_open((*))) &nullop);}' unless defined(&nullopen);
	eval 'sub nullclose () {(( &dev_type_close((*))) &nullop);}' unless defined(&nullclose);
	eval 'sub nullread () {(( &dev_type_read((*))) &nullop);}' unless defined(&nullread);
	eval 'sub nullwrite () {(( &dev_type_write((*))) &nullop);}' unless defined(&nullwrite);
	eval 'sub nullioctl () {(( &dev_type_ioctl((*))) &nullop);}' unless defined(&nullioctl);
	eval 'sub nullstop () {(( &dev_type_stop((*))) &nullop);}' unless defined(&nullstop);
	eval 'sub nullpoll () {(( &dev_type_poll((*))) &nullop);}' unless defined(&nullpoll);
	eval 'sub nulldump () {(( &dev_type_dump((*))) &nullop);}' unless defined(&nulldump);
	eval 'sub nullkqfilter () {(( &dev_type_kqfilter((*))) &eopnotsupp);}' unless defined(&nullkqfilter);
	eval 'sub nulldiscard () {(( &dev_type_discard((*))) &nullop);}' unless defined(&nulldiscard);
    }
    if(defined(&_KERNEL)) {
	eval 'sub ttynodisc () {(( &int (*)( &dev_t, \'struct tty\' *)) &enodev);}' unless defined(&ttynodisc);
	eval 'sub ttyerrclose () {(( &int (*)(\'struct tty\' *, \'int\')) &enodev);}' unless defined(&ttyerrclose);
	eval 'sub ttyerrio () {(( &int (*)(\'struct tty\' *, \'struct uio\' *, \'int\')) &enodev);}' unless defined(&ttyerrio);
	eval 'sub ttyerrinput () {(( &int (*)(\'int\', \'struct tty\' *)) &enodev);}' unless defined(&ttyerrinput);
	eval 'sub ttyerrstart () {(( &int (*)) &enodev);}' unless defined(&ttyerrstart);
    }
    if(defined(&_KERNEL)) {
	eval 'sub DEV_MEM () {0;}' unless defined(&DEV_MEM);
	eval 'sub DEV_KMEM () {1;}' unless defined(&DEV_KMEM);
	eval 'sub DEV_NULL () {2;}' unless defined(&DEV_NULL);
	if(defined(&COMPAT_16)) {
	    eval 'sub _DEV_ZERO_oARM () {3;}' unless defined(&_DEV_ZERO_oARM);
	}
	eval 'sub DEV_FULL () {11;}' unless defined(&DEV_FULL);
	eval 'sub DEV_ZERO () {12;}' unless defined(&DEV_ZERO);
	eval("sub DEVNODE_DONTBOTHER () { 0; }") unless defined(&DEVNODE_DONTBOTHER);
	eval("sub DEVNODE_SINGLE () { 1; }") unless defined(&DEVNODE_SINGLE);
	eval("sub DEVNODE_VECTOR () { 2; }") unless defined(&DEVNODE_VECTOR);
	eval 'sub DEVNODE_FLAG_LINKZERO () {0x1;}' unless defined(&DEVNODE_FLAG_LINKZERO);
	eval 'sub DEVNODE_FLAG_ISMINOR0 () {0x2;}' unless defined(&DEVNODE_FLAG_ISMINOR0);
	if(defined(&notyet)) {
	    eval 'sub DEVNODE_FLAG_ISMINOR1 () {0x4;}' unless defined(&DEVNODE_FLAG_ISMINOR1);
	}
    }
    if(defined(&_KERNEL)) {
    }
}
1;
