/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.SocketListener;
import de.mud.jta.event.SocketRequest;
import java.io.IOException;

public class Timeout
extends Plugin
implements FilterPlugin,
SocketListener,
Runnable {
    private static final int debug = 0;
    protected int timeout = 0;
    protected String timeoutCommand = null;
    protected String timeoutWarning = null;
    protected Thread timeoutThread = null;
    private PluginBus pluginBus;
    FilterPlugin source;

    public Timeout(PluginBus bus, final String id) {
        super(bus, id);
        bus.registerPluginListener(this);
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig config) {
                String tos = config.getProperty("Timeout", id, "seconds");
                if (tos != null) {
                    try {
                        Timeout.this.timeout = Integer.parseInt(tos);
                    }
                    catch (Exception e) {
                        Timeout.this.error("timeout (" + Timeout.this.timeout + ") " + "is not an integer, timeout disabled");
                    }
                    Timeout.this.timeoutCommand = config.getProperty("Timeout", id, "command");
                    Timeout.this.timeoutWarning = config.getProperty("Timeout", id, "warning");
                }
            }
        });
        this.pluginBus = bus;
    }

    public void run() {
        boolean ok = false;
        while (this.timeoutThread != null) {
            try {
                ok = false;
                Thread.sleep(1000 * this.timeout);
            }
            catch (InterruptedException e) {
                ok = true;
            }
            if (ok) continue;
            this.error("data connection timeout, shutting down");
            if (this.timeoutCommand != null) {
                this.error("sending graceful exit command ...");
                try {
                    this.write(this.timeoutCommand.getBytes());
                }
                catch (IOException e) {
                    this.error("could not send exit command");
                }
                this.timeoutThread = null;
                Thread grace = new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000 * Timeout.this.timeout);
                            Timeout.this.pluginBus.broadcast(new SocketRequest());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                grace.start();
                continue;
            }
            this.bus.broadcast(new SocketRequest());
        }
    }

    public void connect(String host, int port) throws IOException {
        if (this.timeout > 0) {
            this.timeoutThread = new Thread(this);
            this.timeoutThread.start();
        }
    }

    public void disconnect() throws IOException {
        if (this.timeoutThread != null) {
            Thread tmp = this.timeoutThread;
            this.timeoutThread = null;
            tmp.interrupt();
        }
    }

    public void setFilterSource(FilterPlugin plugin) {
        this.source = plugin;
    }

    public FilterPlugin getFilterSource() {
        return this.source;
    }

    public int read(byte[] b) throws IOException {
        int n = this.source.read(b);
        if (n > 0 && this.timeoutThread != null) {
            this.timeoutThread.interrupt();
        }
        return n;
    }

    public void write(byte[] b) throws IOException {
        this.source.write(b);
        if (this.timeoutThread != null) {
            this.timeoutThread.interrupt();
        }
    }
}

