require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_M68K_PMAP_MOTOROLA_H_)) {
    eval 'sub _M68K_PMAP_MOTOROLA_H_ () {1;}' unless defined(&_M68K_PMAP_MOTOROLA_H_);
    if(defined(&_KERNEL_OPT)) {
	require './m68k/opt_m68k_arch.ph';
    }
    require 'machine/cpu.ph';
    require 'machine/pte.ph';
    eval 'sub MMU51_SRP_BITS () {( &DTE51_LOWER |  &DTE51_SG |  &DT51_SHORT);}' unless defined(&MMU51_SRP_BITS);
    eval 'sub MMU51_CRP_BITS () {( &DTE51_LOWER |  &DT51_SHORT);}' unless defined(&MMU51_CRP_BITS);
    eval 'sub TIB_SHIFT () {( &PGSHIFT - 2);}' unless defined(&TIB_SHIFT);
    eval 'sub TIB_SIZE () {(1 <<  &TIB_SHIFT);}' unless defined(&TIB_SIZE);
    eval 'sub TIA_SHIFT () {(32-  &TIB_SHIFT -  &PGSHIFT);}' unless defined(&TIA_SHIFT);
    eval 'sub TIA_SIZE () {(1 <<  &TIA_SHIFT);}' unless defined(&TIA_SIZE);
    eval 'sub MMU51_TCR_BITS () {( &TCR51_E |  &TCR51_SRE |  &__SHIFTIN( &PGSHIFT,  &TCR51_PS) |  &__SHIFTIN( &TIA_SHIFT,  &TCR51_TIA) |  &__SHIFTIN( &TIB_SHIFT,  &TCR51_TIB));}' unless defined(&MMU51_TCR_BITS);
    eval 'sub MMU40_TCR_BITS () {( &TCR40_E |  &__SHIFTIN( &PGSHIFT - 12,  &TCR40_P));}' unless defined(&MMU40_TCR_BITS);
    eval 'sub SEGSHIFT () {( &TIB_SHIFT +  &PGSHIFT);}' unless defined(&SEGSHIFT);
    eval 'sub NBSEG30 () {(1 <<  &SEGSHIFT);}' unless defined(&NBSEG30);
    eval 'sub NBSEG40 () {(1 <<  &SG4_SHIFT2);}' unless defined(&NBSEG40);
    if(( defined(&M68020) || defined(&M68030))  && (!defined(&M68040)  && !defined(&M68060))) {
	eval 'sub NBSEG () { &NBSEG30;}' unless defined(&NBSEG);
    }
 elsif(( defined(&M68040) || defined(&M68060))  && (!defined(&M68020)  && !defined(&M68030))) {
	eval 'sub NBSEG () { &NBSEG40;}' unless defined(&NBSEG);
    } else {
	eval 'sub NBSEG () {(( &mmutype ==  &MMU_68040) ?  &NBSEG40 :  &NBSEG30);}' unless defined(&NBSEG);
    }
    eval 'sub SEGOFSET () {( &NBSEG - 1);}' unless defined(&SEGOFSET);
    eval 'sub m68k_round_seg {
        my($x) = @_;
	    eval q((((( &vaddr_t)($x)) +  &SEGOFSET) & ~ &SEGOFSET));
    }' unless defined(&m68k_round_seg);
    eval 'sub m68k_trunc_seg {
        my($x) = @_;
	    eval q((( &vaddr_t)($x) & ~ &SEGOFSET));
    }' unless defined(&m68k_trunc_seg);
    eval 'sub m68k_seg_offset {
        my($x) = @_;
	    eval q((( &vaddr_t)($x) &  &SEGOFSET));
    }' unless defined(&m68k_seg_offset);
    eval 'sub MAXKL2SIZE () {32;}' unless defined(&MAXKL2SIZE);
    if((defined(&PAGE_SIZE) ? &PAGE_SIZE : undef) == 8192) {
	eval 'sub MAXUL2SIZE () {16;}' unless defined(&MAXUL2SIZE);
    } else {
	eval 'sub MAXUL2SIZE () {8;}' unless defined(&MAXUL2SIZE);
    }
    eval 'sub l2tobm {
        my($n) = @_;
	    eval q((1 << ($n)));
    }' unless defined(&l2tobm);
    eval 'sub bmtol2 {
        my($n) = @_;
	    eval q(( &ffs($n) - 1));
    }' unless defined(&bmtol2);
    eval 'sub pmap_resident_count {
        my($pmap) = @_;
	    eval q((($pmap)-> ($pm_stats->{resident_count})));
    }' unless defined(&pmap_resident_count);
    eval 'sub pmap_wired_count {
        my($pmap) = @_;
	    eval q((($pmap)-> ($pm_stats->{wired_count})));
    }' unless defined(&pmap_wired_count);
    eval 'sub pmap_update {
        my($pmap) = @_;
	    eval q( &__nothing);
    }' unless defined(&pmap_update);
    eval 'sub pmap_remove_all {
        my($pmap) = @_;
	    eval q({  &false; });
    }' unless defined(&pmap_remove_all);
    eval 'sub SYSMAP_VA () { &VM_MAX_KERNEL_ADDRESS;}' unless defined(&SYSMAP_VA);
    if(defined(&M68040) || defined(&M68060)) {
    }
    if(defined(&CACHE_HAVE_VAC)) {
    }
    eval 'sub PMAP_NEED_PROCWR () {1;}' unless defined(&PMAP_NEED_PROCWR);
    if(defined(&CACHE_HAVE_VAC)) {
	eval 'sub PMAP_PREFER {
	    my($foff, $vap, $sz, $td) = @_;
    	    eval q( &pmap_prefer(($foff), ($vap)));
	}' unless defined(&PMAP_PREFER);
    }
}
1;
