require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UFS_LFS_LFS_ACCESSORS_H_)) {
    eval 'sub _UFS_LFS_LFS_ACCESSORS_H_ () {1;}' unless defined(&_UFS_LFS_LFS_ACCESSORS_H_);
    if(defined(&_KERNEL_OPT)) {
	require './ufs/lfs/opt_lfs.ph';
    }
    require 'sys/bswap.ph';
    require 'ufs/lfs/lfs.ph';
    if(!defined(&_KERNEL)  && !defined(&_STANDALONE)) {
	require 'assert.ph';
	require 'string.ph';
	eval 'sub KASSERT () { &assert;}' unless defined(&KASSERT);
    } else {
	require 'sys/systm.ph';
    }
    unless(defined(&STRUCT_LFS)) {
	eval 'sub STRUCT_LFS () {\'struct lfs\';}' unless defined(&STRUCT_LFS);
    }
    if(defined(&_STANDALONE) || (defined(&_KERNEL)  && !defined(&LFS_EI))) {
	eval 'sub LFS_SWAP_int16_t {
	    my($fs, $val) = @_;
    	    eval q(($val));
	}' unless defined(&LFS_SWAP_int16_t);
	eval 'sub LFS_SWAP_int32_t {
	    my($fs, $val) = @_;
    	    eval q(($val));
	}' unless defined(&LFS_SWAP_int32_t);
	eval 'sub LFS_SWAP_int64_t {
	    my($fs, $val) = @_;
    	    eval q(($val));
	}' unless defined(&LFS_SWAP_int64_t);
	eval 'sub LFS_SWAP_uint16_t {
	    my($fs, $val) = @_;
    	    eval q(($val));
	}' unless defined(&LFS_SWAP_uint16_t);
	eval 'sub LFS_SWAP_uint32_t {
	    my($fs, $val) = @_;
    	    eval q(($val));
	}' unless defined(&LFS_SWAP_uint32_t);
	eval 'sub LFS_SWAP_uint64_t {
	    my($fs, $val) = @_;
    	    eval q(($val));
	}' unless defined(&LFS_SWAP_uint64_t);
    } else {
	eval 'sub LFS_SWAP_int16_t {
	    my($fs, $val) = @_;
    	    eval q((($fs)-> &lfs_dobyteswap ? ( &int16_t) &bswap16($val) : ($val)));
	}' unless defined(&LFS_SWAP_int16_t);
	eval 'sub LFS_SWAP_int32_t {
	    my($fs, $val) = @_;
    	    eval q((($fs)-> &lfs_dobyteswap ? ( &int32_t) &bswap32($val) : ($val)));
	}' unless defined(&LFS_SWAP_int32_t);
	eval 'sub LFS_SWAP_int64_t {
	    my($fs, $val) = @_;
    	    eval q((($fs)-> &lfs_dobyteswap ? ( &int64_t) &bswap64($val) : ($val)));
	}' unless defined(&LFS_SWAP_int64_t);
	eval 'sub LFS_SWAP_uint16_t {
	    my($fs, $val) = @_;
    	    eval q((($fs)-> &lfs_dobyteswap ?  &bswap16($val) : ($val)));
	}' unless defined(&LFS_SWAP_uint16_t);
	eval 'sub LFS_SWAP_uint32_t {
	    my($fs, $val) = @_;
    	    eval q((($fs)-> &lfs_dobyteswap ?  &bswap32($val) : ($val)));
	}' unless defined(&LFS_SWAP_uint32_t);
	eval 'sub LFS_SWAP_uint64_t {
	    my($fs, $val) = @_;
    	    eval q((($fs)-> &lfs_dobyteswap ?  &bswap64($val) : ($val)));
	}' unless defined(&LFS_SWAP_uint64_t);
    }
    if((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef)) {
	eval 'sub LFS_LITTLE_ENDIAN_ONDISK {
	    my($fs) = @_;
    	    eval q((!($fs)-> &lfs_dobyteswap));
	}' unless defined(&LFS_LITTLE_ENDIAN_ONDISK);
    } else {
	eval 'sub LFS_LITTLE_ENDIAN_ONDISK {
	    my($fs) = @_;
    	    eval q((($fs)-> &lfs_dobyteswap));
	}' unless defined(&LFS_LITTLE_ENDIAN_ONDISK);
    }
    if(defined(&__GNUC__)) {
	if(defined(&__clang__)) {
	}
 elsif( &__GNUC_PREREQ__(9,0)) {
	}
    }
    eval 'sub LFS_DIRHEADERSIZE {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ? $sizeof{\'struct lfs_dirheader64\'} : $sizeof{\'struct lfs_dirheader32\'}));
    }' unless defined(&LFS_DIRHEADERSIZE);
    eval 'sub LFS_DIRECTSIZ {
        my($fs, $namlen) = @_;
	    eval q(( &LFS_DIRHEADERSIZE($fs) + ((($namlen)+1+ 3) &~ 3)));
    }' unless defined(&LFS_DIRECTSIZ);
    eval 'sub LFS_MAXDIRENTRYSIZE () {($sizeof{\'struct lfs_dirheader64\'} + ((( &LFS_MAXNAMLEN+1)+1+ 3) & ~3));}' unless defined(&LFS_MAXDIRENTRYSIZE);
    if(((defined(&BYTE_ORDER) ? &BYTE_ORDER : undef) == (defined(&LITTLE_ENDIAN) ? &LITTLE_ENDIAN : undef))) {
	eval 'sub LFS_OLDDIRSIZ {
	    my($oldfmt, $dp, $needswap) = @_;
    	    eval q(((($oldfmt)  && !($needswap)) ?  &LFS_DIRECTSIZ(($dp)-> &d_type) :  &LFS_DIRECTSIZ(($dp)-> &d_namlen)));
	}' unless defined(&LFS_OLDDIRSIZ);
    } else {
	eval 'sub LFS_OLDDIRSIZ {
	    my($oldfmt, $dp, $needswap) = @_;
    	    eval q(((($oldfmt)  && ($needswap)) ?  &LFS_DIRECTSIZ(($dp)-> &d_type) :  &LFS_DIRECTSIZ(($dp)-> &d_namlen)));
	}' unless defined(&LFS_OLDDIRSIZ);
    }
    eval 'sub LFS_DIRSIZ {
        my($fs, $dp) = @_;
	    eval q( &LFS_DIRECTSIZ($fs,  &lfs_dir_getnamlen($fs, $dp)));
    }' unless defined(&LFS_DIRSIZ);
    eval 'sub LFS_OLDDIRFMT () {1;}' unless defined(&LFS_OLDDIRFMT);
    eval 'sub LFS_NEWDIRFMT () {0;}' unless defined(&LFS_NEWDIRFMT);
    eval 'sub LFS_NEXTDIR {
        my($fs, $dp) = @_;
	    eval q((( &LFS_DIRHEADER *)(($dp) +  &lfs_dir_getreclen($fs, $dp))));
    }' unless defined(&LFS_NEXTDIR);
    eval 'sub lfs_dir_nameptr {
        my($fs,$dh) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) { ( ($dh->{u_64}) + 1); }  &else { ( ($dh->{u_32}) + 1); } });
    }' unless defined(&lfs_dir_nameptr);
    eval 'sub lfs_dir_getino {
        my($fs,$dh) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  &LFS_SWAP_uint64_t($fs,  ($dh->{u_64}->{dh_ino})); }  &else {  &LFS_SWAP_uint32_t($fs,  ($dh->{u_32}->{dh_ino})); } });
    }' unless defined(&lfs_dir_getino);
    eval 'sub lfs_dir_getreclen {
        my($fs,$dh) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  &LFS_SWAP_uint16_t($fs,  ($dh->{u_64}->{dh_reclen})); }  &else {  &LFS_SWAP_uint16_t($fs,  ($dh->{u_32}->{dh_reclen})); } });
    }' unless defined(&lfs_dir_getreclen);
    eval 'sub lfs_dir_gettype {
        my($fs,$dh) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  &KASSERT( ($fs->{l$fs_hasolddirfmt}) == 0);  ($dh->{u_64}->{dh_type}); }  &else  &if ( ($fs->{l$fs_hasolddirfmt})) {  &LFS_DT_UNKNOWN; }  &else {  ($dh->{u_32}->{dh_type}); } });
    }' unless defined(&lfs_dir_gettype);
    eval 'sub lfs_dir_getnamlen {
        my($fs,$dh) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  &KASSERT( ($fs->{l$fs_hasolddirfmt}) == 0);  ($dh->{u_64}->{dh_namlen}); }  &else  &if ( ($fs->{l$fs_hasolddirfmt})  &&  &LFS_LITTLE_ENDIAN_ONDISK($fs)) {  ($dh->{u_32}->{dh_type}); }  &else {  ($dh->{u_32}->{dh_namlen}); } });
    }' unless defined(&lfs_dir_getnamlen);
    eval 'sub lfs_dir_setino {
        my($fs,$dh,$ino) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($dh->{u_64}->{dh_ino}) =  &LFS_SWAP_uint64_t($fs, $ino); }  &else {  ($dh->{u_32}->{dh_ino}) =  &LFS_SWAP_uint32_t($fs, $ino); } });
    }' unless defined(&lfs_dir_setino);
    eval 'sub lfs_dir_setreclen {
        my($fs,$dh,$reclen) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($dh->{u_64}->{dh_reclen}) =  &LFS_SWAP_uint16_t($fs, $reclen); }  &else {  ($dh->{u_32}->{dh_reclen}) =  &LFS_SWAP_uint16_t($fs, $reclen); } });
    }' unless defined(&lfs_dir_setreclen);
    eval 'sub lfs_dir_settype {
        my($fs,$dh,$type) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  &KASSERT( ($fs->{l$fs_hasolddirfmt}) == 0);  ($dh->{u_64}->{dh_type}) = $type; }  &else  &if ( ($fs->{l$fs_hasolddirfmt})) { ; }  &else {  ($dh->{u_32}->{dh_type}) = $type; } });
    }' unless defined(&lfs_dir_settype);
    eval 'sub lfs_dir_setnamlen {
        my($fs,$dh,$namlen) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  &KASSERT( ($fs->{l$fs_hasolddirfmt}) == 0);  ($dh->{u_64}->{dh_namlen}) = $namlen; }  &else  &if ( ($fs->{l$fs_hasolddirfmt})  &&  &LFS_LITTLE_ENDIAN_ONDISK($fs)) {  ($dh->{u_32}->{dh_type}) = $namlen; }  &else {  ($dh->{u_32}->{dh_namlen}) = $namlen; } });
    }' unless defined(&lfs_dir_setnamlen);
    eval 'sub lfs_copydirname {
        my($fs,$dest,$src,$namlen,$reclen) = @_;
	    eval q({ my $spacelen;  &KASSERT($reclen >  &LFS_DIRHEADERSIZE($fs));  $spacelen = $reclen -  &LFS_DIRHEADERSIZE($fs);  &KASSERT( $spacelen > $namlen);  &memcpy($dest, $src, $namlen);  &memset($dest + $namlen, ord(\'\\\\0\'),  $spacelen - $namlen); });
    }' unless defined(&lfs_copydirname);
    eval 'sub lfs_dirtemplate_dotdot {
        my($fs,$dt) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) { ( &LFS_DIRHEADER *) ($dt->{u_64}->{dotdot_header}); }  &else { ( &LFS_DIRHEADER *) ($dt->{u_32}->{dotdot_header}); } });
    }' unless defined(&lfs_dirtemplate_dotdot);
    eval 'sub lfs_dirtemplate_dotdotname {
        my($fs,$dt) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($dt->{u_64}->{dotdot_name}); }  &else {  ($dt->{u_32}->{dotdot_name}); } });
    }' unless defined(&lfs_dirtemplate_dotdotname);
    eval 'sub LFS32_MAXSYMLINKLEN () {(( &ULFS_NDADDR +  &ULFS_NIADDR) * $sizeof{ &int32_t});}' unless defined(&LFS32_MAXSYMLINKLEN);
    eval 'sub LFS64_MAXSYMLINKLEN () {(( &ULFS_NDADDR +  &ULFS_NIADDR) * $sizeof{ &int64_t});}' unless defined(&LFS64_MAXSYMLINKLEN);
    eval 'sub LFS_MAXSYMLINKLEN {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ?  &LFS64_MAXSYMLINKLEN :  &LFS32_MAXSYMLINKLEN));
    }' unless defined(&LFS_MAXSYMLINKLEN);
    eval 'sub DINOSIZE {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ? $sizeof{\'struct lfs64_dinode\'} : $sizeof{\'struct lfs32_dinode\'}));
    }' unless defined(&DINOSIZE);
    eval 'sub DINO_IN_BLOCK {
        my($fs, $base, $ix) = @_;
	    eval q(((($base) +  &DINOSIZE($fs) * ($ix))));
    }' unless defined(&DINO_IN_BLOCK);
    eval 'sub lfs_copy_dinode {
        my($fs,$dst,$src) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($dst->{u_64}) =  ($src->{u_64}); }  &else {  ($dst->{u_32}) =  ($src->{u_32}); } });
    }' unless defined(&lfs_copy_dinode);
    eval 'sub LFS_DEF_DINO_ACCESSOR {
        my($type, $type32, $field) = @_;
	    eval q( &static  &__inline $type  &lfs_dino_get$field( &STRUCT_LFS * &fs, \'union lfs_dinode\' * &dip) {  &if ( ($fs->{lfs_is64})) {  &return  &LFS_SWAP_$type( &fs,  ($dip->{u_64}->{di_})$field); }  &else {  &return  &LFS_SWAP_$type32( &fs,  ($dip->{u_32}->{di_})$field); } }  &static  &__inline  &void  &lfs_dino_set$field( &STRUCT_LFS * &fs, \'union lfs_dinode\' * &dip, $type  &val) {  &if ( ($fs->{lfs_is64})) { $type * &p =  ($dip->{u_64}->{di_})$field; ( &void) &p;  ($dip->{u_64}->{di_})$field =  &LFS_SWAP_$type( &fs,  &val); }  &else { $type32 * &p =  ($dip->{u_32}->{di_})$field; ( &void) &p;  ($dip->{u_32}->{di_})$field =  &LFS_SWAP_$type32( &fs,  &val); } });
    }' unless defined(&LFS_DEF_DINO_ACCESSOR);
    eval 'sub lfs_dino_getdb {
        my($fs,$dip,$ix) = @_;
	    eval q({  &KASSERT($ix <  &ULFS_NDADDR);  &if ( ($fs->{l$fs_is64})) {  &LFS_SWAP_int64_t($fs,  ($dip->{u_64}->{di_db[$ix]})); }  &else { ( &int32_t) &LFS_SWAP_int32_t($fs,  ($dip->{u_32}->{di_db[$ix]})); } });
    }' unless defined(&lfs_dino_getdb);
    eval 'sub lfs_dino_getib {
        my($fs,$dip,$ix) = @_;
	    eval q({  &KASSERT($ix <  &ULFS_NIADDR);  &if ( ($fs->{l$fs_is64})) {  &LFS_SWAP_int64_t($fs,  ($dip->{u_64}->{di_ib[$ix]})); }  &else { ( &int32_t) &LFS_SWAP_int32_t($fs,  ($dip->{u_32}->{di_ib[$ix]})); } });
    }' unless defined(&lfs_dino_getib);
    eval 'sub lfs_dino_setdb {
        my($fs,$dip,$ix,$val) = @_;
	    eval q({  &KASSERT($ix <  &ULFS_NDADDR);  &if ( ($fs->{l$fs_is64})) {  ($dip->{u_64}->{di_db[$ix]}) =  &LFS_SWAP_int64_t($fs, $val); }  &else {  ($dip->{u_32}->{di_db[$ix]}) =  &LFS_SWAP_uint32_t($fs, $val); } });
    }' unless defined(&lfs_dino_setdb);
    eval 'sub lfs_dino_setib {
        my($fs,$dip,$ix,$val) = @_;
	    eval q({  &KASSERT($ix <  &ULFS_NIADDR);  &if ( ($fs->{l$fs_is64})) {  ($dip->{u_64}->{di_ib[$ix]}) =  &LFS_SWAP_int64_t($fs, $val); }  &else {  ($dip->{u_32}->{di_ib[$ix]}) =  &LFS_SWAP_uint32_t($fs, $val); } });
    }' unless defined(&lfs_dino_setib);
    eval 'sub lfs_iblock_set {
        my($fs,$block,$ix,$val) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) { (( &int64_t *)$block)[$ix] = $val; }  &else { (( &int32_t *)$block)[$ix] = $val; } });
    }' unless defined(&lfs_iblock_set);
    eval 'sub LFS_LOCK_BUF {
        my($bp) = @_;
	    eval q( &do {  &if ((($bp)-> &b_flags &  &B_LOCKED) == 0 &&  ($bp->{b_iodone}) ==  &NULL) {  &mutex_enter( &lfs_lock); ++ &locked_queue_count;  &locked_queue_bytes +=  ($bp->{b_bufsize});  &mutex_exit( &lfs_lock); } ($bp)-> &b_flags |=  &B_LOCKED; }  &while (0));
    }' unless defined(&LFS_LOCK_BUF);
    eval 'sub LFS_UNLOCK_BUF {
        my($bp) = @_;
	    eval q( &do {  &if ((($bp)-> &b_flags &  &B_LOCKED) != 0 &&  ($bp->{b_iodone}) ==  &NULL) {  &mutex_enter( &lfs_lock); -- &locked_queue_count;  &locked_queue_bytes -=  ($bp->{b_bufsize});  &if ( &locked_queue_count <  &LFS_WAIT_BUFS  &&  &locked_queue_bytes <  &LFS_WAIT_BYTES)  &cv_broadcast( &locked_queue_cv);  &mutex_exit( &lfs_lock); } ($bp)-> &b_flags &= ~ &B_LOCKED; }  &while (0));
    }' unless defined(&LFS_UNLOCK_BUF);
    eval 'sub LFS_SET_UINO {
        my($ip, $states) = @_;
	    eval q( &do {  &if ((($states) &  &IN_ACCESSED)  && !(($ip)-> &i_state &  &IN_ACCESSED))  &lfs_sb_adduinodes(($ip)-> &i_lfs, 1);  &if ((($states) &  &IN_CLEANING)  && !(($ip)-> &i_state &  &IN_CLEANING))  &lfs_sb_adduinodes(($ip)-> &i_lfs, 1);  &if ((($states) &  &IN_MODIFIED)  && !(($ip)-> &i_state &  &IN_MODIFIED))  &lfs_sb_adduinodes(($ip)-> &i_lfs, 1); ($ip)-> &i_state |= ($states); }  &while (0));
    }' unless defined(&LFS_SET_UINO);
    eval 'sub LFS_CLR_UINO {
        my($ip, $states) = @_;
	    eval q( &do {  &if ((($states) &  &IN_ACCESSED)  && (($ip)-> &i_state &  &IN_ACCESSED))  &lfs_sb_subuinodes(($ip)-> &i_lfs, 1);  &if ((($states) &  &IN_CLEANING)  && (($ip)-> &i_state &  &IN_CLEANING))  &lfs_sb_subuinodes(($ip)-> &i_lfs, 1);  &if ((($states) &  &IN_MODIFIED)  && (($ip)-> &i_state &  &IN_MODIFIED))  &lfs_sb_subuinodes(($ip)-> &i_lfs, 1); ($ip)-> &i_state &= ~($states);  &if ( &lfs_sb_getuinodes(($ip)-> &i_lfs) < 0) {  &panic(\\"lfs_uinodes < 0\\"); } }  &while (0));
    }' unless defined(&LFS_CLR_UINO);
    eval 'sub LFS_ITIMES {
        my($ip, $acc, $mod, $cre) = @_;
	    eval q( &while (($ip)-> &i_state & ( &IN_ACCESS |  &IN_CHANGE |  &IN_UPDATE |  &IN_MODIFY))  &lfs_itimes($ip, $acc, $mod, $cre));
    }' unless defined(&LFS_ITIMES);
    eval 'sub SEGUPB {
        my($fs) = @_;
	    eval q(( &lfs_sb_getsepb($fs)));
    }' unless defined(&SEGUPB);
    eval 'sub SEGTABSIZE_SU {
        my($fs) = @_;
	    eval q((( &lfs_sb_getnseg($fs) +  &SEGUPB($fs) - 1) /  &lfs_sb_getsepb($fs)));
    }' unless defined(&SEGTABSIZE_SU);
    if(defined(&_KERNEL)) {
	eval 'sub SHARE_IFLOCK {
	    my($F) = @_;
    	    eval q( &do {  &rw_enter(($F)-> &lfs_iflock,  &RW_READER); }  &while(0));
	}' unless defined(&SHARE_IFLOCK);
	eval 'sub UNSHARE_IFLOCK {
	    my($F) = @_;
    	    eval q( &do {  &rw_exit(($F)-> &lfs_iflock); }  &while(0));
	}' unless defined(&UNSHARE_IFLOCK);
    } else {
	eval 'sub SHARE_IFLOCK {
	    my($F) = @_;
    	    eval q();
	}' unless defined(&SHARE_IFLOCK);
	eval 'sub UNSHARE_IFLOCK {
	    my($F) = @_;
    	    eval q();
	}' unless defined(&UNSHARE_IFLOCK);
    }
    eval 'sub LFS_SEGENTRY {
        my($SP, $F, $IN, $BP) = @_;
	    eval q( &do { \'int\'  &_e;  &SHARE_IFLOCK;  &VTOI(-> &lfs_ivnode)-> &i_state |=  &IN_ACCESS;  &if (( &_e =  &bread(-> &lfs_ivnode, ( /  &lfs_sb_getsepb) +  &lfs_sb_getcleansz,  &lfs_sb_getbsize, 0, )) != 0)  &panic(\\"lfs: ifile read: segentry %llu: error %d\\\\n\\", ($IN),  &_e);  &if ( &lfs_sb_getversion($F) == 1) ($SP) = ( &SEGUSE *)(( &SEGUSE_V1 *)($BP)-> &b_data + (($IN) & ( &lfs_sb_getsepb($F) - 1)));  &else ($SP) = ( &SEGUSE *)($BP)-> &b_data + (($IN) %  &lfs_sb_getsepb($F));  &UNSHARE_IFLOCK($F); }  &while (0));
    }' unless defined(&LFS_SEGENTRY);
    eval 'sub LFS_WRITESEGENTRY {
        my($SP, $F, $IN, $BP) = @_;
	    eval q( &do {  &if (($SP)-> &su_nbytes == 0) ($SP)-> &su_flags |=  &SEGUSE_EMPTY;  &else ($SP)-> &su_flags &= ~ &SEGUSE_EMPTY; ($F)-> $lfs_suflags[($F)-> &lfs_activesb][($IN)] = ($SP)-> &su_flags;  &LFS_BWRITE_LOG($BP); }  &while (0));
    }' unless defined(&LFS_WRITESEGENTRY);
    eval 'sub LFS_BLKPTRSIZE {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ? $sizeof{ &int64_t} : $sizeof{ &int32_t}));
    }' unless defined(&LFS_BLKPTRSIZE);
    eval 'sub LFS_INUMSIZE {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ? $sizeof{ &int64_t} : $sizeof{ &int32_t}));
    }' unless defined(&LFS_INUMSIZE);
    eval 'sub FINFOSIZE {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ? $sizeof{ &FINFO64} : $sizeof{ &FINFO32}));
    }' unless defined(&FINFOSIZE);
    eval 'sub FINFO_FULLSIZE {
        my($fs, $fip) = @_;
	    eval q(( &FINFOSIZE($fs) +  &lfs_fi_getnblocks($fs, $fip) *  &LFS_BLKPTRSIZE($fs)));
    }' unless defined(&FINFO_FULLSIZE);
    eval 'sub NEXT_FINFO {
        my($fs, $fip) = @_;
	    eval q((( &FINFO *)(($fip) +  &FINFO_FULLSIZE($fs, $fip))));
    }' unless defined(&NEXT_FINFO);
    eval 'sub LFS_DEF_FI_ACCESSOR {
        my($type, $type32, $field) = @_;
	    eval q( &static  &__inline $type  &lfs_fi_get$field( &STRUCT_LFS * &fs,  &FINFO * &fip) {  &if ( ($fs->{lfs_is64})) {  &return  ($fip->{u_64}->{fi_})$field; }  &else {  &return  ($fip->{u_32}->{fi_})$field; } }  &static  &__inline  &void  &lfs_fi_set$field( &STRUCT_LFS * &fs,  &FINFO * &fip, $type  &val) {  &if ( ($fs->{lfs_is64})) { $type * &p =  ($fip->{u_64}->{fi_})$field; ( &void) &p;  ($fip->{u_64}->{fi_})$field =  &val; }  &else { $type32 * &p =  ($fip->{u_32}->{fi_})$field; ( &void) &p;  ($fip->{u_32}->{fi_})$field =  &val; } });
    }' unless defined(&LFS_DEF_FI_ACCESSOR);
    eval 'sub lfs_fi_getblock {
        my($fs,$fip,$idx) = @_;
	    eval q({  &void * &firstblock;  &firstblock = $fip +  &FINFOSIZE($fs);  &KASSERT($idx <  &lfs_fi_getnblocks($fs, $fip));  &if ( ($fs->{l$fs_is64})) { (( &int64_t *) &firstblock)[$idx]; }  &else { (( &int32_t *) &firstblock)[$idx]; } });
    }' unless defined(&lfs_fi_getblock);
    eval 'sub lfs_fi_setblock {
        my($fs,$fip,$idx,$blk) = @_;
	    eval q({  &void * &firstblock;  &firstblock = $fip +  &FINFOSIZE($fs);  &KASSERT($idx <  &lfs_fi_getnblocks($fs, $fip));  &if ( ($fs->{l$fs_is64})) { (( &int64_t *) &firstblock)[$idx] = $blk; }  &else { (( &int32_t *) &firstblock)[$idx] = $blk; } });
    }' unless defined(&lfs_fi_setblock);
    eval 'sub IINFOSIZE {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ? $sizeof{ &IINFO64} : $sizeof{ &IINFO32}));
    }' unless defined(&IINFOSIZE);
    eval 'sub SEGSUM_IINFOSTART {
        my($fs, $buf) = @_;
	    eval q((( &IINFO *)($buf +  &lfs_sb_getsumsize($fs) -  &IINFOSIZE($fs))));
    }' unless defined(&SEGSUM_IINFOSTART);
    eval 'sub NEXTLOWER_IINFO {
        my($fs, $iip) = @_;
	    eval q((( &IINFO *)(($iip) -  &IINFOSIZE($fs))));
    }' unless defined(&NEXTLOWER_IINFO);
    eval 'sub NTH_IINFO {
        my($fs, $buf, $n) = @_;
	    eval q((( &IINFO *)( &SEGSUM_IINFOSTART($fs, $buf) - ($n)* &IINFOSIZE($fs))));
    }' unless defined(&NTH_IINFO);
    eval 'sub lfs_ii_getblock {
        my($fs,$iip) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($iip->{u_64}->{ii_block}); }  &else {  ($iip->{u_32}->{ii_block}); } });
    }' unless defined(&lfs_ii_getblock);
    eval 'sub lfs_ii_setblock {
        my($fs,$iip,$block) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($iip->{u_64}->{ii_block}) = $block; }  &else {  ($iip->{u_32}->{ii_block}) = $block; } });
    }' unless defined(&lfs_ii_setblock);
    eval 'sub IFILE_ENTRYSIZE {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ? $sizeof{ &IFILE64} : $sizeof{ &IFILE32}));
    }' unless defined(&IFILE_ENTRYSIZE);
    eval 'sub LFS_IENTRY {
        my($IP, $F, $IN, $BP) = @_;
	    eval q( &do { \'int\'  &_e;  &SHARE_IFLOCK;  &VTOI(-> &lfs_ivnode)-> &i_state |=  &IN_ACCESS;  &if (( &_e =  &bread(-> &lfs_ivnode, /  &lfs_sb_getifpb +  &lfs_sb_getcleansz +  &lfs_sb_getsegtabsz,  &lfs_sb_getbsize, 0, )) != 0)  &panic(\\"lfs: ifile ino %d read %d\\", ($IN),  &_e);  &if (($F)-> &lfs_is64) { ($IP) = ( &IFILE *)(( &IFILE64 *)($BP)-> &b_data + ($IN) %  &lfs_sb_getifpb($F)); }  &else  &if ( &lfs_sb_getversion($F) > 1) { ($IP) = ( &IFILE *)(( &IFILE32 *)($BP)-> &b_data + ($IN) %  &lfs_sb_getifpb($F)); }  &else { ($IP) = ( &IFILE *)(( &IFILE_V1 *)($BP)-> &b_data + ($IN) %  &lfs_sb_getifpb($F)); }  &UNSHARE_IFLOCK($F); }  &while (0));
    }' unless defined(&LFS_IENTRY);
    eval 'sub LFS_IENTRY_NEXT {
        my($IP, $F) = @_;
	    eval q( &do {  &if (($F)-> &lfs_is64) { ($IP) = ( &IFILE *)(( &IFILE64 *)($IP) + 1); }  &else  &if ( &lfs_sb_getversion($F) > 1) { ($IP) = ( &IFILE *)(( &IFILE32 *)($IP) + 1); }  &else { ($IP) = ( &IFILE *)(( &IFILE_V1 *)($IP) + 1); } }  &while (0));
    }' unless defined(&LFS_IENTRY_NEXT);
    eval 'sub LFS_DEF_IF_ACCESSOR {
        my($type, $type32, $field) = @_;
	    eval q( &static  &__inline $type  &lfs_if_get$field( &STRUCT_LFS * &fs,  &IFILE * &ifp) {  &if ( ($fs->{lfs_is64})) {  &return  ($ifp->{u_64}->{if_})$field; }  &else {  &return  ($ifp->{u_32}->{if_})$field; } }  &static  &__inline  &void  &lfs_if_set$field( &STRUCT_LFS * &fs,  &IFILE * &ifp, $type  &val) {  &if ( ($fs->{lfs_is64})) { $type * &p =  ($ifp->{u_64}->{if_})$field; ( &void) &p;  ($ifp->{u_64}->{if_})$field =  &val; }  &else { $type32 * &p =  ($ifp->{u_32}->{if_})$field; ( &void) &p;  ($ifp->{u_32}->{if_})$field =  &val; } });
    }' unless defined(&LFS_DEF_IF_ACCESSOR);
    eval 'sub CLEANSIZE_SU {
        my($fs) = @_;
	    eval q((((($fs)-> &lfs_is64 ? $sizeof{ &CLEANERINFO64} : $sizeof{ &CLEANERINFO32}) +  &lfs_sb_getbsize($fs) - 1) >>  &lfs_sb_getbshift($fs)));
    }' unless defined(&CLEANSIZE_SU);
    eval 'sub LFS_DEF_CI_ACCESSOR {
        my($type, $type32, $field) = @_;
	    eval q( &static  &__inline $type  &lfs_ci_get$field( &STRUCT_LFS * &fs,  &CLEANERINFO * &cip) {  &if ( ($fs->{lfs_is64})) {  &return  ($cip->{u_64}->{field}); }  &else {  &return  ($cip->{u_32}->{field}); } }  &static  &__inline  &void  &lfs_ci_set$field( &STRUCT_LFS * &fs,  &CLEANERINFO * &cip, $type  &val) {  &if ( ($fs->{lfs_is64})) { $type * &p =  ($cip->{u_64}->{field}); ( &void) &p;  ($cip->{u_64}->{field}) =  &val; }  &else { $type32 * &p =  ($cip->{u_32}->{field}); ( &void) &p;  ($cip->{u_32}->{field}) =  &val; } });
    }' unless defined(&LFS_DEF_CI_ACCESSOR);
    eval 'sub lfs_ci_shiftcleantodirty {
        my($fs,$cip,$num) = @_;
	    eval q({  &lfs_ci_setclean($fs, $cip,  &lfs_ci_getclean($fs, $cip) - $num);  &lfs_ci_setdirty($fs, $cip,  &lfs_ci_getdirty($fs, $cip) + $num); });
    }' unless defined(&lfs_ci_shiftcleantodirty);
    eval 'sub lfs_ci_shiftdirtytoclean {
        my($fs,$cip,$num) = @_;
	    eval q({  &lfs_ci_setdirty($fs, $cip,  &lfs_ci_getdirty($fs, $cip) - $num);  &lfs_ci_setclean($fs, $cip,  &lfs_ci_getclean($fs, $cip) + $num); });
    }' unless defined(&lfs_ci_shiftdirtytoclean);
    eval 'sub LFS_CLEANERINFO {
        my($CP, $F, $BP) = @_;
	    eval q( &do { \'int\'  &_e;  &SHARE_IFLOCK($F);  &VTOI(($F)-> &lfs_ivnode)-> &i_state |=  &IN_ACCESS;  &_e =  &bread(($F)-> &lfs_ivnode, ( &daddr_t)0,  &lfs_sb_getbsize($F), 0, ($BP));  &if ( &_e)  &panic(\\"lfs: ifile read: cleanerinfo: error %d\\\\n\\",  &_e); ($CP) = ( &CLEANERINFO *)($BP)-> &b_data;  &UNSHARE_IFLOCK($F); }  &while (0));
    }' unless defined(&LFS_CLEANERINFO);
    eval 'sub LFS_SYNC_CLEANERINFO {
        my($cip, $fs, $bp, $w) = @_;
	    eval q( &do {  &mutex_enter( &lfs_lock);  &if (($w) ||  &lfs_ci_getbfree($fs, $cip) !=  &lfs_sb_getbfree($fs) ||  &lfs_ci_getavail($fs, $cip) !=  &lfs_sb_getavail($fs) -  ($fs->{l$fs_ravail}) -  ($fs->{l$fs_favail})) {  &lfs_ci_setbfree($fs, $cip,  &lfs_sb_getbfree($fs));  &lfs_ci_setavail($fs, $cip,  &lfs_sb_getavail($fs) -  ($fs->{l$fs_ravail}) -  ($fs->{l$fs_favail}));  &if ((($bp)-> &b_flags &  &B_GATHERED) == 0) {  ($fs->{l$fs_flags}) |=  &LFS_IFDIRTY; }  &mutex_exit( &lfs_lock); ( &void)  &LFS_BWRITE_LOG($bp); }  &else {  &mutex_exit( &lfs_lock);  &brelse($bp, 0); } }  &while (0));
    }' unless defined(&LFS_SYNC_CLEANERINFO);
    eval 'sub LFS_GET_HEADFREE {
        my($FS, $CIP, $BP, $FREEP) = @_;
	    eval q( &do {  &if ( &lfs_sb_getversion($FS) > 1) {  &LFS_CLEANERINFO(($CIP), ($FS), ($BP));  &lfs_sb_setfreehd($FS,  &lfs_ci_getfree_head($FS, $CIP));  &brelse($BP, 0); } *($FREEP) =  &lfs_sb_getfreehd($FS); }  &while (0));
    }' unless defined(&LFS_GET_HEADFREE);
    eval 'sub LFS_PUT_HEADFREE {
        my($FS, $CIP, $BP, $VAL) = @_;
	    eval q( &do {  &lfs_sb_setfreehd($FS, $VAL);  &if ( &lfs_sb_getversion($FS) > 1) {  &LFS_CLEANERINFO(($CIP), ($FS), ($BP));  &lfs_ci_setfree_head($FS, $CIP, $VAL);  &LFS_BWRITE_LOG($BP);  &mutex_enter( &lfs_lock); ($FS)-> &lfs_flags |=  &LFS_IFDIRTY;  &mutex_exit( &lfs_lock); } }  &while (0));
    }' unless defined(&LFS_PUT_HEADFREE);
    eval 'sub LFS_GET_TAILFREE {
        my($FS, $CIP, $BP, $FREEP) = @_;
	    eval q( &do {  &LFS_CLEANERINFO(($CIP), ($FS), ($BP)); *($FREEP) =  &lfs_ci_getfree_tail($FS, $CIP);  &brelse($BP, 0); }  &while (0));
    }' unless defined(&LFS_GET_TAILFREE);
    eval 'sub LFS_PUT_TAILFREE {
        my($FS, $CIP, $BP, $VAL) = @_;
	    eval q( &do {  &LFS_CLEANERINFO(($CIP), ($FS), ($BP));  &lfs_ci_setfree_tail($FS, $CIP, $VAL);  &LFS_BWRITE_LOG($BP);  &mutex_enter( &lfs_lock); ($FS)-> &lfs_flags |=  &LFS_IFDIRTY;  &mutex_exit( &lfs_lock); }  &while (0));
    }' unless defined(&LFS_PUT_TAILFREE);
    eval 'sub SEGSUM_SIZE {
        my($fs) = @_;
	    eval q(( ($fs->{l$fs_is64}) ? $sizeof{ &SEGSUM64} :  &lfs_sb_getversion($fs) > 1? $sizeof{ &SEGSUM32} : $sizeof{ &SEGSUM_V1}));
    }' unless defined(&SEGSUM_SIZE);
    if(0) {
	eval 'sub segsum_finfobase {
	    my($fs,$ssp) = @_;
    	    eval q({ ( &FINFO *)($ssp +  &SEGSUM_SIZE($fs)); });
	}' unless defined(&segsum_finfobase);
    } else {
	eval 'sub SEGSUM_FINFOBASE {
	    my($fs, $ssp) = @_;
    	    eval q((( &FINFO *)(($ssp) +  &SEGSUM_SIZE($fs))););
	}' unless defined(&SEGSUM_FINFOBASE);
    }
    eval 'sub LFS_DEF_SS_ACCESSOR {
        my($type, $type32, $field) = @_;
	    eval q( &static  &__inline $type  &lfs_ss_get$field( &STRUCT_LFS * &fs,  &SEGSUM * &ssp) {  &if ( ($fs->{lfs_is64})) {  &return  ($ssp->{u_64}->{ss_})$field; }  &else {  &return  ($ssp->{u_32}->{ss_})$field; } }  &static  &__inline  &void  &lfs_ss_set$field( &STRUCT_LFS * &fs,  &SEGSUM * &ssp, $type  &val) {  &if ( ($fs->{lfs_is64})) { $type * &p =  ($ssp->{u_64}->{ss_})$field; ( &void) &p;  ($ssp->{u_64}->{ss_})$field =  &val; }  &else { $type32 * &p =  ($ssp->{u_32}->{ss_})$field; ( &void) &p;  ($ssp->{u_32}->{ss_})$field =  &val; } });
    }' unless defined(&LFS_DEF_SS_ACCESSOR);
    eval 'sub lfs_ss_setocreate {
        my($fs,$ssp,$val) = @_;
	    eval q({  &KASSERT( ($fs->{l$fs_is64}) == 0);  ($ssp->{u_v1}->{ss_create}) = $val; });
    }' unless defined(&lfs_ss_setocreate);
    eval 'sub LFS_DEF_SB_ACCESSOR_FULL {
        my($type, $type32, $field) = @_;
	    eval q( &static  &__inline $type  &lfs_sb_get$field( &STRUCT_LFS * &fs) {  &if ( ($fs->{lfs_is64})) {  &return  ($fs->{lfs_dlfs_u}->{u_64}->{dlfs_})$field; }  &else {  &return  ($fs->{lfs_dlfs_u}->{u_32}->{dlfs_})$field; } }  &static  &__inline  &void  &lfs_sb_set$field( &STRUCT_LFS * &fs, $type  &val) {  &if ( ($fs->{lfs_is64})) {  ($fs->{lfs_dlfs_u}->{u_64}->{dlfs_})$field =  &val; }  &else {  ($fs->{lfs_dlfs_u}->{u_32}->{dlfs_})$field =  &val; } }  &static  &__inline  &void  &lfs_sb_add$field( &STRUCT_LFS * &fs, $type  &val) {  &if ( ($fs->{lfs_is64})) { $type * &p64 =  ($fs->{lfs_dlfs_u}->{u_64}->{dlfs_})$field; * &p64 +=  &val; }  &else { $type32 * &p32 =  ($fs->{lfs_dlfs_u}->{u_32}->{dlfs_})$field; * &p32 +=  &val; } }  &static  &__inline  &void  &lfs_sb_sub$field( &STRUCT_LFS * &fs, $type  &val) {  &if ( ($fs->{lfs_is64})) { $type * &p64 =  ($fs->{lfs_dlfs_u}->{u_64}->{dlfs_})$field; * &p64 -=  &val; }  &else { $type32 * &p32 =  ($fs->{lfs_dlfs_u}->{u_32}->{dlfs_})$field; * &p32 -=  &val; } });
    }' unless defined(&LFS_DEF_SB_ACCESSOR_FULL);
    eval 'sub LFS_DEF_SB_ACCESSOR {
        my($t, $f) = @_;
	    eval q( &LFS_DEF_SB_ACCESSOR_FULL($t, $t, $f));
    }' unless defined(&LFS_DEF_SB_ACCESSOR);
    eval 'sub LFS_DEF_SB_ACCESSOR_32ONLY {
        my($type, $field, $val64) = @_;
	    eval q( &static  &__inline $type  &lfs_sb_get$field( &STRUCT_LFS * &fs) {  &if ( ($fs->{lfs_is64})) {  &return $val64; }  &else {  &return  ($fs->{lfs_dlfs_u}->{u_32}->{dlfs_})$field; } });
    }' unless defined(&LFS_DEF_SB_ACCESSOR_32ONLY);
    eval 'sub lfs_sb_getotstamp {
        my($fs) = @_;
	    eval q( &lfs_sb_getinopf($fs));
    }' unless defined(&lfs_sb_getotstamp);
    eval 'sub lfs_sb_setotstamp {
        my($fs, $val) = @_;
	    eval q( &lfs_sb_setinopf($fs, $val));
    }' unless defined(&lfs_sb_setotstamp);
    if(defined(&KASSERT)) {
    }
# some #ifdef were dropped here -- fill in the blanks
    eval 'sub lfs_sb_setsboff {
        my($fs,$n,$val) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($fs->{l$fs_dlfs_u}->{u_64}->{dlfs_sboffs[$n]}) = $val; }  &else {  ($fs->{l$fs_dlfs_u}->{u_32}->{dlfs_sboffs[$n]}) = $val; } });
    }' unless defined(&lfs_sb_setsboff);
    eval 'sub lfs_sb_setfsmnt {
        my($fs,$str) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) { ( &void) &strncpy( ($fs->{l$fs_dlfs_u}->{u_64}->{dlfs_fsmnt}), $str, $sizeof{ ($fs->{l$fs_dlfs_u}->{u_64}->{dlfs_fsmnt})}); }  &else { ( &void) &strncpy( ($fs->{l$fs_dlfs_u}->{u_32}->{dlfs_fsmnt}), $str, $sizeof{ ($fs->{l$fs_dlfs_u}->{u_32}->{dlfs_fsmnt})}); } });
    }' unless defined(&lfs_sb_setfsmnt);
    eval 'sub LFS_MAX_DADDR {
        my($fs) = @_;
	    eval q((($fs)-> &lfs_is64 ? 9.22337203685478e+18 : 0x7fffffff));
    }' unless defined(&LFS_MAX_DADDR);
    eval 'sub LFS_NINDIR {
        my($fs) = @_;
	    eval q(( &lfs_sb_getnindir($fs)));
    }' unless defined(&LFS_NINDIR);
    eval 'sub LFS_INOPB {
        my($fs) = @_;
	    eval q(( &lfs_sb_getinopb($fs)));
    }' unless defined(&LFS_INOPB);
    eval 'sub LFS_INOPF {
        my($fs) = @_;
	    eval q(( &lfs_sb_getinopf($fs)));
    }' unless defined(&LFS_INOPF);
    eval 'sub lfs_blkoff {
        my($fs, $loc) = @_;
	    eval q(((($loc) &  &lfs_sb_getbmask($fs))));
    }' unless defined(&lfs_blkoff);
    eval 'sub lfs_fragoff {
        my($fs, $loc) = @_;
	    eval q(((($loc) &  &lfs_sb_getffmask($fs))));
    }' unless defined(&lfs_fragoff);
    if(defined(&_KERNEL)) {
    } else {
    }
    if(defined(&_KERNEL)) {
    } else {
    }
    eval 'sub lfs_lblkno {
        my($fs, $loc) = @_;
	    eval q((($loc) >>  &lfs_sb_getbshift($fs)));
    }' unless defined(&lfs_lblkno);
    eval 'sub lfs_lblktosize {
        my($fs, $blk) = @_;
	    eval q((($blk) <<  &lfs_sb_getbshift($fs)));
    }' unless defined(&lfs_lblktosize);
    eval 'sub lfs_numfrags {
        my($fs, $loc) = @_;
	    eval q((($loc) >>  &lfs_sb_getffshift($fs)));
    }' unless defined(&lfs_numfrags);
    eval 'sub lfs_blkroundup {
        my($fs, $size) = @_;
	    eval q((( &off_t)((($size) +  &lfs_sb_getbmask($fs)) & (~ &lfs_sb_getbmask($fs)))));
    }' unless defined(&lfs_blkroundup);
    eval 'sub lfs_fragroundup {
        my($fs, $size) = @_;
	    eval q((( &off_t)((($size) +  &lfs_sb_getffmask($fs)) & (~ &lfs_sb_getffmask($fs)))));
    }' unless defined(&lfs_fragroundup);
    eval 'sub lfs_fragstoblks {
        my($fs, $frags) = @_;
	    eval q((($frags) >>  &lfs_sb_getfbshift($fs)));
    }' unless defined(&lfs_fragstoblks);
    eval 'sub lfs_blkstofrags {
        my($fs, $blks) = @_;
	    eval q((($blks) <<  &lfs_sb_getfbshift($fs)));
    }' unless defined(&lfs_blkstofrags);
    eval 'sub lfs_fragnum {
        my($fs, $fsb) = @_;
	    eval q((($fsb) & (($fs)-> &lfs_frag - 1)));
    }' unless defined(&lfs_fragnum);
    eval 'sub lfs_blknum {
        my($fs, $fsb) = @_;
	    eval q((($fsb) &~ (($fs)-> &lfs_frag - 1)));
    }' unless defined(&lfs_blknum);
    eval 'sub lfs_dblksize {
        my($fs, $dp, $lbn) = @_;
	    eval q(((($lbn) >=  &ULFS_NDADDR ||  &lfs_dino_getsize($fs, $dp) >= (($lbn) + 1) <<  &lfs_sb_getbshift($fs)) ?  &lfs_sb_getbsize($fs) : ( &lfs_fragroundup($fs,  &lfs_blkoff($fs,  &lfs_dino_getsize($fs, $dp))))));
    }' unless defined(&lfs_dblksize);
    eval 'sub lfs_segsize {
        my($fs) = @_;
	    eval q(( &lfs_sb_getversion($fs) == 1?  &lfs_lblktosize(($fs),  &lfs_sb_getssize($fs)) :  &lfs_sb_getssize($fs)));
    }' unless defined(&lfs_segsize);
    eval 'sub lfs_segtod {
        my($fs, $seg) = @_;
	    eval q(( &lfs_btofsb($fs,  &lfs_segsize($fs)) * ($seg)));
    }' unless defined(&lfs_segtod);
    eval 'sub lfs_dtosn {
        my($fs, $daddr) = @_;
	    eval q((( &uint32_t)((($daddr) -  &lfs_sb_gets0addr($fs)) /  &lfs_segtod(($fs), 1))));
    }' unless defined(&lfs_dtosn);
    eval 'sub lfs_sntod {
        my($fs, $sn) = @_;
	    eval q((( &daddr_t)( &lfs_segtod(($fs), ($sn)) +  &lfs_sb_gets0addr($fs))));
    }' unless defined(&lfs_sntod);
    if(defined(&_UFS_LFS_LFS_INODE_H_)) {
	eval 'sub lfs_blksize {
	    my($fs,$ip,$lbn) = @_;
    	    eval q({  &if ($lbn >=  &ULFS_NDADDR ||  &lfs_dino_getsize($fs,  ($ip->{i_din})) >= ($lbn + 1) <<  &lfs_sb_getbshift($fs)) {  &lfs_sb_getbsize($fs); }  &else {  &lfs_fragroundup($fs,  &lfs_blkoff($fs,  &lfs_dino_getsize($fs,  ($ip->{i_din})))); } });
	}' unless defined(&lfs_blksize);
    }
    eval 'sub lfs_blocks_fromfinfo {
        my($fs,$bp,$fip) = @_;
	    eval q({  &void * &firstblock;  &firstblock = $fip +  &FINFOSIZE($fs);  &if ( ($fs->{l$fs_is64})) {  ($bp->{b64}) = ( &int64_t *) &firstblock; }  &else {  ($bp->{b32}) = ( &int32_t *) &firstblock; } });
    }' unless defined(&lfs_blocks_fromfinfo);
    eval 'sub lfs_blocks_get {
        my($fs,$bp,$idx) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($bp->{b64[$idx]}); }  &else {  ($bp->{b32[$idx]}); } });
    }' unless defined(&lfs_blocks_get);
    eval 'sub lfs_blocks_set {
        my($fs,$bp,$idx,$val) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($bp->{b64[$idx]}) = $val; }  &else {  ($bp->{b32[$idx]}) = $val; } });
    }' unless defined(&lfs_blocks_set);
    eval 'sub lfs_blocks_inc {
        my($fs,$bp) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($bp->{b64})++; }  &else {  ($bp->{b32})++; } });
    }' unless defined(&lfs_blocks_inc);
    eval 'sub lfs_blocks_eq {
        my($fs,$bp1,$bp2) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($bp1->{b64}) ==  ($bp2->{b64}); }  &else {  ($bp1->{b32}) ==  ($bp2->{b32}); } });
    }' unless defined(&lfs_blocks_eq);
    eval 'sub lfs_blocks_sub {
        my($fs,$bp1,$bp2) = @_;
	    eval q({  &if ( ($fs->{l$fs_is64})) {  ($bp1->{b64}) -  ($bp2->{b64}); }  &else {  ($bp1->{b32}) -  ($bp2->{b32}); } });
    }' unless defined(&lfs_blocks_sub);
    eval 'sub LFS_EST_CMETA {
        my($F) = @_;
	    eval q((( ( &lfs_sb_getdmeta($F) * ( &int64_t) &lfs_sb_getnclean($F)) / ( &lfs_sb_getnseg($F)))));
    }' unless defined(&LFS_EST_CMETA);
    eval 'sub LFS_EST_NONMETA {
        my($F) = @_;
	    eval q(( &lfs_sb_getdsize($F) -  &lfs_sb_getdmeta($F) -  &LFS_EST_CMETA($F)));
    }' unless defined(&LFS_EST_NONMETA);
    eval 'sub LFS_EST_BFREE {
        my($F) = @_;
	    eval q(( &lfs_sb_getbfree($F) >  &LFS_EST_CMETA($F) ?  &lfs_sb_getbfree($F) -  &LFS_EST_CMETA($F) : 0));
    }' unless defined(&LFS_EST_BFREE);
    eval 'sub LFS_EST_RSVD {
        my($F) = @_;
	    eval q((( &LFS_EST_NONMETA($F) * ( &uint64_t) &lfs_sb_getminfree($F)) / 100));
    }' unless defined(&LFS_EST_RSVD);
    eval 'sub ISSPACE {
        my($F, $BB, $C) = @_;
	    eval q((((($C) ==  &NOCRED ||  &kauth_cred_geteuid($C) == 0)  &&  &LFS_EST_BFREE($F) >= ($BB)) || ( &kauth_cred_geteuid($C) != 0 &&  &IS_FREESPACE($F, $BB))));
    }' unless defined(&ISSPACE);
    eval 'sub IS_FREESPACE {
        my($F, $BB) = @_;
	    eval q(( &LFS_EST_BFREE($F) >= ($BB) +  &LFS_EST_RSVD($F)));
    }' unless defined(&IS_FREESPACE);
    eval 'sub LFS_NRESERVE {
        my($F) = @_;
	    eval q(( &lfs_btofsb(($F), (2*  &ULFS_NIADDR + 3) <<  &lfs_sb_getbshift($F))));
    }' unless defined(&LFS_NRESERVE);
    if(defined(&__GNUC__)) {
	if(defined(&__clang__)) {
	}
 elsif( &__GNUC_PREREQ__(9,0)) {
	}
    }
}
1;
