/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.passive;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.diylc.common.ObjectCache;
import org.diylc.common.ResistorColorCode;
import org.diylc.components.AbstractLeadedComponent;
import org.diylc.components.passive.Power;
import org.diylc.core.CreationMethod;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.annotations.PositiveMeasureValidator;
import org.diylc.core.measures.Resistance;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;

@ComponentDescriptor(name="Resistor", author="Branislav Stojkovic", category="Passive", creationMethod=CreationMethod.POINT_BY_POINT, instanceNamePrefix="R", description="Resistor layout symbol", zOrder=4.0)
public class Resistor
extends AbstractLeadedComponent<Resistance> {
    private static final long serialVersionUID = 1L;
    public static Size DEFAULT_WIDTH = new Size(Double.valueOf(0.5), SizeUnit.in);
    public static Size DEFAULT_HEIGHT = new Size(Double.valueOf(0.125), SizeUnit.in);
    public static Color BODY_COLOR = Color.decode("#82CFFD");
    public static Color BORDER_COLOR = BODY_COLOR.darker();
    public static int BAND_SPACING = 5;
    public static int FIRST_BAND = 4;
    private Resistance value = null;
    @Deprecated
    private Power power = Power.HALF;
    private org.diylc.core.measures.Power powerNew = null;
    private ResistorColorCode colorCode = ResistorColorCode._5_BAND;

    public Resistor() {
        this.bodyColor = BODY_COLOR;
        this.borderColor = BORDER_COLOR;
    }

    protected boolean supportsStandingMode() {
        return true;
    }

    @EditableProperty(validatorClass=PositiveMeasureValidator.class)
    public Resistance getValue() {
        return this.value;
    }

    public void setValue(Resistance value) {
        this.value = value;
    }

    public String getValueForDisplay() {
        return this.getValue().toString() + (this.getPowerNew() == null ? "" : " " + this.getPowerNew().toString());
    }

    @Deprecated
    public Power getPower() {
        return this.power;
    }

    @Deprecated
    public void setPower(Power power) {
        this.power = power;
    }

    @EditableProperty(name="Power rating")
    public org.diylc.core.measures.Power getPowerNew() {
        return this.powerNew;
    }

    public void setPowerNew(org.diylc.core.measures.Power powerNew) {
        this.powerNew = powerNew;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        g2d.rotate(-0.7853981633974483, width / 2, height / 2);
        g2d.setColor(LEAD_COLOR_ICON);
        g2d.drawLine(0, height / 2, width, height / 2);
        g2d.setColor(BODY_COLOR);
        g2d.fillRect(4, height / 2 - 3, width - 8, 6);
        g2d.setColor(Color.red);
        g2d.drawLine(7, height / 2 - 3, 7, height / 2 + 3);
        g2d.setColor(Color.orange);
        g2d.drawLine(11, height / 2 - 3, 11, height / 2 + 3);
        g2d.setColor(Color.black);
        g2d.drawLine(15, height / 2 - 3, 15, height / 2 + 3);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRect(4, height / 2 - 3, width - 8, 6);
    }

    protected Size getDefaultWidth() {
        return DEFAULT_HEIGHT;
    }

    protected Size getDefaultLength() {
        return DEFAULT_WIDTH;
    }

    @EditableProperty(name="Color code")
    public ResistorColorCode getColorCode() {
        return this.colorCode;
    }

    public void setColorCode(ResistorColorCode colorCode) {
        this.colorCode = colorCode;
    }

    protected Shape getBodyShape() {
        return new Rectangle2D.Double(0.0, 0.0, this.getLength().convertToPixels(), this.getClosestOdd(this.getWidth().convertToPixels()));
    }

    protected void decorateComponentBody(Graphics2D g2d, boolean outlineMode) {
        if (this.colorCode == ResistorColorCode.NONE || outlineMode || this.value == null) {
            return;
        }
        int height = this.getClosestOdd(this.getWidth().convertToPixels());
        Color[] bands = this.value.getColorCode(this.colorCode);
        int x = FIRST_BAND;
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(2));
        for (int i = 0; i < bands.length; ++i) {
            g2d.setColor(bands[i]);
            g2d.drawLine(x, 1, x, height - 1);
            x += BAND_SPACING;
        }
    }

    protected int getLabelOffset(int bodyWidth, int labelWidth) {
        if (this.value == null) {
            return 0;
        }
        Color[] bands = this.value.getColorCode(this.colorCode);
        int bandArea = FIRST_BAND + BAND_SPACING * (bands.length - 1);
        if (labelWidth > bodyWidth - 2 * bandArea) {
            return bandArea / 2;
        }
        return 0;
    }

    @EditableProperty(name="Reverse (standing)")
    public boolean getFlipStanding() {
        return super.getFlipStanding();
    }
}

