/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.semiconductors;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.Display;
import org.diylc.common.ObjectCache;
import org.diylc.common.Orientation;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Transistor (TO-92 package)", author="Branislav Stojkovic", category="Semiconductors", instanceNamePrefix="Q", description="Transistor with small plastic or epoxy body", stretchable=false, zOrder=4.0)
public class TransistorTO92
extends AbstractTransparentComponent<String> {
    private static final long serialVersionUID = 1L;
    public static Color BODY_COLOR = Color.gray;
    public static Color BORDER_COLOR = Color.gray.darker();
    public static Color PIN_COLOR = Color.decode("#00B2EE");
    public static Color PIN_BORDER_COLOR = PIN_COLOR.darker();
    public static Color LABEL_COLOR = Color.white;
    public static Size PIN_SIZE = new Size(Double.valueOf(0.03), SizeUnit.in);
    public static Size PIN_SPACING = new Size(Double.valueOf(0.05), SizeUnit.in);
    public static Size BODY_DIAMETER = new Size(Double.valueOf(0.2), SizeUnit.in);
    private String value = "";
    private Orientation orientation = Orientation.DEFAULT;
    private Point[] controlPoints = new Point[]{new Point(0, 0), new Point(0, 0), new Point(0, 0)};
    private transient Area body;
    private Color bodyColor = BODY_COLOR;
    private Color borderColor = BORDER_COLOR;
    private Color labelColor = LABEL_COLOR;
    protected Display display = Display.NAME;
    private boolean folded = false;
    private Size pinSpacing = PIN_SPACING;

    public TransistorTO92() {
        this.updateControlPoints();
    }

    @EditableProperty
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @EditableProperty
    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public boolean getFolded() {
        return this.folded;
    }

    public void setFolded(boolean folded) {
        this.folded = folded;
        this.body = null;
    }

    @EditableProperty(name="Pin spacing")
    public Size getPinSpacing() {
        if (this.pinSpacing == null) {
            this.pinSpacing = new Size(Double.valueOf(0.1), SizeUnit.in);
        }
        return this.pinSpacing;
    }

    public void setPinSpacing(Size pinSpacing) {
        this.pinSpacing = pinSpacing;
        this.updateControlPoints();
        this.body = null;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    private void updateControlPoints() {
        int pinSpacing = (int)this.getPinSpacing().convertToPixels();
        int x = this.controlPoints[0].x;
        int y = this.controlPoints[0].y;
        switch (this.orientation) {
            case DEFAULT: {
                this.controlPoints[1].setLocation(x, y + pinSpacing);
                this.controlPoints[2].setLocation(x, y + 2 * pinSpacing);
                break;
            }
            case _90: {
                this.controlPoints[1].setLocation(x - pinSpacing, y);
                this.controlPoints[2].setLocation(x - 2 * pinSpacing, y);
                break;
            }
            case _180: {
                this.controlPoints[1].setLocation(x, y - pinSpacing);
                this.controlPoints[2].setLocation(x, y - 2 * pinSpacing);
                break;
            }
            case _270: {
                this.controlPoints[1].setLocation(x + pinSpacing, y);
                this.controlPoints[2].setLocation(x + 2 * pinSpacing, y);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected orientation: " + this.orientation);
            }
        }
    }

    public Area getBody() {
        block12: {
            int bodyDiameter;
            int y;
            int x;
            block13: {
                if (this.body != null) break block12;
                x = (this.controlPoints[0].x + this.controlPoints[1].x + this.controlPoints[2].x) / 3;
                y = (this.controlPoints[0].y + this.controlPoints[1].y + this.controlPoints[2].y) / 3;
                bodyDiameter = this.getClosestOdd(BODY_DIAMETER.convertToPixels());
                if (!this.folded) break block13;
                switch (this.orientation) {
                    case DEFAULT: {
                        this.body = new Area(new Rectangle2D.Double(x - bodyDiameter, y - bodyDiameter / 2, bodyDiameter, bodyDiameter));
                        break block12;
                    }
                    case _90: {
                        this.body = new Area(new Rectangle2D.Double(x - bodyDiameter / 2, y - bodyDiameter, bodyDiameter, bodyDiameter));
                        break block12;
                    }
                    case _180: {
                        this.body = new Area(new Rectangle2D.Double(x, y - bodyDiameter / 2, bodyDiameter, bodyDiameter));
                        break block12;
                    }
                    case _270: {
                        this.body = new Area(new Rectangle2D.Double(x - bodyDiameter / 2, y, bodyDiameter, bodyDiameter));
                        break block12;
                    }
                    default: {
                        throw new RuntimeException("Unexpected orientation: " + this.orientation);
                    }
                }
            }
            switch (this.orientation) {
                case DEFAULT: {
                    this.body = new Area(new Ellipse2D.Double(x - bodyDiameter / 2, y - bodyDiameter / 2, bodyDiameter, bodyDiameter));
                    this.body.subtract(new Area(new Rectangle2D.Double(x - bodyDiameter, y - bodyDiameter / 2, 3 * bodyDiameter / 4, bodyDiameter)));
                    break;
                }
                case _90: {
                    this.body = new Area(new Ellipse2D.Double(x - bodyDiameter / 2, y - bodyDiameter / 2, bodyDiameter, bodyDiameter));
                    this.body.subtract(new Area(new Rectangle2D.Double(x - bodyDiameter / 2, y - bodyDiameter, bodyDiameter, 3 * bodyDiameter / 4)));
                    break;
                }
                case _180: {
                    this.body = new Area(new Ellipse2D.Double(x - bodyDiameter / 2, y - bodyDiameter / 2, bodyDiameter, bodyDiameter));
                    this.body.subtract(new Area(new Rectangle2D.Double(x + bodyDiameter / 4, y - bodyDiameter / 2, 3 * bodyDiameter / 4, bodyDiameter)));
                    break;
                }
                case _270: {
                    this.body = new Area(new Ellipse2D.Double(x - bodyDiameter / 2, y - bodyDiameter / 2, bodyDiameter, bodyDiameter));
                    this.body.subtract(new Area(new Rectangle2D.Double(x - bodyDiameter / 2, y + bodyDiameter / 4, bodyDiameter, 3 * bodyDiameter / 4)));
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected orientation: " + this.orientation);
                }
            }
        }
        return this.body;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        Color finalLabelColor;
        Color finalBorderColor;
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        int pinSize = (int)PIN_SIZE.convertToPixels() / 2 * 2;
        Area mainArea = this.getBody();
        Composite oldComposite = g2d.getComposite();
        if (this.alpha < MAX_ALPHA) {
            g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
        }
        g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : this.bodyColor);
        g2d.fill(mainArea);
        g2d.setComposite(oldComposite);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor();
        } else {
            finalBorderColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : this.borderColor;
        }
        g2d.setColor(finalBorderColor);
        g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
        g2d.draw(mainArea);
        if (!outlineMode) {
            for (Point point : this.controlPoints) {
                g2d.setColor(PIN_COLOR);
                g2d.fillOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
                g2d.setColor(PIN_BORDER_COLOR);
                g2d.drawOval(point.x - pinSize / 2, point.y - pinSize / 2, pinSize, pinSize);
            }
        }
        g2d.setFont(LABEL_FONT);
        if (outlineMode) {
            Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : theme.getOutlineColor();
        } else {
            finalLabelColor = componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? LABEL_COLOR_SELECTED : this.getLabelColor();
        }
        g2d.setColor(finalLabelColor);
        String label = this.getDisplay() == Display.NAME ? this.getName() : this.getValue();
        FontMetrics fontMetrics = g2d.getFontMetrics(g2d.getFont());
        Rectangle2D rect = fontMetrics.getStringBounds(label, g2d);
        int textHeight = (int)rect.getHeight();
        int textWidth = (int)rect.getWidth();
        Rectangle bounds = mainArea.getBounds();
        int x = bounds.x + (bounds.width - textWidth) / 2;
        int y = bounds.y + (bounds.height - textHeight) / 2 + fontMetrics.getAscent();
        g2d.drawString(label, x, y);
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int margin = 3 * width / 32;
        Area area = new Area(new Ellipse2D.Double(margin / 2, margin, width - 2 * margin, width - 2 * margin));
        area.intersect(new Area(new Rectangle2D.Double(2 * margin, 0.0, width, height)));
        g2d.setColor(BODY_COLOR);
        g2d.fill(area);
        g2d.setColor(BORDER_COLOR);
        g2d.draw(area);
        g2d.setColor(PIN_COLOR);
        int pinSize = 2 * width / 32;
        for (int i = 0; i < 3; ++i) {
            g2d.fillOval(width / 2 - pinSize / 2, height / 4 * (i + 1), pinSize, pinSize);
        }
    }

    @EditableProperty(name="Body")
    public Color getBodyColor() {
        return this.bodyColor;
    }

    public void setBodyColor(Color bodyColor) {
        this.bodyColor = bodyColor;
    }

    @EditableProperty(name="Border")
    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @EditableProperty(name="Label")
    public Color getLabelColor() {
        if (this.labelColor == null) {
            this.labelColor = LABEL_COLOR;
        }
        return this.labelColor;
    }

    public void setLabelColor(Color labelColor) {
        this.labelColor = labelColor;
    }

    @EditableProperty
    public Display getDisplay() {
        if (this.display == null) {
            this.display = Display.NAME;
        }
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }
}

