/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.sql.SQLException;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;

public class LogPanelCellRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel txtId = null;
    private JLabel txtMethod = null;
    private JLabel txtURI = null;
    private JLabel txtStatus = null;
    private JLabel txtReason = null;
    private JLabel txtRTT = null;
    private JLabel txtTag = null;

    public LogPanelCellRenderer() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.25;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagConstraints.fill = 2;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.ipadx = 4;
        gridBagConstraints2.ipady = 1;
        gridBagConstraints2.gridx = 5;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 4;
        gridBagConstraints3.ipadx = 4;
        gridBagConstraints3.ipady = 1;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.gridy = 0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.ipadx = 4;
        gridBagConstraints4.ipady = 1;
        gridBagConstraints4.gridx = 3;
        this.txtTag = new JLabel();
        this.txtTag.setText(" ");
        this.txtTag.setBackground(SystemColor.text);
        this.txtTag.setHorizontalAlignment(2);
        this.txtTag.setPreferredSize(new Dimension(70, 15));
        this.txtTag.setMinimumSize(new Dimension(70, 15));
        this.txtTag.setFont(new Font("Default", 0, 12));
        this.txtTag.setOpaque(true);
        this.txtRTT = new JLabel();
        this.txtRTT.setText(" ");
        this.txtRTT.setBackground(SystemColor.text);
        this.txtRTT.setHorizontalAlignment(4);
        this.txtRTT.setPreferredSize(new Dimension(55, 15));
        this.txtRTT.setMinimumSize(new Dimension(55, 15));
        this.txtRTT.setFont(new Font("Default", 0, 12));
        this.txtRTT.setOpaque(true);
        this.txtReason = new JLabel();
        this.txtReason.setText(" ");
        this.txtReason.setBackground(SystemColor.text);
        this.txtReason.setHorizontalAlignment(2);
        this.txtReason.setPreferredSize(new Dimension(85, 15));
        this.txtReason.setMinimumSize(new Dimension(85, 15));
        this.txtReason.setFont(new Font("Default", 0, 12));
        this.txtReason.setOpaque(true);
        this.txtReason.setVisible(true);
        this.txtStatus = new JLabel();
        this.txtStatus.setText(" ");
        this.txtStatus.setBackground(SystemColor.text);
        this.txtStatus.setHorizontalAlignment(0);
        this.txtStatus.setPreferredSize(new Dimension(30, 15));
        this.txtStatus.setMinimumSize(new Dimension(30, 15));
        this.txtStatus.setFont(new Font("Default", 0, 12));
        this.txtStatus.setOpaque(true);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints5.gridy = 0;
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 0.75;
        gridBagConstraints5.anchor = 17;
        gridBagConstraints5.ipadx = 4;
        gridBagConstraints5.ipady = 1;
        gridBagConstraints5.gridx = 2;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.weightx = 0.0;
        gridBagConstraints6.ipadx = 4;
        gridBagConstraints6.ipady = 1;
        gridBagConstraints6.fill = 0;
        gridBagConstraints6.gridx = 1;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints7.gridy = 0;
        gridBagConstraints7.anchor = 17;
        gridBagConstraints7.weightx = 0.0;
        gridBagConstraints7.ipadx = 4;
        gridBagConstraints7.ipady = 1;
        gridBagConstraints7.gridx = 0;
        this.txtURI = new JLabel();
        this.txtURI.setText(" ");
        this.txtURI.setBackground(SystemColor.text);
        this.txtURI.setHorizontalAlignment(2);
        this.txtURI.setPreferredSize(new Dimension(420, 15));
        this.txtURI.setMinimumSize(new Dimension(420, 15));
        this.txtURI.setFont(new Font("Default", 0, 12));
        this.txtURI.setOpaque(true);
        this.txtMethod = new JLabel();
        this.txtMethod.setText(" ");
        this.txtMethod.setBackground(SystemColor.text);
        this.txtMethod.setHorizontalAlignment(2);
        this.txtMethod.setPreferredSize(new Dimension(45, 15));
        this.txtMethod.setMinimumSize(new Dimension(45, 15));
        this.txtMethod.setFont(new Font("Default", 0, 12));
        this.txtMethod.setCursor(new Cursor(0));
        this.txtMethod.setOpaque(true);
        this.txtId = new JLabel();
        this.txtId.setText(" ");
        this.txtId.setBackground(SystemColor.text);
        this.txtId.setCursor(new Cursor(0));
        this.txtId.setHorizontalAlignment(0);
        this.txtId.setPreferredSize(new Dimension(40, 15));
        this.txtId.setMinimumSize(new Dimension(40, 15));
        this.txtId.setFont(new Font("Default", 0, 12));
        this.txtId.setOpaque(true);
        this.setLayout(new GridBagLayout());
        this.setSize(328, 11);
        this.setFont(new Font("Default", 0, 12));
        this.add((Component)this.txtId, gridBagConstraints7);
        this.add((Component)this.txtMethod, gridBagConstraints6);
        this.add((Component)this.txtURI, gridBagConstraints5);
        this.add((Component)this.txtStatus, gridBagConstraints4);
        this.add((Component)this.txtReason, gridBagConstraints3);
        this.add((Component)this.txtRTT, gridBagConstraints2);
        this.add((Component)this.txtTag, gridBagConstraints);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        HistoryReference historyReference = (HistoryReference)object;
        this.txtId.setText(Integer.toString(historyReference.getHistoryId()));
        try {
            HttpMessage httpMessage = historyReference.getHttpMessage();
            this.txtMethod.setText(httpMessage.getRequestHeader().getMethod());
            this.txtURI.setText(httpMessage.getRequestHeader().getURI().toString());
            this.txtStatus.setText(Integer.toString(httpMessage.getResponseHeader().getStatusCode()));
            this.txtReason.setText(httpMessage.getResponseHeader().getReasonPhrase());
            this.txtRTT.setText(httpMessage.getTimeElapsedMillis() + "ms");
            this.txtTag.setText(httpMessage.getTag());
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            httpMalformedHeaderException.printStackTrace();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        if (bl) {
            this.txtId.setBackground(jList.getSelectionBackground());
            this.txtId.setForeground(jList.getSelectionForeground());
            this.txtMethod.setBackground(jList.getSelectionBackground());
            this.txtMethod.setForeground(jList.getSelectionForeground());
            this.txtURI.setBackground(jList.getSelectionBackground());
            this.txtURI.setForeground(jList.getSelectionForeground());
            this.txtStatus.setBackground(jList.getSelectionBackground());
            this.txtStatus.setForeground(jList.getSelectionForeground());
            this.txtReason.setBackground(jList.getSelectionBackground());
            this.txtReason.setForeground(jList.getSelectionForeground());
            this.txtRTT.setBackground(jList.getSelectionBackground());
            this.txtRTT.setForeground(jList.getSelectionForeground());
            this.txtTag.setBackground(jList.getSelectionBackground());
            this.txtTag.setForeground(jList.getSelectionForeground());
        } else {
            Color color = new Color(jList.getBackground().getRGB() & 0xFFECECEC);
            this.txtId.setBackground(jList.getBackground());
            this.txtId.setForeground(jList.getForeground());
            this.txtMethod.setBackground(color);
            this.txtMethod.setForeground(jList.getForeground());
            this.txtURI.setBackground(jList.getBackground());
            this.txtURI.setForeground(jList.getForeground());
            this.txtStatus.setBackground(color);
            this.txtStatus.setForeground(jList.getForeground());
            this.txtReason.setBackground(jList.getBackground());
            this.txtReason.setForeground(jList.getForeground());
            this.txtRTT.setBackground(color);
            this.txtRTT.setForeground(jList.getForeground());
            this.txtTag.setBackground(jList.getBackground());
            this.txtTag.setForeground(jList.getForeground());
        }
        this.setEnabled(jList.isEnabled());
        this.setFont(jList.getFont());
        return this;
    }
}

