/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import javax.swing.event.ChangeEvent;

public class WeakPropertyChangeListener
implements PropertyChangeListener {
    private WeakReference<PropertyChangeListener> _listenerRef;
    private Object _src;

    public WeakPropertyChangeListener(PropertyChangeListener listener, Object src) {
        this._listenerRef = new WeakReference<PropertyChangeListener>(listener);
        this._src = src;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        PropertyChangeListener listener = (PropertyChangeListener)this._listenerRef.get();
        if (listener == null) {
            this.removeListener();
        } else {
            listener.propertyChange(evt);
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
    }

    private void removeListener() {
        try {
            Method method = this._src.getClass().getMethod("removePropertyChangeListener", PropertyChangeListener.class);
            method.invoke(this._src, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

