/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.encryption.pbe.config;

import java.security.Provider;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.salt.SaltGenerator;

public class SimplePBEConfig
implements PBEConfig {
    private String algorithm = null;
    private String password = null;
    private Integer keyObtentionIterations = null;
    private SaltGenerator saltGenerator = null;
    private String providerName = null;
    private Provider provider = null;

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setKeyObtentionIterations(Integer keyObtentionIterations) {
        this.keyObtentionIterations = keyObtentionIterations;
    }

    public void setKeyObtentionIterations(String keyObtentionIterations) {
        if (keyObtentionIterations != null) {
            try {
                this.keyObtentionIterations = new Integer(keyObtentionIterations);
            }
            catch (NumberFormatException e) {
                throw new EncryptionInitializationException(e);
            }
        } else {
            this.keyObtentionIterations = null;
        }
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        this.saltGenerator = saltGenerator;
    }

    public void setSaltGeneratorClassName(String saltGeneratorClassName) {
        if (saltGeneratorClassName != null) {
            try {
                Class<?> saltGeneratorClass = Thread.currentThread().getContextClassLoader().loadClass(saltGeneratorClassName);
                this.saltGenerator = (SaltGenerator)saltGeneratorClass.newInstance();
            }
            catch (Exception e) {
                throw new EncryptionInitializationException(e);
            }
        } else {
            this.saltGenerator = null;
        }
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public void setProviderClassName(String providerClassName) {
        if (providerClassName != null) {
            try {
                Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(providerClassName);
                this.provider = (Provider)providerClass.newInstance();
            }
            catch (Exception e) {
                throw new EncryptionInitializationException(e);
            }
        } else {
            this.provider = null;
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getKeyObtentionIterations() {
        return this.keyObtentionIterations;
    }

    public SaltGenerator getSaltGenerator() {
        return this.saltGenerator;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Provider getProvider() {
        return this.provider;
    }
}

