/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class ArrowIcon
implements Icon,
SwingConstants {
    private static final int DEFAULT_SIZE = 5;
    private int size;
    private int direction;

    public ArrowIcon(int direction) {
        this(5, direction);
    }

    public ArrowIcon(int size, int direction) {
        this.size = size;
        this.direction = direction;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.direction == 1 || this.direction == 5) {
            this.paintTriangle(g, x, y, this.getIconWidth(), this.getIconHeight(), this.direction, c.isEnabled());
        } else if (this.direction == 7 || this.direction == 3) {
            this.paintTriangle(g, x, y, this.getIconWidth(), this.getIconHeight(), this.direction, c.isEnabled());
        }
    }

    public int getIconWidth() {
        return this.size;
    }

    public int getIconHeight() {
        return this.size;
    }

    private void paintTriangle(Graphics g, int x, int y, int width, int height, int direction, boolean isEnabled) {
        ArrowIcon.paintArrow(g, this.size, x, y, width, height, direction, isEnabled);
    }

    public static void paintArrow(Graphics g, int size, int x, int y, int width, int height, int direction, boolean isEnabled) {
        Color oldColor = g.getColor();
        int j = 0;
        int maxSize = Math.max(size, 2);
        int midW = width / 2;
        int midH = height / 2;
        g.translate(x, y);
        if (isEnabled) {
            g.setColor(UIManager.getColor("controlDkShadow"));
        } else {
            g.setColor(UIManager.getColor("controlShadow"));
        }
        switch (direction) {
            case 1: {
                int i;
                for (i = 0; i < maxSize; ++i) {
                    g.drawLine(midW - i, i, midW + i, i);
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(midW - i + 2, i, midW + i, i);
                break;
            }
            case 5: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i = maxSize - 1; i >= 0; --i) {
                        g.drawLine(midW - i, j, midW + i, j);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i = maxSize - 1; i >= 0; --i) {
                    g.drawLine(midW - i, j, midW + i, j);
                    ++j;
                }
                break;
            }
            case 7: {
                int i;
                for (i = 0; i < maxSize; ++i) {
                    g.drawLine(i, midH - i, i, midH + i);
                }
                if (isEnabled) break;
                g.setColor(UIManager.getColor("controlLtHighlight"));
                g.drawLine(i, midH - i + 2, i, midH + i);
                break;
            }
            case 3: {
                int i;
                if (!isEnabled) {
                    g.translate(1, 1);
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    for (i = maxSize - 1; i >= 0; --i) {
                        g.drawLine(j, midH - i, j, midH + i);
                        ++j;
                    }
                    g.translate(-1, -1);
                    g.setColor(UIManager.getColor("controlShadow"));
                }
                j = 0;
                for (i = maxSize - 1; i >= 0; --i) {
                    g.drawLine(j, midH - i, j, midH + i);
                    ++j;
                }
                break;
            }
        }
        g.translate(-x, -y);
        g.setColor(oldColor);
    }
}

