/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.bluecow.spectro.Clip;
import net.bluecow.spectro.ClipPanel;
import net.bluecow.spectro.ToolboxPanel;
import net.bluecow.spectro.Version;

public class TestingMain {
    public static void main(String[] args) throws Exception {
        final JFrame f = new JFrame("Spectro-Edit " + Version.VERSION);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    FileDialog fd = new FileDialog((Frame)f, "Choose a 16-bit mono WAV file");
                    fd.setVisible(true);
                    String dir = fd.getDirectory();
                    String file = fd.getFile();
                    if (dir == null || file == null) {
                        JOptionPane.showMessageDialog(f, "Ok, maybe next time");
                        System.exit(0);
                    }
                    File wavFile = new File(dir, file);
                    Clip c = new Clip(wavFile);
                    ClipPanel cp = new ClipPanel(c);
                    f.setDefaultCloseOperation(3);
                    f.setLayout(new BorderLayout());
                    f.add((Component)new JScrollPane(cp), "Center");
                    f.add((Component)new ToolboxPanel(cp).getPanel(), "South");
                    f.pack();
                    f.setLocationRelativeTo(null);
                    f.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(f, "Sorry, couldn't read your sample:\n" + e.getMessage() + "\nBe sure your file is 16-bit mono!");
                    System.exit(0);
                }
            }
        });
    }
}

