# See if tracing into write() with gdb reboots (PR 49603)

import os
from bracket import *

name = 'gdb_reboot'

def test_func(ts):
    sh_commands = '''
cat <<END >>test.gdb
break write
run
stepi
stepi
stepi
stepi
stepi
END
gdb --batch -x test.gdb /bin/sh
'''
    img_fn = make_sh_test_temp_disk(ts, sh_commands)
    logfn = os.path.join(results_dir(ts), name + ".log")
    anita_run_1(ts, "boot",
            logfn,
            extra_anita_args = [
                "--run", "mount /dev/wd1a /mnt && sh /mnt/script",
                "--run-timeout", "120", "--vmm-args", "-hdb %s" % img_fn
            ])
    status = run("test `cat %s | fgrep 'mainbus0 (root)' | wc -l` -lt 2" % logfn)
    return status == 0

def op():
    return TestOp(test_func, [install_op], name = name)
