/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.CDR;

import gnu.CORBA.CDR.AbstractDataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LittleEndianOutputStream
extends FilterOutputStream
implements AbstractDataOutput {
    public void flush() throws IOException {
        this.out.flush();
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeByte(int n) throws IOException {
        this.write(n & 0xFF);
    }

    public synchronized void writeShort(int n) throws IOException {
        this.write((byte)(0xFF & n));
        this.write((byte)(0xFF & n >> 8));
    }

    public synchronized void writeChar(int n) throws IOException {
        this.write((byte)(0xFF & n));
        this.write((byte)(0xFF & n >> 8));
    }

    public synchronized void writeInt(int n) throws IOException {
        this.write((byte)(0xFF & n));
        this.write((byte)(0xFF & n >> 8));
        this.write((byte)(0xFF & n >> 16));
        this.write((byte)(0xFF & n >> 24));
    }

    public synchronized void writeLong(long l) throws IOException {
        this.write((byte)(0xFFL & l));
        this.write((byte)(0xFFL & l >> 8));
        this.write((byte)(0xFFL & l >> 16));
        this.write((byte)(0xFFL & l >> 24));
        this.write((byte)(0xFFL & l >> 32));
        this.write((byte)(0xFFL & l >> 40));
        this.write((byte)(0xFFL & l >> 48));
        this.write((byte)(0xFFL & l >> 56));
    }

    public void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public LittleEndianOutputStream(OutputStream outputStream) {
        super(outputStream);
    }
}

