require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_POWERPC_OEA_SPR_H_)) {
    eval 'sub _POWERPC_OEA_SPR_H_ () {1;}' unless defined(&_POWERPC_OEA_SPR_H_);
    if(!defined(&_LOCORE)  && defined(&_KERNEL)) {
	if(defined(&_KERNEL_OPT)) {
	    require './powerpc/oea/opt_ppcarch.ph';
	}
	if(defined(&PPC_OEA64_BRIDGE) || defined (&_ARCH_PPC64)) {
	    require 'powerpc/psl.ph';
	    require 'powerpc/spr.ph';
	}
    }
    eval 'sub SPR_MQ () {0x;}' unless defined(&SPR_MQ);
    eval 'sub SPR_RTCU_R () {0x4;}' unless defined(&SPR_RTCU_R);
    eval 'sub SPR_RTCL_R () {0x5;}' unless defined(&SPR_RTCL_R);
    eval 'sub SPR_DSISR () {0x12;}' unless defined(&SPR_DSISR);
    eval 'sub DSISR_DIRECT () {0x80000000;}' unless defined(&DSISR_DIRECT);
    eval 'sub DSISR_NOTFOUND () {0x40000000;}' unless defined(&DSISR_NOTFOUND);
    eval 'sub DSISR_PROTECT () {0x8000000;}' unless defined(&DSISR_PROTECT);
    eval 'sub DSISR_INVRX () {0x4000000;}' unless defined(&DSISR_INVRX);
    eval 'sub DSISR_STORE () {0x2000000;}' unless defined(&DSISR_STORE);
    eval 'sub DSISR_DABR () {0x400000;}' unless defined(&DSISR_DABR);
    eval 'sub DSISR_SEGMENT () {0x200000;}' unless defined(&DSISR_SEGMENT);
    eval 'sub DSISR_EAR () {0x100000;}' unless defined(&DSISR_EAR);
    eval 'sub SPR_DAR () {0x13;}' unless defined(&SPR_DAR);
    eval 'sub SPR_RTCU_W () {0x14;}' unless defined(&SPR_RTCU_W);
    eval 'sub SPR_RTCL_W () {0x15;}' unless defined(&SPR_RTCL_W);
    eval 'sub SPR_SDR1 () {0x19;}' unless defined(&SPR_SDR1);
    eval 'sub SPR_VRSAVE () {0x100;}' unless defined(&SPR_VRSAVE);
    eval 'sub SPR_SCOMC () {0x114;}' unless defined(&SPR_SCOMC);
    eval 'sub SPR_SCOMD () {0x115;}' unless defined(&SPR_SCOMD);
    eval 'sub SCOM_PCR () {0xaa00100;}' unless defined(&SCOM_PCR);
    eval 'sub SCOM_PCR_BIT () {0x80000000;}' unless defined(&SCOM_PCR_BIT);
    eval 'sub SCOM_PSR () {0x40800100;}' unless defined(&SCOM_PSR);
    eval 'sub PSR_RECEIVED () {(1 << 61);}' unless defined(&PSR_RECEIVED);
    eval 'sub PSR_COMPLETED () {(1 << 60);}' unless defined(&PSR_COMPLETED);
    eval 'sub SCOMC_READ () {0x8000;}' unless defined(&SCOMC_READ);
    eval 'sub SCOMC_WRITE () {0x;}' unless defined(&SCOMC_WRITE);
    eval 'sub SPR_ASR () {0x118;}' unless defined(&SPR_ASR);
    eval 'sub SPR_EAR () {0x11a;}' unless defined(&SPR_EAR);
    eval 'sub MPC601 () {0x1;}' unless defined(&MPC601);
    eval 'sub MPC603 () {0x3;}' unless defined(&MPC603);
    eval 'sub MPC604 () {0x4;}' unless defined(&MPC604);
    eval 'sub MPC602 () {0x5;}' unless defined(&MPC602);
    eval 'sub MPC603e () {0x6;}' unless defined(&MPC603e);
    eval 'sub MPC603ev () {0x7;}' unless defined(&MPC603ev);
    eval 'sub MPC750 () {0x8;}' unless defined(&MPC750);
    eval 'sub MPC604e () {0x9;}' unless defined(&MPC604e);
    eval 'sub MPC604ev () {0xa;}' unless defined(&MPC604ev);
    eval 'sub MPC7400 () {0xc;}' unless defined(&MPC7400);
    eval 'sub MPC620 () {0x14;}' unless defined(&MPC620);
    eval 'sub IBMRS64II () {0x33;}' unless defined(&IBMRS64II);
    eval 'sub IBMRS64IIIp () {0x34;}' unless defined(&IBMRS64IIIp);
    eval 'sub IBMPOWER4 () {0x35;}' unless defined(&IBMPOWER4);
    eval 'sub IBMRS64IIIi () {0x36;}' unless defined(&IBMRS64IIIi);
    eval 'sub IBMRS64IV () {0x37;}' unless defined(&IBMRS64IV);
    eval 'sub IBMPOWER4II () {0x38;}' unless defined(&IBMPOWER4II);
    eval 'sub IBM970 () {0x39;}' unless defined(&IBM970);
    eval 'sub IBMPOWER5GR () {0x3a;}' unless defined(&IBMPOWER5GR);
    eval 'sub IBMPOWER5GS () {0x3b;}' unless defined(&IBMPOWER5GS);
    eval 'sub IBM970FX () {0x3c;}' unless defined(&IBM970FX);
    eval 'sub IBMPOWER6 () {0x3e;}' unless defined(&IBMPOWER6);
    eval 'sub IBMPOWER3 () {0x40;}' unless defined(&IBMPOWER3);
    eval 'sub IBMPOWER3II () {0x41;}' unless defined(&IBMPOWER3II);
    eval 'sub IBM970MP () {0x44;}' unless defined(&IBM970MP);
    eval 'sub IBM970GX () {0x45;}' unless defined(&IBM970GX);
    eval 'sub IBMCELL () {0x70;}' unless defined(&IBMCELL);
    eval 'sub MPC8240 () {0x81;}' unless defined(&MPC8240);
    eval 'sub PA6T () {0x90;}' unless defined(&PA6T);
    eval 'sub IBMPOWER6P5 () {0xf00;}' unless defined(&IBMPOWER6P5);
    eval 'sub IBMSTB25 () {0x5151;}' unless defined(&IBMSTB25);
    eval 'sub IBM750FX () {0x7000;}' unless defined(&IBM750FX);
    eval 'sub IBM750GX () {0x7002;}' unless defined(&IBM750GX);
    eval 'sub MPC7450 () {0x8000;}' unless defined(&MPC7450);
    eval 'sub MPC7455 () {0x8001;}' unless defined(&MPC7455);
    eval 'sub MPC7457 () {0x8002;}' unless defined(&MPC7457);
    eval 'sub MPC7447A () {0x8003;}' unless defined(&MPC7447A);
    eval 'sub MPC7448 () {0x8004;}' unless defined(&MPC7448);
    eval 'sub MPC745X_P {
        my($v) = @_;
	    eval q((($v & 0xfff8) == 0x8000));
    }' unless defined(&MPC745X_P);
    eval 'sub MPC7410 () {0x800c;}' unless defined(&MPC7410);
    eval 'sub MPC5200 () {0x8011;}' unless defined(&MPC5200);
    eval 'sub MPC8245 () {0x8081;}' unless defined(&MPC8245);
    eval 'sub MPCG2 () {0x8082;}' unless defined(&MPCG2);
    eval 'sub MPCe300c1 () {0x8083;}' unless defined(&MPCe300c1);
    eval 'sub MPCe300c2 () {0x8084;}' unless defined(&MPCe300c2);
    eval 'sub MPCe300c3 () {0x8085;}' unless defined(&MPCe300c3);
    eval 'sub SPR_HIOR () {0x137;}' unless defined(&SPR_HIOR);
    eval 'sub SPR_IBAT0U () {0x210;}' unless defined(&SPR_IBAT0U);
    eval 'sub SPR_IBAT0L () {0x211;}' unless defined(&SPR_IBAT0L);
    eval 'sub SPR_IBAT1U () {0x212;}' unless defined(&SPR_IBAT1U);
    eval 'sub SPR_IBAT1L () {0x213;}' unless defined(&SPR_IBAT1L);
    eval 'sub SPR_IBAT2U () {0x214;}' unless defined(&SPR_IBAT2U);
    eval 'sub SPR_IBAT2L () {0x215;}' unless defined(&SPR_IBAT2L);
    eval 'sub SPR_IBAT3U () {0x216;}' unless defined(&SPR_IBAT3U);
    eval 'sub SPR_IBAT3L () {0x217;}' unless defined(&SPR_IBAT3L);
    eval 'sub SPR_DBAT0U () {0x218;}' unless defined(&SPR_DBAT0U);
    eval 'sub SPR_DBAT0L () {0x219;}' unless defined(&SPR_DBAT0L);
    eval 'sub SPR_DBAT1U () {0x21a;}' unless defined(&SPR_DBAT1U);
    eval 'sub SPR_DBAT1L () {0x21b;}' unless defined(&SPR_DBAT1L);
    eval 'sub SPR_DBAT2U () {0x21c;}' unless defined(&SPR_DBAT2U);
    eval 'sub SPR_DBAT2L () {0x21d;}' unless defined(&SPR_DBAT2L);
    eval 'sub SPR_DBAT3U () {0x21e;}' unless defined(&SPR_DBAT3U);
    eval 'sub SPR_DBAT3L () {0x21f;}' unless defined(&SPR_DBAT3L);
    eval 'sub SPR_IBAT4U () {0x230;}' unless defined(&SPR_IBAT4U);
    eval 'sub SPR_IBAT4L () {0x231;}' unless defined(&SPR_IBAT4L);
    eval 'sub SPR_IBAT5U () {0x232;}' unless defined(&SPR_IBAT5U);
    eval 'sub SPR_IBAT5L () {0x233;}' unless defined(&SPR_IBAT5L);
    eval 'sub SPR_IBAT6U () {0x234;}' unless defined(&SPR_IBAT6U);
    eval 'sub SPR_IBAT6L () {0x235;}' unless defined(&SPR_IBAT6L);
    eval 'sub SPR_IBAT7U () {0x236;}' unless defined(&SPR_IBAT7U);
    eval 'sub SPR_IBAT7L () {0x237;}' unless defined(&SPR_IBAT7L);
    eval 'sub SPR_DBAT4U () {0x238;}' unless defined(&SPR_DBAT4U);
    eval 'sub SPR_DBAT4L () {0x239;}' unless defined(&SPR_DBAT4L);
    eval 'sub SPR_DBAT5U () {0x23a;}' unless defined(&SPR_DBAT5U);
    eval 'sub SPR_DBAT5L () {0x23b;}' unless defined(&SPR_DBAT5L);
    eval 'sub SPR_DBAT6U () {0x23c;}' unless defined(&SPR_DBAT6U);
    eval 'sub SPR_DBAT6L () {0x23d;}' unless defined(&SPR_DBAT6L);
    eval 'sub SPR_DBAT7U () {0x23e;}' unless defined(&SPR_DBAT7U);
    eval 'sub SPR_DBAT7L () {0x23f;}' unless defined(&SPR_DBAT7L);
    eval 'sub SPR_UMMCR2 () {0x3a0;}' unless defined(&SPR_UMMCR2);
    eval 'sub SPR_UMMCR0 () {0x3a8;}' unless defined(&SPR_UMMCR0);
    eval 'sub SPR_USIA () {0x3ab;}' unless defined(&SPR_USIA);
    eval 'sub SPR_UMMCR1 () {0x3ac;}' unless defined(&SPR_UMMCR1);
    eval 'sub SPR_MMCR2 () {0x3b0;}' unless defined(&SPR_MMCR2);
    eval 'sub SPR_MMCR2_THRESHMULT_32 () {0x80000000;}' unless defined(&SPR_MMCR2_THRESHMULT_32);
    eval 'sub SPR_MMCR2_THRESHMULT_2 () {0x;}' unless defined(&SPR_MMCR2_THRESHMULT_2);
    eval 'sub SPR_PMC5 () {0x3b1;}' unless defined(&SPR_PMC5);
    eval 'sub SPR_PMC6 () {0x3b2;}' unless defined(&SPR_PMC6);
    eval 'sub SPR_MMCR0 () {0x3b8;}' unless defined(&SPR_MMCR0);
    eval 'sub MMCR0_FC () {0x80000000;}' unless defined(&MMCR0_FC);
    eval 'sub MMCR0_FCS () {0x40000000;}' unless defined(&MMCR0_FCS);
    eval 'sub MMCR0_FCP () {0x20000000;}' unless defined(&MMCR0_FCP);
    eval 'sub MMCR0_FCM1 () {0x10000000;}' unless defined(&MMCR0_FCM1);
    eval 'sub MMCR0_FCM0 () {0x8000000;}' unless defined(&MMCR0_FCM0);
    eval 'sub MMCR0_PMXE () {0x4000000;}' unless defined(&MMCR0_PMXE);
    eval 'sub MMCR0_FCECE () {0x2000000;}' unless defined(&MMCR0_FCECE);
    eval 'sub MMCR0_TBSEL_15 () {0x1800000;}' unless defined(&MMCR0_TBSEL_15);
    eval 'sub MMCR0_TBSEL_19 () {0x1000000;}' unless defined(&MMCR0_TBSEL_19);
    eval 'sub MMCR0_TBSEL_23 () {0x800000;}' unless defined(&MMCR0_TBSEL_23);
    eval 'sub MMCR0_TBSEL_31 () {0x;}' unless defined(&MMCR0_TBSEL_31);
    eval 'sub MMCR0_TBEE () {0x400000;}' unless defined(&MMCR0_TBEE);
    eval 'sub MMCRO_THRESHOLD {
        my($x) = @_;
	    eval q((($x) << 16));
    }' unless defined(&MMCRO_THRESHOLD);
    eval 'sub MMCR0_PMC1CE () {0x8000;}' unless defined(&MMCR0_PMC1CE);
    eval 'sub MMCR0_PMCNCE () {0x4000;}' unless defined(&MMCR0_PMCNCE);
    eval 'sub MMCR0_TRIGGER () {0x2000;}' unless defined(&MMCR0_TRIGGER);
    eval 'sub MMCR0_PMC1SEL {
        my($x) = @_;
	    eval q((($x) << 6));
    }' unless defined(&MMCR0_PMC1SEL);
    eval 'sub MMCR0_PMC2SEL {
        my($x) = @_;
	    eval q((($x) << 0));
    }' unless defined(&MMCR0_PMC2SEL);
    eval 'sub SPR_PMC1 () {0x3b9;}' unless defined(&SPR_PMC1);
    eval 'sub SPR_PMC2 () {0x3ba;}' unless defined(&SPR_PMC2);
    eval 'sub SPR_SIA () {0x3bb;}' unless defined(&SPR_SIA);
    eval 'sub SPR_MMCR1 () {0x3bc;}' unless defined(&SPR_MMCR1);
    eval 'sub MMCR1_PMC3SEL {
        my($x) = @_;
	    eval q((($x) << 27));
    }' unless defined(&MMCR1_PMC3SEL);
    eval 'sub MMCR1_PMC4SEL {
        my($x) = @_;
	    eval q((($x) << 22));
    }' unless defined(&MMCR1_PMC4SEL);
    eval 'sub MMCR1_PMC5SEL {
        my($x) = @_;
	    eval q((($x) << 17));
    }' unless defined(&MMCR1_PMC5SEL);
    eval 'sub MMCR1_PMC6SEL {
        my($x) = @_;
	    eval q((($x) << 11));
    }' unless defined(&MMCR1_PMC6SEL);
    eval 'sub SPR_PMC3 () {0x3bd;}' unless defined(&SPR_PMC3);
    eval 'sub SPR_PMC4 () {0x3be;}' unless defined(&SPR_PMC4);
    eval 'sub SPR_DMISS () {0x3d0;}' unless defined(&SPR_DMISS);
    eval 'sub SPR_DCMP () {0x3d1;}' unless defined(&SPR_DCMP);
    eval 'sub SPR_HASH1 () {0x3d2;}' unless defined(&SPR_HASH1);
    eval 'sub SPR_HASH2 () {0x3d3;}' unless defined(&SPR_HASH2);
    eval 'sub SPR_IMISS () {0x3d4;}' unless defined(&SPR_IMISS);
    eval 'sub SPR_TLBMISS () {0x3d4;}' unless defined(&SPR_TLBMISS);
    eval 'sub SPR_ICMP () {0x3d5;}' unless defined(&SPR_ICMP);
    eval 'sub SPR_PTEHI () {0x3d5;}' unless defined(&SPR_PTEHI);
    eval 'sub SPR_RPA () {0x3d6;}' unless defined(&SPR_RPA);
    eval 'sub SPR_PTELO () {0x3d6;}' unless defined(&SPR_PTELO);
    eval 'sub SPR_HID0 () {0x3f0;}' unless defined(&SPR_HID0);
    eval 'sub SPR_HID1 () {0x3f1;}' unless defined(&SPR_HID1);
    eval 'sub SPR_HID4 () {0x3f4;}' unless defined(&SPR_HID4);
    eval 'sub SPR_HID5 () {0x3f6;}' unless defined(&SPR_HID5);
    eval 'sub SPR_DABR () {0x3f5;}' unless defined(&SPR_DABR);
    eval 'sub SPR_MSSCR0 () {0x3f6;}' unless defined(&SPR_MSSCR0);
    eval 'sub MSSCR0_SHDEN () {0x80000000;}' unless defined(&MSSCR0_SHDEN);
    eval 'sub MSSCR0_SHDPEN3 () {0x40000000;}' unless defined(&MSSCR0_SHDPEN3);
    eval 'sub MSSCR0_L1INTVEN () {0x38000000;}' unless defined(&MSSCR0_L1INTVEN);
    eval 'sub MSSCR0_L2INTVEN () {0x7000000;}' unless defined(&MSSCR0_L2INTVEN);
    eval 'sub MSSCR0_DL1HWF () {0x800000;}' unless defined(&MSSCR0_DL1HWF);
    eval 'sub MSSCR0_MBO () {0x400000;}' unless defined(&MSSCR0_MBO);
    eval 'sub MSSCR0_EMODE () {0x200000;}' unless defined(&MSSCR0_EMODE);
    eval 'sub MSSCR0_ABD () {0x100000;}' unless defined(&MSSCR0_ABD);
    eval 'sub MSSCR0_BMODE () {0xc000;}' unless defined(&MSSCR0_BMODE);
    eval 'sub MSSCR0_ID () {0x40;}' unless defined(&MSSCR0_ID);
    eval 'sub MSSCR0_L2PFE () {0x3;}' unless defined(&MSSCR0_L2PFE);
    eval 'sub SPR_L2PM () {0x3f8;}' unless defined(&SPR_L2PM);
    eval 'sub SPR_L2CR () {0x3f9;}' unless defined(&SPR_L2CR);
    eval 'sub L2CR_L2E () {0x80000000;}' unless defined(&L2CR_L2E);
    eval 'sub L2CR_L2PE () {0x40000000;}' unless defined(&L2CR_L2PE);
    eval 'sub L2CR_L2SIZ () {0x30000000;}' unless defined(&L2CR_L2SIZ);
    eval 'sub L2SIZ_2M () {0x;}' unless defined(&L2SIZ_2M);
    eval 'sub L2SIZ_256K () {0x10000000;}' unless defined(&L2SIZ_256K);
    eval 'sub L2SIZ_512K () {0x20000000;}' unless defined(&L2SIZ_512K);
    eval 'sub L2SIZ_1M () {0x30000000;}' unless defined(&L2SIZ_1M);
    eval 'sub L2CR_L2CLK () {0xe000000;}' unless defined(&L2CR_L2CLK);
    eval 'sub L2CLK_DIS () {0x;}' unless defined(&L2CLK_DIS);
    eval 'sub L2CLK_10 () {0x2000000;}' unless defined(&L2CLK_10);
    eval 'sub L2CLK_15 () {0x4000000;}' unless defined(&L2CLK_15);
    eval 'sub L2CLK_35 () {0x6000000;}' unless defined(&L2CLK_35);
    eval 'sub L2CLK_20 () {0x8000000;}' unless defined(&L2CLK_20);
    eval 'sub L2CLK_25 () {0xa000000;}' unless defined(&L2CLK_25);
    eval 'sub L2CLK_30 () {0xc000000;}' unless defined(&L2CLK_30);
    eval 'sub L2CLK_40 () {0xe000000;}' unless defined(&L2CLK_40);
    eval 'sub L2CR_L2RAM () {0x1800000;}' unless defined(&L2CR_L2RAM);
    eval 'sub L2RAM_FLOWTHRU_BURST () {0x;}' unless defined(&L2RAM_FLOWTHRU_BURST);
    eval 'sub L2RAM_PIPELINE_BURST () {0x1000000;}' unless defined(&L2RAM_PIPELINE_BURST);
    eval 'sub L2RAM_PIPELINE_LATE () {0x1800000;}' unless defined(&L2RAM_PIPELINE_LATE);
    eval 'sub L2CR_L2DO () {0x400000;}' unless defined(&L2CR_L2DO);
    eval 'sub L2CR_L2I () {0x200000;}' unless defined(&L2CR_L2I);
    eval 'sub L2CR_L2CTL () {0x100000;}' unless defined(&L2CR_L2CTL);
    eval 'sub L2CR_L2WT () {0x80000;}' unless defined(&L2CR_L2WT);
    eval 'sub L2CR_L2TS () {0x40000;}' unless defined(&L2CR_L2TS);
    eval 'sub L2CR_L2OH () {0x30000;}' unless defined(&L2CR_L2OH);
    eval 'sub L2CR_L2SL () {0x8000;}' unless defined(&L2CR_L2SL);
    eval 'sub L2CR_L2DF () {0x4000;}' unless defined(&L2CR_L2DF);
    eval 'sub L2CR_L2BYP () {0x2000;}' unless defined(&L2CR_L2BYP);
    eval 'sub L2CR_L2FA () {0x1000;}' unless defined(&L2CR_L2FA);
    eval 'sub L2CR_L2HWF () {0x800;}' unless defined(&L2CR_L2HWF);
    eval 'sub L2CR_L2IO () {0x400;}' unless defined(&L2CR_L2IO);
    eval 'sub L2CR_L2CLKSTP () {0x200;}' unless defined(&L2CR_L2CLKSTP);
    eval 'sub L2CR_L2DRO () {0x100;}' unless defined(&L2CR_L2DRO);
    eval 'sub L2CR_L2IP () {0x1;}' unless defined(&L2CR_L2IP);
    eval 'sub SPR_L3CR () {0x3fa;}' unless defined(&SPR_L3CR);
    eval 'sub L3CR_RESERVED () {0x438003a;}' unless defined(&L3CR_RESERVED);
    eval 'sub L3CR_L3E () {0x80000000;}' unless defined(&L3CR_L3E);
    eval 'sub L3CR_L3PE () {0x40000000;}' unless defined(&L3CR_L3PE);
    eval 'sub L3CR_L3APE () {0x20000000;}' unless defined(&L3CR_L3APE);
    eval 'sub L3CR_L3SIZ () {0x10000000;}' unless defined(&L3CR_L3SIZ);
    eval 'sub L3SIZ_1M () {0x;}' unless defined(&L3SIZ_1M);
    eval 'sub L3SIZ_2M () {0x10000000;}' unless defined(&L3SIZ_2M);
    eval 'sub L3CR_L3CLKEN () {0x8000000;}' unless defined(&L3CR_L3CLKEN);
    eval 'sub L3CR_L3CLK () {0x3800000;}' unless defined(&L3CR_L3CLK);
    eval 'sub L3CLK_60 () {0x;}' unless defined(&L3CLK_60);
    eval 'sub L3CLK_20 () {0x1000000;}' unless defined(&L3CLK_20);
    eval 'sub L3CLK_25 () {0x1800000;}' unless defined(&L3CLK_25);
    eval 'sub L3CLK_30 () {0x2000000;}' unless defined(&L3CLK_30);
    eval 'sub L3CLK_35 () {0x2800000;}' unless defined(&L3CLK_35);
    eval 'sub L3CLK_40 () {0x3000000;}' unless defined(&L3CLK_40);
    eval 'sub L3CLK_50 () {0x3800000;}' unless defined(&L3CLK_50);
    eval 'sub L3CR_L3IO () {0x400000;}' unless defined(&L3CR_L3IO);
    eval 'sub L3CR_L3SPO () {0x40000;}' unless defined(&L3CR_L3SPO);
    eval 'sub L3CR_L3CKSP () {0x30000;}' unless defined(&L3CR_L3CKSP);
    eval 'sub L3CKSP_2 () {0x;}' unless defined(&L3CKSP_2);
    eval 'sub L3CKSP_3 () {0x10000;}' unless defined(&L3CKSP_3);
    eval 'sub L3CKSP_4 () {0x20000;}' unless defined(&L3CKSP_4);
    eval 'sub L3CKSP_5 () {0x30000;}' unless defined(&L3CKSP_5);
    eval 'sub L3CR_L3PSP () {0xe000;}' unless defined(&L3CR_L3PSP);
    eval 'sub L3PSP_0 () {0x;}' unless defined(&L3PSP_0);
    eval 'sub L3PSP_1 () {0x2000;}' unless defined(&L3PSP_1);
    eval 'sub L3PSP_2 () {0x4000;}' unless defined(&L3PSP_2);
    eval 'sub L3PSP_3 () {0x6000;}' unless defined(&L3PSP_3);
    eval 'sub L3PSP_4 () {0x8000;}' unless defined(&L3PSP_4);
    eval 'sub L3PSP_5 () {0xa000;}' unless defined(&L3PSP_5);
    eval 'sub L3CR_L3REP () {0x1000;}' unless defined(&L3CR_L3REP);
    eval 'sub L3CR_L3HWF () {0x800;}' unless defined(&L3CR_L3HWF);
    eval 'sub L3CR_L3I () {0x400;}' unless defined(&L3CR_L3I);
    eval 'sub L3CR_L3RT () {0x300;}' unless defined(&L3CR_L3RT);
    eval 'sub L3RT_MSUG2_DDR () {0x;}' unless defined(&L3RT_MSUG2_DDR);
    eval 'sub L3RT_PIPELINE_LATE () {0x100;}' unless defined(&L3RT_PIPELINE_LATE);
    eval 'sub L3RT_PB2_SRAM () {0x300;}' unless defined(&L3RT_PB2_SRAM);
    eval 'sub L3CR_L3NIRCA () {0x80;}' unless defined(&L3CR_L3NIRCA);
    eval 'sub L3CR_L3DO () {0x40;}' unless defined(&L3CR_L3DO);
    eval 'sub L3CR_PMEN () {0x4;}' unless defined(&L3CR_PMEN);
    eval 'sub L3CR_PMSIZ () {0x4;}' unless defined(&L3CR_PMSIZ);
    eval 'sub SPR_ICTC () {0x3fb;}' unless defined(&SPR_ICTC);
    eval 'sub ICTC_ENABLE () {0x1;}' unless defined(&ICTC_ENABLE);
    eval 'sub ICTC_COUNT_M () {0x1fe;}' unless defined(&ICTC_COUNT_M);
    eval 'sub SPR_THRM1 () {0x3fc;}' unless defined(&SPR_THRM1);
    eval 'sub SPR_THRM2 () {0x3fd;}' unless defined(&SPR_THRM2);
    eval 'sub SPR_THRM_TIN () {0x80000000;}' unless defined(&SPR_THRM_TIN);
    eval 'sub SPR_THRM_TIV () {0x40000000;}' unless defined(&SPR_THRM_TIV);
    eval 'sub SPR_THRM_THRESHOLD {
        my($x) = @_;
	    eval q((($x) << 23));
    }' unless defined(&SPR_THRM_THRESHOLD);
    eval 'sub SPR_THRM_TID () {0x4;}' unless defined(&SPR_THRM_TID);
    eval 'sub SPR_THRM_TIE () {0x2;}' unless defined(&SPR_THRM_TIE);
    eval 'sub SPR_THRM_VALID () {0x1;}' unless defined(&SPR_THRM_VALID);
    eval 'sub SPR_THRM3 () {0x3fe;}' unless defined(&SPR_THRM3);
    eval 'sub SPR_THRM_TIMER {
        my($x) = @_;
	    eval q((($x) << 1));
    }' unless defined(&SPR_THRM_TIMER);
    eval 'sub SPR_THRM_ENABLE () {0x1;}' unless defined(&SPR_THRM_ENABLE);
    eval 'sub SPR_FPECR () {0x3fe;}' unless defined(&SPR_FPECR);
    eval 'sub SPR_PIR () {0x3ff;}' unless defined(&SPR_PIR);
    eval 'sub PMC_OVERFLOW () {0x80000000;}' unless defined(&PMC_OVERFLOW);
    eval 'sub PMCN_NONE () {0;}' unless defined(&PMCN_NONE);
    eval 'sub PMCN_CYCLES () {1;}' unless defined(&PMCN_CYCLES);
    eval 'sub PMCN_ICOMP () {2;}' unless defined(&PMCN_ICOMP);
    eval 'sub PMCN_TBLTRANS () {3;}' unless defined(&PMCN_TBLTRANS);
    eval 'sub PCMN_IDISPATCH () {4;}' unless defined(&PCMN_IDISPATCH);
    if(!defined(&_LOCORE)  && defined(&_KERNEL)) {
	if(defined(&PPC_OEA64_BRIDGE) || defined (&_ARCH_PPC64)) {
	    eval 'sub scom_read {
	        my($address) = @_;
    		eval q({  &register_t  &msr;  &uint64_t  &ret;  &msr =  &mfmsr();  &mtmsr( &msr & ~ &PSL_EE);  &__asm  &volatile(\\"isync;\\");  &mtspr( &SPR_SCOMC, $address |  &SCOMC_READ);  &__asm  &volatile(\\"isync;\\");  &ret =  &mfspr( &SPR_SCOMD);  &mtmsr( &msr);  &__asm  &volatile(\\"isync;\\");  &ret; });
	    }' unless defined(&scom_read);
	    eval 'sub scom_write {
	        my($address,$data) = @_;
    		eval q({  &register_t  &msr;  &msr =  &mfmsr();  &mtmsr( &msr & ~ &PSL_EE);  &__asm  &volatile(\\"isync;\\");  &mtspr( &SPR_SCOMD, $data);  &__asm  &volatile(\\"isync;\\");  &mtspr( &SPR_SCOMC, $address |  &SCOMC_WRITE);  &__asm  &volatile(\\"isync;\\");  &mtmsr( &msr);  &__asm  &volatile(\\"isync;\\"); });
	    }' unless defined(&scom_write);
	}
    }
}
1;
