# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

from typing_extensions import Literal, Required, TypedDict

__all__ = ["DNSSECEditParams"]


class DNSSECEditParams(TypedDict, total=False):
    zone_id: Required[str]
    """Identifier"""

    dnssec_multi_signer: bool
    """
    If true, multi-signer DNSSEC is enabled on the zone, allowing multiple providers
    to serve a DNSSEC-signed zone at the same time. This is required for DNSKEY
    records (except those automatically generated by Cloudflare) to be added to the
    zone.

    See
    [Multi-signer DNSSEC](https://developers.cloudflare.com/dns/dnssec/multi-signer-dnssec/)
    for details.
    """

    dnssec_presigned: bool
    """
    If true, allows Cloudflare to transfer in a DNSSEC-signed zone including
    signatures from an external provider, without requiring Cloudflare to sign any
    records on the fly.

    Note that this feature has some limitations. See
    [Cloudflare as Secondary](https://developers.cloudflare.com/dns/zone-setups/zone-transfers/cloudflare-as-secondary/setup/#dnssec)
    for details.
    """

    status: Literal["active", "disabled"]
    """
    Status of DNSSEC, based on user-desired state and presence of necessary records.
    """
