import sys
from .cformat import cformat


def cprint(*values, **params):
    """Print values with styles and colors.
    """
    sep = params.pop('sep', ' ')
    end = params.pop('end', '\n')
    file = params.pop('file', sys.stdout)
    flush = params.pop('file', False)
    string = sep.join(map(str, values))
    formatted_string = cformat(string, **params)
    print(formatted_string, sep='', end=end, file=file, flush=flush)
