/*
 * Decompiled with CFR 0.152.
 */
package net.bluecow.spectro;

import java.text.DecimalFormat;

class FFT {
    private FFT() {
    }

    public static double[][] fft_1d(double[][] array) {
        double t_i;
        double t_r;
        int i;
        int n = array.length;
        int ln = (int)(Math.log(n) / Math.log(2.0) + 0.5);
        int nv2 = n / 2;
        int j = 1;
        for (i = 1; i < n; ++i) {
            int k;
            if (i < j) {
                t_r = array[i - 1][0];
                t_i = array[i - 1][1];
                array[i - 1][0] = array[j - 1][0];
                array[i - 1][1] = array[j - 1][1];
                array[j - 1][0] = t_r;
                array[j - 1][1] = t_i;
            }
            for (k = nv2; k < j; j -= k, k /= 2) {
            }
            j += k;
        }
        for (int l = 1; l <= ln; ++l) {
            int le = (int)(Math.exp((double)l * Math.log(2.0)) + 0.5);
            int le1 = le / 2;
            double u_r = 1.0;
            double u_i = 0.0;
            double w_r = Math.cos(Math.PI / (double)le1);
            double w_i = -Math.sin(Math.PI / (double)le1);
            for (j = 1; j <= le1; ++j) {
                for (i = j; i <= n; i += le) {
                    int ip = i + le1;
                    t_r = array[ip - 1][0] * u_r - u_i * array[ip - 1][1];
                    t_i = array[ip - 1][1] * u_r + u_i * array[ip - 1][0];
                    array[ip - 1][0] = array[i - 1][0] - t_r;
                    array[ip - 1][1] = array[i - 1][1] - t_i;
                    array[i - 1][0] = array[i - 1][0] + t_r;
                    array[i - 1][1] = array[i - 1][1] + t_i;
                }
                t_r = u_r * w_r - w_i * u_i;
                u_i = w_r * u_i + w_i * u_r;
                u_r = t_r;
            }
        }
        return array;
    }

    public static void main(String[] args) throws NumberFormatException {
        double[][] fftBuf = new double[args.length][2];
        for (int i = 0; i < args.length; ++i) {
            fftBuf[i][0] = Double.parseDouble(args[i]);
            fftBuf[i][1] = 0.0;
        }
        FFT.printArray(fftBuf);
        FFT.fft_1d(fftBuf);
        FFT.printArray(fftBuf);
        FFT.fft_1d(fftBuf);
        FFT.scaleArray(fftBuf, 1.0 / (double)fftBuf.length);
        FFT.reverseArray(fftBuf);
        FFT.printArray(fftBuf);
    }

    public static void printArray(double[][] fftBuf) {
        DecimalFormat real = new DecimalFormat("0.000000000");
        real.setPositivePrefix(" ");
        DecimalFormat imag = new DecimalFormat("0.000000000");
        imag.setNegativePrefix(" - ");
        imag.setPositivePrefix(" + ");
        System.out.println("{");
        for (int i = 0; i < fftBuf.length; ++i) {
            System.out.print(" (");
            System.out.print(real.format(fftBuf[i][0]));
            System.out.print(imag.format(fftBuf[i][1]));
            System.out.println("i)");
        }
        System.out.println("}");
    }

    public static void scaleArray(double[][] fftBuf, double scalar) {
        for (int i = 0; i < fftBuf.length; ++i) {
            double[] dArray = fftBuf[i];
            dArray[0] = dArray[0] * scalar;
            double[] dArray2 = fftBuf[i];
            dArray2[1] = dArray2[1] * scalar;
        }
    }

    public static void reverseArray(double[][] fftBuf) {
        int n = fftBuf.length;
        for (int i = 1; i < n / 2; ++i) {
            double[] temp = fftBuf[i];
            fftBuf[i] = fftBuf[n - i];
            fftBuf[n - i] = temp;
        }
    }
}

