/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarException;

public class Manifest
implements Cloneable {
    private static final byte[] CRLF = new byte[]{13, 10};
    private final Attributes mainAttr;
    private final Map entries;

    public Attributes getMainAttributes() {
        return this.mainAttr;
    }

    public Map getEntries() {
        return this.entries;
    }

    public Attributes getAttributes(String string) {
        return (Attributes)this.getEntries().get(string);
    }

    public void clear() {
        this.mainAttr.clear();
        this.entries.clear();
    }

    public void read(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        Manifest.read_main_section(this.getMainAttributes(), bufferedReader);
        Manifest.read_individual_sections(this.getEntries(), bufferedReader);
    }

    private static final void read_main_section(Attributes attributes, BufferedReader bufferedReader) throws IOException {
        Manifest.read_attributes(attributes, bufferedReader);
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.putValue(Attributes.Name.MANIFEST_VERSION, "0.0");
        }
    }

    private static final void read_version_info(Attributes attributes, BufferedReader bufferedReader) throws IOException {
        String string = Attributes.Name.MANIFEST_VERSION.toString();
        try {
            String string2 = Manifest.expect_header(string, bufferedReader);
            attributes.putValue(Attributes.Name.MANIFEST_VERSION, string2);
        }
        catch (IOException iOException) {
            throw new JarException("Manifest should start with a " + string + ": " + iOException.getMessage());
        }
    }

    private static final String expect_header(String string, BufferedReader bufferedReader) throws IOException {
        String string2 = bufferedReader.readLine();
        if (string2 == null) {
            throw new JarException("unexpected end of file");
        }
        return Manifest.expect_header(string, bufferedReader, string2);
    }

    private static final String expect_header(String string, BufferedReader bufferedReader, String string2) throws IOException {
        try {
            String string3 = string2.substring(0, string.length() + 1);
            if (string3.equalsIgnoreCase(string + ':')) {
                String string4 = string2.substring(string.length() + 2);
                return Manifest.read_header_value(string4, bufferedReader);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        throw new JarException("unexpected '" + string2 + '\'');
    }

    private static final String read_header_value(String string, BufferedReader bufferedReader) throws IOException {
        boolean bl = true;
        while (bl) {
            bufferedReader.mark(1);
            if (bufferedReader.read() == 32) {
                string = string + bufferedReader.readLine();
                continue;
            }
            bufferedReader.reset();
            bl = false;
        }
        return string;
    }

    private static final void read_attributes(Attributes attributes, BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("")) {
            Manifest.read_attribute(attributes, string, bufferedReader);
            string = bufferedReader.readLine();
        }
    }

    private static final void read_attribute(Attributes attributes, String string, BufferedReader bufferedReader) throws IOException {
        try {
            int n = string.indexOf(": ");
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 2);
            String string4 = Manifest.read_header_value(string3, bufferedReader);
            attributes.putValue(string2, string4);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new JarException("Manifest contains a bad header: " + string);
        }
    }

    private static final void read_individual_sections(Map map, BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null && !string.equals("")) {
            Attributes attributes = Manifest.read_section_name(string, bufferedReader, map);
            Manifest.read_attributes(attributes, bufferedReader);
            string = bufferedReader.readLine();
        }
    }

    private static final Attributes read_section_name(String string, BufferedReader bufferedReader, Map map) throws JarException {
        try {
            String string2 = Manifest.expect_header("Name", bufferedReader, string);
            Attributes attributes = new Attributes();
            map.put(string2, attributes);
            return attributes;
        }
        catch (IOException iOException) {
            throw new JarException("Section should start with a Name header: " + iOException.getMessage());
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        BufferedOutputStream bufferedOutputStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream, 4096);
        Manifest.write_main_section(this.getMainAttributes(), bufferedOutputStream);
        bufferedOutputStream.write(CRLF);
        Manifest.write_individual_sections(this.getEntries(), bufferedOutputStream);
        bufferedOutputStream.flush();
    }

    private static final void write_main_section(Attributes attributes, OutputStream outputStream) throws IOException {
        Manifest.write_version_info(attributes, outputStream);
        Manifest.write_main_attributes(attributes, outputStream);
    }

    private static final void write_version_info(Attributes attributes, OutputStream outputStream) throws IOException {
        String string = attributes.getValue(Attributes.Name.MANIFEST_VERSION);
        if (string == null) {
            string = "1.0";
        }
        Manifest.write_header(Attributes.Name.MANIFEST_VERSION.toString(), string, outputStream);
    }

    private static final void write_header(String string, String string2, OutputStream outputStream) throws IOException {
        String string3 = string + ": ";
        byte[] byArray = string3.getBytes("UTF-8");
        if (byArray.length > 72) {
            throw new IOException("Attribute's name already longer than 70 bytes");
        }
        if (byArray.length == 72) {
            outputStream.write(byArray);
            outputStream.write(CRLF);
            string3 = " " + string2;
        } else {
            string3 = string3 + string2;
        }
        while (true) {
            if ((byArray = string3.getBytes("UTF-8")).length < 73) break;
            int n = 72;
            while ((byArray = string3.substring(0, n).getBytes("UTF-8")).length >= 73) {
                if (--n >= 1) continue;
                throw new IOException("Header is unbreakable and longer than 72 bytes");
            }
            outputStream.write(byArray);
            outputStream.write(CRLF);
            string3 = " " + string3.substring(n);
        }
        outputStream.write(byArray);
        outputStream.write(CRLF);
    }

    private static final void write_main_attributes(Attributes attributes, OutputStream outputStream) throws IOException {
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (Attributes.Name.MANIFEST_VERSION.equals(entry.getKey())) continue;
            Manifest.write_attribute_entry(entry, outputStream);
        }
    }

    private static final void write_attribute_entry(Map.Entry entry, OutputStream outputStream) throws IOException {
        String string = entry.getKey().toString();
        String string2 = entry.getValue().toString();
        if (string.equalsIgnoreCase("Name")) {
            throw new JarException("Attributes cannot be called 'Name'");
        }
        if (string.startsWith("From")) {
            throw new JarException("Header cannot start with the four letters 'From'" + string);
        }
        Manifest.write_header(string, string2, outputStream);
    }

    private static final void write_individual_sections(Map map, OutputStream outputStream) throws IOException {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Manifest.write_header("Name", entry.getKey().toString(), outputStream);
            Manifest.write_entry_attributes((Attributes)entry.getValue(), outputStream);
            outputStream.write(CRLF);
        }
    }

    private static final void write_entry_attributes(Attributes attributes, OutputStream outputStream) throws IOException {
        Iterator iterator = attributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Manifest.write_attribute_entry(entry, outputStream);
        }
    }

    public Object clone() {
        return new Manifest(this);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Manifest && this.mainAttr.equals(((Manifest)object).mainAttr) && this.entries.equals(((Manifest)object).entries)) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.mainAttr.hashCode() ^ this.entries.hashCode();
    }

    public Manifest() {
        this.mainAttr = new Attributes();
        this.entries = new Hashtable();
    }

    public Manifest(InputStream inputStream) throws IOException {
        this();
        this.read(inputStream);
    }

    public Manifest(Manifest manifest) {
        this.mainAttr = new Attributes(manifest.getMainAttributes());
        this.entries = new Hashtable(manifest.getEntries());
    }
}

