/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ComponentInputMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class KeyboardManager {
    static KeyboardManager manager = new KeyboardManager();
    Hashtable topLevelLookup;
    Hashtable menuBarLookup;

    public static KeyboardManager getManager() {
        return manager;
    }

    static Container findTopLevel(Component component) {
        Container container = component instanceof Container ? (Container)component : component.getParent();
        while (!(container == null || container instanceof Window || container instanceof Applet || container instanceof JInternalFrame)) {
            container = container.getParent();
        }
        return container;
    }

    Hashtable getHashtableForTopLevel(Container container) {
        Hashtable hashtable = (Hashtable)this.topLevelLookup.get(container);
        if (hashtable == null) {
            hashtable = new Hashtable();
            this.topLevelLookup.put(container, hashtable);
        }
        return hashtable;
    }

    public void registerBinding(JComponent jComponent, KeyStroke keyStroke) {
        Container container = KeyboardManager.findTopLevel(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.getHashtableForTopLevel(container);
        hashtable.put(keyStroke, jComponent);
    }

    public void clearBindingsForComp(JComponent jComponent) {
        Container container = KeyboardManager.findTopLevel(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.getHashtableForTopLevel(container);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (jComponent != (JComponent)hashtable.get(object)) continue;
            hashtable.remove(object);
        }
    }

    public void registerEntireMap(ComponentInputMap componentInputMap) {
        if (componentInputMap == null) {
            return;
        }
        JComponent jComponent = componentInputMap.getComponent();
        KeyStroke[] keyStrokeArray = componentInputMap.keys();
        if (keyStrokeArray == null) {
            return;
        }
        Container container = KeyboardManager.findTopLevel(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.getHashtableForTopLevel(container);
        int n = 0;
        while (n < keyStrokeArray.length) {
            hashtable.put(keyStrokeArray[n], jComponent);
            ++n;
        }
    }

    public boolean processKeyStroke(Component component, KeyStroke keyStroke, KeyEvent keyEvent) {
        Container container;
        boolean bl;
        boolean bl2 = false;
        if (keyEvent.getID() == 401) {
            bl2 = bl = true;
        }
        if ((container = KeyboardManager.findTopLevel(component)) == null) {
            return false;
        }
        Hashtable hashtable = this.getHashtableForTopLevel(container);
        Enumeration enumeration = hashtable.keys();
        JComponent jComponent = (JComponent)hashtable.get(keyStroke);
        if (jComponent != null && jComponent.processKeyBinding(keyStroke, keyEvent, 2, bl)) {
            return true;
        }
        Vector vector = this.getVectorForTopLevel(container);
        int n = 0;
        while (n < vector.size()) {
            if (((JMenuBar)vector.elementAt(n)).processKeyBinding(keyStroke, keyEvent, 2, bl)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    Vector getVectorForTopLevel(Container container) {
        Vector vector = (Vector)this.menuBarLookup.get(container);
        if (vector == null) {
            vector = new Vector();
            this.menuBarLookup.put(container, vector);
        }
        return vector;
    }

    public void registerJMenuBar(JMenuBar jMenuBar) {
        Container container = KeyboardManager.findTopLevel(jMenuBar);
        Vector vector = this.getVectorForTopLevel(container);
        if (!vector.contains(jMenuBar)) {
            vector.add(jMenuBar);
        }
    }

    public void unregisterJMenuBar(JMenuBar jMenuBar) {
        Container container = KeyboardManager.findTopLevel(jMenuBar);
        Vector vector = this.getVectorForTopLevel(container);
        if (vector.contains(jMenuBar)) {
            vector.remove(jMenuBar);
        }
    }

    private final /* synthetic */ void this() {
        this.topLevelLookup = new Hashtable();
        this.menuBarLookup = new Hashtable();
    }

    KeyboardManager() {
        this.this();
    }
}

