/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.file;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.file.TAudioFileFormat;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class AuAudioFileReader
extends TAudioFileReader {
    private static final int READ_LIMIT = 1000;

    /*
     * Unable to fully structure code
     */
    private static final String readDescription(DataInputStream var0, int var1_1) throws IOException {
        var2_2 = -1;
        var3_3 = "";
        if (true) ** GOTO lbl7
        do {
            var3_3 = var3_3 + (char)var2_2;
            --var1_1;
lbl7:
            // 2 sources

            if (var1_1 <= 0) break;
            v0 = var0.readByte();
            var2_2 = v0;
        } while (v0 != 0);
        if (var1_1 > 1 && var2_2 == 0) {
            var0.skip(var1_1 - 1);
        }
        return var3_3;
    }

    protected AudioFileFormat getAudioFileFormat(InputStream inputStream, long l) throws UnsupportedAudioFileException, IOException {
        DataInputStream dataInputStream;
        int n;
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AuAudioFileReader.getAudioFileFormat(InputStream, long): begin");
        }
        if ((n = (dataInputStream = new DataInputStream(inputStream)).readInt()) != 779316836) {
            throw new UnsupportedAudioFileException("not an AU file: wrong header magic");
        }
        int n2 = dataInputStream.readInt();
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AuAudioFileReader.getAudioFileFormat(): data offset: " + n2);
        }
        if (n2 < 24) {
            throw new UnsupportedAudioFileException("not an AU file: data offset must be 24 or greater");
        }
        int n3 = dataInputStream.readInt();
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AuAudioFileReader.getAudioFileFormat(): data length: " + n3);
        }
        if (n3 < 0 && n3 != -1) {
            throw new UnsupportedAudioFileException("not an AU file: data length must be positive, 0 or -1 for unknown");
        }
        AudioFormat.Encoding encoding = null;
        int n4 = 0;
        int n5 = dataInputStream.readInt();
        switch (n5) {
            case 1: {
                encoding = AudioFormat.Encoding.ULAW;
                n4 = 8;
                break;
            }
            case 2: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                n4 = 8;
                break;
            }
            case 3: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                n4 = 16;
                break;
            }
            case 4: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                n4 = 24;
                break;
            }
            case 5: {
                encoding = AudioFormat.Encoding.PCM_SIGNED;
                n4 = 32;
                break;
            }
            case 27: {
                encoding = AudioFormat.Encoding.ALAW;
                n4 = 8;
                break;
            }
        }
        if (n4 == 0) {
            throw new UnsupportedAudioFileException("unsupported AU file: unknown encoding " + n5);
        }
        int n6 = dataInputStream.readInt();
        if (n6 <= 0) {
            throw new UnsupportedAudioFileException("corrupt AU file: sample rate must be positive");
        }
        int n7 = dataInputStream.readInt();
        if (n7 <= 0) {
            throw new UnsupportedAudioFileException("corrupt AU file: number of channels must be positive");
        }
        inputStream.skip(n2 - 24);
        AudioFormat audioFormat = new AudioFormat(encoding, n6, n4, n7, AuAudioFileReader.calculateFrameSize(n4, n7), n6, true);
        TAudioFileFormat tAudioFileFormat = new TAudioFileFormat(AudioFileFormat.Type.AU, audioFormat, n3 == -1 ? -1 : n3 / audioFormat.getFrameSize(), n3 == -1 ? -1 : n3 + n2);
        if (TDebug.TraceAudioFileReader) {
            TDebug.out("AuAudioFileReader.getAudioFileFormat(InputStream, long): begin");
        }
        return tAudioFileFormat;
    }

    public AuAudioFileReader() {
        super(1000);
    }
}

