/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import blbutil.BitList;
import java.util.stream.IntStream;
import vcf.GTRec;
import vcf.Marker;
import vcf.Samples;
import vcf.VcfRecGTParser;

public final class BitSetGTRec
implements GTRec {
    private final int bitsPerAllele;
    private final Marker marker;
    private final Samples samples;
    private final boolean isPhased;
    private final BitList isMissing;
    private final BitList alleles;

    public BitSetGTRec(VcfRecGTParser vcfRecGTParser) {
        int n = vcfRecGTParser.samples().size();
        int n2 = n << 1;
        this.bitsPerAllele = vcfRecGTParser.marker().bitsPerAllele();
        this.marker = vcfRecGTParser.marker();
        this.samples = vcfRecGTParser.samples();
        BitList bitList = new BitList(n2 * this.bitsPerAllele);
        BitList bitList2 = new BitList(n);
        this.isPhased = vcfRecGTParser.storeAlleles(bitList, bitList2);
        this.isMissing = bitList2;
        this.alleles = bitList;
    }

    public BitSetGTRec(VcfRecGTParser.HapListRep hapListRep) {
        int n = hapListRep.samples().size();
        int n2 = n << 1;
        this.bitsPerAllele = hapListRep.marker().bitsPerAllele();
        this.marker = hapListRep.marker();
        this.samples = hapListRep.samples();
        this.isPhased = hapListRep.isPhased();
        this.isMissing = new BitList(n);
        this.alleles = new BitList(n2 * this.bitsPerAllele);
        boolean bl = false;
        int[][] nArray = hapListRep.hapLists(bl);
        int[] nArray2 = hapListRep.missingSamples();
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray3;
            for (int n3 : nArray3 = nArray[i]) {
                BitSetGTRec.storeAllele(this.alleles, n3, this.bitsPerAllele, i);
            }
        }
        for (int n4 : nArray2) {
            this.isMissing.set(n4);
        }
    }

    private static void storeAllele(BitList bitList, int n, int n2, int n3) {
        int n4 = n * n2;
        int n5 = 1;
        for (int i = 0; i < n2; ++i) {
            if ((n3 & n5) == n5) {
                bitList.set(n4);
            }
            ++n4;
            n5 <<= 1;
        }
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int size() {
        return 2 * this.samples.size();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isPhased() {
        return this.isPhased;
    }

    @Override
    public boolean isPhased(int n) {
        return this.isPhased;
    }

    @Override
    public int allele1(int n) {
        return this.isMissing.get(n) ? -1 : this.allele(n << 1);
    }

    @Override
    public int allele2(int n) {
        return this.isMissing.get(n) ? -1 : this.allele(n << 1 | 1);
    }

    @Override
    public int get(int n) {
        return this.isMissing.get(n >> 1) ? -1 : this.allele(n);
    }

    private int allele(int n) {
        int n2 = this.bitsPerAllele * n;
        int n3 = n2 + this.bitsPerAllele;
        int n4 = 0;
        int n5 = 1;
        for (int i = n2; i < n3; ++i) {
            if (this.alleles.get(i)) {
                n4 += n5;
            }
            n5 <<= 1;
        }
        return n4;
    }

    @Override
    public int[] alleles() {
        return IntStream.range(0, this.size()).map(n -> this.get(n)).toArray();
    }

    public String toString() {
        return GTRec.toVcfRec(this);
    }
}

