/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.security.auth.login;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class ConfigFileTokenizer {
    private static final boolean DEBUG = false;
    public static final int TT_EOF = -1;
    public static final int TT_WORD = -3;
    private static final int TT_NONE = -4;
    public String sval;
    public int ttype;
    private BufferedReader br;
    boolean initialised;
    private StringBuffer sb;
    private int sbNdx;

    private static final void debug(String string) {
    }

    public int nextToken() throws IOException {
        if (!this.initialised) {
            this.init();
        }
        if (this.sbNdx >= this.sb.length()) {
            return -1;
        }
        this.skipWhitespace();
        if (this.sbNdx >= this.sb.length()) {
            return -1;
        }
        if (Character.isJavaIdentifierPart(this.sb.charAt(this.sbNdx))) {
            int n = this.sbNdx + 1;
            while (Character.isJavaIdentifierPart(this.sb.charAt(n)) || this.sb.charAt(n) == '.') {
                ++n;
            }
            this.ttype = -3;
            this.sval = this.sb.substring(this.sbNdx, n);
            this.sbNdx = n;
            return this.ttype;
        }
        char c = this.sb.charAt(this.sbNdx);
        if (c == '{' || c == '}' || c == ';' || c == '=') {
            this.ttype = c;
            ++this.sbNdx;
            return this.ttype;
        }
        if (c == '\"' || c == '\'') {
            int n;
            this.ttype = c;
            String string = this.sb.substring(this.sbNdx, this.sbNdx + 1);
            int n2 = this.sbNdx + 1;
            while (true) {
                if ((n = this.sb.indexOf(string, n2)) == -1) {
                    this.abort("Missing closing quote: " + string);
                }
                if (this.sb.charAt(n - 1) != '\\') break;
                ++n2;
            }
            this.sval = this.sb.substring(this.sbNdx, ++n);
            this.sbNdx = n;
            return this.ttype;
        }
        this.abort("Unknown character: " + this.sb.charAt(this.sbNdx));
        return Integer.MIN_VALUE;
    }

    public void pushBack() {
        int n = 1;
        if (this.ttype == -3) {
            n = this.sval.length();
        }
        this.sbNdx -= n;
    }

    private final void init() throws IOException {
        String string;
        this.sb = new StringBuffer();
        while ((string = this.br.readLine()) != null) {
            if ((string = string.trim()).length() == 0 || string.startsWith("#") || string.startsWith("//")) continue;
            this.sb.append(string).append(" ");
        }
        this.sbNdx = 0;
        this.sval = null;
        this.ttype = -4;
        this.initialised = true;
    }

    private final void skipWhitespace() throws IOException {
        while (this.sbNdx < this.sb.length()) {
            if (Character.isWhitespace(this.sb.charAt(this.sbNdx))) {
                ++this.sbNdx;
                while (this.sbNdx < this.sb.length() && Character.isWhitespace(this.sb.charAt(this.sbNdx))) {
                    ++this.sbNdx;
                }
                continue;
            }
            if (this.sb.charAt(this.sbNdx) != '/' || this.sb.charAt(this.sbNdx + 1) != '*') break;
            int n = this.sb.indexOf("*/", this.sbNdx + 2);
            if (n == -1) {
                this.abort("Missing closing */ sequence");
            }
            this.sbNdx = n + 2;
        }
    }

    private final void abort(String string) throws IOException {
        ConfigFileTokenizer.debug("DEBUG: " + string);
        ConfigFileTokenizer.debug("DEBUG: sb = " + this.sb);
        ConfigFileTokenizer.debug("DEBUG: sbNdx = " + this.sbNdx);
        throw new IOException(string);
    }

    ConfigFileTokenizer(Reader reader) {
        this.br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.initialised = false;
    }
}

