/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;
import org.xbill.DNS.WireParseException;

public class LOCRecord
extends Record {
    private static NumberFormat w2 = new DecimalFormat();
    private static NumberFormat w3;
    private long size;
    private long hPrecision;
    private long vPrecision;
    private long latitude;
    private long longitude;
    private long altitude;

    Record getObject() {
        return new LOCRecord();
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        int n = dNSInput.readU8();
        if (n != 0) {
            throw new WireParseException("Invalid LOC version");
        }
        this.size = LOCRecord.parseLOCformat(dNSInput.readU8());
        this.hPrecision = LOCRecord.parseLOCformat(dNSInput.readU8());
        this.vPrecision = LOCRecord.parseLOCformat(dNSInput.readU8());
        this.latitude = dNSInput.readU32();
        this.longitude = dNSInput.readU32();
        this.altitude = dNSInput.readU32();
    }

    private final long parsePosition(Tokenizer tokenizer, String string) throws IOException {
        boolean bl = string.equals("latitude");
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        n = tokenizer.getUInt16();
        if (n > 180 || n > 90 && bl) {
            throw tokenizer.exception("Invalid LOC " + string + " degrees");
        }
        String string2 = tokenizer.getString();
        try {
            n2 = Integer.parseInt(string2);
            if (n2 < 0 || n2 > 59) {
                throw tokenizer.exception("Invalid LOC " + string + " minutes");
            }
            string2 = tokenizer.getString();
            d = Double.parseDouble(string2);
            if (d < 0.0 || d >= 60.0) {
                throw tokenizer.exception("Invalid LOC " + string + " seconds");
            }
            string2 = tokenizer.getString();
        }
        catch (NumberFormatException numberFormatException) {}
        if (string2.length() != 1) {
            throw tokenizer.exception("Invalid LOC " + string);
        }
        long l = (long)(1000.0 * (d + (double)(60L * ((long)n2 + 60L * (long)n))));
        char c = Character.toUpperCase(string2.charAt(0));
        if (bl && c == 'S' || !bl && c == 'W') {
            l = -l;
        } else if (bl && c != 'N' || !bl && c != 'E') {
            throw tokenizer.exception("Invalid LOC " + string);
        }
        return l += 0x80000000L;
    }

    private final long parseDouble(Tokenizer tokenizer, String string, boolean bl, long l, long l2, long l3) throws IOException {
        Tokenizer.Token token = tokenizer.get();
        if (token.isEOL()) {
            if (bl) {
                throw tokenizer.exception("Invalid LOC " + string);
            }
            tokenizer.unget();
            return l3;
        }
        String string2 = token.value;
        if (string2.length() > 1 && string2.charAt(string2.length() - 1) == 'm') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        try {
            long l4 = (long)(100.0 * new Double(string2));
            if (l4 < l || l4 > l2) {
                throw tokenizer.exception("Invalid LOC " + string);
            }
            return l4;
        }
        catch (NumberFormatException numberFormatException) {
            throw tokenizer.exception("Invalid LOC " + string);
        }
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        Object var3_3 = null;
        this.latitude = this.parsePosition(tokenizer, "latitude");
        this.longitude = this.parsePosition(tokenizer, "longitude");
        this.altitude = this.parseDouble(tokenizer, "altitude", true, -10000000L, 4284967295L, 0L) + 10000000L;
        this.size = this.parseDouble(tokenizer, "size", false, 0L, 9000000000L, 100L);
        this.hPrecision = this.parseDouble(tokenizer, "horizontal precision", false, 0L, 9000000000L, 1000000L);
        this.vPrecision = this.parseDouble(tokenizer, "vertical precision", false, 0L, 9000000000L, 1000L);
    }

    private final String positionToString(long l, char c, char c2) {
        char c3;
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = l - 0x80000000L;
        if (l2 < 0L) {
            l2 = -l2;
            c3 = c2;
        } else {
            c3 = c;
        }
        stringBuffer.append(l2 / 3600000L);
        stringBuffer.append(" ");
        stringBuffer.append((l2 %= 3600000L) / 60000L);
        stringBuffer.append(" ");
        stringBuffer.append(w3.format((double)(l2 %= 60000L) / 1000.0));
        stringBuffer.append(" ");
        stringBuffer.append(c3);
        return stringBuffer.toString();
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.positionToString(this.latitude, 'N', 'S'));
        stringBuffer.append(" ");
        stringBuffer.append(this.positionToString(this.longitude, 'E', 'W'));
        stringBuffer.append(" ");
        stringBuffer.append(w2.format((double)(this.altitude - 10000000L) / 100.0));
        stringBuffer.append("m ");
        stringBuffer.append(w2.format((double)this.size / 100.0));
        stringBuffer.append("m ");
        stringBuffer.append(w2.format((double)this.hPrecision / 100.0));
        stringBuffer.append("m ");
        stringBuffer.append(w2.format((double)this.vPrecision / 100.0));
        stringBuffer.append("m");
        return stringBuffer.toString();
    }

    public double getLatitude() {
        return (double)(this.latitude - 0x80000000L) / 3600000.0;
    }

    public double getLongitude() {
        return (double)(this.longitude - 0x80000000L) / 3600000.0;
    }

    public double getAltitude() {
        return (double)(this.altitude - 10000000L) / 100.0;
    }

    public double getSize() {
        return (double)this.size / 100.0;
    }

    public double getHPrecision() {
        return (double)this.hPrecision / 100.0;
    }

    public double getVPrecision() {
        return (double)this.vPrecision / 100.0;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeU8(0);
        dNSOutput.writeU8(this.toLOCformat(this.size));
        dNSOutput.writeU8(this.toLOCformat(this.hPrecision));
        dNSOutput.writeU8(this.toLOCformat(this.vPrecision));
        dNSOutput.writeU32(this.latitude);
        dNSOutput.writeU32(this.longitude);
        dNSOutput.writeU32(this.altitude);
    }

    /*
     * Unable to fully structure code
     */
    private static final long parseLOCformat(int var0) throws WireParseException {
        var1_1 = var0 >> 4;
        var3_2 = var0 & 15;
        if (var1_1 <= 9L && var3_2 <= 9) ** GOTO lbl6
        throw new WireParseException("Invalid LOC Encoding");
lbl-1000:
        // 1 sources

        {
            var1_1 *= 10L;
lbl6:
            // 2 sources

            ** while (var3_2-- > 0)
        }
lbl7:
        // 1 sources

        return var1_1;
    }

    private final byte toLOCformat(long l) {
        int n = 0;
        while (l > 9L) {
            n = (byte)(n + 1);
            l = (l + (long)5) / 10L;
        }
        return (byte)((l << 4) + (long)n);
    }

    LOCRecord() {
    }

    public LOCRecord(Name name, int n, long l, double d, double d2, double d3, double d4, double d5, double d6) {
        super(name, 29, n, l);
        this.latitude = (long)(d * 3600.0 * 1000.0 + 2.147483648E9);
        this.longitude = (long)(d2 * 3600.0 * 1000.0 + 2.147483648E9);
        this.altitude = (long)((d3 + 100000.0) * 100.0);
        this.size = (long)(d4 * 100.0);
        this.hPrecision = (long)(d5 * 100.0);
        this.vPrecision = (long)(d6 * 100.0);
    }

    static {
        w2.setMaximumFractionDigits(2);
        w2.setGroupingUsed(false);
        w3 = new DecimalFormat();
        w3.setMaximumFractionDigits(3);
        w3.setGroupingUsed(false);
    }
}

