/*
 * Decompiled with CFR 0.152.
 */
package free.util;

import java.io.IOException;
import java.io.OutputStream;

public class MultiOutputStream
extends OutputStream {
    private final OutputStream[] streams;

    public MultiOutputStream(OutputStream outputStream, OutputStream outputStream2) {
        this(new OutputStream[]{outputStream, outputStream2});
    }

    public MultiOutputStream(OutputStream[] outputStreamArray) {
        int n;
        if (outputStreamArray == null) {
            throw new IllegalArgumentException("Specified array may not be null");
        }
        int n2 = 0;
        for (n = 0; n < outputStreamArray.length; ++n) {
            if (outputStreamArray[n] == null) continue;
            ++n2;
        }
        this.streams = new OutputStream[n2];
        n2 = 0;
        for (n = 0; n < outputStreamArray.length; ++n) {
            OutputStream outputStream = outputStreamArray[n];
            if (outputStream == null) continue;
            this.streams[n2++] = outputStream;
        }
    }

    public void close() throws IOException {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i].close();
        }
    }

    public void flush() throws IOException {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i].flush();
        }
    }

    public void write(int n) throws IOException {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i].write(n);
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < this.streams.length; ++i) {
            this.streams[i].write(byArray, n, n2);
        }
    }
}

