/*
 * Decompiled with CFR 0.152.
 */
package free.jin.console;

import free.chess.Player;
import free.jin.HistoryListItem;
import free.jin.I18n;
import free.jin.LibListItem;
import free.jin.SearchListItem;
import free.jin.StoredListItem;
import free.jin.event.GameListEvent;
import free.util.UnsupportedOperationException;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class GameListTableModel
implements TableModel {
    private final String[][] tableData;
    private final String[] columnNames;

    public GameListTableModel(GameListEvent gameListEvent) {
        I18n i18n = I18n.get((Class)GameListTableModel.class);
        int n = gameListEvent.getID();
        int n2 = gameListEvent.getItemCount();
        String string = i18n.getString("ratedGameIndicator");
        String string2 = i18n.getString("unratedGameIndicator");
        if (n == 1) {
            this.tableData = new String[n2][12];
            for (int i = 0; i < n2; ++i) {
                HistoryListItem historyListItem = (HistoryListItem)gameListEvent.getItem(i);
                Player player = historyListItem.getPlayer();
                this.tableData[i][0] = String.valueOf(historyListItem.getIndex());
                this.tableData[i][1] = this.getHistoryResultCodeString(historyListItem.getResultStatus(), player);
                this.tableData[i][2] = String.valueOf(player.isWhite() ? historyListItem.getWhiteRating() : historyListItem.getBlackRating());
                this.tableData[i][3] = player.toString().substring(0, 1);
                this.tableData[i][4] = String.valueOf(player.isWhite() ? historyListItem.getBlackRating() : historyListItem.getWhiteRating());
                this.tableData[i][5] = player.isWhite() ? historyListItem.getBlackName() : historyListItem.getWhiteName();
                this.tableData[i][6] = this.getTCString(historyListItem.getVariantName(), historyListItem.getWhiteTime(), historyListItem.getWhiteInc(), historyListItem.getBlackTime(), historyListItem.getBlackInc());
                this.tableData[i][7] = historyListItem.isRated() ? string : string2;
                this.tableData[i][8] = historyListItem.getRatingCategoryName();
                this.tableData[i][9] = historyListItem.getECO();
                this.tableData[i][10] = historyListItem.getEndExplanationString();
                this.tableData[i][11] = historyListItem.getDateString() + " " + historyListItem.getTimeString();
            }
            this.columnNames = new String[]{i18n.getString("rowIndexColumn"), i18n.getString("resultColumn"), i18n.getString("ratingColumn"), i18n.getString("colorColumn"), i18n.getString("oppRatingColumn"), i18n.getString("oppColumn"), i18n.getString("timeControlsColumn"), i18n.getString("ratedColumn"), i18n.getString("categoryColumn"), i18n.getString("ecoColumn"), i18n.getString("endExplanationColumn"), i18n.getString("gameStartDateColumn")};
        } else if (n == 2) {
            this.tableData = new String[n2][11];
            for (int i = 0; i < n2; ++i) {
                SearchListItem searchListItem = (SearchListItem)gameListEvent.getItem(i);
                this.tableData[i][0] = String.valueOf(searchListItem.getIndex());
                this.tableData[i][1] = searchListItem.getWhiteName();
                this.tableData[i][2] = searchListItem.getWhiteRating() == -1 ? "?" : String.valueOf(searchListItem.getWhiteRating());
                this.tableData[i][3] = searchListItem.getBlackName();
                this.tableData[i][4] = searchListItem.getBlackRating() == -1 ? "?" : String.valueOf(searchListItem.getBlackRating());
                this.tableData[i][5] = searchListItem.getEndExplanationString();
                this.tableData[i][6] = this.getTCString(searchListItem.getVariantName(), searchListItem.getWhiteTime(), searchListItem.getWhiteInc(), searchListItem.getBlackTime(), searchListItem.getBlackInc());
                this.tableData[i][7] = searchListItem.isRated() ? string : string2;
                this.tableData[i][8] = searchListItem.getRatingCategoryName();
                this.tableData[i][9] = searchListItem.getECO();
                this.tableData[i][10] = searchListItem.getDateString() + " " + searchListItem.getTimeString();
            }
            this.columnNames = new String[]{i18n.getString("rowIndexColumn"), i18n.getString("whitePlayerColumn"), i18n.getString("ratingColumn"), i18n.getString("blackPlayerColumn"), i18n.getString("ratingColumn"), i18n.getString("resultColumn"), i18n.getString("timeControlsColumn"), i18n.getString("ratedColumn"), i18n.getString("categoryColumn"), i18n.getString("ecoColumn"), i18n.getString("gameStartDateColumn")};
        } else if (n == 3) {
            this.tableData = new String[n2][12];
            for (int i = 0; i < n2; ++i) {
                LibListItem libListItem = (LibListItem)gameListEvent.getItem(i);
                this.tableData[i][0] = String.valueOf(libListItem.getIndex());
                this.tableData[i][1] = libListItem.getWhiteName();
                this.tableData[i][2] = libListItem.getWhiteRating() == -1 ? "?" : String.valueOf(libListItem.getWhiteRating());
                this.tableData[i][3] = libListItem.getBlackName();
                this.tableData[i][4] = libListItem.getBlackRating() == -1 ? "?" : String.valueOf(libListItem.getBlackRating());
                this.tableData[i][5] = libListItem.getEndExplanationString();
                this.tableData[i][6] = this.getTCString(libListItem.getVariantName(), libListItem.getWhiteTime(), libListItem.getWhiteInc(), libListItem.getBlackTime(), libListItem.getBlackInc());
                this.tableData[i][7] = libListItem.isRated() ? string : string2;
                this.tableData[i][8] = libListItem.getRatingCategoryName();
                this.tableData[i][9] = libListItem.getECO();
                this.tableData[i][10] = libListItem.getDateString() + " " + libListItem.getTimeString();
                this.tableData[i][11] = libListItem.getNote();
            }
            this.columnNames = new String[]{i18n.getString("rowIndexColumn"), i18n.getString("whitePlayerColumn"), i18n.getString("ratingColumn"), i18n.getString("blackPlayerColumn"), i18n.getString("ratingColumn"), i18n.getString("resultColumn"), i18n.getString("timeControlsColumn"), i18n.getString("ratedColumn"), i18n.getString("categoryColumn"), i18n.getString("ecoColumn"), i18n.getString("gameStartDateColumn"), i18n.getString("noteColumn")};
        } else if (n == 4) {
            this.tableData = new String[n2][11];
            String string3 = i18n.getString("oppPresentIndicator");
            String string4 = i18n.getString("oppAbsentIndicator");
            for (int i = 0; i < n2; ++i) {
                StoredListItem storedListItem = (StoredListItem)gameListEvent.getItem(i);
                Player player = storedListItem.getPlayer();
                this.tableData[i][0] = storedListItem.isOpponentPresent() ? string3 : string4;
                this.tableData[i][1] = String.valueOf(player.isWhite() ? storedListItem.getWhiteRating() : storedListItem.getBlackRating());
                this.tableData[i][2] = player.toString().substring(0, 1);
                this.tableData[i][3] = String.valueOf(player.isWhite() ? storedListItem.getBlackRating() : storedListItem.getWhiteRating());
                this.tableData[i][4] = player.isWhite() ? storedListItem.getBlackName() : storedListItem.getWhiteName();
                this.tableData[i][5] = this.getTCString(storedListItem.getVariantName(), storedListItem.getWhiteTime(), storedListItem.getWhiteInc(), storedListItem.getBlackTime(), storedListItem.getBlackInc());
                this.tableData[i][6] = storedListItem.isRated() ? string : string2;
                this.tableData[i][7] = storedListItem.getRatingCategoryName();
                this.tableData[i][8] = storedListItem.getECO();
                this.tableData[i][9] = storedListItem.getDateString() + " " + storedListItem.getTimeString();
                this.tableData[i][10] = storedListItem.getAdjournmentReason();
            }
            this.columnNames = new String[]{i18n.getString("oppPresentColumn"), i18n.getString("ratingColumn"), i18n.getString("colorColumn"), i18n.getString("oppRatingColumn"), i18n.getString("oppColumn"), i18n.getString("timeControlsColumn"), i18n.getString("ratedColumn"), i18n.getString("categoryColumn"), i18n.getString("ecoColumn"), i18n.getString("gameStartDateColumn"), i18n.getString("adjournmentReasonColumn")};
        } else {
            throw new IllegalArgumentException("Unknown GameListEvent ID encountered");
        }
    }

    protected String getHistoryResultCodeString(int n, Player player) {
        switch (n) {
            case 0: {
                if (player.isWhite()) {
                    return "+";
                }
                return "-";
            }
            case 1: {
                if (player.isBlack()) {
                    return "+";
                }
                return "-";
            }
            case 2: {
                return "=";
            }
            case 4: {
                return "a";
            }
        }
        throw new IllegalArgumentException("Illegal result code encountered");
    }

    protected String getTCString(String string, int n, int n2, int n3, int n4) {
        if (n == n3 && n2 == n4) {
            return "" + n / 60000 + " " + n2 / 1000 + " " + string;
        }
        return "" + n / 60000 + " " + n2 / 1000 + " : " + n3 / 60000 + " " + n4 / 1000 + " " + string;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public int getRowCount() {
        return this.tableData.length;
    }

    public Object getValueAt(int n, int n2) {
        return this.tableData[n][n2];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        throw new UnsupportedOperationException("Changing the values of this table is not supported");
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
    }
}

