/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.sound.midi.dssi;

import gnu.javax.sound.midi.dssi.DSSIMidiDeviceProvider;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.SoundbankResource;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.VoiceStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DSSISynthesizer
implements Synthesizer {
    long sohandle;
    long handle;
    private MidiDevice.Info info;
    MidiChannel[] channels;
    List soundbanks;
    DSSISoundbank defaultSoundbank;

    static native void noteOn_(long var0, int var2, int var3, int var4);

    static native void noteOff_(long var0, int var2, int var3, int var4);

    static native void setPolyPressure_(long var0, int var2, int var3, int var4);

    static native int getPolyPressure_(long var0, int var2, int var3);

    static native void controlChange_(long var0, int var2, int var3, int var4);

    static native void open_(long var0);

    static native void close_(long var0);

    static native String getProgramName_(long var0, int var2);

    static native int getProgramBank_(long var0, int var2);

    static native int getProgramProgram_(long var0, int var2);

    static native void selectProgram_(long var0, int var2, int var3);

    public int getMaxPolyphony() {
        return 0;
    }

    public long getLatency() {
        return 0L;
    }

    public MidiChannel[] getChannels() {
        return this.channels;
    }

    public VoiceStatus[] getVoiceStatus() {
        return null;
    }

    public boolean isSoundbankSupported(Soundbank soundbank) {
        return false;
    }

    public boolean loadInstrument(Instrument instrument) {
        if (instrument.getSoundbank() != this.defaultSoundbank) {
            throw new IllegalArgumentException("Synthesizer doesn't support this instrument's soundbank");
        }
        Patch patch = instrument.getPatch();
        DSSISynthesizer.selectProgram_(this.sohandle, patch.getBank(), patch.getProgram());
        return true;
    }

    public void unloadInstrument(Instrument instrument) {
    }

    public boolean remapInstrument(Instrument instrument, Instrument instrument2) {
        return false;
    }

    public Soundbank getDefaultSoundbank() {
        return this.defaultSoundbank;
    }

    public Instrument[] getAvailableInstruments() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.soundbanks.iterator();
        while (iterator.hasNext()) {
            Soundbank soundbank = (Soundbank)iterator.next();
            Instrument[] instrumentArray = soundbank.getInstruments();
            int n = 0;
            while (n < instrumentArray.length) {
                arrayList.add(instrumentArray[n]);
                ++n;
            }
        }
        return (Instrument[])arrayList.toArray(new Instrument[arrayList.size()]);
    }

    public Instrument[] getLoadedInstruments() {
        return null;
    }

    public boolean loadAllInstruments(Soundbank soundbank) {
        return false;
    }

    public void unloadAllInstruments(Soundbank soundbank) {
    }

    public boolean loadInstruments(Soundbank soundbank, Patch[] patchArray) {
        return false;
    }

    public void unloadInstruments(Soundbank soundbank, Patch[] patchArray) {
    }

    public MidiDevice.Info getDeviceInfo() {
        return this.info;
    }

    public void open() throws MidiUnavailableException {
        DSSISynthesizer.open_(this.sohandle);
    }

    public void close() {
        DSSISynthesizer.close_(this.sohandle);
    }

    public boolean isOpen() {
        return false;
    }

    public long getMicrosecondPosition() {
        return 0L;
    }

    public int getMaxReceivers() {
        return 1;
    }

    public int getMaxTransmitters() {
        return 0;
    }

    public Receiver getReceiver() throws MidiUnavailableException {
        return new DSSIReceiver();
    }

    public Transmitter getTransmitter() throws MidiUnavailableException {
        return null;
    }

    private final /* synthetic */ void this() {
        this.channels = new MidiChannel[16];
        this.soundbanks = new ArrayList();
    }

    public DSSISynthesizer(MidiDevice.Info info, String string, long l) {
        String string2;
        this.this();
        this.info = info;
        this.sohandle = DSSIMidiDeviceProvider.dlopen_(string);
        this.handle = DSSIMidiDeviceProvider.getDSSIHandle_(this.sohandle, l);
        this.channels[0] = new DSSIMidiChannel(0);
        this.defaultSoundbank = new DSSISoundbank("name", "description", "vendor", "version");
        this.soundbanks.add(this.defaultSoundbank);
        int n = 0;
        do {
            if ((string2 = DSSISynthesizer.getProgramName_(this.sohandle, n)) == null) continue;
            this.defaultSoundbank.add(new DSSIInstrument(this.defaultSoundbank, new Patch(DSSISynthesizer.getProgramBank_(this.sohandle, n), DSSISynthesizer.getProgramProgram_(this.sohandle, n)), string2));
            ++n;
        } while (string2 != null);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DSSIReceiver
    implements Receiver {
        public void send(MidiMessage midiMessage, long l) throws IllegalStateException {
            if (midiMessage instanceof ShortMessage) {
                ShortMessage shortMessage = (ShortMessage)midiMessage;
                switch (midiMessage.getStatus()) {
                    case 144: {
                        int n = shortMessage.getData2();
                        if (n > 0) {
                            DSSISynthesizer.this.channels[shortMessage.getChannel()].noteOn(shortMessage.getData1(), shortMessage.getData2());
                            break;
                        }
                        DSSISynthesizer.this.channels[shortMessage.getChannel()].noteOff(shortMessage.getData1());
                        break;
                    }
                    case 176: {
                        DSSISynthesizer.this.channels[shortMessage.getChannel()].controlChange(shortMessage.getData1(), shortMessage.getData2());
                        break;
                    }
                    default: {
                        System.out.println("Unhandled message: " + midiMessage.getStatus());
                    }
                }
            }
        }

        public void close() {
        }

        DSSIReceiver() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DSSIMidiChannel
    implements MidiChannel {
        int channel;

        public void noteOn(int n, int n2) {
            DSSISynthesizer.noteOn_(DSSISynthesizer.this.sohandle, this.channel, n, n2);
        }

        public void noteOff(int n, int n2) {
            DSSISynthesizer.noteOff_(DSSISynthesizer.this.sohandle, this.channel, n, n2);
        }

        public void noteOff(int n) {
            DSSISynthesizer.noteOff_(DSSISynthesizer.this.sohandle, this.channel, n, -1);
        }

        public void setPolyPressure(int n, int n2) {
            DSSISynthesizer.setPolyPressure_(DSSISynthesizer.this.sohandle, this.channel, n, n2);
        }

        public int getPolyPressure(int n) {
            return DSSISynthesizer.getPolyPressure_(DSSISynthesizer.this.sohandle, this.channel, n);
        }

        public void setChannelPressure(int n) {
        }

        public int getChannelPressure() {
            return 0;
        }

        public void controlChange(int n, int n2) {
            DSSISynthesizer.controlChange_(DSSISynthesizer.this.sohandle, this.channel, n, n2);
        }

        public int getController(int n) {
            return 0;
        }

        public void programChange(int n) {
        }

        public void programChange(int n, int n2) {
        }

        public int getProgram() {
            return 0;
        }

        public void setPitchBend(int n) {
        }

        public int getPitchBend() {
            return 0;
        }

        public void resetAllControllers() {
        }

        public void allNotesOff() {
        }

        public void allSoundOff() {
        }

        public boolean localControl(boolean bl) {
            return false;
        }

        public void setMono(boolean bl) {
        }

        public boolean getMono() {
            return false;
        }

        public void setOmni(boolean bl) {
        }

        public boolean getOmni() {
            return false;
        }

        public void setMute(boolean bl) {
        }

        public boolean getMute() {
            return false;
        }

        public void setSolo(boolean bl) {
        }

        public boolean getSolo() {
            return false;
        }

        private final /* synthetic */ void this() {
            this.channel = 0;
        }

        public DSSIMidiChannel(int n) {
            this.this();
            this.channel = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DSSISoundbank
    implements Soundbank {
        private String name;
        private String description;
        private List instruments;
        private List resources;
        private String vendor;
        private String version;

        void add(Instrument instrument) {
            this.instruments.add(instrument);
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getDescription() {
            return this.description;
        }

        public SoundbankResource[] getResources() {
            return (SoundbankResource[])this.resources.toArray(new SoundbankResource[this.resources.size()]);
        }

        public Instrument[] getInstruments() {
            return (Instrument[])this.instruments.toArray(new Instrument[this.instruments.size()]);
        }

        public Instrument getInstrument(Patch patch) {
            Iterator iterator = this.instruments.iterator();
            while (iterator.hasNext()) {
                Instrument instrument = (Instrument)iterator.next();
                if (!instrument.getPatch().equals(patch)) continue;
                return instrument;
            }
            return null;
        }

        private final /* synthetic */ void this() {
            this.instruments = new ArrayList();
            this.resources = new ArrayList();
        }

        public DSSISoundbank(String string, String string2, String string3, String string4) {
            this.this();
            this.name = string;
            this.description = string2;
            this.vendor = string3;
            this.version = string4;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DSSIInstrument
    extends Instrument {
        public Object getData() {
            return null;
        }

        DSSIInstrument(Soundbank soundbank, Patch patch, String string) {
            super(soundbank, patch, string, null);
        }
    }
}

