/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class NULLRecord
extends Record {
    private byte[] data;

    Record getObject() {
        return new NULLRecord();
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.data = dNSInput.readByteArray();
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        throw tokenizer.exception("no defined text format for NULL records");
    }

    String rrToString() {
        return NULLRecord.unknownToString(this.data);
    }

    public byte[] getData() {
        return this.data;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        dNSOutput.writeByteArray(this.data);
    }

    NULLRecord() {
    }

    public NULLRecord(Name name, int n, long l, byte[] byArray) {
        super(name, 10, n, l);
        if (byArray.length > (char)-1) {
            throw new IllegalArgumentException("data must be <65536 bytes");
        }
        this.data = byArray;
    }
}

