require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_UVM_UVM_PAGE_H_)) {
    eval 'sub _UVM_UVM_PAGE_H_ () {1;}' unless defined(&_UVM_UVM_PAGE_H_);
    require 'uvm/uvm_extern.ph';
    require 'uvm/uvm_pglist.ph';
    require 'sys/rbtree.ph';
    if(defined(&__HAVE_VM_PAGE_MD)) {
    }
    if(defined(&UVM_PAGE_TRKOWN)) {
    }
    eval 'sub PG_BUSY () {0x1;}' unless defined(&PG_BUSY);
    eval 'sub PG_WANTED () {0x2;}' unless defined(&PG_WANTED);
    eval 'sub PG_TABLED () {0x4;}' unless defined(&PG_TABLED);
    eval 'sub PG_CLEAN () {0x8;}' unless defined(&PG_CLEAN);
    eval 'sub PG_PAGEOUT () {0x10;}' unless defined(&PG_PAGEOUT);
    eval 'sub PG_RELEASED () {0x20;}' unless defined(&PG_RELEASED);
    eval 'sub PG_FAKE () {0x40;}' unless defined(&PG_FAKE);
    eval 'sub PG_RDONLY () {0x80;}' unless defined(&PG_RDONLY);
    eval 'sub PG_ZERO () {0x100;}' unless defined(&PG_ZERO);
    eval 'sub PG_MARKER () {0x200;}' unless defined(&PG_MARKER);
    eval 'sub PG_PAGER1 () {0x1000;}' unless defined(&PG_PAGER1);
    eval 'sub UVM_PGFLAGBITS () {"\\20\\1BUSY\\2WANTED\\3TABLED\\4CLEAN\\5PAGEOUT\\6RELEASED\\7FAKE\\10RDONLY" "\\11ZERO\\12MARKER\\15PAGER1";}' unless defined(&UVM_PGFLAGBITS);
    eval 'sub PQ_FREE () {0x1;}' unless defined(&PQ_FREE);
    eval 'sub PQ_ANON () {0x2;}' unless defined(&PQ_ANON);
    eval 'sub PQ_AOBJ () {0x4;}' unless defined(&PQ_AOBJ);
    eval 'sub PQ_SWAPBACKED () {( &PQ_ANON| &PQ_AOBJ);}' unless defined(&PQ_SWAPBACKED);
    eval 'sub PQ_READAHEAD () {0x8;}' unless defined(&PQ_READAHEAD);
    eval 'sub PQ_PRIVATE1 () {0x100;}' unless defined(&PQ_PRIVATE1);
    eval 'sub PQ_PRIVATE2 () {0x200;}' unless defined(&PQ_PRIVATE2);
    eval 'sub PQ_PRIVATE3 () {0x400;}' unless defined(&PQ_PRIVATE3);
    eval 'sub PQ_PRIVATE4 () {0x800;}' unless defined(&PQ_PRIVATE4);
    eval 'sub PQ_PRIVATE5 () {0x1000;}' unless defined(&PQ_PRIVATE5);
    eval 'sub PQ_PRIVATE6 () {0x2000;}' unless defined(&PQ_PRIVATE6);
    eval 'sub PQ_PRIVATE7 () {0x4000;}' unless defined(&PQ_PRIVATE7);
    eval 'sub PQ_PRIVATE8 () {0x8000;}' unless defined(&PQ_PRIVATE8);
    eval 'sub UVM_PQFLAGBITS () {"\\20\\1FREE\\2ANON\\3AOBJ\\4READAHEAD" "\\11PRIVATE1\\12PRIVATE2\\13PRIVATE3\\14PRIVATE4" "\\15PRIVATE5\\16PRIVATE6\\17PRIVATE7\\20PRIVATE8";}' unless defined(&UVM_PQFLAGBITS);
    eval 'sub VM_PSTRAT_RANDOM () {1;}' unless defined(&VM_PSTRAT_RANDOM);
    eval 'sub VM_PSTRAT_BSEARCH () {2;}' unless defined(&VM_PSTRAT_BSEARCH);
    eval 'sub VM_PSTRAT_BIGFIRST () {3;}' unless defined(&VM_PSTRAT_BIGFIRST);
    if(defined(&_KERNEL)) {
	if(defined(&UVM_PAGE_TRKOWN)) {
	}
	if(!defined(&PMAP_STEAL_MEMORY)) {
	}
	if(defined(&PMAP_DIRECT)) {
	}
	eval 'sub UVM_PAGE_TREE_PENALTY () {4;}' unless defined(&UVM_PAGE_TREE_PENALTY);
	eval 'sub VM_PAGE_TO_PHYS {
	    my($entry) = @_;
    	    eval q( &uvm_vm_page_to_phys($entry));
	}' unless defined(&VM_PAGE_TO_PHYS);
	if(defined(&__HAVE_VM_PAGE_MD)) {
	    eval 'sub VM_PAGE_TO_MD {
	        my($pg) = @_;
    		eval q((($pg)-> &mdpage));
	    }' unless defined(&VM_PAGE_TO_MD);
	}
	eval 'sub VM_PGCOLOR_BUCKET {
	    my($pg) = @_;
    	    eval q(( &atop( &VM_PAGE_TO_PHYS(($pg))) &  ($uvmexp->{colormask})));
	}' unless defined(&VM_PGCOLOR_BUCKET);
	eval 'sub PHYS_TO_VM_PAGE {
	    my($pa) = @_;
    	    eval q( &uvm_phys_to_vm_page($pa));
	}' unless defined(&PHYS_TO_VM_PAGE);
	eval 'sub VM_PAGE_IS_FREE {
	    my($entry) = @_;
    	    eval q((($entry)-> &pqflags &  &PQ_FREE));
	}' unless defined(&VM_PAGE_IS_FREE);
	eval 'sub VM_FREE_PAGE_TO_CPU {
	    my($pg) = @_;
    	    eval q(((( &uintptr_t) ($pg->{offset}))));
	}' unless defined(&VM_FREE_PAGE_TO_CPU);
	if(defined(&DEBUG)) {
	}
    }
}
1;
