/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.signature;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0004J\u0013\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00028\u0000\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H\u0014J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020+H\u0014J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020-H\u0014J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020/H\u0014J\u0010\u00100\u001a\u00020\u001f2\u0006\u0010(\u001a\u000201H\u0014J\u0010\u00102\u001a\u00020\u001f2\u0006\u0010(\u001a\u000203H\u0014J\u0010\u00104\u001a\u00020\u001f2\u0006\u0010(\u001a\u000205H\u0014J\u0010\u00106\u001a\u00020\u001f2\u0006\u0010(\u001a\u000207H\u0014J\b\u00108\u001a\u00020\u001fH\u0004J\u0010\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020;H\u0004J\u0010\u0010<\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020;H\u0004R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\nX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0013\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureBuilder;", "D", "", "()V", "classFqnSegments", "", "", "getClassFqnSegments", "()Ljava/util/List;", "hashId", "", "getHashId", "()Ljava/lang/Long;", "setHashId", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "hashIdAcc", "getHashIdAcc", "setHashIdAcc", "mask", "getMask", "()J", "setMask", "(J)V", "packageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "setPackageFqn", "(Lorg/jetbrains/kotlin/name/FqName;)V", "accept", "", "d", "(Ljava/lang/Object;)V", "build", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "buildSignature", "declaration", "(Ljava/lang/Object;)Lorg/jetbrains/kotlin/ir/util/IdSignature;", "platformSpecificAlias", "descriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "platformSpecificClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "platformSpecificConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "platformSpecificFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "platformSpecificGetter", "Lorg/jetbrains/kotlin/descriptors/PropertyGetterDescriptor;", "platformSpecificPackage", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentDescriptor;", "platformSpecificProperty", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "platformSpecificSetter", "Lorg/jetbrains/kotlin/descriptors/PropertySetterDescriptor;", "reset", "setExpected", "f", "", "setSpecialJavaProperty", "ir.serialization.common"})
public abstract class IdSignatureBuilder<D> {
    private FqName packageFqn;
    private final List<String> classFqnSegments;
    private Long hashId;
    private Long hashIdAcc;
    private long mask;

    @NotNull
    protected final FqName getPackageFqn() {
        return this.packageFqn;
    }

    protected final void setPackageFqn(@NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"<set-?>");
        this.packageFqn = fqName2;
    }

    @NotNull
    protected final List<String> getClassFqnSegments() {
        return this.classFqnSegments;
    }

    @Nullable
    protected final Long getHashId() {
        return this.hashId;
    }

    protected final void setHashId(@Nullable Long l) {
        this.hashId = l;
    }

    @Nullable
    protected final Long getHashIdAcc() {
        return this.hashIdAcc;
    }

    protected final void setHashIdAcc(@Nullable Long l) {
        this.hashIdAcc = l;
    }

    protected final long getMask() {
        return this.mask;
    }

    protected final void setMask(long l) {
        this.mask = l;
    }

    protected abstract void accept(D var1);

    protected final void reset() {
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FqName.ROOT");
        this.packageFqn = fqName2;
        this.classFqnSegments.clear();
        this.hashId = null;
        this.mask = 0L;
    }

    @NotNull
    protected final IdSignature build() {
        IdSignature idSignature;
        String string2 = this.packageFqn.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageFqn.asString()");
        String packageFqName = string2;
        String classFqName = CollectionsKt.joinToString$default((Iterable)this.classFqnSegments, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        if (this.hashIdAcc == null) {
            idSignature = new IdSignature.PublicSignature(packageFqName, classFqName, this.hashId, this.mask);
        } else {
            IdSignature.PublicSignature accessorSignature = new IdSignature.PublicSignature(packageFqName, classFqName, this.hashIdAcc, this.mask);
            this.hashIdAcc = null;
            List<String> list2 = this.classFqnSegments;
            boolean bl = false;
            boolean bl2 = false;
            List<String> $this$run = list2;
            boolean bl3 = false;
            $this$run.remove(CollectionsKt.getLastIndex($this$run));
            IdSignature propertySignature = this.build();
            idSignature = new IdSignature.AccessorSignature(propertySignature, accessorSignature);
        }
        return idSignature;
    }

    protected final void setExpected(boolean f) {
        this.mask |= IdSignature.Flags.IS_EXPECT.encode(f);
    }

    protected final void setSpecialJavaProperty(boolean f) {
        this.mask |= IdSignature.Flags.IS_JAVA_FOR_KOTLIN_OVERRIDE_PROPERTY.encode(f);
    }

    protected void platformSpecificProperty(@NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
    }

    protected void platformSpecificGetter(@NotNull PropertyGetterDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
    }

    protected void platformSpecificSetter(@NotNull PropertySetterDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
    }

    protected void platformSpecificFunction(@NotNull FunctionDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
    }

    protected void platformSpecificConstructor(@NotNull ConstructorDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
    }

    protected void platformSpecificClass(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
    }

    protected void platformSpecificAlias(@NotNull TypeAliasDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
    }

    protected void platformSpecificPackage(@NotNull PackageFragmentDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
    }

    @NotNull
    public final IdSignature buildSignature(D declaration2) {
        this.reset();
        this.accept(declaration2);
        return this.build();
    }

    public IdSignatureBuilder() {
        FqName fqName2 = FqName.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"FqName.ROOT");
        this.packageFqn = fqName2;
        boolean bl = false;
        this.classFqnSegments = new ArrayList();
    }
}

