/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.scope;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiInstanceOfExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPattern;
import org.jetbrains.kotlin.com.intellij.psi.PsiPatternVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiPolyadicExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.ResolveState;

public enum PatternResolveState {
    WHEN_TRUE,
    WHEN_FALSE,
    WHEN_BOTH,
    WHEN_NONE;

    public static final Key<PatternResolveState> KEY;

    public static PatternResolveState fromBoolean(boolean value2) {
        return value2 ? WHEN_TRUE : WHEN_FALSE;
    }

    public PatternResolveState invert() {
        switch (this) {
            case WHEN_TRUE: {
                return WHEN_FALSE;
            }
            case WHEN_FALSE: {
                return WHEN_TRUE;
            }
        }
        return this;
    }

    public ResolveState putInto(ResolveState rs) {
        return rs.put(KEY, this);
    }

    @NotNull
    public static PatternResolveState stateAtParent(PsiPatternVariable element, PsiExpression parent2) {
        PsiPattern pattern = element.getPattern();
        if (pattern == null) {
            throw new IllegalArgumentException("Variable has no pattern associated");
        }
        PatternResolveState state = WHEN_TRUE;
        PsiElement prev = pattern;
        PsiElement current2 = prev.getParent();
        while (prev != parent2) {
            if (!(current2 instanceof PsiInstanceOfExpression || current2 instanceof PsiParenthesizedExpression || current2 instanceof PsiPolyadicExpression && (((PsiPolyadicExpression)current2).getOperationTokenType() == JavaTokenType.ANDAND || ((PsiPolyadicExpression)current2).getOperationTokenType() == JavaTokenType.OROR))) {
                if (current2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)current2).getOperationTokenType() == JavaTokenType.EXCL) {
                    state = state.invert();
                } else {
                    PatternResolveState patternResolveState = WHEN_NONE;
                    if (patternResolveState == null) {
                        PatternResolveState.$$$reportNull$$$0(0);
                    }
                    return patternResolveState;
                }
            }
            prev = current2;
            current2 = current2.getParent();
        }
        PatternResolveState patternResolveState = state;
        if (patternResolveState == null) {
            PatternResolveState.$$$reportNull$$$0(1);
        }
        return patternResolveState;
    }

    static {
        KEY = Key.create("JavaPatternDeclarationHint");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/scope/PatternResolveState", "stateAtParent"));
    }
}

